<?php

$args = array(
	"mode" => "vertical",
	"force_vertical_mode" => 800,
	"horizontal_start_position" => 'top',
	"move_items" => 1,
	"start_index" => 0,
	"visible_items" => 4,

	"vertical_start_position" => 'right',
	"vertical_trigger" => '150px',
);

wp_enqueue_script( 'timeline-horizontal-vertical' );
wp_enqueue_script( 'timeline-horizontal-vertical-custom' );

if( is_rtl() ) {
	wp_enqueue_style( 'timeline-horizontal-vertical-rtl' );
} else {
	wp_enqueue_style( 'timeline-horizontal-vertical' );
}

$html = "";

$mode = "";
$force_vertical_mode = "";
$horizontal_start_position = "";
$move_items = "";
$start_index = "";
$visible_items = "";

$vertical_start_position = "";
$vertical_trigger = "";

$params = shortcode_atts($args, $atts);
extract($params);

$html .= '<div class="tm-timeline-horizontal-vertical" 
			data-tm-mode="'.esc_attr( $mode ).'"';


if( $mode == 'horizontal' ) {
$html .= 	'
			data-tm-force-vertical-mode="'.esc_attr( $force_vertical_mode ).'" 
			data-tm-horizontal-start-position="'.esc_attr( $horizontal_start_position ).'" 
			data-tm-move-items="'.esc_attr( $move_items ).'" 
			data-tm-start-index="'.esc_attr( $start_index ).'" 
			data-tm-visible-items="'.esc_attr( $visible_items ).'" ';
			
} else {
$html .= 	'
			data-tm-vertical-start-position="'.esc_attr( $vertical_start_position ).'" 
			data-tm-vertical-trigger="'.esc_attr( $vertical_trigger ).'" ';
}
$html .= 	'
		  ><div class="timeline__wrap"><div class="timeline__items">';
$html .= do_shortcode($content);
$html .= '</div></div></div>';

$output = htmlentities($html);
echo html_entity_decode($output);

