<?php
$args = array(
	'values' => '',
);

$html = "";
$values = "";

$params = shortcode_atts($args, $atts);
extract($params);

wp_enqueue_script( 'timeline-cd-horizontal' );

if( is_rtl() ) {
	wp_enqueue_style( 'timeline-cd-horizontal' );
} else {
	wp_enqueue_style( 'timeline-cd-horizontal' );
}

$values = (array) vc_param_group_parse_atts( $values );
$date_list = '';
foreach ( $values as $k => $v ) {
	$selected = '';
	if( $v['make_selected'] == 'true' ) {
		$selected = 'selected';
	}
	$date_list .= '<li><a href="#0" data-date="'.esc_attr( $v['date'] ).'" class="'.esc_attr( $selected ).'">'.esc_html( $v['date_label'] ).'</a></li>';
}


$html .= '<div class="tm-sc-horizontal-timeline">';
$html .= '<div class="cd-horizontal-timeline">';
$html .= '
	<div class="timeline">
		<div class="events-wrapper">
			<div class="events">
				<ol>
					'.$date_list.'
				</ol>

				<span class="filling-line" aria-hidden="true"></span>
			</div>
		</div>
			
		<ul class="cd-timeline-navigation">
			<li><a href="#0" class="prev inactive">'.esc_html__( 'Previous', 'charitab-wp' ).'</a></li>
			<li><a href="#0" class="next">'.esc_html__( 'Next', 'charitab-wp' ).'</a></li>
		</ul>
	</div>
	';
$html .= '<div class="events-content"><ol>';
$html .= do_shortcode($content);
$html .= '</ol></div></div></div>';

$output = htmlentities($html);
echo html_entity_decode($output);

