<?php
$css = $show_gallery_title = $featured_image_size = $gallery_lightbox_type = $columns = '';
extract(shortcode_atts(array(
    'css' => ''
), $atts));
$css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ) );

extract( $atts );
?>
<?php
	$current_page_id = charitab_mascot_get_page_id();
	$holder_id = charitab_mascot_get_isotope_holder_ID('pet');
?>

<?php
	$gallery_images = charitab_mascot_get_rwmb_group_advanced( 'charitab_mascot_' . "pet_mb_gallery",  "gallery_images", null, false, 'all' );
?>

<!-- Gallery Grid -->
<div id="<?php echo esc_attr( $holder_id ) ?>" class="isotope-layout grid-<?php echo esc_attr( $columns );?> <?php echo esc_attr( $gutter );?> <?php echo esc_attr( $css_class ); ?> clearfix">
	<!-- the loop -->
	<?php
	if ( !empty( $gallery_images ) ) {
	?>
	<?php 
		foreach ( $gallery_images as $each_gallery_image ) { 
			$url = $each_gallery_image['full_url'];
			$file_info = pathinfo($url);
			if ( is_array( $each_gallery_image['sizes'] ) &&  array_key_exists( $featured_image_size, $each_gallery_image['sizes'] ) ) {
				$thumb_url = $file_info['dirname'] . '/' . $each_gallery_image['sizes'][$featured_image_size]['file'];
			} else {
				$thumb_url = $each_gallery_image['full_url'];
			}
	?>
	<!-- Item Start -->
	<div class="isotope-item box-hover-effect">
		<div class="effect-wrapper">
			<div class="thumb">
				<img src="<?php echo esc_url( $thumb_url );?>" alt="<?php esc_attr_e( 'Thumb', 'charitab-wp' ); ?>">
			</div>
			<div class="overlay-shade"></div>
			<?php if ( $show_gallery_title == 'true' ) : ?>
			<div class="text-holder text-holder-top">
				<div class="title"><?php the_title();?></div>
			</div>
			<?php endif; ?>
			<div class="icons-holder icons-holder-middle">
				<div class="icons-holder-inner">
					<div class="<?php echo esc_attr( apply_filters( 'charitab_mascot_tmvc_pet_gallery_social_info', 'styled-icons icon-sm icon-dark icon-circled icon-theme-colored1') ); ?>">
						<?php 
							if ( $gallery_lightbox_type == 'pretty-photo' ) :
								wp_enqueue_script( 'prettyphoto' );
								wp_enqueue_style( 'prettyphoto' );
						?>
						<a data-rel="prettyPhoto[gallery<?php echo esc_attr( $holder_id );?>]" title="<?php the_title_attribute(); ?>" href="<?php echo esc_url( $each_gallery_image['full_url'] );?>"><i class="fa fa-picture-o"></i></a>
						<?php
                        	else:
								wp_enqueue_script( 'nivo-lightbox' );
								wp_enqueue_style( 'nivo-lightbox' );
								wp_enqueue_style( 'nivo-lightbox-theme' );
						?>
						<a data-lightbox-gallery="gallery-<?php echo esc_attr( $holder_id );?>" title="<?php the_title_attribute(); ?>" href="<?php echo esc_url( $each_gallery_image['full_url'] );?>"><i class="fa fa-picture-o"></i></a>
						<?php endif; ?>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!-- Portfolio Item End -->
	<?php
		}
	}
	?>
	<!-- end of the loop -->
</div>
<!-- End Portfolio Gallery Grid -->