<?php

$args = array(
	"background_color" => "",
	"background_image" => "",
	"item_padding" => "",
	"alignment" => "",
	"header_style" => "",
);

$html = "";
$tm_splitted_item_style = "";
$tm_splitted_item_data = "";

extract(shortcode_atts($args, $atts));

$background_color = esc_attr($background_color);
$item_padding = esc_attr($item_padding);

if($background_color != "" || $background_image != "" || $item_padding != "" || $item_padding != "") {
	$tm_splitted_item_style .= "style='";

	if ($background_color != "") {
		$tm_splitted_item_style .= "background-color:".$background_color.";";
	}

	if ($background_image != "") {
		$background_image_src = wp_get_attachment_url( $background_image );
		$tm_splitted_item_style .= "background-image:url(".esc_url( $background_image_src ).");";
	}

	if ($alignment != "") {
		$tm_splitted_item_style .= "text-align:".esc_attr( $alignment ).";";
	}

	if ($item_padding != "") {
		$tm_splitted_item_style .= "padding:0px ".$item_padding.";";
	}

	$tm_splitted_item_style .= "'";
}


$tm_splitted_item_data = "data-header_style='".esc_attr( $header_style )."'"; //render empty value also, in order to remove header style if needed


$html .= "<div class='slide' ".$tm_splitted_item_style." ".$tm_splitted_item_data." >";
$html .= do_shortcode($content);
$html .= "</div>";
$output = htmlentities($html);
echo html_entity_decode($output);

