<?php


/**
 * Predefine demo imports
 */
function charitab_mascot_ocdi_import_files() {
	$demo_url = array();
	$demo_url['demo_main'] = 'http://wp.kodesolution.live/nonprofit/charity/charitab/tgm/v5.0/main-demo/';
	$demo_url['demo_fundraising'] = 'http://wp.kodesolution.live/nonprofit/charity/charitab/tgm/v5.0/fundraising/';
	$demo_url['demo_ngo'] = 'http://wp.kodesolution.live/nonprofit/charity/charitab/tgm/v5.0/ngo/';
	$demo_url['demo_eco'] = 'http://wp.kodesolution.live/nonprofit/charity/charitab/tgm/v5.0/eco/';
	$demo_url['demo_children'] = 'http://wp.kodesolution.live/nonprofit/charity/charitab/tgm/v5.0/children/';
	$demo_url['demo_candidate'] = 'http://wp.kodesolution.live/nonprofit/charity/charitab/tgm/v5.0/candidate/';
	$demo_url['demo_hot'] = 'http://wp.kodesolution.live/nonprofit/charity/charitab/tgm/v5.0/hot/';
	return array(
		array(
				'import_file_name'           => 'Main Demo',
				'categories'                 => array( 'Main Demo' ),
				'import_file_url'            => $demo_url['demo_main'] . 'xml.xml',
				'import_widget_file_url'     => $demo_url['demo_main'] . 'wie.wie',
				//'import_customizer_file_url' => 'http://www.your_domain.com/ocdi/customizer.dat',
				'import_redux'               => array(
						array(
								'file_url'    => $demo_url['demo_main'] . 'json.json',
								'option_name' => 'charitab_mascot_redux_theme_opt',
						),
				),
				'import_preview_image_url'   => $demo_url['demo_main'] . 'screenshot.jpg',
				'import_notice'              => __( 'After you import this demo, you will have to setup the slider separately.', 'charitab-wp' ),
				'preview_url'                => $demo_url['demo_main'],
		),
		array(
				'import_file_name'           => 'Fundraising',
				'categories'                 => array( 'Fundraising' ),
				'import_file_url'            => $demo_url['demo_fundraising'] . 'xml.xml',
				'import_widget_file_url'     => $demo_url['demo_fundraising'] . 'wie.wie',
				//'import_customizer_file_url' => 'http://www.your_domain.com/ocdi/customizer.dat',
				'import_redux'               => array(
						array(
								'file_url'    => $demo_url['demo_fundraising'] . 'json.json',
								'option_name' => 'charitab_mascot_redux_theme_opt',
						),
				),
				'import_preview_image_url'   => $demo_url['demo_fundraising'] . 'screenshot.jpg',
				'import_notice'              => __( 'After you import this demo, you will have to setup the slider separately.', 'charitab-wp' ),
				'preview_url'                => $demo_url['demo_fundraising'],
		),
		array(
				'import_file_name'           => 'NGO',
				'categories'                 => array( 'NGO' ),
				'import_file_url'            => $demo_url['demo_ngo'] . 'xml.xml',
				'import_widget_file_url'     => $demo_url['demo_ngo'] . 'wie.wie',
				//'import_customizer_file_url' => 'http://www.your_domain.com/ocdi/customizer.dat',
				'import_redux'               => array(
						array(
								'file_url'    => $demo_url['demo_ngo'] . 'json.json',
								'option_name' => 'charitab_mascot_redux_theme_opt',
						),
				),
				'import_preview_image_url'   => $demo_url['demo_ngo'] . 'screenshot.jpg',
				'import_notice'              => __( 'After you import this demo, you will have to setup the slider separately.', 'charitab-wp' ),
				'preview_url'                => $demo_url['demo_ngo'],
		),
		array(
				'import_file_name'           => 'ECO',
				'categories'                 => array( 'ECO' ),
				'import_file_url'            => $demo_url['demo_eco'] . 'xml.xml',
				'import_widget_file_url'     => $demo_url['demo_eco'] . 'wie.wie',
				//'import_customizer_file_url' => 'http://www.your_domain.com/ocdi/customizer.dat',
				'import_redux'               => array(
						array(
								'file_url'    => $demo_url['demo_eco'] . 'json.json',
								'option_name' => 'charitab_mascot_redux_theme_opt',
						),
				),
				'import_preview_image_url'   => $demo_url['demo_eco'] . 'screenshot.jpg',
				'import_notice'              => __( 'After you import this demo, you will have to setup the slider separately.', 'charitab-wp' ),
				'preview_url'                => $demo_url['demo_eco'],
		),
		array(
				'import_file_name'           => 'Children',
				'categories'                 => array( 'Children' ),
				'import_file_url'            => $demo_url['demo_children'] . 'xml.xml',
				'import_widget_file_url'     => $demo_url['demo_children'] . 'wie.wie',
				//'import_customizer_file_url' => 'http://www.your_domain.com/ocdi/customizer.dat',
				'import_redux'               => array(
						array(
								'file_url'    => $demo_url['demo_children'] . 'json.json',
								'option_name' => 'charitab_mascot_redux_theme_opt',
						),
				),
				'import_preview_image_url'   => $demo_url['demo_children'] . 'screenshot.jpg',
				'import_notice'              => __( 'After you import this demo, you will have to setup the slider separately.', 'charitab-wp' ),
				'preview_url'                => $demo_url['demo_children'],
		),
		array(
				'import_file_name'           => 'Candidate',
				'categories'                 => array( 'Candidate' ),
				'import_file_url'            => $demo_url['demo_candidate'] . 'xml.xml',
				'import_widget_file_url'     => $demo_url['demo_candidate'] . 'wie.wie',
				//'import_customizer_file_url' => 'http://www.your_domain.com/ocdi/customizer.dat',
				'import_redux'               => array(
						array(
								'file_url'    => $demo_url['demo_candidate'] . 'json.json',
								'option_name' => 'charitab_mascot_redux_theme_opt',
						),
				),
				'import_preview_image_url'   => $demo_url['demo_candidate'] . 'screenshot.jpg',
				'import_notice'              => __( 'After you import this demo, you will have to setup the slider separately.', 'charitab-wp' ),
				'preview_url'                => $demo_url['demo_candidate'],
		),
		array(
				'import_file_name'           => 'Hot',
				'categories'                 => array( 'Hot' ),
				'import_file_url'            => $demo_url['demo_hot'] . 'xml.xml',
				'import_widget_file_url'     => $demo_url['demo_hot'] . 'wie.wie',
				//'import_customizer_file_url' => 'http://www.your_domain.com/ocdi/customizer.dat',
				'import_redux'               => array(
						array(
								'file_url'    => $demo_url['demo_hot'] . 'json.json',
								'option_name' => 'charitab_mascot_redux_theme_opt',
						),
				),
				'import_preview_image_url'   => $demo_url['demo_hot'] . 'screenshot.jpg',
				'import_notice'              => __( 'After you import this demo, you will have to setup the slider separately.', 'charitab-wp' ),
				'preview_url'                => $demo_url['demo_hot'],
		),
	);
}
add_filter( 'pt-ocdi/import_files', 'charitab_mascot_ocdi_import_files' );



/**
 * Automatically assign “Front page”, “Posts page” and menu locations after the importer is done
 */
function charitab_mascot_ocdi_after_import_setup( $selected_import ) {
	// Assign menus to their locations.
	$main_menu = get_term_by( 'name', 'Top Primary Nav', 'nav_menu' );

	set_theme_mod( 'nav_menu_locations', array(
			'primary' => $main_menu->term_id,
		)
	);


	$front_page = 'Index Multipage Layout1';
	$blog_page = 'Blog';

	if ( 'Main Demo' === $selected_import['import_file_name'] ) {
	}
	elseif ( 'Hot' === $selected_import['import_file_name'] ) {
		$front_page = 'Divided Multi Scrolling Slider';
	}

	// Assign front page and posts page (blog page).
	$front_page_id = get_page_by_title( $front_page );
	$blog_page_id  = get_page_by_title( $blog_page );

	update_option( 'show_on_front', 'page' );
	update_option( 'page_on_front', $front_page_id->ID );
	update_option( 'page_for_posts', $blog_page_id->ID );

	//update theme options:
	charitab_mascot_generate_css_for_custom_theme_color_from_less();
	charitab_mascot_generate_dynamic_css();
}
add_action( 'pt-ocdi/after_import', 'charitab_mascot_ocdi_after_import_setup' );



/**
 * Change the location, title and other parameters of the plugin page
 */
function charitab_mascot_ocdi_plugin_page_setup( $default_settings ) {
	$default_settings['parent_slug'] = 'themes.php';
	$default_settings['page_title']  = esc_html__( 'One Click Demo Import - ThemeMascot' , 'charitab-wp' );
	$default_settings['menu_title']  = esc_html__( 'Import Demo Data' , 'charitab-wp' );
	$default_settings['capability']  = 'import';
	$default_settings['menu_slug']   = 'tm-one-click-demo-import';

	return $default_settings;
}
add_filter( 'pt-ocdi/plugin_page_setup', 'charitab_mascot_ocdi_plugin_page_setup' );


add_filter( 'pt-ocdi/disable_pt_branding', '__return_true' );