<?php
	/**
	 * ReduxFramework Sample Config File
	 * For full documentation, please visit: http://docs.reduxframework.com/
	 */

	if ( ! class_exists( 'Redux' ) ) {
		return;
	}

	// This is your option name where all the Redux data is stored.
	$opt_name = "charitab_mascot_redux_theme_opt";

	// This line is only for altering the demo. Can be easily removed.
	$opt_name = apply_filters( 'charitab_mascot_redux_theme_opt/opt_name', $opt_name );

	$site_url = site_url();

	//custom action hook for this template:
	add_action('redux/options/charitab_mascot_redux_theme_opt/saved', 'charitab_mascot_generate_css_for_custom_theme_color_from_less');
	add_action('redux/options/charitab_mascot_redux_theme_opt/saved', 'charitab_mascot_generate_dynamic_css');
	add_action('redux/options/charitab_mascot_redux_theme_opt/reset', 'charitab_mascot_generate_css_for_custom_theme_color_from_less');
	add_action('redux/options/charitab_mascot_redux_theme_opt/reset', 'charitab_mascot_generate_dynamic_css');
	add_action('redux/options/charitab_mascot_redux_theme_opt/section/reset', 'charitab_mascot_generate_css_for_custom_theme_color_from_less');
	add_action('redux/options/charitab_mascot_redux_theme_opt/section/reset', 'charitab_mascot_generate_dynamic_css');

	//required files
	require_once( 'filter-social-links.php' );
	/*
	 *
	 * --> Used within different fields. Simply examples. Search for ACTUAL DECLARATION for field examples
	 *
	 */

	// Background Patterns Reader
	$sample_patterns_path = CHARITAB_MASCOT_ADMIN_ASSETS_DIR . '/images/pattern/';
	$sample_patterns_url  = CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/pattern/';
	$sample_patterns      = array();
	
	if ( is_dir( $sample_patterns_path ) ) {

		if ( $sample_patterns_dir = opendir( $sample_patterns_path ) ) {
			$sample_patterns = array();

			while ( ( $sample_patterns_file = readdir( $sample_patterns_dir ) ) !== false ) {

				if ( stristr( $sample_patterns_file, '.png' ) !== false || stristr( $sample_patterns_file, '.jpg' ) !== false ) {
					$name              = explode( '.', $sample_patterns_file );
					$name              = str_replace( '.' . end( $name ), '', $sample_patterns_file );
					$sample_patterns[ $sample_patterns_url . $sample_patterns_file ] = array(
						'alt' => $name,
						'img' => $sample_patterns_url . $sample_patterns_file
					);
				}
			}
		}
	}


	/*
	 *
	 * ---> START SECTIONS
	 *
	 */

	/*

		As of Redux 3.5+, there is an extensive API. This API can be used in a mix/match mode allowing for


	 */


	// -> START General Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'General', 'charitab-wp' ),
		'id'     => 'general-settings',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-admin-home',
		'fields' => array(
			array(
				'id'       => 'general-settings-favicon',
				'type'     => 'media',
				'url'      => false,
				'title'    => esc_html__( 'Favicon', 'charitab-wp' ),
				'compiler' => 'true',
				//'mode'      => false, // Can be set to false to allow any media type, or can also be set to any mime type.
				'desc'     => esc_html__( 'Basic media uploader with disabled URL input field.', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Upload a 32px x 32px png/gif image that will represent your website favicon.', 'charitab-wp' ),
				'default'  => array( 'url' => CHARITAB_MASCOT_ASSETS_URI . '/images/logo/favicon.png' ),
			),
			array(
				'id'       => 'general-settings-apple-touch-144',
				'type'     => 'media',
				'url'      => false,
				'title'    => esc_html__( 'Apple Touch 144x144 Icon', 'charitab-wp' ),
				'compiler' => 'true',
				//'mode'      => false, // Can be set to false to allow any media type, or can also be set to any mime type.
				'desc'     => esc_html__( 'Basic media uploader with disabled URL input field.', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Upload a 144px x 144px png image that will be your website bookmark on retina iOS devices.', 'charitab-wp' ),
				'default'  => array( 'url' => CHARITAB_MASCOT_ASSETS_URI . '/images/logo/apple-touch-icon-144x144.png' ),
			),
			array(
				'id'       => 'general-settings-apple-touch-114',
				'type'     => 'media',
				'url'      => false,
				'title'    => esc_html__( 'Apple Touch 114x114 Icon', 'charitab-wp' ),
				'compiler' => 'true',
				//'mode'      => false, // Can be set to false to allow any media type, or can also be set to any mime type.
				'desc'     => esc_html__( 'Basic media uploader with disabled URL input field.', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Upload a 114px x 114px png image that will be your website bookmark on retina iOS devices.', 'charitab-wp' ),
				'default'  => array( 'url' => CHARITAB_MASCOT_ASSETS_URI . '/images/logo/apple-touch-icon-114x114.png' ),
			),
			array(
				'id'       => 'general-settings-apple-touch-72',
				'type'     => 'media',
				'url'      => false,
				'title'    => esc_html__( 'Apple Touch 72x72 Icon', 'charitab-wp' ),
				'compiler' => 'true',
				//'mode'      => false, // Can be set to false to allow any media type, or can also be set to any mime type.
				'desc'     => esc_html__( 'Basic media uploader with disabled URL input field.', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Upload a 72px x 72px Png image that will be your website bookmark on non-retina iOS devices.', 'charitab-wp' ),
				'default'  => array( 'url' => CHARITAB_MASCOT_ASSETS_URI . '/images/logo/apple-touch-icon-72x72.png' ),
			),
			array(
				'id'       => 'general-settings-apple-touch-32',
				'type'     => 'media',
				'url'      => false,
				'title'    => esc_html__( 'Apple Touch 32x32 Icon', 'charitab-wp' ),
				'compiler' => 'true',
				//'mode'      => false, // Can be set to false to allow any media type, or can also be set to any mime type.
				'desc'     => esc_html__( 'Basic media uploader with disabled URL input field.', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Upload a 32px x 32px png image that will be your website bookmark on non-retina iOS devices.', 'charitab-wp' ),
				'default'  => array( 'url' => CHARITAB_MASCOT_ASSETS_URI . '/images/logo/apple-touch-icon.png' ),
			),
			array(
				'id'       => 'general-settings-enable-responsive',
				'type'     => 'switch',
				'title'    => esc_html__( 'Enable Responsive', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enable/Disable the responsive behaviour of the theme', 'charitab-wp' ),
				'default'  => true,
			),
			/*array(
				'id'       => 'general-settings-enable-rtl',
				'type'     => 'switch',
				'title'    => esc_html__( 'Enable RTL~', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Please enable this option if you are using wordpress for RTL languages.', 'charitab-wp' ),
				'default'  => false,
			),*/
			array(
				'id'       => 'general-settings-enable-backtotop',
				'type'     => 'switch',
				'title'    => esc_html__( 'Enable Back To Top', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enable Back to Top button that appears in the bottom right corner of the screen.', 'charitab-wp' ),
				'default'  => true,
			),


			array(
				'id'       => 'general-settings-smooth-scroll',
				'type'     => 'switch',
				'title'    => esc_html__( 'Enable Smooth Scroll', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enabling this option will perform a smooth scrolling effect on every page (except on Mac and touch devices).', 'charitab-wp' ),
				'default'  => true,
			),

			/*
			array(
				'id'       => 'general-settings-smooth-page-transition',
				'type'     => 'switch',
				'title'    => esc_html__( 'Smooth Page Transitions=======', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enabling this option will perform a smooth transition between pages when clicking on links.', 'charitab-wp' ),
				'default'  => false,
			),*/
			//section H3 Starts
			array(
				'id'       => 'general-settings-enable-page-preloader-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Page Preloader Settings', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enable/Disable Page Preloader.', 'charitab-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
			),
			array(
				'id'       => 'general-settings-enable-page-preloader',
				'type'     => 'switch',
				'title'    => esc_html__( 'Enable Page Preloader', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enabling this option will show page preloader.', 'charitab-wp' ),
				'default'  => false,
			),
			array(
				'id'        => 'general-settings-page-preloader-type',
				'type'      => 'button_set',
				'compiler'  => true,
				'title'     => esc_html__( 'Page Preloader Type', 'charitab-wp' ),
				'subtitle'  => esc_html__( 'Select preloader type', 'charitab-wp' ),
				'options'   => array(
					'css-preloader'    => esc_html__( 'CSS Preloader', 'charitab-wp' ),
					'gif-preloader'    => esc_html__( 'Gif Icon Preloader', 'charitab-wp' )
				),
				'default'   => 'css-preloader',
				'required' => array( 'general-settings-enable-page-preloader', '=', '1' ),
			),
			array(
				'id'        => 'general-settings-page-preloader-type-css',
				'type'     => 'select',
				'title'    => esc_html__( 'CSS Preloader', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Choose Predefined CSS Preloader.', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array(
					'preloader-bubblingG'           => esc_html__( 'Bubbling', 'charitab-wp' ),
					'preloader-circle-loading-wrapper' => esc_html__( 'Circle Loading', 'charitab-wp' ),
					'preloader-coffee'              => esc_html__( 'Coffee', 'charitab-wp' ),
					'preloader-battery'             => esc_html__( 'Battery', 'charitab-wp' ),
					'preloader-dot-circle-rotator'  => esc_html__( 'Dot Circle Rotator', 'charitab-wp' ),
					'preloader-dot-loading'         => esc_html__( 'Dot Loading', 'charitab-wp' ),
					'preloader-double-torus'        => esc_html__( 'Double Torus', 'charitab-wp' ),
					'preloader-equalizer'           => esc_html__( 'Equalizer', 'charitab-wp' ),
					'preloader-floating-circles'    => esc_html__( 'Floating Circles', 'charitab-wp' ),
					'preloader-fountainTextG'       => esc_html__( 'Fountain Text', 'charitab-wp' ),
					'preloader-jackhammer'          => esc_html__( 'Jackhammer', 'charitab-wp' ),
					'preloader-loading-wrapper'     => esc_html__( 'Loading', 'charitab-wp' ),
					'preloader-orbit-loading'       => esc_html__( 'Orbit Loading', 'charitab-wp' ),
					'preloader-speeding-wheel'      => esc_html__( 'Speeding Wheel', 'charitab-wp' ),
					'preloader-square-swapping'     => esc_html__( 'Square Swapping', 'charitab-wp' ),
					'preloader-tube-tunnel'         => esc_html__( 'Tube Tunnel', 'charitab-wp' ),
					'preloader-whirlpool'           => esc_html__( 'Whirlpool', 'charitab-wp' ),
				),
				'default'  => 'preloader-dot-loading',
				'required' => array( 'general-settings-page-preloader-type', '=', 'css-preloader' ),
			),
			array(
				'id'        => 'general-settings-page-preloader-type-gif',
				'type'     => 'select',
				'title'    => esc_html__( 'Gif Icon Preloader', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Choose Predefined Gif Icon Preloader.', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array(
					CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/preloaders/1.gif'  =>  'preloader-1',
					CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/preloaders/2.gif'  =>  'preloader-2',
					CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/preloaders/3.gif'  =>  'preloader-3',
					CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/preloaders/4.gif'  =>  'preloader-4',
					CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/preloaders/5.gif'  =>  'preloader-5',
					CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/preloaders/6.gif'  =>  'preloader-6',
					CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/preloaders/7.gif'  =>  'preloader-7',
					CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/preloaders/8.gif'  =>  'preloader-8',
					CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/preloaders/9.gif'  =>  'preloader-9',
					CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/preloaders/10.gif' =>  'preloader-10',
				),
				'default'  => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/preloaders/1.gif',
				'required' => array( 'general-settings-page-preloader-type', '=', 'gif-preloader' ),
			),
			array(
				'id'        => 'general-settings-page-preloader-show-disable-button',
				'type'     => 'checkbox',
				'title'    => esc_html__( 'Show Disable Preloader Button', 'charitab-wp' ),
				'subtitle'    => esc_html__( 'Show Disable Preloader Button at the corner of the screen.', 'charitab-wp' ),
				'desc'     => '',
				'default'  => '1',
				'required' => array( 'general-settings-enable-page-preloader', '=', '1' ),
			),
			array(
				'id'        => 'general-settings-page-preloader-show-disable-button-text',
				'type'     => 'text',
				'title'    => esc_html__( 'Disable Preloader Button Text', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enter the text that will be appeared into the Disable Preloader Button.', 'charitab-wp' ),
				'desc'     => '',
				'default'    => esc_html__( 'Disable Preloader', 'charitab-wp' ),
				'required' => array( 'general-settings-page-preloader-show-disable-button', '=', '1' ),
			),
			array(
				'id'       => 'general-settings-enable-page-preloader-ends',
				'type'     => 'section',
				'indent'   => false, // Indent all options below until the next 'section' option is set.
			),
		)
	) );

	$my_wp_get_theme = wp_get_theme();
	// -> START Logo Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Logo', 'charitab-wp' ),
		'id'     => 'logo-settings',
		'desc'   => sprintf( esc_html__( 'If you want to upload SVG logo then please install this %1$ssvg plugin%2$s', 'charitab-wp' ), '<a target="_blank" href="' . esc_url( 'https://wordpress.org/plugins/svg-support/' ) . '">', '</a>' ),
		'icon'   => 'dashicons-before dashicons-palmtree',
		'fields' => array(
			array(
				'id'       => 'logo-settings-site-brand',
				'type'     => 'text',
				'title'    => esc_html__( 'Site Brand', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enter the text that will be appeared as logo', 'charitab-wp' ),
				'desc'     => '',
				'default'  => $my_wp_get_theme->get( 'Name' ),
			),

			array(
				'id'       => 'logo-settings-want-to-use-logo',
				'type'     => 'switch',
				'title'    => esc_html__( 'Use logo in replace of "Site Brand" Text?', 'charitab-wp' ),
				'subtitle' => esc_html__( 'If you want to use logo then please enable it.', 'charitab-wp' ),
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
			),

			array(
				'id'       => 'logo-settings-switchable-logo',
				'type'     => 'switch',
				'title'    => esc_html__( 'Switchable logo(Light+Dark)?', 'charitab-wp' ),
				'subtitle' => esc_html__( 'If you want to use switchable logo then please enable it.', 'charitab-wp' ),
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
				'required' => array( 'logo-settings-want-to-use-logo', '=', '1' ),
			),

			array(
				'id'       => 'logo-settings-logo-default',
				'type'     => 'media',
				'url'      => false,
				'title'    => esc_html__( 'Logo (Default)', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Upload/choose your custom logo image', 'charitab-wp' ),
				'compiler' => 'true',
				//'mode'      => false, // Can be set to false to allow any media type, or can also be set to any mime type.
				'desc'     => '',
				'default'  => array( 'url' => CHARITAB_MASCOT_ASSETS_URI . '/images/logo/logo-wide.png' ),
				'required' => array( 'logo-settings-switchable-logo', '=', '0' ),
			),

			array(
				'id'       => 'logo-settings-logo-default-2x',
				'type'     => 'media',
				'url'      => false,
				'title'    => esc_html__( 'Logo (Default) Retina', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Select an image file for the retina version of the logo. It should be exactly 2x the size of the main logo.', 'charitab-wp' ),
				'compiler' => 'true',
				//'mode'      => false, // Can be set to false to allow any media type, or can also be set to any mime type.
				'desc'     => '',
				'default'  => array( 'url' => CHARITAB_MASCOT_ASSETS_URI . '/images/logo/logo-wide@2x.png' ),
				'required' => array( 'logo-settings-switchable-logo', '=', '0' ),
			),

			array(
				'id'       => 'logo-settings-logo-light',
				'type'     => 'media',
				'url'      => false,
				'title'    => esc_html__( 'Logo (Light)', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Upload a logo for the light skin.', 'charitab-wp' ),
				'compiler' => 'true',
				//'mode'      => false, // Can be set to false to allow any media type, or can also be set to any mime type.
				'desc'     => '',
				'default'  => array( 'url' => CHARITAB_MASCOT_ASSETS_URI . '/images/logo/logo-wide-white.png' ),
				'required' => array( 'logo-settings-switchable-logo', '=', '1' ),
			),

			array(
				'id'       => 'logo-settings-logo-light-2x',
				'type'     => 'media',
				'url'      => false,
				'title'    => esc_html__( 'Logo (Light) Retina', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Select an image file for the retina version of the logo. It should be exactly 2x the size of the main logo.', 'charitab-wp' ),
				'compiler' => 'true',
				//'mode'      => false, // Can be set to false to allow any media type, or can also be set to any mime type.
				'desc'     => '',
				'default'  => array( 'url' => CHARITAB_MASCOT_ASSETS_URI . '/images/logo/logo-wide-white@2x.png' ),
				'required' => array( 'logo-settings-switchable-logo', '=', '1' ),
			),

			array(
				'id'       => 'logo-settings-logo-dark',
				'type'     => 'media',
				'url'      => false,
				'title'    => esc_html__( 'Logo (Dark)', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Upload a logo for the dark skin.', 'charitab-wp' ),
				'compiler' => 'true',
				//'mode'      => false, // Can be set to false to allow any media type, or can also be set to any mime type.
				'desc'     => '',
				'default'  => array( 'url' => CHARITAB_MASCOT_ASSETS_URI . '/images/logo/logo-wide.png' ),
				'required' => array( 'logo-settings-switchable-logo', '=', '1' ),
			),

			array(
				'id'       => 'logo-settings-logo-dark-2x',
				'type'     => 'media',
				'url'      => false,
				'title'    => esc_html__( 'Logo (Dark) Retina', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Select an image file for the retina version of the logo. It should be exactly 2x the size of the main logo.', 'charitab-wp' ),
				'compiler' => 'true',
				//'mode'      => false, // Can be set to false to allow any media type, or can also be set to any mime type.
				'desc'     => '',
				'default'  => array( 'url' => CHARITAB_MASCOT_ASSETS_URI . '/images/logo/logo-wide@2x.png' ),
				'required' => array( 'logo-settings-switchable-logo', '=', '1' ),
			),


			array(
				'id'            => 'logo-settings-maximum-logo-width',
				'type'          => 'slider',
				'title'         => esc_html__( 'Maximum Logo Width(px)', 'charitab-wp' ),
				'subtitle'      => esc_html__( 'Enter maximum logo width in px.', 'charitab-wp' ),
				'desc'          => '',
				'default'       => 220,
				'min'           => 20,
				'step'          => 1,
				'max'           => 500,
				'display_value' => 'text',
				'required' => array( 'logo-settings-want-to-use-logo', '=', '1' ),
			),


			array(
				'id'            => 'logo-settings-maximum-logo-height',
				'type'          => 'slider',
				'title'         => esc_html__( 'Maximum Logo Height(px)', 'charitab-wp' ),
				'subtitle'      => esc_html__( 'Enter maximum logo height in px.', 'charitab-wp' ),
				'desc'          => '',
				'default'       => 55,
				'min'           => 20,
				'step'          => 1,
				'max'           => 250,
				'display_value' => 'text',
				'required' => array( 'logo-settings-want-to-use-logo', '=', '1' ),
			),
			array(
				'id'            => 'logo-settings-maximum-logo-height-in-sticky-mode',
				'type'          => 'slider',
				'title'         => esc_html__( 'Maximum Logo Height(px) in Sticky Mode', 'charitab-wp' ),
				'subtitle'      => esc_html__( 'Enter maximum logo height in px in sticky header mode.', 'charitab-wp' ),
				'desc'          => '',
				'default'       => 40,
				'min'           => 20,
				'step'          => 1,
				'max'           => 250,
				'display_value' => 'text',
				'required' => array( 'logo-settings-want-to-use-logo', '=', '1' ),
			),

			array(
				'id'            => 'logo-settings-logo-margin-around',
				'type'     => 'spacing',
				// An array of CSS selectors to apply this font style to
				'mode'     => 'margin',
				// absolute, padding, margin, defaults to padding
				'all'      => false,
				// Have one field that applies to all
				'top'           => true,
				'right'         => true,
				'bottom'        => true,
				'left'          => true,
				'units'         => 'px',      // You can specify a unit value. Possible: px, em, %
				//'units_extended'=> 'true',    // Allow users to select any type of unit
				'display_units' => true,   // Set to false to hide the units if the units are specified
				'title'    => esc_html__( 'Margin(px) Around Logo', 'charitab-wp' ),
			),

			array(
				'id'            => 'logo-settings-logo-sticky-margin-around',
				'type'     => 'spacing',
				// An array of CSS selectors to apply this font style to
				'mode'     => 'margin',
				// absolute, padding, margin, defaults to padding
				'all'      => false,
				// Have one field that applies to all
				'top'           => true,
				'right'         => true,
				'bottom'        => true,
				'left'          => true,
				'units'         => 'px',      // You can specify a unit value. Possible: px, em, %
				//'units_extended'=> 'true',    // Allow users to select any type of unit
				'display_units' => true,   // Set to false to hide the units if the units are specified
				'title'    => esc_html__( 'Margin(px) Around Logo in Sticky Mode', 'charitab-wp' ),
			),

			array(
				'id'       => 'logo-settings-admin-login-logo',
				'type'     => 'media',
				'url'      => false,
				'title'    => esc_html__( 'WordPress Admin Login Logo', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Change the default wordpress login logo. Dimensions should be 250x50 px', 'charitab-wp' ),
				'compiler' => 'true',
				//'mode'      => false, // Can be set to false to allow any media type, or can also be set to any mime type.
				'desc'     => '',
				'default'  => array( 'url' => CHARITAB_MASCOT_ASSETS_URI . '/images/logo/logo-wide.png' ),
			),

		)
	) );



	// -> START Layout Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Layout Settings', 'charitab-wp' ),
		'id'     => 'layout-settings',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-editor-table',
		'fields' => array(
			array(
				'id'        => 'layout-settings-page-layout',
				'type'      => 'button_set',
				'compiler'  => true,
				'title'     => esc_html__( 'Page Layout', 'charitab-wp' ),
				'subtitle'  => esc_html__( 'Select primary page layout of your theme', 'charitab-wp' ),
				'options'   => array(
					'boxed'        => esc_html__( 'Boxed', 'charitab-wp' ),
					'stretched'    => esc_html__( 'Stretched', 'charitab-wp' )
				),
				'default'   => 'stretched',
			),

			array(
				'id'       => 'layout-settings-content-width',
				'type'     => 'button_set',
				'compiler' =>true,
				'title'    => esc_html__( 'Content Width', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Select content width. You can use any width by using custom CSS', 'charitab-wp' ),
				'options' => array(
					'container-970px'     => esc_html__( '970px', 'charitab-wp' ),
					'container-default'   => esc_html__( '1170px (Bootstrap Default)', 'charitab-wp' ),
					'container-1230px'    => esc_html__( '1230px', 'charitab-wp' ),
					'container-1340px'    => esc_html__( '1340px', 'charitab-wp' ),
					'container-1500px'    => esc_html__( '1500px', 'charitab-wp' ),
					'container-1600px'    => esc_html__( '1600px', 'charitab-wp' ),
					'container-100pr'     => esc_html__( 'Fullwidth 100%', 'charitab-wp' )
				),
				'default' => 'container-default',
			),


			//section H3 Starts
			array(
				'id'       => 'layout-settings-boxed-layout-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Boxed Layout Settings', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Define styles for Boxed Layout.', 'charitab-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
				'required' => array( 'layout-settings-page-layout', '=', 'boxed' ),
			),
			array(
				'id'             => 'layout-settings-boxed-layout-padding-top-bottom',
				'type'           => 'spacing',
				'mode'           => 'padding',
				'all'            => false,
				// Have one field that applies to all
				'top'            => true,     // Disable the top
				'right'          => false,     // Disable the right
				'bottom'         => true,     // Disable the bottom
				'left'           => false,     // Disable the left
				'units'          => 'px',
				'units_extended' => 'true',
				'display_units'  => true,   // Set to false to hide the units if the units are specified
				'title'          => esc_html__( 'Padding Top & Bottom(px)', 'charitab-wp' ),
				'subtitle'       => esc_html__( 'Top and bottom padding in px for boxed layout.', 'charitab-wp' ),
				'desc'           => esc_html__( 'Controls the top and bottom padding of the boxed layout. Ex: 40px, 40px. Please put only integer value. Because the unit \'px\' will be automatically added to the end of the value.', 'charitab-wp' ),
				'default'            => array(
					'padding-top'     => '40', 
					'padding-bottom'  => '40', 
					'units'          => 'px', 
				)
			),
			array(
				'id'       => 'layout-settings-boxed-layout-container-shadow',
				'type'     => 'switch',
				'title'    => esc_html__( 'Container Shadow?', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Add shadow around the container.', 'charitab-wp' ),
				'default'  => 0,
				'on'       => 'On',
				'off'      => 'Off',
			),
			array(
				'id'       => 'layout-settings-boxed-layout-bg-type',
				'type'     => 'radio',
				'title'    => esc_html__( 'Background Type', 'charitab-wp' ),
				'subtitle' => esc_html__( 'You can use patterns, image or solid color as a background.', 'charitab-wp' ),
				'options'	=> array(
					'bg-color'     => esc_html__( 'Solid Color', 'charitab-wp' ),
					'bg-patter'    => esc_html__( 'Patterns from Theme Library', 'charitab-wp' ),
					'bg-image'     => esc_html__( 'Upload Own Image', 'charitab-wp' ),
				),
				'default'  => 'bg-color',
			),
			array(
				'id'       => 'layout-settings-boxed-layout-bg-type-bgcolor',
				'type'     => 'color',
				'title'    => esc_html__( 'Background Solid Color', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Pick a custom color for background (default: #444).', 'charitab-wp' ),
				'default'  => '#444',
				'transparent' => true,
				'required' => array( 'layout-settings-boxed-layout-bg-type', '=', 'bg-color' ),
			),
			array(
				'id'       => 'layout-settings-boxed-layout-bg-type-pattern',
				'type'     => 'image_select',
				'title'    => esc_html__( 'Choose Patterns from Theme Library', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Select a patterns by clicking on it.', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> $sample_patterns,
				'default'  => key($sample_patterns),
				'required' => array( 'layout-settings-boxed-layout-bg-type', '=', 'bg-patter' ),
			),
			array(
				'id'       => 'layout-settings-boxed-layout-bg-type-bgimg',
				'type'     => 'background',
				'title'    => esc_html__( 'Background Image', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Body background image.', 'charitab-wp' ),
				'background-color' => false,
				'required' => array( 'layout-settings-boxed-layout-bg-type', '=', 'bg-image' ),
			),
			array(
				'id'       => 'layout-settings-boxed-layout-ends',
				'type'     => 'section',
				'indent'   => false, // Indent all options below until the next 'section' option is set.
			),
		)
	) );


	// -> START Theme Color Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Theme Color Settings', 'charitab-wp' ),
		'id'     => 'theme-color-settings',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-art',
		'fields' => array(
			array(
				'id'       => 'theme-color-settings-theme-color-type',
				'type'     => 'button_set',
				'compiler' =>true,
				'title'    => esc_html__( 'Website Primary Theme Color', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Select website primary theme color', 'charitab-wp' ),
				'options' => array(
					'predefined' => esc_html__( 'Predefined Theme Colors', 'charitab-wp' ),
					'custom'     => esc_html__( 'Custom Theme Color', 'charitab-wp' )
				),
				'default' => 'predefined',
			),
			array(
				'id'       => 'theme-color-settings-primary-theme-color',
				'type'     => 'select',
				'title'    => esc_html__( 'Predefined Theme Colors', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Choose one from these predefined theme colors', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> charitab_mascot_metabox_get_list_of_predefined_theme_color_css_files(),
				'default'  => 'theme-skin-color-set1.css',
				'required' => array( 'theme-color-settings-theme-color-type', '=', 'predefined' ),
			),
			array(
				'id'       => 'theme-color-settings-custom-theme-color1',
				'type'     => 'color',
				'title'    => esc_html__( 'Custom Primary Theme Color', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Pick a custom primary color for the theme.', 'charitab-wp' ),
				'default'  => '#1296CC',
				'transparent'  => false,
				'required' => array( 'theme-color-settings-theme-color-type', '=', 'custom' ),
			),
			array(
				'id'       => 'theme-color-settings-custom-theme-color2',
				'type'     => 'color',
				'title'    => esc_html__( 'Custom Secondary Theme Color', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Pick a custom secondary color for the theme.', 'charitab-wp' ),
				'default'  => '#dd9933',
				'transparent'  => false,
				'required' => array( 'theme-color-settings-theme-color-type', '=', 'custom' ),
			),
			array(
				'id'       => 'theme-color-settings-custom-theme-color-filename',
				'type'     => 'text',
				'title'    => esc_html__( 'File Name to Save This Color Set (Optional)', 'charitab-wp' ),
				'subtitle' => esc_html__( 'If you want to save this color set as a css file then give a name of the file. File name must starts with "theme-color-". Same name will override exising one. Leave empty for not to save it as a css file.', 'charitab-wp' ),
				'desc'     => '',
				'required' => array( 'theme-color-settings-theme-color-type', '=', 'custom' ),
			),



			//Site Category CSS files
			array(
				'id'       	=> 'theme-color-settings-theme-color-custom-site-cssfile-info-field',
				'type'      => 'info',
				'title'     => esc_html__( 'Attach Premade CSS File to get extra styling throughout the site.', 'charitab-wp' ),
				'notice'    => false,
			),
			array(
				'id'       => 'theme-color-settings-premade-sitewise-css-file',
				'type'     => 'select',
				'title'    => esc_html__( 'Attach Premade CSS File into the header', 'charitab-wp' ),
				'subtitle' => esc_html__( 'These files are located in assets/css/sites folder of this theme.', 'charitab-wp' ),
				'options'	=> charitab_mascot_metabox_get_list_of_premade_sitewise_css_files(),
			),
		)
	) );



	// -> START Typography
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Typography', 'charitab-wp' ),
		'id'     => 'typography',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-editor-textcolor',
	) );

	// -> START Body Typography
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Body Typography', 'charitab-wp' ),
		'id'     => 'primary-body-typography',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-editor-textcolor',
		'subsection' => true,
		'fields' => array(
			array(
				'id'            => 'typography-primary-body',
				'type'          => 'typography',
				'title'         => esc_html__( 'Primary Body Font', 'charitab-wp' ),
				'subtitle'      => esc_html__( 'Specify the body font properties.', 'charitab-wp' ),
				//'compiler'    => true,  // Use if you want to hook in your own CSS compiler
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
			),
			array(
				'id'            => 'typography-primary-body-link-color',
				'type'          => 'color',
				'title'         => esc_html__( 'Primary Link Color', 'charitab-wp' ),
				'subtitle'      => esc_html__( 'Specify link color throughout the body.', 'charitab-wp' ),
				'transparent'   => false,
			),
		)
		
	) );

	// -> START Headings Typography
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Headings Typography', 'charitab-wp' ),
		'id'     => 'headings-typography',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-editor-textcolor',
		'subsection' => true,
		'fields' => array(
			//section H1 Starts
			array(
				'id'       => 'typography-h1-section-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Heading H1', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Define styles for heading H1.', 'charitab-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
			),
			array(
				'id'            => 'typography-h1',
				'type'          => 'typography',
				'title'         => esc_html__( 'Typography', 'charitab-wp' ),
				'subtitle'      => '',
				//'compiler'    => true,  // Use if you want to hook in your own CSS compiler
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
			),
			array(
				'id'       => 'typography-h1-margin-top-bottom',
				'type'     => 'spacing',
				// An array of CSS selectors to apply this font style to
				'mode'     => 'margin',
				// absolute, padding, margin, defaults to padding
				'all'      => false,
				// Have one field that applies to all
				'top'      => true,     // Disable the top
				'right'    => false,     // Disable the right
				'bottom'   => true,     // Disable the bottom
				'left'     => false,     // Disable the left
				'units'    => 'px',      // You can specify a unit value. Possible: px, em, %
				//'units_extended'=> 'true',    // Allow users to select any type of unit
				'display_units' => true,   // Set to false to hide the units if the units are specified
				'title'    => esc_html__( 'Margin Top & Bottom', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
			),
			array(
				'id'     => 'typography-h1-section-ends',
				'type'   => 'section',
				'indent' => false, // Indent all options below until the next 'section' option is set.
			),


			//section H2 Starts
			array(
				'id'       => 'typography-h2-section-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Heading H2', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Define styles for heading H2.', 'charitab-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
			),
			array(
				'id'            => 'typography-h2',
				'type'          => 'typography',
				'title'         => esc_html__( 'Typography', 'charitab-wp' ),
				'subtitle'      => '',
				//'compiler'    => true,  // Use if you want to hook in your own CSS compiler
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
			),
			array(
				'id'       => 'typography-h2-margin-top-bottom',
				'type'     => 'spacing',
				// An array of CSS selectors to apply this font style to
				'mode'     => 'margin',
				// absolute, padding, margin, defaults to padding
				'all'      => false,
				// Have one field that applies to all
				'top'      => true,     // Disable the top
				'right'    => false,     // Disable the right
				'bottom'   => true,     // Disable the bottom
				'left'     => false,     // Disable the left
				'units'    => 'px',      // You can specify a unit value. Possible: px, em, %
				//'units_extended'=> 'true',    // Allow users to select any type of unit
				'display_units' => true,   // Set to false to hide the units if the units are specified
				'title'    => esc_html__( 'Margin Top & Bottom', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
			),
			array(
				'id'     => 'typography-h2-section-ends',
				'type'   => 'section',
				'indent' => false, // Indent all options below until the next 'section' option is set.
			),


			//section H3 Starts
			array(
				'id'       => 'typography-h3-section-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Heading H3', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Define styles for heading H3.', 'charitab-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
			),
			array(
				'id'            => 'typography-h3',
				'type'          => 'typography',
				'title'         => esc_html__( 'Typography', 'charitab-wp' ),
				'subtitle'      => '',
				//'compiler'    => true,  // Use if you want to hook in your own CSS compiler
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
			),
			array(
				'id'       => 'typography-h3-margin-top-bottom',
				'type'     => 'spacing',
				// An array of CSS selectors to apply this font style to
				'mode'     => 'margin',
				// absolute, padding, margin, defaults to padding
				'all'      => false,
				// Have one field that applies to all
				'top'      => true,     // Disable the top
				'right'    => false,     // Disable the right
				'bottom'   => true,     // Disable the bottom
				'left'     => false,     // Disable the left
				'units'    => 'px',      // You can specify a unit value. Possible: px, em, %
				//'units_extended'=> 'true',    // Allow users to select any type of unit
				'display_units' => true,   // Set to false to hide the units if the units are specified
				'title'    => esc_html__( 'Margin Top & Bottom', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
			),
			array(
				'id'     => 'typography-h3-section-ends',
				'type'   => 'section',
				'indent' => false, // Indent all options below until the next 'section' option is set.
			),


			//section H4 Starts
			array(
				'id'       => 'typography-h4-section-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Heading H4', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Define styles for heading H4.', 'charitab-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
			),
			array(
				'id'            => 'typography-h4',
				'type'          => 'typography',
				'title'         => esc_html__( 'Typography', 'charitab-wp' ),
				'subtitle'      => '',
				//'compiler'    => true,  // Use if you want to hook in your own CSS compiler
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
			),
			array(
				'id'       => 'typography-h4-margin-top-bottom',
				'type'     => 'spacing',
				// An array of CSS selectors to apply this font style to
				'mode'     => 'margin',
				// absolute, padding, margin, defaults to padding
				'all'      => false,
				// Have one field that applies to all
				'top'      => true,     // Disable the top
				'right'    => false,     // Disable the right
				'bottom'   => true,     // Disable the bottom
				'left'     => false,     // Disable the left
				'units'    => 'px',      // You can specify a unit value. Possible: px, em, %
				//'units_extended'=> 'true',    // Allow users to select any type of unit
				'display_units' => true,   // Set to false to hide the units if the units are specified
				'title'    => esc_html__( 'Margin Top & Bottom', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
			),
			array(
				'id'     => 'typography-h4-section-ends',
				'type'   => 'section',
				'indent' => false, // Indent all options below until the next 'section' option is set.
			),


			//section H5 Starts
			array(
				'id'       => 'typography-h5-section-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Heading H5', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Define styles for heading H5.', 'charitab-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
			),
			array(
				'id'            => 'typography-h5',
				'type'          => 'typography',
				'title'         => esc_html__( 'Typography', 'charitab-wp' ),
				'subtitle'      => '',
				//'compiler'    => true,  // Use if you want to hook in your own CSS compiler
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
			),
			array(
				'id'       => 'typography-h5-margin-top-bottom',
				'type'     => 'spacing',
				// An array of CSS selectors to apply this font style to
				'mode'     => 'margin',
				// absolute, padding, margin, defaults to padding
				'all'      => false,
				// Have one field that applies to all
				'top'      => true,     // Disable the top
				'right'    => false,     // Disable the right
				'bottom'   => true,     // Disable the bottom
				'left'     => false,     // Disable the left
				'units'    => 'px',      // You can specify a unit value. Possible: px, em, %
				//'units_extended'=> 'true',    // Allow users to select any type of unit
				'display_units' => true,   // Set to false to hide the units if the units are specified
				'title'    => esc_html__( 'Margin Top & Bottom', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
			),
			array(
				'id'     => 'typography-h5-section-ends',
				'type'   => 'section',
				'indent' => false, // Indent all options below until the next 'section' option is set.
			),


			//section H6 Starts
			array(
				'id'       => 'typography-h6-section-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Heading H6', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Define styles for heading H6.', 'charitab-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
			),
			array(
				'id'            => 'typography-h6',
				'type'          => 'typography',
				'title'         => esc_html__( 'Typography', 'charitab-wp' ),
				'subtitle'      => '',
				//'compiler'    => true,  // Use if you want to hook in your own CSS compiler
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
			),
			array(
				'id'       => 'typography-h6-margin-top-bottom',
				'type'     => 'spacing',
				// An array of CSS selectors to apply this font style to
				'mode'     => 'margin',
				// absolute, padding, margin, defaults to padding
				'all'      => false,
				// Have one field that applies to all
				'top'      => true,     // Disable the top
				'right'    => false,     // Disable the right
				'bottom'   => true,     // Disable the bottom
				'left'     => false,     // Disable the left
				'units'    => 'px',      // You can specify a unit value. Possible: px, em, %
				//'units_extended'=> 'true',    // Allow users to select any type of unit
				'display_units' => true,   // Set to false to hide the units if the units are specified
				'title'    => esc_html__( 'Margin Top & Bottom', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
			),
			array(
				'id'     => 'typography-h6-section-ends',
				'type'   => 'section',
				'indent' => false, // Indent all options below until the next 'section' option is set.
			),



		)
	) );

	// -> START Button Typography
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Button Typography', 'charitab-wp' ),
		'id'     => 'primary-button-typography',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-editor-textcolor',
		'subsection' => true,
		'fields' => array(
			array(
				'id'            => 'button-typography-btn-default',
				'type'          => 'typography',
				'title'         => esc_html__( 'Typography - Button Default', 'charitab-wp' ),
				'subtitle'      => '',
				//'compiler'    => true,  // Use if you want to hook in your own CSS compiler
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
			),
			array(
				'id'       => 'button-typography-btn-default-padding',
				'type'     => 'spacing',
				// An array of CSS selectors to apply this font style to
				'mode'     => 'padding',
				// absolute, padding, margin, defaults to padding
				'all'      => false,
				// Have one field that applies to all
				'top'           => true,     // Disable the top
				'right'         => true,     // Disable the right
				'bottom'        => true,     // Disable the bottom
				'left'          => true,     // Disable the left
				'units'         => 'px',      // You can specify a unit value. Possible: px, em, %
				//'units_extended'=> 'true',    // Allow users to select any type of unit
				'display_units' => true,   // Set to false to hide the units if the units are specified
				'title'    => esc_html__( 'Padding - Button Default', 'charitab-wp' ),
			),
			array(
				'id'            => 'button-typography-btn-lg',
				'type'          => 'typography',
				'title'         => esc_html__( 'Typography - Button Large', 'charitab-wp' ),
				'subtitle'      => '',
				//'compiler'    => true,  // Use if you want to hook in your own CSS compiler
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
			),
			array(
				'id'       => 'button-typography-btn-lg-padding',
				'type'     => 'spacing',
				// An array of CSS selectors to apply this font style to
				'mode'     => 'padding',
				// absolute, padding, margin, defaults to padding
				'all'      => false,
				// Have one field that applies to all
				'top'           => true,     // Disable the top
				'right'         => true,     // Disable the right
				'bottom'        => true,     // Disable the bottom
				'left'          => true,     // Disable the left
				'units'         => 'px',      // You can specify a unit value. Possible: px, em, %
				//'units_extended'=> 'true',    // Allow users to select any type of unit
				'display_units' => true,   // Set to false to hide the units if the units are specified
				'title'    => esc_html__( 'Padding - Button Large', 'charitab-wp' ),
			),
			array(
				'id'            => 'button-typography-btn-sm',
				'type'          => 'typography',
				'title'         => esc_html__( 'Typography - Button Small', 'charitab-wp' ),
				'subtitle'      => '',
				//'compiler'    => true,  // Use if you want to hook in your own CSS compiler
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
			),
			array(
				'id'       => 'button-typography-btn-sm-padding',
				'type'     => 'spacing',
				// An array of CSS selectors to apply this font style to
				'mode'     => 'padding',
				// absolute, padding, margin, defaults to padding
				'all'      => false,
				// Have one field that applies to all
				'top'           => true,     // Disable the top
				'right'         => true,     // Disable the right
				'bottom'        => true,     // Disable the bottom
				'left'          => true,     // Disable the left
				'units'         => 'px',      // You can specify a unit value. Possible: px, em, %
				//'units_extended'=> 'true',    // Allow users to select any type of unit
				'display_units' => true,   // Set to false to hide the units if the units are specified
				'title'    => esc_html__( 'Padding - Button Small', 'charitab-wp' ),
			),
			array(
				'id'            => 'button-typography-btn-xs',
				'type'          => 'typography',
				'title'         => esc_html__( 'Typography - Button Extra Small', 'charitab-wp' ),
				'subtitle'      => '',
				//'compiler'    => true,  // Use if you want to hook in your own CSS compiler
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
			),
			array(
				'id'       => 'button-typography-btn-xs-padding',
				'type'     => 'spacing',
				// An array of CSS selectors to apply this font style to
				'mode'     => 'padding',
				// absolute, padding, margin, defaults to padding
				'all'      => false,
				// Have one field that applies to all
				'top'           => true,     // Disable the top
				'right'         => true,     // Disable the right
				'bottom'        => true,     // Disable the bottom
				'left'          => true,     // Disable the left
				'units'         => 'px',      // You can specify a unit value. Possible: px, em, %
				//'units_extended'=> 'true',    // Allow users to select any type of unit
				'display_units' => true,   // Set to false to hide the units if the units are specified
				'title'    => esc_html__( 'Padding - Button Extra Small', 'charitab-wp' ),
			),
		)
		
	) );

	// -> START Link Typography
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Post/Page Content Link Typography', 'charitab-wp' ),
		'id'     => 'content-link-typography',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-editor-textcolor',
		'subsection' => true,
		'fields' => array(
			array(
				'id'            => 'link-typography-link',
				'type'          => 'typography',
				'title'         => esc_html__( 'Link Typography', 'charitab-wp' ),
				'subtitle'      => '',
				//'compiler'    => true,  // Use if you want to hook in your own CSS compiler
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
			),
			array(
				'id'	   => 'link-typography-link-hover-color',
				'type'     => 'color',
				'title'    => esc_html__( 'Link Hover Color', 'charitab-wp' ),
				'transparent' => false,
			),
		)
	) );



	// -> START Header
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Header', 'charitab-wp' ),
		'id'     => 'header',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-arrow-up-alt',
	) );



	// -> START Header Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Header', 'charitab-wp' ),
		'id'     => 'header-settings',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-arrow-up-alt',
		'subsection' => true,
		'fields' => array(
			array(
				'id'       => 'header-settings-choose-header-visibility',
				'type'     => 'switch',
				'title'    => esc_html__( 'Header Visibility', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Show or hide header globally', 'charitab-wp' ),
				'default'  => 1,
				'on'       => 'Show',
				'off'      => 'Hide',
			),
		)
	) );


	// -> START Header Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Header Structure', 'charitab-wp' ),
		'id'     => 'header-structure',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-arrow-up-alt',
		'subsection' => true,
		'fields' => array(
			array(
				'id'   => 'info_normal',
				'type' => 'info',
				'desc' => sprintf( '<img src="%1$s" alt="header-layout">', CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/header-layout/header-layout.jpg')
			),
		)
	) );


	// -> START Header Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Header Layout', 'charitab-wp' ),
		'id'     => 'header-layout',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-arrow-up-alt',
		'subsection' => true,
		'fields' => array(
			//Header Visibility Important
			array(
				'id'        => 'header-settings-header-layout-info-field-important',
				'type'      => 'info',
				'title'     => esc_html__( 'Important!', 'charitab-wp' ),
				'subtitle'  => sprintf( esc_html__( 'As you have chosen %1$sHeader Visibility%2$s to %1$sHide%2$s so there\'s nothing to show here!', 'charitab-wp' ), '<strong>', '</strong>'),
				'notice'    => false,
				'required' => array( 'header-settings-choose-header-visibility', '!=', '1' ),
			),

			array(
				'id'       => 'header-settings-header-layout-type-container',
				'type'     => 'button_set',
				'compiler' =>true,
				'title'    => esc_html__( 'Header Container', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Put Header content boxed or stretched fullwidth.', 'charitab-wp' ),
				'options'	=> array(
					'container' => esc_html__( 'Container', 'charitab-wp' ),
					'container-fluid' => esc_html__( 'Container Fluid', 'charitab-wp' )
				),
				'default' => 'container',
				'required' => array( 'header-settings-choose-header-visibility', '=', '1' ),
			),
			/*array(
				'id'       => 'header-settings-header-layout-type-behaviour',
				'type'     => 'select',
				'title'    => esc_html__( 'Header Behaviour~', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Select the behaviour of header when you scroll down to page', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array(
					'header-fixed'  => esc_html__( 'Fixed on Scroll', 'charitab-wp' ),
					'header-sticky' => esc_html__( 'Sticky on Scroll', 'charitab-wp' ),
				),
				'default'  => 'header-fixed',
				'required' => array( 'header-settings-choose-header-visibility', '=', '1' ),
			),*/

			array(
				'id'       => 'header-settings-choose-header-layout-type',
				'type'     => 'image_select',
				'title'    => esc_html__( 'Choose Header Layout Type', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Select the type of header you would like to use', 'charitab-wp' ),
				'desc'     => '',
				//Must provide key => value(array:title|img) pairs for radio options
				'options'	=> array(
					'header-2rows' => array(
						'alt' => 'Standard Header - 2 Rows',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/header-layout/header-2rows.jpg'
					),
					'header-3rows' => array(
						'alt' => 'Standard Header - 3 Rows',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/header-layout/header-3rows.jpg'
					),
					'header-2rows-floating-header' => array(
						'alt' => 'Floating Header - 2 Rows',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/header-layout/header-2rows-floating-header.jpg'
					),
					'header-logo-center' => array(
						'alt' => '3 Rows Logo Center',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/header-layout/header-logo-center.jpg'
					),
					'header-logo-menu-center' => array(
						'alt' => '3 Rows Logo + Menu Centered',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/header-layout/header-logo-menu-center.jpg'
					),
					'header-mobile-nav' => array(
						'alt' => 'Mobile Nav',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/header-layout/header-mobile-nav.jpg'
					),
					'header-side-panel-nav' => array(
						'alt' => 'Side Panel Nav',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/header-layout/header-side-panel-nav.jpg'
					),
					'header-vertical-nav' => array(
						'alt' => 'Vertical Nav',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/header-layout/header-vertical-nav.jpg'
					),
				),
				'default'  => 'header-2rows',
				'required' => array( 'header-settings-choose-header-visibility', '=', '1' ),
			),

		)
	) );


	// -> START Header Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Header Layout Other', 'charitab-wp' ),
		'id'     => 'header-layout-other',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-arrow-up-alt',
		'subsection' => true,
		'fields' => array(
			array(
				'id'       => 'header-settings-header-layout-other-bg-shadow',
				'type'     => 'button_set',
				'compiler' =>true,
				'title'    => esc_html__( 'Header Background Shadow', 'charitab-wp' ),
				'options'	=> array(
					'header-bg-dark-shadow'		=> esc_html__( 'Dark Background Shadow', 'charitab-wp' ),
					'header-bg-light-shadow'	=> esc_html__( 'Light Background Shadow', 'charitab-wp' ),
				),
				'default' => 'header-bg-dark-shadow',
				'required' => array( 'header-settings-choose-header-layout-type', '=', 'header-2rows-floating-header' ),
			),
		)
	) );


	// -> START Header Top Row
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Header Top Row', 'charitab-wp' ),
		'id'     => 'header-header-top',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-arrow-up-alt',
		'subsection' => true,
		'fields' => array(

			//Header Visibility Important
			array(
				'id'        => 'header-settings-header-top-info-field-important',
				'type'      => 'info',
				'title'     => esc_html__( 'Important!', 'charitab-wp' ),
				'subtitle'  => sprintf( esc_html__( 'As you have chosen %1$sHeader Visibility%2$s to %1$sHide%2$s so there\'s nothing to show here!', 'charitab-wp' ), '<strong>', '</strong>'),
				'notice'    => false,
				'required' => array( 'header-settings-choose-header-visibility', '!=', '1' ),
			),


			array(
				'id'       => 'header-settings-choose-header-top-cpt-widget-area',
				'type'     => 'select',
				'title'    => esc_html__( 'Choose Pre Made Header Top Area', 'charitab-wp' ),
				'subtitle' => esc_html__( 'It will be shown at the very top of the page. You can customize this part from Admin Dashboard > Parts - Header Top.', 'charitab-wp' ),
				'desc'     => '',
				'data'     => 'posts',
				'args' => array(
					'post_type' => array( 'header-top' ),
				),
			),

			array(
				'id'       => 'header-settings-show-header-top',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Remaining Header Top Area', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enabling this option will show Header Top section', 'charitab-wp' ),
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
				'required' => array( 'header-settings-choose-header-visibility', '=', '1' ),
			),
			array(
				'id'       => 'header-settings-show-header-top-in-mobile',
				'type'     => 'switch',
				'title'    => esc_html__( '|--- Show Header Top in Mobile Devices', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Show/Hide Header Top in Mobile View', 'charitab-wp' ),
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
				'required'  => array( 
					array( 'header-settings-show-header-top', '=', '1' )
				)
			),






			//Header Top Column 1
			array(
				'id'        => 'header-settings-header-top-column1-info-field-column1',
				'type'      => 'info',
				'title'     => esc_html__( 'Header Top Column 1 - Left Widget', 'charitab-wp' ),
				'subtitle'  => esc_html__( 'Choose content to display on column 1 (Left Widget) of header top', 'charitab-wp' ),
				'notice'    => false,
				'required'  => array( 
					array( 'header-settings-show-header-top', '=', '1' )
				)
			),
			array(
				'id'       => 'header-settings-header-top-column1-content',
				'type'     => 'select',
				'title'    => esc_html__( 'Column 1 (Left Widget) - Content Types', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Choose content type to display on column 1.', 'charitab-wp' ),
				'desc'     => sprintf( esc_html__( '> You can choose multiple and rearrange them by moving left or right! %3$s> In case of %1$s"Social Links"%2$s, you will find it\'s settings at %1$sTheme Options > Social Links%2$s. %3$s> In case of %1$s"Header Top Navigation"%2$s, Please create a new menu from %1$sAppearance > Menus%2$s and set Theme Location %1$s"Column 1 - Header Top Navigation"%2$s', 'charitab-wp' ), '<strong>', '</strong>', '<br>'),
				'multi'    => true,
				'sortable' => true,
				'options'	=> array(
					'contact-info'      => esc_html__( 'Contact Info', 'charitab-wp' ),
					'custom-text'       => esc_html__( 'Custom Text', 'charitab-wp' ),
					'custom-button'     => esc_html__( 'Custom Button', 'charitab-wp' ),
					'header-top-nav'    => esc_html__( 'Header Top Navigation', 'charitab-wp' ),
					'social-links'      => esc_html__( 'Social Links', 'charitab-wp' ),
					'search-box'        => esc_html__( 'Search Box', 'charitab-wp' ),
					'header-top-side-push-panel'   => esc_html__( 'Side Push Panel', 'charitab-wp' ),
					'login-register'    => esc_html__( 'Login/Register', 'charitab-wp' ),
					'wpml-languages'    => esc_html__( 'WPML Languages', 'charitab-wp' ),
					'checkout-button'   => esc_html__( 'Checkout Button', 'charitab-wp' ),
				),
				'default'  => array(
					'contact-info',
				),
				'required' => array( 
					array( 'header-settings-show-header-top', '=', '1' )
				)
			),


			//Column 1 - Contact Info
			array(
				'id'       => 'header-settings-header-top-column1-contact-info-section-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Column 1 - Contact Info', 'charitab-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
				'required' => array( 
					array( 'header-settings-header-top-column1-content', '=', 'contact-info' )
				)
			),
			array(
				'id'       => 'header-settings-header-top-column1-contact-info-checkbox',
				'type'     => 'sortable',
				'title'    => esc_html__( 'Column 1 - Contact Info Visibility and Ordering', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Show/Hide each item individually. Reorder them by moving up or down!', 'charitab-wp' ),
				'desc'     => esc_html__( 'Please choose which fields you want to display.', 'charitab-wp' ),
				'label'    => true,
				'mode'     => 'checkbox',
				'options'	=> array(
					'phone'           => esc_html__( 'Phone', 'charitab-wp' ),
					'email'           => esc_html__( 'Email', 'charitab-wp' ),
					'address'         => esc_html__( 'Address', 'charitab-wp' ),
					'opening-hours'   => esc_html__( 'Opening Hours', 'charitab-wp' ),
				),
				'default' => array(
					'phone'           => 1,
					'email'           => 1,
					'address'         => 0,
					'opening-hours'   => 0,
				),
			),
			array(
				'id'       => 'header-settings-header-top-column1-contact-info-phone',
				'type'     => 'text',
				'title'    => esc_html__( 'Contact Info - Phone', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enter your custom contact info.', 'charitab-wp' ),
				'desc'     => esc_html__( 'Reorder them by moving up or down!', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array(
					'icon'           => esc_html__( 'Icon', 'charitab-wp' ),
					'text'           => esc_html__( 'Text', 'charitab-wp' ),
				),
				'default' => array(
					'icon'           => 'fa fa-phone',
					'text'           => esc_html__( '(123) 456-78-90', 'charitab-wp' ),
				),
			),

			array(
				'id'       => 'header-settings-header-top-column1-contact-info-email',
				'type'     => 'text',
				'title'    => esc_html__( 'Contact Info - Email', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enter your custom contact info.', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array(
					'icon'           => esc_html__( 'Icon', 'charitab-wp' ),
					'text'           => esc_html__( 'Text', 'charitab-wp' ),
				),
				'default' => array(
					'icon'           => 'fa fa-envelope-o',
					'text'           => 'info@example.com',
				),
			),
			array(
				'id'       => 'header-settings-header-top-column1-contact-info-address',
				'type'     => 'text',
				'title'    => esc_html__( 'Contact Info - Address', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enter your custom contact info.', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array(
					'icon'           => esc_html__( 'Icon', 'charitab-wp' ),
					'text'           => esc_html__( 'Text', 'charitab-wp' ),
				),
				'default' => array(
					'icon'           => 'fa fa-map-o',
					'text'           => esc_html__( '121 King Street, Melbourne', 'charitab-wp' ),
				),
			),
			array(
				'id'       => 'header-settings-header-top-column1-contact-info-opening-hours',
				'type'     => 'text',
				'title'    => esc_html__( 'Contact Info - Opening Hours', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enter your custom contact info.', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array(
					'icon'           => esc_html__( 'Icon', 'charitab-wp' ),
					'text'           => esc_html__( 'Text', 'charitab-wp' ),
				),
				'default' => array(
					'icon'           => 'fa fa-clock-o',
					'text'           => esc_html__( 'Mon-Fri 09:00-17:00', 'charitab-wp' ),
				),
			),
			array(
				'id'       => 'header-settings-header-top-column1-contact-info-section-ends',
				'type'     => 'section',
				'title'    => '',
				'subtitle' => '',
				'indent'   => false, // Indent all options below until the next 'section' option is set.
				'required' => array( 
					array( 'header-settings-header-top-column1-content', '=', 'contact-info' )
				)
			),



			//Column 1 - Custom Text
			array(
				'id'       => 'header-settings-header-top-column1-custom-text-section-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Column 1 - Custom Text', 'charitab-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
				'required' => array( 
					array( 'header-settings-header-top-column1-content', '=', 'custom-text' )
				)
			),
			array(
				'id'       => 'header-settings-header-top-column1-custom-text',
				'type'     => 'textarea',
				'title'    => esc_html__( 'Column 1 - Custom Text', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enter your custom text. Custom HTML tags are allowed (wp_kses).', 'charitab-wp' ),
				'rows'     => '3',
				'desc'     => '',
				'default'  => sprintf( esc_html__( 'Custom %1$sheader top%1$s text goes here!', 'charitab-wp' ), '<br>'),
				'validate' => 'html_custom',
				'allowed_html' => array(
					'a' => array(
						'href' => array(),
						'title' => array(),
						'class' => array(),
						'id' => array()
					),
					'br' => array(),
					'em' => array(),
					'strong' => array()
				),
			),
			array(
				'id'       => 'header-settings-header-top-column1-custom-text-section-ends',
				'type'     => 'section',
				'title'    => '',
				'subtitle' => '',
				'indent'   => false, // Indent all options below until the next 'section' option is set.
				'required' => array( 
					array( 'header-settings-header-top-column1-content', '=', 'custom-text' )
				)
			),




			//Column 1 - Custom Button
			array(
				'id'       => 'header-settings-header-top-column1-custom-button-section-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Column 1 - Custom Button', 'charitab-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
				'required' => array( 
					array( 'header-settings-header-top-column1-content', '=', 'custom-button' )
				)
			),
			array(
				'id'       => 'header-settings-header-top-column1-custom-button',
				'type'     => 'sortable',
				'title'    => esc_html__( 'Column 1 - Custom Button', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enter your custom button info.', 'charitab-wp' ),
				'desc'     => esc_html__( 'Show a custom button in the header top.', 'charitab-wp' ),
				'label'    => true,
				'options'	=> array(
					esc_html__( 'Button Title', 'charitab-wp' )  => '',
					esc_html__( 'Button Link', 'charitab-wp' )   => '',
				),
				'default' => array(
					esc_html__( 'Button Title', 'charitab-wp' )  => esc_html__( 'Custom Button', 'charitab-wp' ),
					esc_html__( 'Button Link', 'charitab-wp' )   => '#',
				),
			),
			array(
				'id'       => 'header-settings-header-top-column1-custom-button-design-style',
				'type'     => 'select',
				'title'    => esc_html__( 'Button Design Style', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array_flip( charitab_mascot_get_btn_design_style() ),
				'default'  => 'btn-gray',
			),
			array(
				'id'       => 'header-settings-header-top-column1-custom-button-size',
				'type'     => 'select',
				'title'    => esc_html__( 'Button Size', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array_flip( charitab_mascot_get_button_size() ),
			),
			array(
				'id'       => 'header-settings-header-top-column1-custom-button-flat',
				'type'     => 'switch',
				'title'    => esc_html__( 'Make Button Flat', 'charitab-wp' ),
				'default'  => 1,
			),
			array(
				'id'       => 'header-settings-header-top-column1-custom-button-outlined',
				'type'     => 'switch',
				'title'    => esc_html__( 'Make Button Outlined', 'charitab-wp' ),
				'default'  => 0,
			),
			array(
				'id'       => 'header-settings-header-top-column1-custom-button-round',
				'type'     => 'switch',
				'title'    => esc_html__( 'Make Button Round', 'charitab-wp' ),
				'default'  => 0,
			),
			array(
				'id'       => 'header-settings-header-top-column1-custom-button-link-open-in-window',
				'type'     => 'select',
				'title'    => esc_html__( 'Open Link in', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'options'	=> array(
					'_blank' => esc_html__( 'New Tab', 'charitab-wp' ),
					'_self'  => esc_html__( 'Same Tab', 'charitab-wp' ),
				),
				'default'  => '_blank',
			),
			array(
				'id'       => 'header-settings-header-top-column1-custom-button-section-ends',
				'type'     => 'section',
				'title'    => '',
				'subtitle' => '',
				'indent'   => false, // Indent all options below until the next 'section' option is set.
				'required' => array( 
					array( 'header-settings-header-top-column1-content', '=', 'custom-button' )
				)
			),



			//Column 1 - Social Links
			array(
				'id'       => 'header-settings-header-top-column1-social-links-section-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Column 1 - Social Links', 'charitab-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
				'required' => array( 
					array( 'header-settings-header-top-column1-content', '=', 'social-links' )
				)
			),
			array(
				'id'       => 'header-settings-header-top-column1-social-links-label',
				'type'     => 'text',
				'title'    => esc_html__( 'Social Links Label', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enter the text that will be appeared on the left side of social links', 'charitab-wp' ),
				'desc'     => '',
			),
			array(
				'id'       => 'header-settings-header-top-column1-social-links-color',
				'type'     => 'select',
				'title'    => esc_html__( 'Social Links - Background Color', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array(
					'icon-gray'     => esc_html__( 'Gray', 'charitab-wp' ),
					'icon-dark'     => esc_html__( 'Dark', 'charitab-wp' ),
					'icon-white'    => esc_html__( 'White', 'charitab-wp' ),
					''              => esc_html__( 'Default', 'charitab-wp' ),
				),
				'default'  => 'icon-gray',
			),
			array(
				'id'       => 'header-settings-header-top-column1-social-links-icon-style',
				'type'     => 'select',
				'title'    => esc_html__( 'Social Links Icon Style', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array(
					'icon-rounded'   => esc_html__( 'Rounded', 'charitab-wp' ),
					'icon-default'	 => esc_html__( 'Default', 'charitab-wp' ),
					'icon-circled'   => esc_html__( 'Circled', 'charitab-wp' ),
				),
				'default'  => 'icon-circled',
			),
			array(
				'id'       => 'header-settings-header-top-column1-social-links-icon-size',
				'type'     => 'select',
				'title'    => esc_html__( 'Social Links Icon Size', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array(
					'icon-xs'   => esc_html__( 'Extra Small', 'charitab-wp' ),
					'icon-sm'	=> esc_html__( 'Small', 'charitab-wp' ),
					'icon-md'   => esc_html__( 'Medium', 'charitab-wp' ),
					'icon-lg'   => esc_html__( 'Large', 'charitab-wp' ),
					'icon-xl'   => esc_html__( 'Extra Large', 'charitab-wp' ),
				),
				'default'  => 'icon-xs',
			),
			array(
				'id'       => 'header-settings-header-top-column1-social-links-icon-border-style',
				'type'     => 'checkbox',
				'title'    => esc_html__( 'Make Icon Area Bordered?', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'default'  => '0',
			),
			array(
				'id'       => 'header-settings-header-top-column1-social-links-theme-colored',
				'type'     => 'select',
				'title'    => esc_html__( 'Make Social Links Theme Colored?', 'charitab-wp' ),
				'subtitle' => esc_html__( 'To make the social links theme colored, please check it.', 'charitab-wp' ),
				'desc'     => '',
				'options'  => charitab_mascot_theme_color_list(),
				'default'  => '',
			),
			array(
				'id'       => 'header-settings-header-top-column1-social-links-section-ends',
				'type'     => 'section',
				'title'    => '',
				'subtitle' => '',
				'indent'   => false, // Indent all options below until the next 'section' option is set.
				'required' => array( 
					array( 'header-settings-header-top-column1-content', '=', 'social-links' )
				)
			),


			//Column 1 - Text Alignment
			array(
				'id'       => 'header-settings-header-top-column1-text-align-section-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Column 1 - Text Alignment', 'charitab-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
				'required' => array( 
					array( 'header-settings-show-header-top', '=', '1' )
				)
			),
			array(
				'id'       => 'header-settings-header-top-column1-text-align',
				'type'     => 'select',
				'title'    => esc_html__( 'Column 1 - Text Alignment', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Text Alignment in Header Top Column 1', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> charitab_mascot_redux_text_alignment_single_word_list(),
				'default'  => 'left',
			),
			array(
				'id'       => 'header-settings-header-top-column1-text-align-section-ends',
				'type'     => 'section',
				'title'    => '',
				'subtitle' => '',
				'indent'   => false, // Indent all options below until the next 'section' option is set.
				'required' => array( 
					array( 'header-settings-show-header-top', '=', '1' )
				)
			),








			//Header Top Column 2
			array(
				'id'        => 'header-settings-header-top-column2-info-field-column2',
				'type'      => 'info',
				'title'     => esc_html__( 'Header Top Column 2 - Right Widget', 'charitab-wp' ),
				'subtitle'  => esc_html__( 'Choose content to display on column 2 (Left Widget) of header top', 'charitab-wp' ),
				'notice'    => false,
				'required'  => array( 
					array( 'header-settings-show-header-top', '=', '1' )
				)
			),
			array(
				'id'       => 'header-settings-header-top-column2-content',
				'type'     => 'select',
				'title'    => esc_html__( 'Column 2 (Right Widget) - Content Types', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Choose content type to display on column 2.', 'charitab-wp' ),
				'desc'     => sprintf( esc_html__( '> You can choose multiple and rearrange them by moving left or right! %3$s> In case of %1$s"Social Links"%2$s, you will find it\'s settings at %1$sTheme Options > Social Links%2$s. %3$s> In case of %1$s"Header Top Navigation"%2$s, Please create a new menu from %1$sAppearance > Menus%2$s and set Theme Location %1$s"Column 2 - Header Top Navigation"%2$s', 'charitab-wp' ), '<strong>', '</strong>', '<br>'),
				'multi'    => true,
				'sortable' => true,
				'options'	=> array(
					'contact-info'      => esc_html__( 'Contact Info', 'charitab-wp' ),
					'custom-text'       => esc_html__( 'Custom Text', 'charitab-wp' ),
					'custom-button'     => esc_html__( 'Custom Button', 'charitab-wp' ),
					'header-top-nav'    => esc_html__( 'Header Top Navigation', 'charitab-wp' ),
					'social-links'      => esc_html__( 'Social Links', 'charitab-wp' ),
					'search-box'        => esc_html__( 'Search Box', 'charitab-wp' ),
					'header-top-side-push-panel'   => esc_html__( 'Side Push Panel', 'charitab-wp' ),
					'login-register'    => esc_html__( 'Login/Register', 'charitab-wp' ),
					'wpml-languages'    => esc_html__( 'WPML Languages', 'charitab-wp' ),
					'checkout-button'   => esc_html__( 'Checkout Button', 'charitab-wp' ),
				),
				'default'  => array(
					'social-links',
				),
				'required' => array( 
					array( 'header-settings-show-header-top', '=', '1' )
				)
			),


			//Column 2 - Contact Info
			array(
				'id'       => 'header-settings-header-top-column2-contact-info-section-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Column 2 - Contact Info', 'charitab-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
				'required' => array( 
					array( 'header-settings-header-top-column2-content', '=', 'contact-info' )
				)
			),
			array(
				'id'       => 'header-settings-header-top-column2-contact-info-checkbox',
				'type'     => 'sortable',
				'title'    => esc_html__( 'Column 2 - Contact Info Visibility and Ordering', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Show/Hide each item individually. Reorder them by moving up or down!', 'charitab-wp' ),
				'desc'     => esc_html__( 'Please choose which fields you want to display.', 'charitab-wp' ),
				'label'    => true,
				'mode'     => 'checkbox',
				'options'	=> array(
					'phone'           => esc_html__( 'Phone', 'charitab-wp' ),
					'email'           => esc_html__( 'Email', 'charitab-wp' ),
					'address'         => esc_html__( 'Address', 'charitab-wp' ),
					'opening-hours'   => esc_html__( 'Opening Hours', 'charitab-wp' ),
				),
				'default' => array(
					'phone'           => 1,
					'email'           => 1,
					'address'         => 0,
					'opening-hours'   => 0,
				),
			),
			array(
				'id'       => 'header-settings-header-top-column2-contact-info-phone',
				'type'     => 'text',
				'title'    => esc_html__( 'Contact Info - Phone', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enter your custom contact info.', 'charitab-wp' ),
				'desc'     => esc_html__( 'Reorder them by moving up or down!', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array(
					'icon'           => esc_html__( 'Icon', 'charitab-wp' ),
					'text'           => esc_html__( 'Text', 'charitab-wp' ),
				),
				'default' => array(
					'icon'           => 'fa fa-phone',
					'text'           => esc_html__( 'Questions? Call us at: (123) 456-78-90', 'charitab-wp' ),
				),
			),
			array(
				'id'       => 'header-settings-header-top-column2-contact-info-email',
				'type'     => 'text',
				'title'    => esc_html__( 'Contact Info - Email', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enter your custom contact info.', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array(
					'icon'           => esc_html__( 'Icon', 'charitab-wp' ),
					'text'           => esc_html__( 'Text', 'charitab-wp' ),
				),
				'default' => array(
					'icon'           => 'fa fa-envelope-o',
					'text'           => 'info@example.com',
				),
			),
			array(
				'id'       => 'header-settings-header-top-column2-contact-info-address',
				'type'     => 'text',
				'title'    => esc_html__( 'Contact Info - Address', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enter your custom contact info.', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array(
					'icon'           => esc_html__( 'Icon', 'charitab-wp' ),
					'text'           => esc_html__( 'Text', 'charitab-wp' ),
				),
				'default' => array(
					'icon'           => 'fa fa-map-o',
					'text'           => esc_html__( 'Your Company Location', 'charitab-wp' ),
				),
			),
			array(
				'id'       => 'header-settings-header-top-column2-contact-info-opening-hours',
				'type'     => 'text',
				'title'    => esc_html__( 'Contact Info - Opening Hours', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enter your custom contact info.', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array(
					'icon'           => esc_html__( 'Icon', 'charitab-wp' ),
					'text'           => esc_html__( 'Text', 'charitab-wp' ),
				),
				'default' => array(
					'icon'           => 'fa fa-clock-o',
					'text'           => esc_html__( 'Mon-Fri 09:00-17:00', 'charitab-wp' ),
				),
			),
			array(
				'id'       => 'header-settings-header-top-column2-contact-info-section-ends',
				'type'     => 'section',
				'title'    => '',
				'subtitle' => '',
				'indent'   => false, // Indent all options below until the next 'section' option is set.
				'required' => array( 
					array( 'header-settings-header-top-column2-content', '=', 'contact-info' )
				)
			),



			//Column 2 - Custom Text
			array(
				'id'       => 'header-settings-header-top-column2-custom-text-section-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Column 2 - Custom Text', 'charitab-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
				'required' => array( 
					array( 'header-settings-header-top-column2-content', '=', 'custom-text' )
				)
			),
			array(
				'id'       => 'header-settings-header-top-column2-custom-text',
				'type'     => 'textarea',
				'title'    => esc_html__( 'Column 2 - Custom Text', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enter your custom text. Custom HTML tags are allowed (wp_kses).', 'charitab-wp' ),
				'rows'     => '3',
				'desc'     => '',
				'default'  => sprintf( esc_html__( 'Custom %1$sheader top%2$s text goes here!', 'charitab-wp' ), '<strong>', '</strong>'),
				'validate' => 'html_custom',
				'allowed_html' => array(
					'a' => array(
						'href' => array(),
						'title' => array(),
						'class' => array(),
						'id' => array()
					),
					'br' => array(),
					'em' => array(),
					'strong' => array()
				),
			),
			array(
				'id'       => 'header-settings-header-top-column2-custom-text-section-ends',
				'type'     => 'section',
				'title'    => '',
				'subtitle' => '',
				'indent'   => false, // Indent all options below until the next 'section' option is set.
				'required' => array( 
					array( 'header-settings-header-top-column2-content', '=', 'custom-text' )
				)
			),




			//Column 2 - Custom Button
			array(
				'id'       => 'header-settings-header-top-column2-custom-button-section-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Column 2 - Custom Button', 'charitab-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
				'required' => array( 
					array( 'header-settings-header-top-column2-content', '=', 'custom-button' )
				)
			),
			array(
				'id'       => 'header-settings-header-top-column2-custom-button',
				'type'     => 'sortable',
				'title'    => esc_html__( 'Column 2 - Custom Button', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enter your custom button info.', 'charitab-wp' ),
				'desc'     => esc_html__( 'Show a custom button in the header top.', 'charitab-wp' ),
				'label'    => true,
				'options'	=> array(
					esc_html__( 'Button Title', 'charitab-wp' )  => '',
					esc_html__( 'Button Link', 'charitab-wp' )   => '',
				),
				'default' => array(
					esc_html__( 'Button Title', 'charitab-wp' )  => esc_html__( 'Custom Button', 'charitab-wp' ),
					esc_html__( 'Button Link', 'charitab-wp' )   => '#',
				),
			),
			array(
				'id'       => 'header-settings-header-top-column2-custom-button-design-style',
				'type'     => 'select',
				'title'    => esc_html__( 'Button Design Style', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array_flip( charitab_mascot_get_btn_design_style() ),
				'default'  => 'btn-gray',
			),
			array(
				'id'       => 'header-settings-header-top-column2-custom-button-size',
				'type'     => 'select',
				'title'    => esc_html__( 'Button Size', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array_flip( charitab_mascot_get_button_size() ),
			),
			array(
				'id'       => 'header-settings-header-top-column2-custom-button-flat',
				'type'     => 'switch',
				'title'    => esc_html__( 'Make Button Flat', 'charitab-wp' ),
				'default'  => 1,
			),
			array(
				'id'       => 'header-settings-header-top-column2-custom-button-outlined',
				'type'     => 'switch',
				'title'    => esc_html__( 'Make Button Outlined', 'charitab-wp' ),
				'default'  => 0,
			),
			array(
				'id'       => 'header-settings-header-top-column2-custom-button-round',
				'type'     => 'switch',
				'title'    => esc_html__( 'Make Button Round', 'charitab-wp' ),
				'default'  => 0,
			),
			array(
				'id'       => 'header-settings-header-top-column2-custom-button-link-open-in-window',
				'type'     => 'select',
				'title'    => esc_html__( 'Open Link in', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'options'	=> array(
					'_blank' => esc_html__( 'New Tab', 'charitab-wp' ),
					'_self'  => esc_html__( 'Same Tab', 'charitab-wp' ),
				),
				'default'  => '_blank',
			),
			array(
				'id'       => 'header-settings-header-top-column2-custom-button-section-ends',
				'type'     => 'section',
				'title'    => '',
				'subtitle' => '',
				'indent'   => false, // Indent all options below until the next 'section' option is set.
				'required' => array( 
					array( 'header-settings-header-top-column2-content', '=', 'custom-button' )
				)
			),




			//Column 2 - Social Links
			array(
				'id'       => 'header-settings-header-top-column2-social-links-section-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Column 2 - Social Links', 'charitab-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
				'required' => array( 
					array( 'header-settings-header-top-column2-content', '=', 'social-links' )
				)
			),
			array(
				'id'       => 'header-settings-header-top-column2-social-links-label',
				'type'     => 'text',
				'title'    => esc_html__( 'Social Links Label', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enter the text that will be appeared on the left side of social links', 'charitab-wp' ),
				'desc'     => '',
			),
			array(
				'id'       => 'header-settings-header-top-column2-social-links-color',
				'type'     => 'select',
				'title'    => esc_html__( 'Social Links - Background Color', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array(
					'icon-gray'     => esc_html__( 'Gray', 'charitab-wp' ),
					'icon-dark'     => esc_html__( 'Dark', 'charitab-wp' ),
					'icon-white'    => esc_html__( 'White', 'charitab-wp' ),
					''              => esc_html__( 'Default', 'charitab-wp' ),
				),
				'default'  => 'icon-gray',
			),
			array(
				'id'       => 'header-settings-header-top-column2-social-links-icon-style',
				'type'     => 'select',
				'title'    => esc_html__( 'Social Links Icon Style', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array(
					'icon-rounded'   => esc_html__( 'Rounded', 'charitab-wp' ),
					'icon-default'	 => esc_html__( 'Default', 'charitab-wp' ),
					'icon-circled'   => esc_html__( 'Circled', 'charitab-wp' ),
				),
				'default'  => 'icon-circled',
			),
			array(
				'id'       => 'header-settings-header-top-column2-social-links-icon-size',
				'type'     => 'select',
				'title'    => esc_html__( 'Social Links Icon Size', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array(
					'icon-xs'   => esc_html__( 'Extra Small', 'charitab-wp' ),
					'icon-sm'	=> esc_html__( 'Small', 'charitab-wp' ),
					'icon-md'   => esc_html__( 'Medium', 'charitab-wp' ),
					'icon-lg'   => esc_html__( 'Large', 'charitab-wp' ),
					'icon-xl'   => esc_html__( 'Extra Large', 'charitab-wp' ),
				),
				'default'  => 'icon-xs',
			),
			array(
				'id'       => 'header-settings-header-top-column2-social-links-icon-border-style',
				'type'     => 'checkbox',
				'title'    => esc_html__( 'Make Icon Area Bordered?', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'default'  => '0',
			),
			array(
				'id'       => 'header-settings-header-top-column2-social-links-theme-colored',
				'type'     => 'select',
				'title'    => esc_html__( 'Make Social Links Theme Colored?', 'charitab-wp' ),
				'subtitle' => esc_html__( 'To make the social links theme colored, please check it.', 'charitab-wp' ),
				'desc'     => '',
				'options'  => charitab_mascot_theme_color_list(),
				'default'  => '',
			),
			array(
				'id'       => 'header-settings-header-top-column2-social-links-section-ends',
				'type'     => 'section',
				'title'    => '',
				'subtitle' => '',
				'indent'   => false, // Indent all options below until the next 'section' option is set.
				'required' => array( 
					array( 'header-settings-header-top-column2-content', '=', 'social-links' )
				)
			),


			//Column 2 - Text Alignment
			array(
				'id'       => 'header-settings-header-top-column2-text-align-section-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Column 2 - Text Alignment', 'charitab-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
				'required' => array( 
					array( 'header-settings-show-header-top', '=', '1' )
				)
			),
			array(
				'id'       => 'header-settings-header-top-column2-text-align',
				'type'     => 'select',
				'title'    => esc_html__( 'Column 2 - Text Alignment', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Text Alignment in Header Top Column 2', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> charitab_mascot_redux_text_alignment_single_word_list(),
				'default'  => 'right',
			),
			array(
				'id'       => 'header-settings-header-top-column2-text-align-section-ends',
				'type'     => 'section',
				'title'    => '',
				'subtitle' => '',
				'indent'   => false, // Indent all options below until the next 'section' option is set.
				'required' => array( 
					array( 'header-settings-show-header-top', '=', '1' )
				)
			),





			//Header Top Other Settings
			array(
				'id'        => 'header-settings-header-top-info-field-other-settings',
				'type'      => 'info',
				'title'     => esc_html__( 'Header Top Other Settings', 'charitab-wp' ),
				'notice'    => false,
				'required'  => array( 
					array( 'header-settings-show-header-top', '=', '1' )
				)
			),
			array(
				'id'       => 'header-settings-header-top-padding-top-bottom',
				'type'     => 'spacing',
				// An array of CSS selectors to apply this font style to
				'mode'     => 'padding',
				// absolute, padding, margin, defaults to padding
				'all'      => false,
				// Have one field that applies to all
				'top'           => true,     // Disable the top
				'right'         => false,     // Disable the right
				'bottom'        => true,     // Disable the bottom
				'left'          => false,     // Disable the left
				'units'         => 'px',      // You can specify a unit value. Possible: px, em, %
				//'units_extended'=> 'true',    // Allow users to select any type of unit
				'display_units' => true,   // Set to false to hide the units if the units are specified
				'title'    => esc_html__( 'Padding Top & Bottom(px)', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Padding for top and bottom in px.', 'charitab-wp' ),
				'desc'     => sprintf( esc_html__( 'Default Padding Top is 20px and Bottom is 20px. %1$sPlease put only integer value. Because the unit \'px\' will be automatically added to the end of the value.', 'charitab-wp' ), '<br>'),
				'required' => array( 
					array( 'header-settings-show-header-top', '=', '1' )
				)
			),
			array(
				'id'       => 'header-settings-header-top-bgcolor-use-themecolor',
				'type'     => 'select',
				'title'    => esc_html__( 'Use Theme Color in Background?', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Use theme color or custom bg color', 'charitab-wp' ),
				'desc'     => '',
				'options'  => charitab_mascot_theme_color_list(),
				'default'  => '',
				'required' => array( 
					array( 'header-settings-show-header-top', '=', '1' )
				)
			),
			array(
				'id'       => 'header-settings-header-top-custom-bgcolor',
				'type'     => 'color',
				'title'    => esc_html__( 'Custom Background Color', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Pick a custom background color for Header Top.', 'charitab-wp' ),
				'transparent' => true,
				'required' => array( 
					array( 'header-settings-show-header-top', '=', '1' ),
					array( 'header-settings-header-top-bgcolor-use-themecolor', '=', '' ),
				)
			),
			/*array(
				'id'       => 'header-settings-header-top-has-border',
				'type'     => 'switch',
				'title'    => esc_html__( 'Top Bar in Grid Border?', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Put visible grid border in top bar.', 'charitab-wp' ),
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
				'required' => array( 
					array( 'header-settings-show-header-top', '=', '1' )
				)
			),*/



		)
	) );


	// -> START Header Top Typography
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Header Top Typography', 'charitab-wp' ),
		'id'     => 'header-header-top-typography',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-arrow-up-alt',
		'subsection' => true,
		'fields' => array(

			//Header Top Typography
			array(
				'id'        => 'header-settings-header-top-info-field-typography',
				'type'      => 'info',
				'title'     => esc_html__( 'Header Top Typography', 'charitab-wp' ),
				'notice'    => false,
				'required'  => array( 
					array( 'header-settings-show-header-top', '=', '1' )
				)
			),
			array(
				'id'            => 'header-settings-header-top-widget-text-typography',
				'type'          => 'typography',
				'title'         => esc_html__( 'Widget Text Typography', 'charitab-wp' ),
				'subtitle'      => '',
				//'compiler'    => true,  // Use if you want to hook in your own CSS compiler
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
				'required'      => array( 
					array( 'header-settings-show-header-top', '=', '1' )
				)
			),
			array(
				'id'            => 'header-settings-header-top-widget-link-typography',
				'type'          => 'typography',
				'title'         => esc_html__( 'Widget Link Typography', 'charitab-wp' ),
				'subtitle'      => '',
				//'compiler'    => true,  // Use if you want to hook in your own CSS compiler
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
				'required'      => array( 
					array( 'header-settings-show-header-top', '=', '1' )
				)
			),
			array(
				'id'       => 'header-settings-header-top-widget-link-hover-color',
				'type'     => 'color',
				'title'    => esc_html__( 'Widget Link Hover/Active Color', 'charitab-wp' ),
				'subtitle' => '',
				'transparent' => false,
				'required' => array( 
					array( 'header-settings-show-header-top', '=', '1' )
				)
			),
		)
	) );



	// -> START Header Middle Row
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Header Middle Row', 'charitab-wp' ),
		'id'     => 'header-header-mid',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-arrow-up-alt',
		'subsection' => true,
		'fields' => array(

			//Header Visibility Important
			array(
				'id'        => 'header-settings-header-mid-info-field-important',
				'type'      => 'info',
				'title'     => esc_html__( 'Important!', 'charitab-wp' ),
				'subtitle'  => sprintf( esc_html__( 'As you have chosen %1$sHeader Visibility%2$s to %1$sHide%2$s so there\'s nothing to show here!', 'charitab-wp' ), '<strong>', '</strong>'),
				'notice'    => false,
				'required' => array( 'header-settings-choose-header-visibility', '!=', '1' ),
			),

			//Header Visibility Important
			array(
				'id'        => 'header-settings-header-mid-info-field-only-visible-header-2',
				'type'      => 'info',
				'title'     => esc_html__( 'Important! Features Availability.', 'charitab-wp' ),
				'subtitle'  => esc_html__( 'Header Middle Row features are only available for "Header Layout Type - 3 Rows"! So please choose it from Header Layout tab.', 'charitab-wp' ),
				'notice'    => false,
			),


			//Header Middle Row Column 3
			array(
				'id'       => 'header-settings-header-mid-column3-bgcolor-use-themecolor',
				'type'     => 'select',
				'title'    => esc_html__( 'Use Theme Color in Background?', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Use theme color or custom bg color', 'charitab-wp' ),
				'desc'     => '',
				'options'  => charitab_mascot_theme_color_list(),
				'default'  => '',
			),
			array(
				'id'       => 'header-settings-header-mid-column3-custom-bgcolor',
				'type'     => 'color',
				'title'    => esc_html__( 'Custom Background Color', 'charitab-wp' ),
				'subtitle' => '',
				'subtitle' => esc_html__( 'Pick a custom background color for Header Middle Row.', 'charitab-wp' ),
				'transparent' => true,
				'required' => array( 
					array( 'header-settings-header-mid-column3-bgcolor-use-themecolor', '=', '' ),
				)
			),

			array(
				'id'        => 'header-settings-header-mid-column3-info-field-column3',
				'type'      => 'info',
				'title'     => esc_html__( 'Column 3: Header Middle Row Right Widget', 'charitab-wp' ),
				'subtitle'  => esc_html__( 'Here we have treated Column 3 as the header middle row right widget.', 'charitab-wp' ),
				'notice'    => false,
			),
			array(
				'id'       => 'header-settings-header-mid-column3-content',
				'type'     => 'select',
				'title'    => esc_html__( 'Column 3 - Content Types', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Choose content type to display on column 3.', 'charitab-wp' ),
				'desc'     => sprintf( esc_html__( '> You can choose multiple and rearrange them by moving left or right! %3$s> In case of %1$s"Social Links"%2$s, you will find it\'s settings at %1$sTheme Options > Social Links%2$s.', 'charitab-wp' ), '<strong>', '</strong>', '<br>'),
				'multi'    => true,
				'sortable' => true,
				'options'	=> array(
					'column3-contact-info'      => esc_html__( 'Contact Info', 'charitab-wp' ),
					'column3-custom-text'       => esc_html__( 'Custom Text', 'charitab-wp' ),
					'column3-custom-button'     => esc_html__( 'Custom Button', 'charitab-wp' ),
					'column3-social-links'      => esc_html__( 'Social Links', 'charitab-wp' ),
					'column3-search-box'        => esc_html__( 'Search Box', 'charitab-wp' ),
				),
				'default'  => array(
					'column3-contact-info',
				),
			),


			//Column 3 - Contact Info
			array(
				'id'       => 'header-settings-header-mid-column3-contact-info-section-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Column 3 - Contact Info', 'charitab-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
				'required' => array( 
					array( 'header-settings-header-mid-column3-content', '=', 'column3-contact-info' )
				)
			),
			array(
				'id'       => 'header-settings-header-mid-column3-contact-info-iconbox-style',
				'type'     => 'button_set',
				'compiler' =>true,
				'title'    => esc_html__( 'Icon Box Style', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Select icon box style.', 'charitab-wp' ),
				'options' => array(
					'big-font-icon'     => esc_html__( 'Big Font Icon', 'charitab-wp' ),
					'small-font-icon'   => esc_html__( 'Small Font Icon', 'charitab-wp' )
				),
				'default' => 'big-font-icon',
			),
			array(
				'id'       => 'header-settings-header-mid-column3-contact-info-icon-use-themecolor',
				'type'     => 'select',
				'title'    => esc_html__( 'Use Icon Theme Color?', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Use theme color or custom color for Icons', 'charitab-wp' ),
				'desc'     => '',
				'options'  => charitab_mascot_theme_color_list(),
				'default'  => '',
			),
			array(
				'id'       => 'header-settings-header-mid-column3-contact-info-icon-custom-color',
				'type'     => 'color',
				'title'    => esc_html__( 'Custom Icon Color', 'charitab-wp' ),
				'subtitle' => '',
				'subtitle' => esc_html__( 'Pick a custom color for Icons.', 'charitab-wp' ),
				'transparent' => false,
				'required' => array( 
					array( 'header-settings-header-mid-column3-contact-info-icon-use-themecolor', '=', '' ),
				)
			),
			array(
				'id'       => 'header-settings-header-mid-column3-contact-info-checkbox',
				'type'     => 'sortable',
				'title'    => esc_html__( 'Contact Info Visibility and Ordering', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Show/Hide each item individually. Reorder them by moving up or down!', 'charitab-wp' ),
				'desc'     => esc_html__( 'Please choose which fields you want to display.', 'charitab-wp' ),
				'label'    => true,
				'mode'     => 'checkbox',
				'options'	=> array(
					'phone'           => esc_html__( 'Phone', 'charitab-wp' ),
					'email'           => esc_html__( 'Email', 'charitab-wp' ),
					'address'         => esc_html__( 'Address', 'charitab-wp' ),
					'opening-hours'   => esc_html__( 'Opening Hours', 'charitab-wp' ),
				),
				'default' => array(
					'phone'           => 1,
					'email'           => 1,
					'address'         => 1,
					'opening-hours'   => 0,
				),
			),
			array(
				'id'       => 'header-settings-header-mid-column3-contact-info-phone',
				'type'     => 'text',
				'title'    => esc_html__( 'Contact Info - Phone', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enter your custom contact info.', 'charitab-wp' ),
				'desc'     => esc_html__( 'Reorder them by moving up or down!', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array(
					'icon'            => esc_html__( 'Icon', 'charitab-wp' ),
					'title'           => esc_html__( 'Title', 'charitab-wp' ),
					'subtitle'        => esc_html__( 'Subtitle', 'charitab-wp' ),
				),
				'default' => array(
					'icon'            => 'fa fa-phone',
					'title'           => esc_html__( 'Call us at', 'charitab-wp' ),
					'subtitle'        => esc_html__( '(123) 456-78-90', 'charitab-wp' ),
				),
			),

			array(
				'id'       => 'header-settings-header-mid-column3-contact-info-email',
				'type'     => 'text',
				'title'    => esc_html__( 'Contact Info - Email', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enter your custom contact info.', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array(
					'icon'            => esc_html__( 'Icon', 'charitab-wp' ),
					'title'           => esc_html__( 'Title', 'charitab-wp' ),
					'subtitle'        => esc_html__( 'Subtitle', 'charitab-wp' ),
				),
				'default' => array(
					'icon'            => 'fa fa-envelope-o',
					'title'           => esc_html__( 'Email us', 'charitab-wp' ),
					'subtitle'        => 'info@example.com',
				),
			),
			array(
				'id'       => 'header-settings-header-mid-column3-contact-info-address',
				'type'     => 'text',
				'title'    => esc_html__( 'Contact Info - Address', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enter your custom contact info.', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array(
					'icon'            => esc_html__( 'Icon', 'charitab-wp' ),
					'title'           => esc_html__( 'Title', 'charitab-wp' ),
					'subtitle'        => esc_html__( 'Subtitle', 'charitab-wp' ),
				),
				'default' => array(
					'icon'            => 'fa fa-map-o',
					'title'           => esc_html__( 'Envato HQ', 'charitab-wp' ),
					'subtitle'        => esc_html__( '121 King Street, Melbourne', 'charitab-wp' ),
				),
			),
			array(
				'id'       => 'header-settings-header-mid-column3-contact-info-opening-hours',
				'type'     => 'text',
				'title'    => esc_html__( 'Contact Info - Opening Hours', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enter your custom contact info.', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array(
					'icon'            => esc_html__( 'Icon', 'charitab-wp' ),
					'title'           => esc_html__( 'Title', 'charitab-wp' ),
					'subtitle'        => esc_html__( 'Subtitle', 'charitab-wp' ),
				),
				'default' => array(
					'icon'            => 'fa fa-clock-o',
					'title'           => esc_html__( '09:00 - 17:00', 'charitab-wp' ),
					'subtitle'        => esc_html__( 'Monday - Friday', 'charitab-wp' ),
				),
			),
			array(
				'id'       => 'header-settings-header-mid-column3-contact-info-section-ends',
				'type'     => 'section',
				'title'    => '',
				'subtitle' => '',
				'indent'   => false, // Indent all options below until the next 'section' option is set.
				'required' => array( 
					array( 'header-settings-header-mid-column3-content', '=', 'column3-contact-info' )
				)
			),



			//Column 3 - Custom Text
			array(
				'id'       => 'header-settings-header-mid-column3-custom-text-section-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Column 3 - Custom Text', 'charitab-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
				'required' => array( 
					array( 'header-settings-header-mid-column3-content', '=', 'column3-custom-text' )
				)
			),
			array(
				'id'       => 'header-settings-header-mid-column3-custom-text',
				'type'     => 'textarea',
				'title'    => esc_html__( 'Column 3 - Custom Text', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enter your custom text. Custom HTML tags are allowed (wp_kses).', 'charitab-wp' ),
				'rows'     => '3',
				'desc'     => '',
				'default'  => sprintf( esc_html__( 'Custom %1$sheader middle row%2$s text goes here!', 'charitab-wp' ), '<strong>', '</strong>'),
				'validate' => 'html_custom',
				'allowed_html' => array(
					'a' => array(
						'href' => array(),
						'title' => array(),
						'class' => array(),
						'id' => array()
					),
					'br' => array(),
					'em' => array(),
					'strong' => array()
				),
			),
			array(
				'id'       => 'header-settings-header-mid-column3-custom-text-section-ends',
				'type'     => 'section',
				'title'    => '',
				'subtitle' => '',
				'indent'   => false, // Indent all options below until the next 'section' option is set.
				'required' => array( 
					array( 'header-settings-header-mid-column3-content', '=', 'column3-custom-text' )
				)
			),




			//Column 3 - Custom Button
			array(
				'id'       => 'header-settings-header-mid-column3-custom-button-section-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Column 3 - Custom Button', 'charitab-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
				'required' => array( 
					array( 'header-settings-header-mid-column3-content', '=', 'column3-custom-button' )
				)
			),
			array(
				'id'       => 'header-settings-header-mid-column3-custom-button',
				'type'     => 'sortable',
				'title'    => esc_html__( 'Column 3 - Custom Button', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enter your custom button info.', 'charitab-wp' ),
				'desc'     => esc_html__( 'Show a custom button in the header middle row.', 'charitab-wp' ),
				'label'    => true,
				'options'	=> array(
					esc_html__( 'Button Title', 'charitab-wp' )  => '',
					esc_html__( 'Button Link', 'charitab-wp' )   => '',
				),
				'default' => array(
					esc_html__( 'Button Title', 'charitab-wp' )  => esc_html__( 'Custom Button', 'charitab-wp' ),
					esc_html__( 'Button Link', 'charitab-wp' )   => '#',
				),
			),
			array(
				'id'       => 'header-settings-header-mid-column3-custom-button-design-style',
				'type'     => 'select',
				'title'    => esc_html__( 'Button Design Style', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array_flip( charitab_mascot_get_btn_design_style() ),
				'default'  => 'btn-gray',
			),
			array(
				'id'       => 'header-settings-header-top-column3-custom-button-size',
				'type'     => 'select',
				'title'    => esc_html__( 'Button Size', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array_flip( charitab_mascot_get_button_size() ),
			),
			array(
				'id'       => 'header-settings-header-top-column3-custom-button-flat',
				'type'     => 'switch',
				'title'    => esc_html__( 'Make Button Flat', 'charitab-wp' ),
				'default'  => 1,
			),
			array(
				'id'       => 'header-settings-header-top-column3-custom-button-outlined',
				'type'     => 'switch',
				'title'    => esc_html__( 'Make Button Outlined', 'charitab-wp' ),
				'default'  => 0,
			),
			array(
				'id'       => 'header-settings-header-top-column3-custom-button-round',
				'type'     => 'switch',
				'title'    => esc_html__( 'Make Button Round', 'charitab-wp' ),
				'default'  => 0,
			),
			array(
				'id'       => 'header-settings-header-top-column3-custom-button-link-open-in-window',
				'type'     => 'select',
				'title'    => esc_html__( 'Open Link in', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'options'	=> array(
					'_blank' => esc_html__( 'New Tab', 'charitab-wp' ),
					'_self'  => esc_html__( 'Same Tab', 'charitab-wp' ),
				),
				'default'  => '_blank',
			),
			array(
				'id'       => 'header-settings-header-mid-column3-custom-button-section-ends',
				'type'     => 'section',
				'title'    => '',
				'subtitle' => '',
				'indent'   => false, // Indent all options below until the next 'section' option is set.
				'required' => array( 
					array( 'header-settings-header-mid-column3-content', '=', 'column3-custom-button' )
				)
			),


			//Column 3 - Social Links
			array(
				'id'       => 'header-settings-header-mid-column3-social-links-section-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Column 3 - Social Links', 'charitab-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
				'required' => array( 
					array( 'header-settings-header-mid-column3-content', '=', 'column3-social-links' )
				)
			),
			array(
				'id'       => 'header-settings-header-top-column3-social-links-label',
				'type'     => 'text',
				'title'    => esc_html__( 'Social Links Label', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enter the text that will be appeared on the left side of social links', 'charitab-wp' ),
				'desc'     => '',
			),
			array(
				'id'       => 'header-settings-header-mid-column3-social-links-color',
				'type'     => 'select',
				'title'    => esc_html__( 'Social Links - Background Color', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array(
					'icon-gray'     => esc_html__( 'Gray', 'charitab-wp' ),
					'icon-dark'     => esc_html__( 'Dark', 'charitab-wp' ),
					'icon-white'    => esc_html__( 'White', 'charitab-wp' ),
					''              => esc_html__( 'Default', 'charitab-wp' ),
				),
				'default'  => 'icon-gray',
			),
			array(
				'id'       => 'header-settings-header-mid-column3-social-links-icon-style',
				'type'     => 'select',
				'title'    => esc_html__( 'Social Links Icon Style', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array(
					'icon-rounded'   => esc_html__( 'Rounded', 'charitab-wp' ),
					'icon-default'	 => esc_html__( 'Default', 'charitab-wp' ),
					'icon-circled'   => esc_html__( 'Circled', 'charitab-wp' ),
				),
				'default'  => 'icon-circled',
			),
			array(
				'id'       => 'header-settings-header-mid-column3-social-links-icon-size',
				'type'     => 'select',
				'title'    => esc_html__( 'Social Links Icon Size', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array(
					'icon-xs'   => esc_html__( 'Extra Small', 'charitab-wp' ),
					'icon-sm'	=> esc_html__( 'Small', 'charitab-wp' ),
					'icon-md'   => esc_html__( 'Medium', 'charitab-wp' ),
					'icon-lg'   => esc_html__( 'Large', 'charitab-wp' ),
					'icon-xl'   => esc_html__( 'Extra Large', 'charitab-wp' ),
				),
				'default'  => 'icon-md',
			),
			array(
				'id'       => 'header-settings-header-mid-column3-social-links-icon-border-style',
				'type'     => 'checkbox',
				'title'    => esc_html__( 'Make Icon Area Bordered?', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'default'  => '0',
			),
			array(
				'id'       => 'header-settings-header-mid-column3-social-links-theme-colored',
				'type'     => 'select',
				'title'    => esc_html__( 'Make Social Links Theme Colored?', 'charitab-wp' ),
				'subtitle' => esc_html__( 'To make the social links theme colored, please check it.', 'charitab-wp' ),
				'desc'     => '',
				'options'  => charitab_mascot_theme_color_list(),
				'default'  => '',
			),
			array(
				'id'       => 'header-settings-header-mid-column3-social-links-section-ends',
				'type'     => 'section',
				'title'    => '',
				'subtitle' => '',
				'indent'   => false, // Indent all options below until the next 'section' option is set.
				'required' => array( 
					array( 'header-settings-header-mid-column3-content', '=', 'column3-social-links' )
				)
			),

		)
	) );


	// -> START Header Navigation Row
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Header Navigation Row', 'charitab-wp' ),
		'id'     => 'header-navigation-layout',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-arrow-up-alt',
		'subsection' => true,
		'fields' => array(

			//Header Visibility Important
			array(
				'id'        => 'header-settings-header-navigation-info-field-important',
				'type'      => 'info',
				'title'     => esc_html__( 'Important!', 'charitab-wp' ),
				'subtitle'  => sprintf( esc_html__( 'As you have chosen %1$sHeader Visibility%2$s to %1$sHide%2$s so there\'s nothing to show here!', 'charitab-wp' ), '<strong>', '</strong>'),
				'notice'    => false,
				'required' => array( 'header-settings-choose-header-visibility', '!=', '1' ),
			),



			
			array(
				'id'       => 'header-settings-navigation-show-header-nav-row',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Header Navigation Row', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enabling/Disabling this option will show/hide Whole Header Navigation Row section.', 'charitab-wp' ),
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
				'required' => array( 'header-settings-choose-header-visibility', '=', '1' ),
			),
			array(
				'id'       => 'header-settings-navigation-show-header-nav-bar-fixed-on-scroll',
				'type'     => 'switch',
				'title'    => esc_html__( 'Make Navigation Bar Fixed/Sticky on Scroll?', 'charitab-wp' ),
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
				'required' => array( 'header-settings-choose-header-visibility', '=', '1' ),
			),
			array(
				'id'       => 'header-settings-navigation-show-header-nav-bar-always-visible-on-scroll',
				'type'     => 'switch',
				'title'    => esc_html__( 'Make Navigation Bar Always Visible(Fixed at the top) on Sticky?', 'charitab-wp' ),
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
				'required' => array( 'header-settings-navigation-show-header-nav-bar-fixed-on-scroll', '=', '1' ),
			),

			array(
				'id'       => 'header-settings-navigation-bgcolor-use-themecolor',
				'type'     => 'select',
				'title'    => esc_html__( 'Use Theme Color in Background?', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Use theme color or custom bg color in Header Navigation Row', 'charitab-wp' ),
				'desc'     => '',
				'options'  => charitab_mascot_theme_color_list(),
				'default'  => '',
				'required' => array( 'header-settings-navigation-show-header-nav-row', '=', '1' ),
			),
			array(
				'id'       => 'header-settings-navigation-custom-bgcolor',
				'type'     => 'color',
				'title'    => esc_html__( 'Custom Background Color', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Pick a custom background color for Header Navigation Row.', 'charitab-wp' ),
				'transparent' => true,
				'required' => array( 'header-settings-navigation-bgcolor-use-themecolor', '=', '' ),
			),



			array(
				'id'        => 'header-settings-navigation-custom-navigation-link-field',
				'type'      => 'info',
				'title'     => esc_html__( 'Cart/Search/Side Push Icons', 'charitab-wp' ),
				'notice'    => false,
				'required' => array( 'header-settings-navigation-show-header-nav-row', '=', '1' ),
			),
			array(
				'id'       => 'header-settings-navigation-custom-navigation-link-n-icon-color',
				'type'     => 'color',
				'title'    => esc_html__( 'Navigation Link and Cart/Search/Side Push Icon Color', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Pick a custom color for link and icons on Header Navigation Row.', 'charitab-wp' ),
				'transparent' => true,
				'required' => array( 'header-settings-navigation-show-header-nav-row', '=', '1' ),
			),
			array(
				'id'       => 'header-settings-navigation-show-menu-cart-icon',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Cart Icon', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Add Cart Icon on the right hand side of the menu. WooCommerce plugin needs to be installed.', 'charitab-wp' ),
				'default'  => 1,
				'on'       => 'Yes',
				'off'      => 'No',
				'required' => array( 'header-settings-navigation-show-header-nav-row', '=', '1' ),
			),
			array(
				'id'       => 'header-settings-navigation-show-menu-cart-icon-in-mobile-device',
				'type'     => 'switch',
				'title'    => esc_html__( '|---Show Cart Icon in Mobile Device', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Show/Hide icon in Mobile View', 'charitab-wp' ),
				'default'  => 0,
				'on'       => 'Yes',
				'off'      => 'No',
				'required' => array( 'header-settings-navigation-show-menu-cart-icon', '=', '1' ),
			),
			array(
				'id'       => 'header-settings-navigation-menu-cart-icon-code',
				'type'     => 'text',
				'title'    => esc_html__( 'Cart Icon', 'charitab-wp' ),
				'subtitle' => sprintf( esc_html__( 'You can change the search icon from here. See full list of icons from %1$shere%2$s', 'charitab-wp' ), '<a target="_blank" href="' . esc_url( 'http://docs.kodesolution.info/icons/' ) . '">', '</a>' ),
				'desc'     => '',
				'default'  => 'fa fa-shopping-cart',
				'required' => array( 'header-settings-navigation-show-menu-cart-icon', '=', '1' ),
			),


			array(
				'id'       => 'header-settings-navigation-show-menu-search-icon',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Search Icon', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Add Search Icon on the right hand side of the menu.', 'charitab-wp' ),
				'default'  => 1,
				'on'       => 'Yes',
				'off'      => 'No',
				'required' => array( 'header-settings-navigation-show-header-nav-row', '=', '1' ),
			),
			array(
				'id'       => 'header-settings-navigation-show-menu-search-icon-in-mobile-device',
				'type'     => 'switch',
				'title'    => esc_html__( '|---Show Search Icon in Mobile Device', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Show/Hide icon in Mobile View', 'charitab-wp' ),
				'default'  => 0,
				'on'       => 'Yes',
				'off'      => 'No',
				'required' => array( 'header-settings-navigation-show-menu-search-icon', '=', '1' ),
			),
			array(
				'id'       => 'header-settings-navigation-menu-search-icon-code',
				'type'     => 'text',
				'title'    => esc_html__( 'Search Icon', 'charitab-wp' ),
				'subtitle' => sprintf( esc_html__( 'You can change the search icon from here. See full list of icons from %1$shere%2$s', 'charitab-wp' ), '<a target="_blank" href="' . esc_url( 'http://docs.kodesolution.info/icons/' ) . '">', '</a>' ),
				'desc'     => '',
				'default'  => 'fa fa-search',
				'required' => array( 'header-settings-navigation-show-menu-search-icon', '=', '1' ),
			),


			array(
				'id'       => 'header-settings-navigation-show-side-push-panel',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Side Push Panel', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Add Side Push Icon on the right hand side of the menu to Enable/Disable Side Push Panel section. You can easily add your widgets to this section from Appearance > Widgets (Side Push Panel Sidebar)', 'charitab-wp' ),
				'default'  => 1,
				'on'       => 'Yes',
				'off'      => 'No',
				'required' => array( 'header-settings-navigation-show-header-nav-row', '=', '1' ),
			),
			array(
				'id'       => 'header-settings-navigation-show-side-push-panel-in-mobile-device',
				'type'     => 'switch',
				'title'    => esc_html__( '|---Show Side Push Panel Icon in Mobile Device', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Show/Hide icon in Mobile View', 'charitab-wp' ),
				'default'  => 0,
				'on'       => 'Yes',
				'off'      => 'No',
				'required' => array( 'header-settings-navigation-show-side-push-panel', '=', '1' ),
			),



			//Header Nav - Custom Button
			array(
				'id'        => 'header-settings-navigation-custom-button-info-field',
				'type'      => 'info',
				'title'     => esc_html__( 'Custom Button', 'charitab-wp' ),
				'subtitle'  => esc_html__( 'Add Custom Button on the right hand side of the Header Navigation Row', 'charitab-wp' ),
				'notice'    => false,
				'required'  => array( 
					array( 'header-settings-show-header-top', '=', '1' )
				)
			),
			array(
				'id'       => 'header-settings-navigation-show-custom-button',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Custom Button', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Add Custom Button on the right hand side of the Header Navigation Row.', 'charitab-wp' ),
				'default'  => 0,
				'on'       => 'Yes',
				'off'      => 'No',
				'required' => array( 'header-settings-navigation-show-header-nav-row', '=', '1' ),
			),
			array(
				'id'       => 'header-settings-navigation-custom-button-info',
				'type'     => 'sortable',
				'title'    => esc_html__( 'Custom Button Info', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enter your custom button info.', 'charitab-wp' ),
				'desc'     => esc_html__( 'Show a custom button in the Header Navigation Row.', 'charitab-wp' ),
				'label'    => true,
				'options'	=> array(
					esc_html__( 'Button Title', 'charitab-wp' )  => '',
					esc_html__( 'Button Link', 'charitab-wp' )   => '',
				),
				'default' => array(
					esc_html__( 'Button Title', 'charitab-wp' )  => esc_html__( 'Custom Button', 'charitab-wp' ),
					esc_html__( 'Button Link', 'charitab-wp' )   => '#',
				),
				'required'  => array( 
					array( 'header-settings-navigation-show-custom-button', '=', '1' )
				)
			),
			array(
				'id'       => 'header-settings-navigation-custom-button-design-style',
				'type'     => 'select',
				'title'    => esc_html__( 'Button Design Style', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array_flip( charitab_mascot_get_btn_design_style() ),
				'default'  => 'btn-gray',
				'required'  => array( 
					array( 'header-settings-navigation-show-custom-button', '=', '1' )
				)
			),
			array(
				'id'       => 'header-settings-navigation-custom-button-size',
				'type'     => 'select',
				'title'    => esc_html__( 'Button Size', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array_flip( charitab_mascot_get_button_size() ),
				'required'  => array( 
					array( 'header-settings-navigation-show-custom-button', '=', '1' )
				)
			),
			array(
				'id'       => 'header-settings-navigation-custom-button-flat',
				'type'     => 'switch',
				'title'    => esc_html__( 'Make Button Flat', 'charitab-wp' ),
				'default'  => 0,
				'required'  => array( 
					array( 'header-settings-navigation-show-custom-button', '=', '1' )
				)
			),
			array(
				'id'       => 'header-settings-navigation-custom-button-outlined',
				'type'     => 'switch',
				'title'    => esc_html__( 'Make Button Outlined', 'charitab-wp' ),
				'default'  => 0,
				'required'  => array( 
					array( 'header-settings-navigation-show-custom-button', '=', '1' )
				)
			),
			array(
				'id'       => 'header-settings-navigation-custom-button-round',
				'type'     => 'switch',
				'title'    => esc_html__( 'Make Button Round', 'charitab-wp' ),
				'default'  => 0,
				'required'  => array( 
					array( 'header-settings-navigation-show-custom-button', '=', '1' )
				)
			),
			array(
				'id'       => 'header-settings-navigation-custom-button-link-open-in-window',
				'type'     => 'select',
				'title'    => esc_html__( 'Open Link in', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'options'	=> array(
					'_blank' => esc_html__( 'New Tab', 'charitab-wp' ),
					'_self'  => esc_html__( 'Same Tab', 'charitab-wp' ),
				),
				'default'  => '_blank',
				'required'  => array( 
					array( 'header-settings-navigation-show-custom-button', '=', '1' )
				)
			),
			array(
				'id'       => 'header-settings-navigation-custom-button-show-in-mobile-device',
				'type'     => 'switch',
				'title'    => esc_html__( '|---Show Button in Mobile Device', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Show/Hide icon in Mobile View', 'charitab-wp' ),
				'default'  => 0,
				'on'       => 'Yes',
				'off'      => 'No',
				'required'  => array( 
					array( 'header-settings-navigation-show-custom-button', '=', '1' )
				)
			),


			array(
				'id'        => 'header-settings-navigation-color-scheme-info-field',
				'type'      => 'info',
				'title'     => esc_html__( 'Navigation Color Scheme', 'charitab-wp' ),
				'notice'    => false,
				'required' => array( 'header-settings-choose-header-visibility', '=', '1' ),
			),
			array(
				'id'       => 'header-settings-navigation-color-scheme',
				'type'     => 'image_select',
				'title'    => esc_html__( 'Color Scheme', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Select the color scheme of main menu', 'charitab-wp' ),
				'desc'     => '',
				//Must provide key => value(array:title|img) pairs for radio options
				'options'	=> array(
					'default' => array(
						'alt' => esc_html__( 'Default', 'charitab-wp' ),
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/top-menu-style/colors/default.jpg '
					),
					'blue' => array(
						'alt' => esc_html__( 'Blue', 'charitab-wp' ),
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/top-menu-style/colors/blue.jpg '
					),
					'green' => array(
						'alt' => esc_html__( 'Green', 'charitab-wp' ),
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/top-menu-style/colors/green.jpg '
					),
					'orange' => array(
						'alt' => esc_html__( 'Orange', 'charitab-wp' ),
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/top-menu-style/colors/orange.jpg '
					),
					'pink' => array(
						'alt' => esc_html__( 'Pink', 'charitab-wp' ),
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/top-menu-style/colors/pink.jpg '
					),
					'purple' => array(
						'alt' => esc_html__( 'Purple', 'charitab-wp' ),
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/top-menu-style/colors/purple.jpg '
					),
					'red' => array(
						'alt' => esc_html__( 'Red', 'charitab-wp' ),
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/top-menu-style/colors/red.jpg '
					),
					'yellow' => array(
						'alt' => esc_html__( 'Yellow', 'charitab-wp' ),
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/top-menu-style/colors/yellow.jpg '
					)
				),
				'default'  => 'green',
				'required' => array( 'header-settings-choose-header-visibility', '=', '1' ),
			),

			array(
				'id'       => 'header-settings-navigation-primary-effect',
				'type'     => 'button_set',
				'title'    => esc_html__( 'Primary Effect', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'options'	=> array(
					'fade'  => esc_html__( 'Fade', 'charitab-wp' ),
					'slide' => esc_html__( 'Slide', 'charitab-wp' )
				),
				'default'  => 'fade',
				'required' => array( 'header-settings-choose-header-visibility', '=', '1' ),
			),
			array(
				'id'       => 'header-settings-navigation-css3-animation',
				'type'     => 'button_set',
				'title'    => esc_html__( 'CSS3 Animation', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'options'	=> array(
					'none'      => esc_html__( 'None', 'charitab-wp' ),
					'zoom-in'   => esc_html__( 'Zoom In', 'charitab-wp' ),
					'zoom-out'  => esc_html__( 'Zoom Out', 'charitab-wp' ),
					'drop-up'   => esc_html__( 'Drop Up', 'charitab-wp' ),
					'drop-left' => esc_html__( 'Drop Left', 'charitab-wp' ),
					'swing'     => esc_html__( 'Swing', 'charitab-wp' ),
					'flip'      => esc_html__( 'Flip', 'charitab-wp' ),
					'roll-in'   => esc_html__( 'Roll In', 'charitab-wp' ),
					'stretch'   => esc_html__( 'Stretch', 'charitab-wp' ),
				),
				'default'  => 'none',
				'required' => array( 'header-settings-choose-header-visibility', '=', '1' ),
			),

			
			array(
				'id'       => 'header-settings-navigation-skin',
				'type'     => 'image_select',
				'title'    => esc_html__( 'Navigation Skin', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Select the skin of main menu you would like to use', 'charitab-wp' ),
				'desc'     => '',
				//Must provide key => value(array:title|img) pairs for radio options
				'options'	=> array(
					'rounded-boxed' => array(
						'alt' => 'rounded-boxed',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/top-menu-style/skins/rounded-boxed.jpg'
					),
					'boxed' => array(
						'alt' => 'boxed',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/top-menu-style/skins/boxed.jpg'
					),
					'border-boxed' => array(
						'alt' => 'border-boxed',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/top-menu-style/skins/border-boxed.jpg'
					),
					'top-bottom-boxed-border' => array(
						'alt' => 'top-bottom-boxed-border',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/top-menu-style/skins/top-bottom-boxed-border.jpg'
					),
					'border-left' => array(
						'alt' => 'border-left',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/top-menu-style/skins/border-left.jpg'
					),
					'border-top' => array(
						'alt' => 'border-top',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/top-menu-style/skins/border-top.jpg'
					),
					'border-bottom' => array(
						'alt' => 'border-bottom',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/top-menu-style/skins/border-bottom.jpg'
					),
					'border-top-bottom' => array(
						'alt' => 'border-top-bottom',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/top-menu-style/skins/border-top-bottom.jpg'
					),
					'bottom-trace' => array(
						'alt' => 'bottom-trace',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/top-menu-style/skins/bottom-trace.jpg'
					),
					'default' => array(
						'alt' => 'default',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/top-menu-style/skins/default.jpg'
					),
					'colored-boxed' => array(
						'alt' => 'colored-boxed',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/top-menu-style/skins/colored-boxed.jpg'
					),
					'colored' => array(
						'alt' => 'colored',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/top-menu-style/skins/colored.jpg'
					),
					'gradient-boxed' => array(
						'alt' => 'gradient-boxed',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/top-menu-style/skins/gradient-boxed.jpg'
					),
					'gradient' => array(
						'alt' => 'gradient',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/top-menu-style/skins/gradient.jpg'
					),
					'strip' => array(
						'alt' => 'strip',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/top-menu-style/skins/strip.jpg'
					),
					'dark' => array(
						'alt' => 'dark',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/top-menu-style/skins/dark.jpg'
					),
				),
				'default'  => 'rounded-boxed',
				'required' => array( 'header-settings-choose-header-visibility', '=', '1' ),
			),

			
		)
	) );


	// -> START Header Navigation Skin Typography
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Header Nav Typography', 'charitab-wp' ),
		'id'     => 'header-header-navigation-skin-typography',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-arrow-up-alt',
		'subsection' => true,
		'fields' => array(


			//Header Nav - Navigation Skin
			array(
				'id'        => 'header-settings-navigation-skin-info-field',
				'type'      => 'info',
				'title'     => esc_html__( 'Navigation Skin', 'charitab-wp' ),
				'subtitle'  => esc_html__( 'Select the skin of main menu you would like to use', 'charitab-wp' ),
				'notice'    => false,
				'required'  => array( 
					array( 'header-settings-show-header-top', '=', '1' )
				)
			),
			array(
				'id'            => 'header-settings-navigation-item-typography',
				'type'          => 'typography',
				'title'         => esc_html__( 'Main Nav Items Typography', 'charitab-wp' ),
				'subtitle'      => '',
				//'compiler'    => true,  // Use if you want to hook in your own CSS compiler
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
			),
			array(
				'id'       => 'header-settings-navigation-item-hover-color',
				'type'     => 'color',
				'title'    => esc_html__( 'Main Nav Items Hover/Active Color', 'charitab-wp' ),
				'subtitle' => '',
				'transparent' => false,
			),
			array(
				'id'            => 'header-settings-navigation-item-dropdown-typography',
				'type'          => 'typography',
				'title'         => esc_html__( 'Main Nav Dropdown Items Typography', 'charitab-wp' ),
				'subtitle'      => '',
				//'compiler'    => true,  // Use if you want to hook in your own CSS compiler
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
			),
			array(
				'id'       => 'header-settings-navigation-item-dropdown-hover-color',
				'type'     => 'color',
				'title'    => esc_html__( 'Dropdown Items Hover/Active Color', 'charitab-wp' ),
				'subtitle' => '',
				'transparent' => false,
			),


			array(
				'id'            => 'header-settings-navigation-skin-dropdown-menu-width',
				'type'          => 'slider',
				'title'         => esc_html__( 'Dropdown Menu Width(px)', 'charitab-wp' ),
				'subtitle'      => esc_html__( 'Enter width of dropdown menu in px.', 'charitab-wp' ),
				'desc'          => '',
				'default'       => 260,
				'min'           => 150,
				'step'          => 1,
				'max'           => 400,
				'display_value' => 'text',
			),


			
			array(
				'id'            => 'header-settings-navigation-item-megamenu-dropdown-typography',
				'type'          => 'typography',
				'title'         => esc_html__( 'Main Nav Megamenu Items Typography', 'charitab-wp' ),
				'subtitle'      => '',
				//'compiler'    => true,  // Use if you want to hook in your own CSS compiler
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
			),
			array(
				'id'       => 'header-settings-navigation-item-megamenu-dropdown-hover-color',
				'type'     => 'color',
				'title'    => esc_html__( 'Megamenu Items Hover/Active Color', 'charitab-wp' ),
				'subtitle' => '',
				'transparent' => false,
			),
			array(
				'id'            => 'header-settings-navigation-item-padding',
				'type'     => 'spacing',
				// An array of CSS selectors to apply this font style to
				'mode'     => 'padding',
				// absolute, padding, margin, defaults to padding
				'all'      => false,
				// Have one field that applies to all
				'top'           => true,
				'right'         => true,
				'bottom'        => true,
				'left'          => true,
				'units'         => 'px',      // You can specify a unit value. Possible: px, em, %
				//'units_extended'=> 'true',    // Allow users to select any type of unit
				'display_units' => true,   // Set to false to hide the units if the units are specified
				'title'    => esc_html__( 'Main Nav Items Padding(px) Around it', 'charitab-wp' ),
			),
			/*array(
				'id'            => 'header-settings-navigation-item-font-size',
				'type'          => 'slider',
				'title'         => esc_html__( 'Main Nav Item Font Size(px)', 'charitab-wp' ),
				'subtitle'      => esc_html__( 'Default: 16px', 'charitab-wp' ),
				'default'       => 16,
				'min'           => 10,
				'step'          => 1,
				'max'           => 30,
				'display_value' => 'text',
			),*/
		)
	) );



	// -> START Header Vertical Nav
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Header Vertical Nav', 'charitab-wp' ),
		'id'     => 'header-vertical-nav-settings',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-arrow-up-alt',
		'subsection' => true,
		'fields' => array(

			//Header Visibility Important
			array(
				'id'        => 'header-settings-header-vertical-nav-info-field-important',
				'type'      => 'info',
				'title'     => esc_html__( 'Important!', 'charitab-wp' ),
				'subtitle'  => sprintf( esc_html__( 'As you have chosen %1$sHeader Visibility%2$s to %1$sHide%2$s so there\'s nothing to show here!', 'charitab-wp' ), '<strong>', '</strong>'),
				'notice'    => false,
				'required' => array( 'header-settings-choose-header-visibility', '!=', '1' ),
			),

			//Header Visibility Important
			array(
				'id'        => 'header-settings-header-vertical-nav-info-field-only-visible-vertical-nav',
				'type'      => 'info',
				'title'     => esc_html__( 'Important! Features Availability.', 'charitab-wp' ),
				'subtitle'  => esc_html__( 'Header Vertical Nav features are only available for "Header Layout Type - Vertical Nav"! So please choose it from Header Layout tab.', 'charitab-wp' ),
				'notice'    => false,
			),

			array(
				'id'       		=> 'header-settings-navigation-vertical-navbar-width',
				'type'          => 'slider',
				'title'    		=> esc_html__( 'Vertical Nav Bar Width', 'charitab-wp' ),
				'subtitle' 		=> esc_html__( 'Default: 300px', 'charitab-wp' ),
				'desc'          => '',
				'default'       => 300,
				'min'           => 100,
				'step'          => 1,
				'max'           => 600,
				'display_value' => 'text',
			),
			array(
				'id'       		=> 'header-settings-navigation-vertical-nav-container-width',
				'type'          => 'slider',
				'title'    		=> esc_html__( 'Vertical Nav Main Content Container Width', 'charitab-wp' ),
				'subtitle' 		=> esc_html__( 'Default: 1100px', 'charitab-wp' ),
				'desc'          => '',
				'default'       => 1100,
				'min'           => 500,
				'step'          => 1,
				'max'           => 1600,
				'display_value' => 'text',
			),
			array(
				'id'       => 'header-settings-navigation-vertical-nav-bgimg',
				'type'     => 'background',
				'title'    => esc_html__( 'Background for Vertical Nav', 'charitab-wp' ),
				'subtitle' => sprintf( esc_html__( 'Set background image for Header Layout Type %1$sVertical Nav%2$s.', 'charitab-wp' ), '<strong>', '</strong>'),
			),
			array(
				'id'       => 'header-settings-navigation-vertical-nav-layer-overlay-status',
				'type'     => 'switch',
				'title'    => esc_html__( 'Add Page Title Background Overlay', 'charitab-wp' ),
				'subtitle' => '',
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
			),
			array(
				'id'       => 'header-settings-navigation-vertical-nav-layer-overlay',
				'type'          => 'slider',
				'title'         => esc_html__( 'Background Overlay Opacity', 'charitab-wp' ),
				'subtitle'      => esc_html__( 'Overlay on background image on Page Title.', 'charitab-wp' ),
				'desc'          => '',
				'default'       => 8,
				'min'           => 1,
				'step'          => 1,
				'max'           => 9,
				'display_value' => 'text',
			),
			array(
				'id'       => 'header-settings-navigation-vertical-nav-layer-overlay-color',
				'type'     => 'button_set',
				'compiler' =>true,
				'title'    => esc_html__( 'Background Overlay Color', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Select Dark or White Overlay on background image.', 'charitab-wp' ),
				'options'	=> array(
					''          	=> esc_html__( 'None', 'charitab-wp' ),
					'dark'          => esc_html__( 'Dark', 'charitab-wp' ),
					'white'         => esc_html__( 'White', 'charitab-wp' ),
					'theme-colored1' => esc_html__( 'Primary Theme Color1', 'charitab-wp' ),
					'theme-colored2' => esc_html__( 'Primary Theme Color2', 'charitab-wp' )
				),
				'default' => 'dark',
			),
			

			array(
				'id'       => 'header-settings-navigation-vertical-nav-shadow',
				'type'     => 'switch',
				'title'    => esc_html__( 'Shadow?', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Make shadow around the vertical nav area.', 'charitab-wp' ),
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
			),

			array(
				'id'       => 'header-settings-navigation-vertical-nav-border',
				'type'     => 'switch',
				'title'    => esc_html__( 'Vertical Area Border', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Make Border around the vertical nav area.', 'charitab-wp' ),
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
			),

			array(
				'id'       => 'header-settings-navigation-vertical-nav-center-content',
				'type'     => 'switch',
				'title'    => esc_html__( 'Center Content', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Center the content of vertical nav area.', 'charitab-wp' ),
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
			),



			array(
				'id'        => 'header-settings-navigation-vertical-nav-field-widget-typography',
				'type'      => 'info',
				'title'     => esc_html__( 'Widget Typography', 'charitab-wp' ),
				'notice'    => false,
			),
			array(
				'id'            => 'header-settings-navigation-vertical-nav-widget-title-typography',
				'type'          => 'typography',
				'title'         => esc_html__( 'Widget Title Typography', 'charitab-wp' ),
				'subtitle'      => '',
				//'compiler'    => true,  // Use if you want to hook in your own CSS compiler
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
			),
			array(
				'id'            => 'header-settings-navigation-vertical-nav-widget-text-typography',
				'type'          => 'typography',
				'title'         => esc_html__( 'Widget Text Typography', 'charitab-wp' ),
				'subtitle'      => '',
				//'compiler'    => true,  // Use if you want to hook in your own CSS compiler
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
			),
			array(
				'id'            => 'header-settings-navigation-vertical-nav-widget-link-typography',
				'type'          => 'typography',
				'title'         => esc_html__( 'Widget Link Typography', 'charitab-wp' ),
				'subtitle'      => '',
				//'compiler'    => true,  // Use if you want to hook in your own CSS compiler
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
			),
			array(
				'id'       => 'header-settings-navigation-vertical-nav-widget-link-hover-color',
				'type'     => 'color',
				'title'    => esc_html__( 'Widget Link Hover/Active Color', 'charitab-wp' ),
				'subtitle' => '',
				'transparent' => false,
			),

		)
	) );



	// -> START Menu
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Menu', 'charitab-wp' ),
		'id'     => 'header-menu',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-menu',
	) );



	// -> START Header Menu Megamenu
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Megamenu', 'charitab-wp' ),
		'id'     => 'header-menu-megamenu',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-menu',
		'subsection' => true,
		'fields' => array(
			array(
				'id'       => 'header-menu-megamenu-enable-megamenu',
				'type'     => 'switch',
				'title'    => esc_html__( 'Enable Mega Menu', 'charitab-wp' ),
				'subtitle' => sprintf( esc_html__( 'Turn on to enable mega menu. After enabling mega menu, you will get a lot of options for mega menu at %1$sAppearance > Menus%2$s', 'charitab-wp' ), '<strong>', '</strong>'),
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
				'required' => array( 'header-settings-choose-header-visibility', '=', '1' ),
			),
		)
	) );



	// -> START Footer
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Footer Call Out', 'charitab-wp' ),
		'id'     => 'footer-top-call-out',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-editor-insertmore',
	) );


	// -> START Footer Top Callout Area
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Footer Top Callout Area', 'charitab-wp' ),
		'id'     => 'footer-top-call-out-area',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-editor-insertmore',
		'subsection' => true,
		'fields' => array(
			array(
				'id'       => 'footer-top-call-out-area-visibility',
				'type'     => 'switch',
				'title'    => esc_html__( 'Footer Top Callout', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Show or hide footer top callout area globally', 'charitab-wp' ),
				'default'  => 0,
				'on'       => 'Show',
				'off'      => 'Hide',
			),

			//section Callout Text
			array(
				'id'       => 'footer-top-call-out-area-text-section-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Callout Text', 'charitab-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
				'required' => array( 
					array( 'footer-top-call-out-area-visibility', '=', '1' )
				)
			),
			array(
				'id'       => 'footer-top-call-out-area-text',
				'type'     => 'editor',
				'title'    => esc_html__( 'Callout Text', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enter your custom content for your footer callout.', 'charitab-wp' ),
				'desc'     => '',
				'args'     => array(
					'textarea_rows'    => 5
				),
				'default'  => esc_html__( 'This is sample footer callout text. From here you can add some relevant information about your company or product. Lorem ipsum dolor sit amet, consectetur adipiscing elit.', 'charitab-wp' ),
			),
			array(
				'id'       => 'footer-top-call-out-area-text-color',
				'type'     => 'color',
				'title'    => esc_html__( 'Callout Area Text Color', 'charitab-wp' ),
				'subtitle' => '',
				'transparent' => false,
			),
			array(
				'id'            => 'footer-top-call-out-area-text-font-size',
				'type'          => 'slider',
				'title'         => esc_html__( 'Font Size(px)', 'charitab-wp' ),
				'subtitle'      => esc_html__( 'Default: 18px', 'charitab-wp' ),
				'default'       => 18,
				'min'           => 1,
				'step'          => 1,
				'max'           => 100,
				'display_value' => 'text',
			),
			array(
				'id'       => 'footer-top-call-out-area-text-align',
				'type'     => 'select',
				'title'    => esc_html__( 'Text Alignment', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> charitab_mascot_redux_text_alignment_list(),
				'default'  => '',
			),
			array(
				'id'       => 'footer-top-call-out-area-text-section-ends',
				'type'     => 'section',
				'title'    => '',
				'subtitle' => '',
				'indent'   => false, // Indent all options below until the next 'section' option is set.
				'required' => array( 
					array( 'footer-top-call-out-area-visibility', '=', '1' )
				)
			),


			//section Left Font Icon
			array(
				'id'       => 'footer-top-call-out-area-left-font-icon-section-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Left Font Icon', 'charitab-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
				'required' => array( 
					array( 'footer-top-call-out-area-visibility', '=', '1' )
				)
			),
			array(
				'id'       => 'footer-top-call-out-area-left-font-icon',
				'type'     => 'text',
				'title'    => esc_html__( 'Font Icon', 'charitab-wp' ),
				'desc'     => sprintf( esc_html__( 'Example: "fa fa-diamond". Collect your own icon from here: %1$sFontAwesome%2$s.', 'charitab-wp' ), '<a target="_blank" href="' . esc_url( 'https://fontawesome.com/v4.7.0/icons/' ) . '">', '</a>' ),
			),
			array(
				'id'       => 'footer-top-call-out-area-left-font-icon-position',
				'type'     => 'select',
				'title'    => esc_html__( 'Icon Position', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'options'	=> array(
					'left' => 'Left',
					'top'  => 'Top',
				),
				'default'  => 'left',
			),
			array(
				'id'            => 'footer-top-call-out-area-left-font-icon-fontsize',
				'type'          => 'slider',
				'title'         => esc_html__( 'Font Size(px)', 'charitab-wp' ),
				'subtitle'      => esc_html__( 'Default: 48px', 'charitab-wp' ),
				'default'       => 48,
				'min'           => 1,
				'step'          => 1,
				'max'           => 200,
				'display_value' => 'text',
			),
			array(
				'id'       => 'footer-top-call-out-area-left-font-icon-color',
				'type'     => 'color',
				'title'    => esc_html__( 'Icon Color', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Pick a custom color for Left Font Icon.', 'charitab-wp' ),
				'transparent' => false,
			),
			array(
				'id'       => 'footer-top-call-out-area-left-font-icon-section-ends',
				'type'     => 'section',
				'title'    => '',
				'subtitle' => '',
				'indent'   => false, // Indent all options below until the next 'section' option is set.
				'required' => array( 
					array( 'footer-top-call-out-area-visibility', '=', '1' )
				)
			),




			//section Callout Button
			array(
				'id'       => 'footer-top-call-out-area-button-section-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Callout Button', 'charitab-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
				'required' => array( 
					array( 'footer-top-call-out-area-visibility', '=', '1' )
				)
			),
			array(
				'id'       => 'footer-top-call-out-area-button-visibility',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Callout Button', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Show or hide callout button.', 'charitab-wp' ),
				'default'  => 1,
				'on'       => 'Show',
				'off'      => 'Hide',
			),
			array(
				'id'       => 'footer-top-call-out-area-button-position',
				'type'     => 'select',
				'title'    => esc_html__( 'Button Position', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'options'	=> array(
					'button-right'     => 'Right',
					'button-bottom'    => 'Bottom',
				),
				'default'  => 'button-right',
				'required' => array( 
					array( 'footer-top-call-out-area-button-visibility', '=', '1' )
				)
			),
			array(
				'id'       => 'footer-top-call-out-area-button-text',
				'type'     => 'text',
				'title'    => esc_html__( 'Button Text', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enter the text that will be appeared in callout button.', 'charitab-wp' ),
				'desc'     => '',
				'default'  => esc_html__( 'Get Started!', 'charitab-wp' ),
				'required' => array( 
					array( 'footer-top-call-out-area-button-visibility', '=', '1' )
				)
			),
			array(
				'id'       => 'footer-top-call-out-area-button-link',
				'type'     => 'text',
				'title'    => esc_html__( 'Button Link', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enter the URL for the callout button.', 'charitab-wp' ),
				'desc'     => '',
				'default'  => esc_html__( 'https://themeforest.net/', 'charitab-wp' ),
				'required' => array( 
					array( 'footer-top-call-out-area-button-visibility', '=', '1' )
				)
			),
			array(
				'id'       => 'footer-top-call-out-area-button-link-open-in-window',
				'type'     => 'select',
				'title'    => esc_html__( 'Open Button Link in', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'options'	=> array(
					'_blank' => esc_html__( 'New Tab', 'charitab-wp' ),
					'_self'  => esc_html__( 'Same Tab', 'charitab-wp' ),
				),
				'default'  => '_blank',
				'required' => array( 
					array( 'footer-top-call-out-area-button-visibility', '=', '1' )
				)
			),
			array(
				'id'       => 'footer-top-call-out-area-button-section-ends',
				'type'     => 'section',
				'title'    => '',
				'subtitle' => '',
				'indent'   => false, // Indent all options below until the next 'section' option is set.
				'required' => array( 
					array( 'footer-top-call-out-area-visibility', '=', '1' )
				)
			),




			//section Other Settings
			array(
				'id'       => 'footer-top-call-out-area-other-section-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Other Settings', 'charitab-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
				'required' => array( 
					array( 'footer-top-call-out-area-visibility', '=', '1' )
				)
			),
			array(
				'id'       => 'footer-top-call-out-area-bgcolor',
				'type'     => 'color',
				'title'    => esc_html__( 'Callout Area Background Color', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Pick a custom background color for callout area.', 'charitab-wp' ),
				'default'  => '#f5f5f5',
				'transparent' => false,
			),
			array(
				'id'       => 'footer-top-call-out-area-border-top-color',
				'type'     => 'color',
				'title'    => esc_html__( 'Callout Area Border Top Color', 'charitab-wp' ),
				'subtitle' => '',
				'transparent' => false,
			),
			array(
				'id'       => 'footer-top-call-out-area-border-bottom-color',
				'type'     => 'color',
				'title'    => esc_html__( 'Callout Area Border Bottom Color', 'charitab-wp' ),
				'subtitle' => '',
				'transparent' => false,
			),
			array(
				'id'       => 'footer-top-call-out-area-other-section-ends',
				'type'     => 'section',
				'title'    => '',
				'subtitle' => '',
				'indent'   => false, // Indent all options below until the next 'section' option is set.
				'required' => array( 
					array( 'footer-top-call-out-area-visibility', '=', '1' )
				)
			),
		)
	) );



	// -> START Footer
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Footer', 'charitab-wp' ),
		'id'     => 'footer',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-arrow-down-alt',
	) );

	// -> START Footer Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Footer Settings', 'charitab-wp' ),
		'id'     => 'footer-settings',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-arrow-down-alt2',
		'subsection' => true,
		'fields' => array(
			array(
				'id'       => 'footer-settings-footer-visibility',
				'type'     => 'switch',
				'title'    => esc_html__( 'Footer Visibility', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Show or hide footer globally', 'charitab-wp' ),
				'default'  => 1,
				'on'       => 'Show',
				'off'      => 'Hide',
			),
			array(
				'id'       => 'footer-settings-choose-footer-widget-area',
				'type'     => 'select',
				'title'    => esc_html__( 'Choose Footer', 'charitab-wp' ),
				'subtitle' => esc_html__( 'You can customize footer from Admin Dashboard > Parts - Footer.', 'charitab-wp' ),
				'desc'     => '',
				'data'     => 'posts',
				'args' => array(
					'post_type' => array( 'footer' ),
				),
				'required' => array( 'footer-settings-footer-visibility', '=', '1' ),
			),
			array(
				'id'       => 'footer-settings-fixed-footer-bottom',
				'type'     => 'switch',
				'title'    => esc_html__( 'Fixed Footer Bottom Effect', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enabling this option will make Footer gradually appear on scroll. This is popular for OnePage Websites.', 'charitab-wp' ),
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
				'required' => array( 'footer-settings-footer-visibility', '=', '1' ),
			),





			array(
				'id'        => 'footer-settings-footer-top-typography',
				'type'      => 'info',
				'title'     => esc_html__( 'Typography', 'charitab-wp' ),
				'notice'    => false,
				'required' => array( 'footer-settings-footer-visibility', '=', '1' ),
			),
			array(
				'id'            => 'footer-settings-footer-top-widget-title-typography',
				'type'          => 'typography',
				'title'         => esc_html__( 'Widget Title Typography', 'charitab-wp' ),
				'subtitle'      => '',
				//'compiler'    => true,  // Use if you want to hook in your own CSS compiler
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
				'required' => array( 'footer-settings-footer-visibility', '=', '1' ),
			),

			
			array(
				'id'       => 'footer-settings-footer-widget-title-show-line-bottom',
				'type'     => 'checkbox',
				'title'    => esc_html__( 'Show Line Bottom Under Widget Title', 'charitab-wp' ),
				'subtitle' => esc_html__( 'If you enable it then a thin line will be visible below the widget title.', 'charitab-wp' ),
				'desc'     => '',
				'default'  => '0',
			),
			array(
				'id'       => 'footer-settings-footer-widget-title-line-bottom-theme-colored',
				'type'     => 'select',
				'title'    => esc_html__( 'Make Line Bottom Theme Colored?', 'charitab-wp' ),
				'subtitle' => esc_html__( 'To make the Line Bottom theme colored, please check it.', 'charitab-wp' ),
				'desc'     => '',
				'options'  => charitab_mascot_theme_color_list(),
				'default'  => '1',
				'required' => array( 'footer-settings-footer-widget-title-show-line-bottom', '=', '1' ),
			),
			array(
				'id'       => 'footer-settings-footer-widget-title-line-bottom-custom-color',
				'type'     => 'color',
				'title'    => esc_html__( 'Custom Line Bottom Color', 'charitab-wp' ),
				'subtitle' => '',
				'transparent' => false,
				'required' => array( 'footer-settings-footer-widget-title-line-bottom-theme-colored', '=', '' ),
			),


			array(
				'id'            => 'footer-settings-footer-top-widget-text-typography',
				'type'          => 'typography',
				'title'         => esc_html__( 'Widget Text Typography', 'charitab-wp' ),
				'subtitle'      => '',
				//'compiler'    => true,  // Use if you want to hook in your own CSS compiler
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
				'required' => array( 'footer-settings-footer-visibility', '=', '1' ),
			),
			array(
				'id'            => 'footer-settings-footer-top-widget-link-typography',
				'type'          => 'typography',
				'title'         => esc_html__( 'Widget Link Typography', 'charitab-wp' ),
				'subtitle'      => '',
				//'compiler'    => true,  // Use if you want to hook in your own CSS compiler
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
				'required' => array( 'footer-settings-footer-visibility', '=', '1' ),
			),
			array(
				'id'       => 'footer-settings-footer-top-widget-link-hover-color',
				'type'     => 'color',
				'title'    => esc_html__( 'Widget Link Hover/Active Color', 'charitab-wp' ),
				'subtitle' => '',
				'transparent' => false,
				'required' => array( 'footer-settings-footer-visibility', '=', '1' ),
			),
			
		)
	) );



	// -> START Page Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Page', 'charitab-wp' ),
		'id'     => 'page-settings',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-media-default',
		'fields' => array(
			array(
				'id'       => 'page-settings-sidebar-layout',
				'type'     => 'select',
				'title'    => esc_html__( 'Page Sidebar Layout', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Choose a sidebar layout for pages', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array(
					'no-sidebar'            => esc_html__( 'No Sidebar', 'charitab-wp' ),
					'both-sidebar-25-50-25' => esc_html__( 'Sidebar Both Side (1/4 + 2/4 + 1/4)', 'charitab-wp' ),
					'sidebar-right-25'      => esc_html__( 'Sidebar Right 1/4', 'charitab-wp' ),
					'sidebar-right-33'      => esc_html__( 'Sidebar Right 1/3', 'charitab-wp' ),
					'sidebar-left-25'       => esc_html__( 'Sidebar Left 1/4', 'charitab-wp' ),
					'sidebar-left-33'       => esc_html__( 'Sidebar Left 1/3', 'charitab-wp' ),

				),
				'default'  => 'no-sidebar',
			),
			array(
				'id'       => 'page-settings-sidebar-layout-sidebar-default',
				'type'     => 'select',
				'title'    => esc_html__( 'Page Default Sidebar', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Choose default sidebar that will be displayed on pages.', 'charitab-wp' ),
				'desc'     => '',
				'data'     => 'sidebars',
				'default'  => 'page-sidebar',
				'required' => array( 'page-settings-sidebar-layout', '!=', 'no-sidebar' ),
			),
			array(
				'id'       => 'page-settings-sidebar-layout-sidebar-two',
				'type'     => 'select',
				'title'    => esc_html__( 'Page Sidebar 2', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Choose sidebar 2 that will be displayed on pages. Sidebar 2 will only be used if "Sidebar Both Side" is selected.', 'charitab-wp' ),
				'desc'     => '',
				'data'     => 'sidebars',
				'default'  => 'page-sidebar-two',
				'required' => array( 'page-settings-sidebar-layout', '=', 'both-sidebar-25-50-25' ),
			),
			array(
				'id'       => 'page-settings-sidebar-layout-sidebar-two-position',
				'type'     => 'button_set',
				'compiler' =>true,
				'title'    => esc_html__( 'Page Sidebar 2 - Position', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Controls the position of sidebar 2. In that case, default sidebar will be shown on opposite side.', 'charitab-wp' ),
				'options'	=> array(
					'left'      => esc_html__( 'Left', 'charitab-wp' ),
					'right'     => esc_html__( 'Right', 'charitab-wp' )
				),
				'default'  => 'right',
				'required' => array( 'page-settings-sidebar-layout', '=', 'both-sidebar-25-50-25' ),
			),
			array(
				'id'       => 'page-settings-show-comments',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Page Comments', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enable/Disable comments on all pages except the post pages. It is possible to disable them individually using page meta settings.', 'charitab-wp' ),
				'default'  => true,
			),
			array(
				'id'       => 'page-settings-show-share',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Social Share', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enable/Disabling this option will show/hide share options on your page.', 'charitab-wp' ),
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
			),
		)
	) );




	// -> START Page Title Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Page Title', 'charitab-wp' ),
		'id'     => 'page-title-settings',
		'desc'   => esc_html__( 'Enable/Disable Page Title Area for posts and pages.', 'charitab-wp' ),
		'icon'   => 'dashicons-before dashicons-archive',
		'fields' => array(
			array(
				'id'       => 'page-title-settings-enable-page-title',
				'type'     => 'switch',
				'title'    => esc_html__( 'Enable Page Title Area', 'charitab-wp' ),
				'subtitle' => '',
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
			),
			array(
				'id'       => 'page-title-settings-title-layout',
				'type'     => 'image_select',
				'title'    => esc_html__( 'Choose Page Title Layout', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
				//Must provide key => value(array:title|img) pairs for radio options
				'options'	=> array(
					'standard' => array(
						'alt' => 'standard',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/footer/f11.jpg'
					),
					'split' => array(
						'alt' => 'split',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/footer/f7.jpg'
					),
				),
				'default'  => 'standard',
				'required' => array( 'page-title-settings-enable-page-title', '=', '1' ),
			),
			array(
				'id'       => 'page-title-settings-container',
				'type'     => 'button_set',
				'compiler' =>true,
				'title'    => esc_html__( 'Title Area Container', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Put Page Title content into boxed or stretched fullwidth.', 'charitab-wp' ),
				'options'	=> array(
					'container' => esc_html__( 'Container', 'charitab-wp' ),
					'container-fluid' => esc_html__( 'Container Fluid', 'charitab-wp' )
				),
				'default' => 'container',
				'required' => array( 'page-title-settings-enable-page-title', '=', '1' ),
			),
			array(
				'id'       => 'page-title-settings-enable-custom-padding-top-bottom',
				'type'     => 'switch',
				'title'    => esc_html__( 'Add Custom Padding Top & Bottom into Page Title Area', 'charitab-wp' ),
				'subtitle' => '',
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
			),
			array(
				'id'             => 'page-title-settings-container-padding-top-bottom',
				'type'           => 'spacing',
				'mode'           => 'padding',
				'all'            => false,
				// Have one field that applies to all
				'top'            => true,     // Disable the top
				'right'          => false,     // Disable the right
				'bottom'         => true,     // Disable the bottom
				'left'           => false,     // Disable the left
				'units'          => 'px',
				'units_extended' => 'true',
				'display_units'  => true,   // Set to false to hide the units if the units are specified
				'title'          => esc_html__( 'Padding Top & Bottom(px)', 'charitab-wp' ),
				'subtitle'       => esc_html__( 'Top and bottom padding in px of page title container.', 'charitab-wp' ),
				'desc'           => esc_html__( 'Controls the top and bottom padding of page title. Ex: 80px, 80px. Please put only integer value. Because the unit \'px\' will be automatically added to the end of the value.', 'charitab-wp' ),
				'default'            => array(
					'padding-top'     => '80', 
					'padding-bottom'  => '80', 
					'units'          => 'px', 
				),
				'required' => array( 'page-title-settings-enable-custom-padding-top-bottom', '=', '1' ),
			),
			array(
				'id'       => 'page-title-settings-show-title',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Title', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enable/Disable title on Page Title Area. It is possible to disable them individually using page meta settings.', 'charitab-wp' ),
				'default'  => true,
				'required' => array( 'page-title-settings-enable-page-title', '=', '1' ),
			),
			array(
				'id'       => 'page-title-settings-show-subtitle',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Subtitle', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enable/Disable Sub title on Page Title Area. It is possible to disable them individually using page meta settings.', 'charitab-wp' ),
				'default'  => true,
				'required' => array( 'page-title-settings-enable-page-title', '=', '1' ),
			),
			array(
				'id'       => 'page-title-settings-show-breadcrumbs',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Breadcrumbs', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enable/Disable breadcrumbs on Page Title. It is possible to disable them individually using page meta settings.', 'charitab-wp' ),
				'default'  => true,
				'required' => array( 'page-title-settings-enable-page-title', '=', '1' ),
			),
			array(
				'id'       => 'page-title-settings-height',
				'type'     => 'select',
				'title'    => esc_html__( 'Title Area Height', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'select2' => array( array( 'minimumResultsForSearch' => 'Infinity' ) ),
				'options'	=> array(
					'padding-default'       => esc_html__( 'Default', 'charitab-wp' ),
					'padding-extra-small'   => esc_html__( 'Extra Small', 'charitab-wp' ),
					'padding-small'         => esc_html__( 'Small', 'charitab-wp' ),
					'padding-medium'        => esc_html__( 'Medium', 'charitab-wp' ),
					'padding-large'         => esc_html__( 'Large', 'charitab-wp' ),
					'padding-extra-large'   => esc_html__( 'Extra Large', 'charitab-wp' ),
				),
				'default'  => 'padding-medium',
				'required' => array( 'page-title-settings-enable-page-title', '=', '1' ),
			),
			array(
				'id'       => 'page-title-settings-text-color',
				'type'     => 'button_set',
				'title'    => esc_html__( 'Default Text Color', 'charitab-wp' ),
				'desc'     => '',
				'subtitle' => esc_html__( 'Select default text color. Inverted will turn font color to black. Inverted is suitable for white background.', 'charitab-wp' ),
				'options'	=> array(
					'text-default'   => esc_html__( 'Default (Text White)', 'charitab-wp' ),
					'text-inverted'  => esc_html__( 'Inverted (Text Black)', 'charitab-wp' )
				),
				'default' => 'text-default',
				'required' => array( 'page-title-settings-enable-page-title', '=', '1' ),
			),
			array(
				'id'       => 'page-title-settings-text-align',
				'type'     => 'select',
				'title'    => esc_html__( 'Text Alignment', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Text Alignment of Page Title', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> charitab_mascot_redux_text_alignment_list(),
				'default'  => 'text-center',
				'required' => array( 'page-title-settings-enable-page-title', '=', '1' ),
			),
			array(
				'id'       => 'page-title-settings-top-border-color',
				'type'     => 'color',
				'title'    => esc_html__( 'Title Area Top Border Color', 'charitab-wp' ),
				'subtitle' => '',
				'transparent' => false,
				'required' => array( 'page-title-settings-enable-page-title', '=', '1' ),
			),
			array(
				'id'       => 'page-title-settings-bottom-border-color',
				'type'     => 'color',
				'title'    => esc_html__( 'Title Area Bottom Border Color', 'charitab-wp' ),
				'subtitle' => '',
				'transparent' => false,
				'required' => array( 'page-title-settings-enable-page-title', '=', '1' ),
			),


			//Page Title background
			array(
				'id'       => 'page-title-settings-bg-section-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Page Title Background', 'charitab-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
				'required' => array( 
					array( 'page-title-settings-enable-page-title', '=', '1' )
				)
			),
			array(
				'id'       => 'page-title-settings-bg',
				'type'     => 'background',
				'title'    => esc_html__( 'Page Title Background', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Choose background image or color.', 'charitab-wp' ),
				'default'  => array(
					'background-repeat'     => 'no-repeat',
					'background-size'       => 'cover',
					'background-attachment' => '',
					'background-position'   => 'center center',
					'background-image'      => CHARITAB_MASCOT_ASSETS_URI . '/images/bg/bg1.jpg',
				),
				'required' => array( 
					array( 'page-title-settings-enable-page-title', '=', '1' )
				)
			),
			/*array(
				'id'       => 'page-title-settings-bg-parallax-effect',
				'type'     => 'switch',
				'title'    => esc_html__( 'Page Title Background Parallax Effect', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Parallax effect only for background image of Page Title.', 'charitab-wp' ),
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
				'required' => array( 
					array( 'page-title-settings-enable-page-title', '=', '1' )
				)
			),*/
			array(
				'id'       => 'page-title-settings-bg-layer-overlay-status',
				'type'     => 'switch',
				'title'    => esc_html__( 'Add Page Title Background Overlay', 'charitab-wp' ),
				'subtitle' => '',
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
				'required' => array( 
					array( 'page-title-settings-enable-page-title', '=', '1' )
				)
			),
			array(
				'id'       => 'page-title-settings-bg-layer-overlay',
				'type'          => 'slider',
				'title'         => esc_html__( 'Background Overlay Opacity', 'charitab-wp' ),
				'subtitle'      => esc_html__( 'Overlay on background image on Page Title.', 'charitab-wp' ),
				'desc'          => '',
				'default'       => 8,
				'min'           => 1,
				'step'          => 1,
				'max'           => 9,
				'display_value' => 'text',
				'required' => array( 
					array( 'page-title-settings-enable-page-title', '=', '1' ),
					array( 'page-title-settings-bg-layer-overlay-status', '=', '1' )
				)
			),
			array(
				'id'       => 'page-title-settings-bg-layer-overlay-color',
				'type'     => 'button_set',
				'compiler' =>true,
				'title'    => esc_html__( 'Background Overlay Color', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Select Dark or White Overlay on background image.', 'charitab-wp' ),
				'options'	=> array(
					''          	=> esc_html__( 'None', 'charitab-wp' ),
					'dark'          => esc_html__( 'Dark', 'charitab-wp' ),
					'white'         => esc_html__( 'White', 'charitab-wp' ),
					'theme-colored1' => esc_html__( 'Primary Theme Color1', 'charitab-wp' ),
					'theme-colored2' => esc_html__( 'Primary Theme Color2', 'charitab-wp' )
				),
				'default' => 'dark',
				'required' => array( 
					array( 'page-title-settings-enable-page-title', '=', '1' ),
					array( 'page-title-settings-bg-layer-overlay-status', '=', '1' )
				)
			),

			//background video
			array(
				'id'       => 'page-title-settings-bg-video-status',
				'type'     => 'switch',
				'title'    => esc_html__( 'Add Background Video', 'charitab-wp' ),
				'subtitle' => '',
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
				'required' => array( 
					array( 'page-title-settings-enable-page-title', '=', '1' )
				)
			),
			array(
				'id'       => 'page-title-settings-bg-video-type',
				'type'     => 'button_set',
				'compiler' =>true,
				'title'    => esc_html__( 'Video Type', 'charitab-wp' ),
				'subtitle' => '',
				'options' => array(
					'youtube' => esc_html__( 'Youtube', 'charitab-wp' ),
					'self-hosted' => esc_html__( 'Self Hosted Video', 'charitab-wp' )
				),
				'default' => 'youtube',
				'required' => array( 
					array( 'page-title-settings-enable-page-title', '=', '1' ),
					array( 'page-title-settings-bg-video-status', '=', '1' )
				)
			),
			array(
				'id'       => 'page-title-settings-bg-video-youtube-id',
				'type'     => 'text',
				'title'    => esc_html__( 'Youtube Video ID', 'charitab-wp' ),
				'subtitle'    => esc_html__( 'Only put video ID not the whole URL.', 'charitab-wp' ),
				'desc'     => '',
				'placeholder'    => esc_html__( 'Example: E5ln4uR4TwQ', 'charitab-wp' ),
				'default' => '',
				'required' => array( 
					array( 'page-title-settings-enable-page-title', '=', '1' ),
					array( 'page-title-settings-bg-video-status', '=', '1' ),
					array( 'page-title-settings-bg-video-type', '=', 'youtube' )
				)
			),
			array(
				'id'       => 'page-title-settings-bg-video-self-hosted-video-poster',
				'type'     => 'media',
				'title'    => esc_html__( 'Video Poster', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'url'      => true,
				'readonly' => false,
				'mode'     => false, // Can be set to false to allow any media type, or can also be set to any mime type.
				'default'  => '',
				'required' => array( 
					array( 'page-title-settings-enable-page-title', '=', '1' ),
					array( 'page-title-settings-bg-video-status', '=', '1' ),
					array( 'page-title-settings-bg-video-type', '=', 'self-hosted' )
				)
			),
			array(
				'id'       => 'page-title-settings-bg-video-self-hosted-mp4-video-url',
				'type'     => 'media',
				'title'    => esc_html__( 'MP4 Video URL', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'url'      => true,
				'readonly' => false,
				'mode'     => 'mp4', // Can be set to false to allow any media type, or can also be set to any mime type.
				'default'  => '',
				'required' => array( 
					array( 'page-title-settings-enable-page-title', '=', '1' ),
					array( 'page-title-settings-bg-video-status', '=', '1' ),
					array( 'page-title-settings-bg-video-type', '=', 'self-hosted' )
				)
			),
			array(
				'id'       => 'page-title-settings-bg-video-self-hosted-webm-video-url',
				'type'     => 'media',
				'title'    => esc_html__( 'WEBM Video URL', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'url'      => true,
				'readonly' => false,
				'mode'     => 'webm', // Can be set to false to allow any media type, or can also be set to any mime type.
				'default'  => '',
				'required' => array( 
					array( 'page-title-settings-enable-page-title', '=', '1' ),
					array( 'page-title-settings-bg-video-status', '=', '1' ),
					array( 'page-title-settings-bg-video-type', '=', 'self-hosted' )
				)
			),
			array(
				'id'       => 'page-title-settings-bg-video-self-hosted-ogv-video-url',
				'type'     => 'media',
				'title'    => esc_html__( 'OGV Video URL', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'url'      => true,
				'readonly' => false,
				'mode'     => 'false', // Can be set to false to allow any media type, or can also be set to any mime type.
				'default'  => '',
				'required' => array( 
					array( 'page-title-settings-enable-page-title', '=', '1' ),
					array( 'page-title-settings-bg-video-status', '=', '1' ),
					array( 'page-title-settings-bg-video-type', '=', 'self-hosted' )
				)
			),
			array(
				'id'       => 'page-title-settings-bg-section-ends',
				'type'     => 'section',
				'title'    => '',
				'subtitle' => '',
				'indent'   => false, // Indent all options below until the next 'section' option is set.
				'required' => array( 
					array( 'page-title-settings-enable-page-title', '=', '1' ),
				)
			),



			//animation
			array(
				'id'       => 'page-title-settings-title-animation-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Animation Effect', 'charitab-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
				'required' => array( 
					array( 'page-title-settings-enable-page-title', '=', '1' )
				)
			),
			array(
				'id'       => 'page-title-settings-title-animation-effect',
				'type'     => 'select',
				'title'    => esc_html__( 'Title Animation Effect', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'options'	=> charitab_mascot_animate_css_animation_list(),
				'default'  => '',
				'required' => array( 'page-title-settings-enable-page-title', '=', '1' ),
			),
			array(
				'id'       => 'page-title-settings-title-animation-duration',
				'type'     => 'text',
				'title'    => esc_html__( 'Title Animation Duration', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => esc_html__( 'Change the animation duration. Example: 1500ms or 1.5s or 0.5s etc. Default 0.5s.', 'charitab-wp' ),
				'placeholder' => esc_html__( '1.5s', 'charitab-wp' ),
				'default'  => '',
				'required' => array( 'page-title-settings-enable-page-title', '=', '1' ),
			),
			array(
				'id'       => 'page-title-settings-subtitle-animation-effect',
				'type'     => 'select',
				'title'    => esc_html__( 'Sub Title Animation Effect', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'options'	=> charitab_mascot_animate_css_animation_list(),
				'default'  => '',
				'required' => array( 'page-title-settings-enable-page-title', '=', '1' ),
			),
			array(
				'id'       => 'page-title-settings-subtitle-animation-duration',
				'type'     => 'text',
				'title'    => esc_html__( 'Sub Title Animation Duration', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => esc_html__( 'Change the animation duration. Example: 1500ms or 1.5s or 0.5s etc. Default 0.5s.', 'charitab-wp' ),
				'placeholder' => esc_html__( '1.5s', 'charitab-wp' ),
				'default'  => '',
				'required' => array( 'page-title-settings-enable-page-title', '=', '1' ),
			),
			array(
				'id'       => 'page-title-settings-title-animation-ends',
				'type'     => 'section',
				'indent'   => false, // Indent all options below until the next 'section' option is set.
				'required' => array( 
					array( 'page-title-settings-enable-page-title', '=', '1' )
				)
			),



			//section Typography Starts
			array(
				'id'       => 'page-title-settings-title-typography-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Typography', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Define text and styles for Title.', 'charitab-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
				'required' => array( 'page-title-settings-enable-page-title', '=', '1' ),
			),
			array(
				'id'       => 'page-title-settings-title-tag',
				'type'     => 'select',
				'title'    => esc_html__( 'Title Tag', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Choose title element tag', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> charitab_mascot_heading_tag_list_all(),
				'default'  => 'h1',
			),
			array(
				'id'            => 'page-title-settings-title-typography',
				'type'          => 'typography',
				'title'         => esc_html__( 'Title Typography', 'charitab-wp' ),
				'subtitle'      => '',
				//'compiler'    => true,  // Use if you want to hook in your own CSS compiler
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
				'default'     => array(
					'font-size'   => '54px',
					'line-height' => '64px',
				),
			),
			array(
				'id'       => 'page-title-settings-title-margin-top-bottom',
				'type'     => 'spacing',
				// An array of CSS selectors to apply this font style to
				'mode'     => 'margin',
				// absolute, padding, margin, defaults to padding
				'all'      => false,
				// Have one field that applies to all
				'top'      => true,     // Disable the top
				'right'    => false,     // Disable the right
				'bottom'   => true,     // Disable the bottom
				'left'     => false,     // Disable the left
				'units'    => 'px',      // You can specify a unit value. Possible: px, em, %
				//'units_extended'=> 'true',    // Allow users to select any type of unit
				'display_units' => true,   // Set to false to hide the units if the units are specified
				'title'    => esc_html__( 'Title Margin Top & Bottom', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
			),
			array(
				'id'       => 'page-title-settings-subtitle-tag',
				'type'     => 'select',
				'title'    => esc_html__( 'Subtitle Tag', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Choose subtitle element tag', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> charitab_mascot_heading_tag_list_all(),
				'default'  => 'h6',
			),
			array(
				'id'            => 'page-title-settings-subtitle-typography',
				'type'          => 'typography',
				'title'         => esc_html__( 'Sub Title Typography', 'charitab-wp' ),
				'subtitle'      => '',
				//'compiler'    => true,  // Use if you want to hook in your own CSS compiler
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
			),
			array(
				'id'       => 'page-title-settings-subtitle-margin-top-bottom',
				'type'     => 'spacing',
				// An array of CSS selectors to apply this font style to
				'mode'     => 'margin',
				// absolute, padding, margin, defaults to padding
				'all'      => false,
				// Have one field that applies to all
				'top'      => true,     // Disable the top
				'right'    => false,     // Disable the right
				'bottom'   => true,     // Disable the bottom
				'left'     => false,     // Disable the left
				'units'    => 'px',      // You can specify a unit value. Possible: px, em, %
				//'units_extended'=> 'true',    // Allow users to select any type of unit
				'display_units' => true,   // Set to false to hide the units if the units are specified
				'title'    => esc_html__( 'Sub Title Margin Top & Bottom', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
			),
			array(
				'id'            => 'page-title-settings-breadcrumbs-typography',
				'type'          => 'typography',
				'title'         => esc_html__( 'Breadcrumbs Typography', 'charitab-wp' ),
				'subtitle'      => '',
				//'compiler'    => true,  // Use if you want to hook in your own CSS compiler
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
			),
			array(
				'id'       => 'page-title-settings-breadcrumbs-last-child-text-color',
				'type'     => 'color',
				'title'    => esc_html__( 'Breadcrumbs Last Child Text Color', 'charitab-wp' ),
				'subtitle' => '',
				'transparent' => false,
			),
			array(
				'id'       => 'page-title-settings-breadcrumbs-seperator-color',
				'type'     => 'color',
				'title'    => esc_html__( 'Breadcrumbs Seperator Color', 'charitab-wp' ),
				'subtitle' => '',
				'transparent' => false,
			),
			array(
				'id'       => 'page-title-settings-breadcrumbs-link-hover-color',
				'type'     => 'color',
				'title'    => esc_html__( 'Breadcrumbs Link Hover/Active Color', 'charitab-wp' ),
				'subtitle' => '',
				'transparent' => false,
			),
			array(
				'id'       => 'page-title-settings-title-typography-ends',
				'type'   => 'section',
				'indent' => false, // Indent all options below until the next 'section' option is set.
			),
		)
	) );



	// -> START Blog Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Blog', 'charitab-wp' ),
		'id'     => 'blog-settings-parent',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-media-document',
	) );



	// -> START Blog Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Blog Archive Page', 'charitab-wp' ),
		'id'     => 'blog-settings',
		'subsection'       => true,
		'desc'   => '',
		'fields' => array(
			array(
				'id'       => 'blog-settings-archive-page-layout',
				'type'     => 'select',
				'title'    => esc_html__( 'Default Blog Post Layout for Archive Pages', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Choose a default layout for archive pages', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array(
					'standard-1-col' => 'Standard 1 Column Default',
					'standard-1-col-classic' => 'Standard 1 Column Classic',
					'standard-2-col' => 'Standard 2 Columns',
					'standard-3-col' => 'Standard 3 Columns',
					'standard-4-col' => 'Standard 4 Columns',
					'masonry-2-col'  => 'Masonry 2 Columns',
					'masonry-3-col'  => 'Masonry 3 Columns',
					'masonry-4-col'  => 'Masonry 4 Columns',
				),
				'default'  => 'standard-1-col',
			),
			array(
				'id'       => 'blog-settings-sidebar-layout',
				'type'     => 'select',
				'title'    => esc_html__( 'Sidebar Layout', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Choose a sidebar layout for pages', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array(
					'no-sidebar'            => esc_html__( 'No Sidebar', 'charitab-wp' ),
					'both-sidebar-25-50-25' => esc_html__( 'Sidebar Both Side (1/4 + 2/4 + 1/4)', 'charitab-wp' ),
					'sidebar-right-25'      => esc_html__( 'Sidebar Right 1/4', 'charitab-wp' ),
					'sidebar-right-33'      => esc_html__( 'Sidebar Right 1/3', 'charitab-wp' ),
					'sidebar-left-25'       => esc_html__( 'Sidebar Left 1/4', 'charitab-wp' ),
					'sidebar-left-33'       => esc_html__( 'Sidebar Left 1/3', 'charitab-wp' ),
				),
				'default'  => 'sidebar-right-25',
			),


			array(
				'id'       => 'blog-settings-sidebar-layout-sidebar-default',
				'type'     => 'select',
				'title'    => esc_html__( 'Blog Default Sidebar', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Choose default sidebar that will be displayed on blog archive pages.', 'charitab-wp' ),
				'desc'     => '',
				'data'     => 'sidebars',
				'default'  => 'default-sidebar',
				'required' => array( 'blog-settings-sidebar-layout', '!=', 'no-sidebar' ),
			),
			array(
				'id'       => 'blog-settings-sidebar-layout-sidebar-two',
				'type'     => 'select',
				'title'    => esc_html__( 'Blog Sidebar 2', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Choose sidebar 2 that will be displayed on blog archive pages. Sidebar 2 will only be used if "Sidebar Both Side" is selected.', 'charitab-wp' ),
				'desc'     => '',
				'data'     => 'sidebars',
				'default'  => 'blog-secondary-sidebar',
				'required' => array( 'blog-settings-sidebar-layout', '=', 'both-sidebar-25-50-25' ),
			),
			array(
				'id'       => 'blog-settings-sidebar-layout-sidebar-two-position',
				'type'     => 'button_set',
				'compiler' =>true,
				'title'    => esc_html__( 'Blog Sidebar 2 - Position', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Controls the position of sidebar 2. In that case, default sidebar will be shown on opposite side.', 'charitab-wp' ),
				'options'	=> array(
					'left'      => esc_html__( 'Left', 'charitab-wp' ),
					'right'     => esc_html__( 'Right', 'charitab-wp' )
				),
				'default'  => 'right',
				'required' => array( 'blog-settings-sidebar-layout', '=', 'both-sidebar-25-50-25' ),
			),


			array(
				'id'       => 'blog-settings-fullwidth',
				'type'     => 'switch',
				'title'    => esc_html__( 'Fullwidth?', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Make the page fullwidth or not.', 'charitab-wp' ),
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
			),
			array(
				'id'            => 'blog-settings-excerpt-length',
				'type'          => 'slider',
				'title'         => esc_html__( 'Excerpt Length', 'charitab-wp' ),
				'subtitle'      => esc_html__( 'Number of words to display in excerpt.', 'charitab-wp' ),
				'desc'          => '',
				'default'       => 22,
				'min'           => 0,
				'step'          => 1,
				'max'           => 500,
				'display_value' => 'text',
			),
			array(
				'id'       => 'blog-settings-show-post-featured-image',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Featured Image', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enable/Disabling this option will show/hide Featured Image in blog page.', 'charitab-wp' ),
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
			),
			array(
				'id'       => 'blog-settings-post-featured-image-size',
				'type'     => 'select',
				'title'    => esc_html__( 'Featured Image Size', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Featured image size in blog page.', 'charitab-wp' ),
				'desc'     => '',
				'data'     => 'image_sizes',
				'default'  => 'charitab_mascot_wide',
				'required' => array( 'blog-settings-show-post-featured-image', '=', '1' ),
			),
			array(
				'id'       => 'blog-settings-post-meta',
				'type'     => 'checkbox',
				'title'    => esc_html__( 'Post Meta', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enable/Disabling this option will show/hide each Post Meta on your page.', 'charitab-wp' ),
				'desc' => '',
				//Must provide key => value pairs for multi checkbox options
				'options'	=> array(
					'show-post-by-author'       => esc_html__( 'Show By Author', 'charitab-wp' ),
					'show-post-date'            => esc_html__( 'Show Date', 'charitab-wp' ),
					'show-post-category'        => esc_html__( 'Show Category', 'charitab-wp' ),
					'show-post-comments-count'  => esc_html__( 'Show Comments Count', 'charitab-wp' ),
					'show-post-tag'             => esc_html__( 'Show Tag', 'charitab-wp' ),
					'show-post-like-button'     => esc_html__( 'Show Like Button', 'charitab-wp' ),
				),
				//See how std has changed? you also don't need to specify opts that are 0.
				'default'  => array(
					'show-post-by-author' => '1',
					'show-post-date' => '1',
					'show-post-category' => '1',
					'show-post-comments-count' => '0',
					'show-post-tag' => '0',
					'show-post-like-button' => '0'
				)
			),
			array(
				'id'       => 'blog-settings-show-pagination',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Pagination', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enabling this option will show comments on your page.', 'charitab-wp' ),
				'default'  => true,
			),
		)
	) );



	// -> START Single Post Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Single Post', 'charitab-wp' ),
		'id'     => 'blog-single-post-settings',
		'subsection'       => true,
		'desc'   => '',
		'fields' => array(
			array(
				'id'       => 'blog-single-post-settings-fullwidth',
				'type'     => 'switch',
				'title'    => esc_html__( 'Fullwidth?', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Make the page fullwidth or not.', 'charitab-wp' ),
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
			),
			array(
				'id'       => 'blog-single-post-settings-sidebar-layout',
				'type'     => 'select',
				'title'    => esc_html__( 'Sidebar Layout', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Choose a sidebar layout for pages', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array(
					'no-sidebar'            => esc_html__( 'No Sidebar', 'charitab-wp' ),
					'both-sidebar-25-50-25' => esc_html__( 'Sidebar Both Side (1/4 + 2/4 + 1/4)', 'charitab-wp' ),
					'sidebar-right-25'      => esc_html__( 'Sidebar Right 1/4', 'charitab-wp' ),
					'sidebar-right-33'      => esc_html__( 'Sidebar Right 1/3', 'charitab-wp' ),
					'sidebar-left-25'       => esc_html__( 'Sidebar Left 1/4', 'charitab-wp' ),
					'sidebar-left-33'       => esc_html__( 'Sidebar Left 1/3', 'charitab-wp' ),
				),
				'default'  => 'sidebar-right-25',
			),



			array(
				'id'       => 'blog-single-post-settings-sidebar-layout-sidebar-default',
				'type'     => 'select',
				'title'    => esc_html__( 'Default Sidebar', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Choose default sidebar that will be displayed on blog single pages.', 'charitab-wp' ),
				'desc'     => '',
				'data'     => 'sidebars',
				'default'  => 'default-sidebar',
				'required' => array( 'blog-single-post-settings-sidebar-layout', '!=', 'no-sidebar' ),
			),
			array(
				'id'       => 'blog-single-post-settings-sidebar-layout-sidebar-two',
				'type'     => 'select',
				'title'    => esc_html__( 'Sidebar 2', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Choose sidebar 2 that will be displayed on blog single pages. Sidebar 2 will only be used if "Sidebar Both Side" is selected.', 'charitab-wp' ),
				'desc'     => '',
				'data'     => 'sidebars',
				'default'  => 'blog-secondary-sidebar',
				'required' => array( 'blog-single-post-settings-sidebar-layout', '=', 'both-sidebar-25-50-25' ),
			),
			array(
				'id'       => 'blog-single-post-settings-sidebar-layout-sidebar-two-position',
				'type'     => 'button_set',
				'compiler' =>true,
				'title'    => esc_html__( 'Sidebar 2 - Position', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Controls the position of sidebar 2. In that case, default sidebar will be shown on opposite side.', 'charitab-wp' ),
				'options'	=> array(
					'left'      => esc_html__( 'Left', 'charitab-wp' ),
					'right'     => esc_html__( 'Right', 'charitab-wp' )
				),
				'default'  => 'right',
				'required' => array( 'blog-single-post-settings-sidebar-layout', '=', 'both-sidebar-25-50-25' ),
			),


			
			array(
				'id'       => 'blog-single-post-settings-show-post-featured-image',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Featured Image', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enable/Disabling this option will show/hide Featured Image in blog page.', 'charitab-wp' ),
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
			),
			array(
				'id'            => 'blog-single-post-settings-featured-image-height',
				'type'          => 'slider',
				'title'         => esc_html__( 'Featured Image Height(px)', 'charitab-wp' ),
				'subtitle'      => esc_html__( 'Set height for featured image displayed on your blog single page.', 'charitab-wp' ),
				'desc'          => '',
				'default'       => 600,
				'min'           => 0,
				'step'          => 1,
				'max'           => 1200,
				'display_value' => 'text',
			),
			array(
				'id'       => 'blog-single-post-settings-enable-drop-caps',
				'type'     => 'switch',
				'title'    => esc_html__( 'Enable Drop Caps', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enable/Disabling Drop Caps for the first letter of post content.', 'charitab-wp' ),
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
			),
			array(
				'id'       => 'blog-single-post-settings-post-meta',
				'type'     => 'checkbox',
				'title'    => esc_html__( 'Post Meta', 'charitab-wp' ),
				'subtitle'     => esc_html__( 'Enable/Disabling this option will show/hide each Post Meta on your page.', 'charitab-wp' ),
				'desc' => '',
				//Must provide key => value pairs for multi checkbox options
				'options'	=> array(
					'show-post-by-author'       => esc_html__( 'Show By Author', 'charitab-wp' ),
					'show-post-date'            => esc_html__( 'Show Date', 'charitab-wp' ),
					'show-post-category'        => esc_html__( 'Show Category', 'charitab-wp' ),
					'show-post-comments-count'  => esc_html__( 'Show Comments Count', 'charitab-wp' ),
					'show-post-like-button'     => esc_html__( 'Show Like Button', 'charitab-wp' ),
				),
				//See how std has changed? you also don't need to specify opts that are 0.
				'default'  => array(
					'show-post-by-author' => '1',
					'show-post-date' => '1',
					'show-post-category' => '1',
					'show-post-comments-count' => '1',
					'show-post-like-button' => '0'
				)
			),
			array(
				'id'       => 'blog-single-post-settings-show-tags',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Tags', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enable/Disabling this option will show/hide tags on your page.', 'charitab-wp' ),
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
			),
			array(
				'id'       => 'blog-single-post-settings-show-share',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Social Share', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enable/Disabling this option will show/hide share options on your page.', 'charitab-wp' ),
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
			),


			//section Next/Previous Navigation Link Starts
			array(
				'id'       => 'blog-single-post-settings-show-next-pre-post-link-section-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Next/Previous Navigation Link', 'charitab-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
			),
			array(
				'id'       => 'blog-single-post-settings-show-next-pre-post-link',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Next/Previous Single Post Navigation Link', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enable/Disabling this option will show/hide link for Next & Previous Posts.', 'charitab-wp' ),
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
			),
			array(
				'id'       => 'blog-single-post-settings-show-next-pre-post-link-within-same-cat',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Navigation Link Within Same Category', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enable/Disabling this option will show/hide link to the next/previous post within the same category as the current post.', 'charitab-wp' ),
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
				'required' => array( 'blog-single-post-settings-show-next-pre-post-link', '=', '1' ),
			),
			array(
				'id'       => 'blog-single-post-settings-show-next-pre-post-link-section-ends',
				'type'   => 'section',
				'indent' => false, // Indent all options below until the next 'section' option is set.
			),


			//section Author Info Box
			array(
				'id'       => 'blog-single-post-settings-author-info-box-section-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Author Info Box', 'charitab-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
			),
			array(
				'id'       => 'blog-single-post-settings-author-info-box',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Author Info Box', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enable/Disabling this option will show/hide Author Info Box on your page.', 'charitab-wp' ),
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
			),
			array(
				'id'       => 'blog-single-post-settings-author-info-box-show-social-icons',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Social Icons', 'charitab-wp' ),
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
				'required' => array( 'blog-single-post-settings-author-info-box', '=', '1' ),
			),
			array(
				'id'       => 'blog-single-post-settings-author-info-box-show-author-email',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Author Email', 'charitab-wp' ),
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
				'required' => array( 'blog-single-post-settings-author-info-box', '=', '1' ),
			),
			array(
				'id'       => 'blog-single-post-settings-author-info-box-section-ends',
				'type'   => 'section',
				'indent' => false, // Indent all options below until the next 'section' option is set.
			),




			//section Related Posts Starts
			array(
				'id'       => 'blog-single-post-settings-related-posts-section-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Related Posts', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enable/Disabling this option will show/hide Related Posts List/Carousel on your page.', 'charitab-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
			),
			array(
				'id'       => 'blog-single-post-settings-show-related-posts',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Related Posts', 'charitab-wp' ),
				'subtitle' => '',
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
			),
			array(
				'id'       => 'blog-single-post-settings-show-related-posts-carousel',
				'type'     => 'switch',
				'title'    => esc_html__( 'Carousel?', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Make it carousel or grid', 'charitab-wp' ),
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
				'required' => array( 'blog-single-post-settings-show-related-posts', '=', '1' ),
			),
			array(
				'id'       => 'blog-single-post-settings-show-related-posts-count',
				'type'     => 'text',
				'title'    => esc_html__( 'Number of Posts', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => esc_html__( 'Enter number of posts to display. Default 3', 'charitab-wp' ),
				'default'  => '3',
				'required' => array( 'blog-single-post-settings-show-related-posts', '=', '1' ),
			),
			array(
				'id'       => 'blog-single-post-settings-related-posts-show-excerpt',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Excerpt', 'charitab-wp' ),
				'subtitle' => '',
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
				'required' => array( 'blog-single-post-settings-show-related-posts', '=', '1' ),
			),
			array(
				'id'            => 'blog-single-post-settings-show-related-posts-excerpt-length',
				'type'          => 'slider',
				'title'         => esc_html__( 'Excerpt Length', 'charitab-wp' ),
				'subtitle'      => esc_html__( 'Number of words to display in excerpt.', 'charitab-wp' ),
				'desc'          => '',
				'default'       => 20,
				'min'           => 0,
				'step'          => 1,
				'max'           => 200,
				'display_value' => 'text',
				'required' => array( 'blog-single-post-settings-show-related-posts-excerpt', '=', '1' ),
			),
			array(
				'id'       => 'blog-single-post-settings-related-posts-section-ends',
				'type'   => 'section',
				'indent' => false, // Indent all options below until the next 'section' option is set.
			),



			//section Show Comments Starts
			array(
				'id'       => 'blog-single-post-settings-comments-section-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Comments', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enable/Disabling this option will show/hide Comments on your page.', 'charitab-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
			),
			array(
				'id'       => 'blog-single-post-settings-show-comments',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Comments', 'charitab-wp' ),
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
			),
			array(
				'id'       => 'blog-single-post-settings-comments-section-ends',
				'type'   => 'section',
				'indent' => false, // Indent all options below until the next 'section' option is set.
			),

		)
	) );



	// -> START Single Post Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Other Settings', 'charitab-wp' ),
		'id'     => 'blog-other-settings',
		'subsection'       => true,
		'desc'   => '',
		'fields' => array(
			array(
				'id'       => 'blog-other-settings-show-blog-title-description',
				'type'     => 'switch',
				'title'    => esc_html__( 'Custom Blog Title & Description', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Add title and description in title section of blog page', 'charitab-wp' ),
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
			),
			array(
				'id'       => 'blog-other-settings-blog-title-text',
				'type'     => 'text',
				'title'    => esc_html__( 'Blog Title Text', 'charitab-wp' ),
				'desc'     => '',
				'default'  => esc_html__( 'Blog', 'charitab-wp' ),
				'required' => array( 'blog-other-settings-show-blog-title-description', '=', '1' ),
			),
			array(
				'id'       => 'blog-other-settings-blog-description-text',
				'type'     => 'textarea',
				'title'    => esc_html__( 'Blog Description Text', 'charitab-wp' ),
				'desc'     => '',
				'default'  => '',
				'required' => array( 'blog-other-settings-show-blog-title-description', '=', '1' ),
			)
		)
	) );



	/*// -> START Portfolio Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Portfolio', 'charitab-wp' ),
		'id'     => 'portfolio-settings-parent',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-format-gallery',
	) );



	// -> START Portfolio Layout Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Portfolio Archive Layout', 'charitab-wp' ),
		'id'     => 'portfolio-layout-settings',
		'subsection'       => true,
		'desc'   => '',
		'fields' => array(
			array(
				'id'       => 'portfolio-settings-sidebar-layout',
				'type'     => 'select',
				'title'    => esc_html__( 'Portfolio Sidebar Layout', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Choose a sidebar layout for portfolio pages', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array(
					'no-sidebar'            => esc_html__( 'No Sidebar', 'charitab-wp' ),
					'both-sidebar-25-50-25' => esc_html__( 'Sidebar Both Side (1/4 + 2/4 + 1/4)', 'charitab-wp' ),
					'sidebar-right-25'      => esc_html__( 'Sidebar Right 1/4', 'charitab-wp' ),
					'sidebar-right-33'      => esc_html__( 'Sidebar Right 1/3', 'charitab-wp' ),
					'sidebar-left-25'       => esc_html__( 'Sidebar Left 1/4', 'charitab-wp' ),
					'sidebar-left-33'       => esc_html__( 'Sidebar Left 1/3', 'charitab-wp' ),

				),
				'default'  => 'no-sidebar',
			),
			array(
				'id'       => 'portfolio-settings-sidebar-layout-sidebar-default',
				'type'     => 'select',
				'title'    => esc_html__( 'Portfolio Default Sidebar', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Choose default sidebar that will be displayed on portfolio pages.', 'charitab-wp' ),
				'desc'     => '',
				'data'     => 'sidebars',
				'default'  => 'page-sidebar',
				'required' => array( 'portfolio-settings-sidebar-layout', '!=', 'no-sidebar' ),
			),
			array(
				'id'       => 'portfolio-settings-sidebar-layout-sidebar-two',
				'type'     => 'select',
				'title'    => esc_html__( 'Portfolio Sidebar 2', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Choose sidebar 2 that will be displayed on portfolio pages. Sidebar 2 will only be used if "Sidebar Both Side" is selected.', 'charitab-wp' ),
				'desc'     => '',
				'data'     => 'sidebars',
				'default'  => 'page-sidebar-two',
				'required' => array( 'portfolio-settings-sidebar-layout', '=', 'both-sidebar-25-50-25' ),
			),
			array(
				'id'       => 'portfolio-settings-sidebar-layout-sidebar-two-position',
				'type'     => 'button_set',
				'compiler' =>true,
				'title'    => esc_html__( 'Portfolio Sidebar 2 - Position', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Controls the position of sidebar 2. In that case, default sidebar will be shown on opposite side.', 'charitab-wp' ),
				'options'	=> array(
					'left'      => esc_html__( 'Left', 'charitab-wp' ),
					'right'     => esc_html__( 'Right', 'charitab-wp' )
				),
				'default'  => 'right',
				'required' => array( 'portfolio-settings-sidebar-layout', '=', 'both-sidebar-25-50-25' ),
			),




			array(
				'id'       => 'portfolio-layout-settings-select-portfolio-type',
				'type'     => 'image_select',
				'title'    => esc_html__( 'Portfolio Type', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Select the type of portfolio you would like to display.', 'charitab-wp' ),
				'desc'     => '',
				//Must provide key => value(array:title|img) pairs for radio options
				'options'	=> array(
					'default' => array(
						'alt' => 'Default',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/portfolio/type/default.png'
					),
					'london' => array(
						'alt' => 'London',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/portfolio/type/london.png'
					),
					'rome' => array(
						'alt' => 'Rome',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/portfolio/type/rome.png'
					),
					'paris' => array(
						'alt' => 'Paris',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/portfolio/type/paris.png'
					),
					'barlin' => array(
						'alt' => 'Barlin',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/portfolio/type/barlin.png'
					),
					'simple' => array(
						'alt' => 'Simple',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/portfolio/type/simple.png'
					),
					'standard' => array(
						'alt' => 'Standard',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/portfolio/type/standard.png'
					),
				),
				'default'  => 'standard'
			),

			array(
				'id'       => 'portfolio-layout-settings-select-portfolio-layout-mode',
				'type'     => 'image_select',
				'title'    => esc_html__( 'Portfolio Layout Mode (FitRows Or Masonry)', 'charitab-wp' ),
				'subtitle' => esc_html__( 'You can position items with different layout modes. Select a layout mode you would like to use.', 'charitab-wp' ),
				'desc'     => '',
				//Must provide key => value(array:title|img) pairs for radio options
				'options'	=> array(
					'fitrows' => array(
						'alt' => 'Fit Rows',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/portfolio/layout-mode/fitrows.png'
					),
					'masonry' => array(
						'alt' => 'Masonry',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/portfolio/layout-mode/masonry.png'
					),
				),
				'default'  => 'masonry'
			),


			array(
				'id'       => 'portfolio-layout-settings-items-per-row',
				'type'     => 'select',
				'title'    => esc_html__( 'Number of Portfolio Items Per Row', 'charitab-wp' ),
				'subtitle'    => esc_html__( 'Select your default column structure for your portfolio items.', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array(
					'1'  => '1 Item Per Row',
					'2'  => '2 Items Per Row',
					'3'  => '3 Items Per Row',
					'4'  => '4 Items Per Row',
					'5'  => '5 Items Per Row',
					'6'  => '6 Items Per Row',
					'7'  => '7 Items Per Row',
					'8'  => '8 Items Per Row',
					'9'  => '9 Items Per Row',
					'10' => '10 Items Per Row',
				),
				'default'  => '3',
			),
			array(
				'id'            => 'portfolio-layout-settings-items-per-page',
				'type'          => 'slider',
				'title'         => esc_html__( 'Number of Portfolio Items Per Page', 'charitab-wp' ),
				'subtitle'      => esc_html__( 'Controls the number of items to display on portfolio archive pages. Set to -1 to display all. Set to 0 to use the number of posts from Settings > Reading.', 'charitab-wp' ),
				'desc'          => '',
				'default'       => 10,
				'min'           => -1,
				'step'          => 1,
				'max'           => 40,
				'display_value' => 'text',
			),
			array(
				'id'            => 'portfolio-layout-settings-gutter-size',
				'type'          => 'slider',
				'title'         => esc_html__( 'Portfolio Column Spacing (Gutter Size) px', 'charitab-wp' ),
				'subtitle'      => esc_html__( 'Controls column spacing or gutter size between items on portfolio archive pages.', 'charitab-wp' ),
				'desc'          => '',
				'default'       => 30,
				'min'           => 0,
				'step'          => 1,
				'max'           => 250,
				'display_value' => 'text',
			),
			array(
				'id'       => 'portfolio-layout-settings-thumbnail-orientation',
				'type'     => 'button_set',
				'compiler' =>true,
				'title'    => esc_html__( 'Thumbnail Orientation', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Choose thumbnail orientation on your Portfolio Archive Page.', 'charitab-wp' ),
				'options'	=> array(
					'landscape' => esc_html__( 'Landscape', 'charitab-wp' ),
					'portrait'  => esc_html__( 'Portrait', 'charitab-wp' )
				),
				'default' => 'landscape',
			),
			array(
				'id'       => 'portfolio-layout-settings-thumbnail-ratio',
				'type'     => 'button_set',
				'compiler' =>true,
				'title'    => esc_html__( 'Thumbnail Ratio', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Choose thumbnail ratio on your Portfolio Archive Page.', 'charitab-wp' ),
				'options'	=> array(
					'16:9'  => esc_html__( '16:9', 'charitab-wp' ),
					'4:3'   => esc_html__( '4:3', 'charitab-wp' ),
					'3:2'   => esc_html__( '3:2', 'charitab-wp' ),
					'1:1'   => esc_html__( '1:1', 'charitab-wp' )
				),
				'default' => '16:9',
			),
		)
	) );



	// -> START Portfolio Layout Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Portfolio Page Layout', 'charitab-wp' ),
		'id'     => 'portfolio-page-settings',
		'subsection'       => true,
		'desc'   => '',
		'fields' => array(
			array(
				'id'       => 'portfolio-layout-settings-fullwidth',
				'type'     => 'switch',
				'title'    => esc_html__( 'Page Fullwidth?', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Make the portfolio page fullwidth or not.', 'charitab-wp' ),
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
			),
			array(
				'id'       => 'portfolio-layout-settings-portfolio-items-add-animation-effect',
				'type'     => 'switch',
				'title'    => esc_html__( 'Add Reveal Animation Effect?', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Want to add a reveal animation effect on portfolio items at first sight?', 'charitab-wp' ),
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
			),
			array(
				'id'       => 'portfolio-layout-settings-portfolio-items-animation-effect',
				'type'     => 'select',
				'title'    => esc_html__( 'Choose Reveal Animation Effect', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Choose a reveal animation effect from the list for portfolio items.', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> charitab_mascot_animate_css_animation_list(),
				'default'  => 'fadeInUp',
				'required' => array( 'portfolio-layout-settings-portfolio-items-add-animation-effect', '=', '1' ),
			),
			array(
				'id'       => 'portfolio-layout-settings-portfolio-filter-sorter-position',
				'type'     => 'button_set',
				'compiler' =>true,
				'title'    => esc_html__( 'Portfolio Filter & Sorter Position', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Put Filter in left or center of the container.', 'charitab-wp' ),
				'options'	=> charitab_mascot_redux_text_alignment_list(),
				'default' => 'text-left',
				'required' => array( 'portfolio-layout-settings-portfolio-filter', '=', '1' ),
			),





			
			array(
				'id'       => 'portfolio-layout-settings-portfolio-filter-settings',
				'type'      => 'info',
				'title'     => esc_html__( 'Portfolio Filter', 'charitab-wp' ),
				'notice'    => false,
			),
			array(
				'id'       => 'portfolio-layout-settings-portfolio-filter',
				'type'     => 'switch',
				'title'    => esc_html__( 'Filter on Portfolio Items', 'charitab-wp' ),
				'subtitle' => '',
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
			),
			array(
				'id'       => 'portfolio-layout-settings-portfolio-filter-style',
				'type'     => 'button_set',
				'title'    => esc_html__( 'Filter Style', 'charitab-wp' ),
				'subtitle' => esc_html__( 'You can choose one from different predefined styles.', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array(
					'1'  => 'Plain Text',
					'2'  => 'Flat Box',
					'3'  => 'Button Set',
				),
				'default'  => '1',
				'required' => array( 'portfolio-layout-settings-portfolio-filter', '=', '1' ),
			),




			array(
				'id'       => 'portfolio-layout-settings-portfolio-sorter-settings',
				'type'      => 'info',
				'title'     => esc_html__( 'Portfolio Sorter', 'charitab-wp' ),
				'notice'    => false,
			),
			array(
				'id'       => 'portfolio-layout-settings-portfolio-sorter',
				'type'     => 'switch',
				'title'    => esc_html__( 'Sorter on Portfolio Items', 'charitab-wp' ),
				'subtitle' => '',
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
			),
			array(
				'id'       => 'portfolio-layout-settings-portfolio-sorter-style',
				'type'     => 'button_set',
				'title'    => esc_html__( 'Sorter Style', 'charitab-wp' ),
				'subtitle' => esc_html__( 'You can choose one from different predefined styles.', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array(
					'1'  => 'Button Set',
					'2'  => 'List',
				),
				'default'  => '1',
				'required' => array( 'portfolio-layout-settings-portfolio-sorter', '=', '1' ),
			),
			array(
				'id'       => 'portfolio-layout-settings-portfolio-sorter-elements',
				'type'     => 'checkbox',
				'title'    => esc_html__( 'Sorter Elements', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enable/Disabling this option will show/hide each sorter elements.', 'charitab-wp' ),
				'desc'     => '',
				//Must provide key => value pairs for multi checkbox options
				'options'	=> array(
					'sorter-date'               => esc_html__( 'Date', 'charitab-wp' ),
					'sorter-name'               => esc_html__( 'Name', 'charitab-wp' ),
					'sorter-random'             => esc_html__( 'Random', 'charitab-wp' ),
					'sorter-original-order'     => esc_html__( 'Original Order', 'charitab-wp' ),
					//'sorter-shuffle'            => esc_html__( 'Shuffle', 'charitab-wp' ),
				),
				//See how std has changed? you also don't need to specify opts that are 0.
				'default'  => array(
					'sorter-date' => '1',
					'sorter-name' => '1',
					'sorter-random' => '1',
					'sorter-original-order' => '1',
					//'sorter-shuffle' => '1',
				),
				'required' => array( 'portfolio-layout-settings-portfolio-sorter', '=', '1' ),
			),






			array(
				'id'       => 'portfolio-layout-settings-lightbox-settings',
				'type'      => 'info',
				'title'     => esc_html__( 'Lightbox Settings', 'charitab-wp' ),
				'notice'    => false,
			),
			array(
				'id'       => 'portfolio-layout-settings-lightbox-type',
				'type'     => 'button_set',
				'title'    => esc_html__( 'Lightbox Type', 'charitab-wp' ),
				'subtitle' => esc_html__( 'If set to "Linked to Featured Image" mode, lightbox previous and next arrows will continue through all portfolio items Featured Images shown in the list. Otherwise it will show PrettyPhoto Gallery for each portfolio item.', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array(
					'link-featured'    => 'Linked to Featured Image',
					'link-featured-prettyphoto'    => 'Linked to Featured Image + PrettyPhoto',
					'link-gallery'     => 'Linked to Portfolio Gallery + PrettyPhoto',
				),
				'default'  => 'link-featured-prettyphoto',
			),





			
			array(
				'id'       => 'portfolio-layout-settings-display-content-settings',
				'type'      => 'info',
				'title'     => esc_html__( 'Display Content Settings', 'charitab-wp' ),
				'notice'    => false,
			),
			array(
				'id'       => 'portfolio-layout-settings-display-content-type',
				'type'     => 'button_set',
				'title'    => esc_html__( 'Display Content Type', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Controls the content type to display between excerpt and full content for portfolio elements and portfolio archive pages.', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array(
					'full-excerpt' => 'Full Excerpt',
					'custom-excerpt'      => 'Excerpt Custom Length',
					'full-content' => 'Full Content',
				),
				'default'  => 'full-excerpt',
			),
			array(
				'id'            => 'portfolio-layout-settings-excerpt-length',
				'type'          => 'slider',
				'title'         => esc_html__( 'Excerpt Length', 'charitab-wp' ),
				'subtitle'      => esc_html__( 'Number of words to display in excerpt for each portfolio item.', 'charitab-wp' ),
				'desc'          => '',
				'default'       => 20,
				'min'           => 0,
				'step'          => 1,
				'max'           => 300,
				'display_value' => 'text',
				'required' => array( 'portfolio-layout-settings-display-content-type', '=', 'custom-excerpt' ),
			),
			array(
				'id'       => 'portfolio-layout-settings-portfolio-showhide-options',
				'type'     => 'checkbox',
				'title'    => esc_html__( 'Portfolio Show/Hide Options', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enable/Disabling this option will show/hide each portfolio option on your page.', 'charitab-wp' ),
				'desc'     => '',
				//Must provide key => value pairs for multi checkbox options
				'options'	=> array(
					'show-portfolio-title'          => esc_html__( 'Show Title', 'charitab-wp' ),
					'show-portfolio-content'        => esc_html__( 'Show Content/Excerpt', 'charitab-wp' ),
					'show-portfolio-category'       => esc_html__( 'Show Category', 'charitab-wp' ),
					'show-portfolio-tag'            => esc_html__( 'Show Tag', 'charitab-wp' ),
					'show-portfolio-date'           => esc_html__( 'Show Date', 'charitab-wp' ),
					'show-portfolio-comments-count' => esc_html__( 'Show Comments Count', 'charitab-wp' ),
					'show-portfolio-like-button'    => esc_html__( 'Show Like Button', 'charitab-wp' ),
				),
				//See how std has changed? you also don't need to specify opts that are 0.
				'default'  => array(
					'show-portfolio-title' => '1',
					'show-portfolio-content' => '0',
					'show-portfolio-category' => '1',
					'show-portfolio-tag' => '0',
					'show-portfolio-date' => '0',
					'show-portfolio-comments-count' => '0',
					'show-portfolio-like-button' => '1',
				)
			),





			
			array(
				'id'       => 'portfolio-layout-settings-portfolio-pagination-settings',
				'type'      => 'info',
				'title'     => esc_html__( 'Pagination Settings', 'charitab-wp' ),
				'notice'    => false,
			),
			array(
				'id'       => 'portfolio-layout-settings-pagination-type',
				'type'     => 'button_set',
				'title'    => esc_html__( 'Pagination Type', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Controls the pagination type for portfolio elements and portfolio archive pages.', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array(
					'normal-pagination' => 'Normal Pagination',
					'infinite-scroll' => 'Infinite Scroll',
					'load-more-button' => 'Load More Button',
				),
				'default'  => 'normal-pagination',
			),
			array(
				'id'       => 'portfolio-layout-settings-text-align',
				'type'     => 'button_set',
				'title'    => esc_html__( 'Pagination Text Alignment', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> charitab_mascot_redux_text_alignment_list(),
				'default'  => 'text-left',
			),



		)
	) );



	// -> START Portfolio Single Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Portfolio Single', 'charitab-wp' ),
		'id'     => 'portfolio-single-page-settings',
		'subsection'       => true,
		'desc'   => '',
		'fields' => array(
			array(
				'id'       => 'portfolio-single-page-settings-fullwidth',
				'type'     => 'switch',
				'title'    => esc_html__( 'Fullwidth?', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Make the page fullwidth or not.', 'charitab-wp' ),
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
			),
			array(
				'id'       => 'portfolio-single-page-settings-sidebar-layout',
				'type'     => 'select',
				'title'    => esc_html__( 'Sidebar Layout', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Choose a sidebar layout for portfolio details pages', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array(
					'no-sidebar'            => esc_html__( 'No Sidebar', 'charitab-wp' ),
					'both-sidebar-25-50-25' => esc_html__( 'Sidebar Both Side (1/4 + 2/4 + 1/4)', 'charitab-wp' ),
					'sidebar-right-25'      => esc_html__( 'Sidebar Right 1/4', 'charitab-wp' ),
					'sidebar-right-33'      => esc_html__( 'Sidebar Right 1/3', 'charitab-wp' ),
					'sidebar-left-25'       => esc_html__( 'Sidebar Left 1/4', 'charitab-wp' ),
					'sidebar-left-33'       => esc_html__( 'Sidebar Left 1/3', 'charitab-wp' ),
				),
				'default'  => 'no-sidebar',
			),



			array(
				'id'       => 'portfolio-single-page-settings-sidebar-layout-sidebar-default',
				'type'     => 'select',
				'title'    => esc_html__( 'Default Sidebar', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Choose default sidebar that will be displayed on portfolio single pages.', 'charitab-wp' ),
				'desc'     => '',
				'data'     => 'sidebars',
				'default'  => 'page-sidebar',
				'required' => array( 'portfolio-single-page-settings-sidebar-layout', '!=', 'no-sidebar' ),
			),
			array(
				'id'       => 'portfolio-single-page-settings-sidebar-layout-sidebar-two',
				'type'     => 'select',
				'title'    => esc_html__( 'Sidebar 2', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Choose sidebar 2 that will be displayed on portfolio single pages. Sidebar 2 will only be used if "Sidebar Both Side" is selected.', 'charitab-wp' ),
				'desc'     => '',
				'data'     => 'sidebars',
				'default'  => 'page-sidebar-two',
				'required' => array( 'portfolio-single-page-settings-sidebar-layout', '=', 'both-sidebar-25-50-25' ),
			),
			array(
				'id'       => 'portfolio-single-page-settings-sidebar-layout-sidebar-two-position',
				'type'     => 'button_set',
				'compiler' =>true,
				'title'    => esc_html__( 'Sidebar 2 - Position', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Controls the position of sidebar 2. In that case, default sidebar will be shown on opposite side.', 'charitab-wp' ),
				'options'	=> array(
					'left'      => esc_html__( 'Left', 'charitab-wp' ),
					'right'     => esc_html__( 'Right', 'charitab-wp' )
				),
				'default'  => 'right',
				'required' => array( 'portfolio-single-page-settings-sidebar-layout', '=', 'both-sidebar-25-50-25' ),
			),


			array(
				'id'       => 'portfolio-single-page-settings-select-portfolio-details-type',
				'type'     => 'image_select',
				'title'    => esc_html__( 'Portfolio Details Type', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Select the type of portfolio details you would like to display.', 'charitab-wp' ),
				'desc'     => '',
				//Must provide key => value(array:title|img) pairs for radio options
				'options'	=> array(
					'small-image' => array(
						'alt' => esc_html__( 'Small Image', 'charitab-wp' ),
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/portfolio-single/type/small-image.png'
					),
					'small-image-slider' => array(
						'alt' => esc_html__( 'Small Image Slider', 'charitab-wp' ),
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/portfolio-single/type/small-image-slider.png'
					),
					'big-image' => array(
						'alt' => esc_html__( 'Big Image', 'charitab-wp' ),
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/portfolio-single/type/big-image.png'
					),
					'big-image-slider' => array(
						'alt' => esc_html__( 'Big Image Slider', 'charitab-wp' ),
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/portfolio-single/type/big-image-slider.png'
					),
					'small-image-gallery' => array(
						'alt' => esc_html__( 'Small Image Gallery', 'charitab-wp' ),
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/portfolio-single/type/small-image-gallery.png'
					),
					'big-image-gallery' => array(
						'alt' => esc_html__( 'Big Image Gallery', 'charitab-wp' ),
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/portfolio-single/type/big-image-gallery.png'
					),
				),
				'default'  => 'small-image'
			),


			//Small Image
			array(
				'id'        => 'portfolio-single-page-settings-portfolio-type-small-image-settings',
				'type'      => 'info',
				'title'     => esc_html__( 'Small Image Settings', 'charitab-wp' ),
				'notice'    => false,
				'required' => array( 'portfolio-single-page-settings-select-portfolio-details-type', '=', 'small-image' ),
			),
			array(
				'id'        => 'portfolio-single-page-settings-portfolio-type-small-image-description-alignment',
				'type'     => 'button_set',
				'compiler' =>true,
				'title'    => esc_html__( 'Item Description Alignment', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Choose alignment of item description.', 'charitab-wp' ),
				'options'	=> array(
					'left'   => esc_html__( 'Left', 'charitab-wp' ),
					'right'  => esc_html__( 'Right', 'charitab-wp' )
				),
				'default' => 'left',
				'required' => array( 
					array( 'portfolio-single-page-settings-select-portfolio-details-type', '=', 'small-image' )
				)
			),
			array(
				'id'        => 'portfolio-single-page-settings-portfolio-type-small-image-description-width',
				'type'     => 'button_set',
				'compiler' =>true,
				'title'    => esc_html__( 'Item Description Width', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Choose width of item description.', 'charitab-wp' ),
				'options'	=> array(
					'6'     => esc_html__( 'Half (1/2)', 'charitab-wp' ),
					'4'     => esc_html__( 'One Third (1/3)', 'charitab-wp' ),
					'3'     => esc_html__( 'One Fourth (1/4)', 'charitab-wp' )
				),
				'default' => '6',
				'required' => array( 
					array( 'portfolio-single-page-settings-select-portfolio-details-type', '=', 'small-image' )
				)
			),
			array(
				'id'        => 'portfolio-single-page-settings-portfolio-type-small-image-description-sticky',
				'type'     => 'switch',
				'title'    => esc_html__( 'Make Description Sticky', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Make description container sticky when scrolling down the page.', 'charitab-wp' ),
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
				'required' => array( 
					array( 'portfolio-single-page-settings-select-portfolio-details-type', '=', 'small-image' )
				)
			),




			//Small Image Slider
			array(
				'id'        => 'portfolio-single-page-settings-portfolio-type-small-image-slider-settings',
				'type'      => 'info',
				'title'     => esc_html__( 'Small Image Slider Settings', 'charitab-wp' ),
				'notice'    => false,
				'required' => array( 'portfolio-single-page-settings-select-portfolio-details-type', '=', 'small-image-slider' ),
			),
			array(
				'id'        => 'portfolio-single-page-settings-portfolio-type-small-image-slider-description-alignment',
				'type'     => 'button_set',
				'compiler' =>true,
				'title'    => esc_html__( 'Item Description Alignment', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Choose alignment of item description.', 'charitab-wp' ),
				'options'	=> array(
					'left'   => esc_html__( 'Left', 'charitab-wp' ),
					'right'  => esc_html__( 'Right', 'charitab-wp' )
				),
				'default' => 'left',
				'required' => array( 
					array( 'portfolio-single-page-settings-select-portfolio-details-type', '=', 'small-image-slider' )
				)
			),
			array(
				'id'        => 'portfolio-single-page-settings-portfolio-type-small-image-slider-description-width',
				'type'     => 'button_set',
				'compiler' =>true,
				'title'    => esc_html__( 'Item Description Width', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Choose width of item description.', 'charitab-wp' ),
				'options'	=> array(
					'6'     => esc_html__( 'Half (1/2)', 'charitab-wp' ),
					'4'     => esc_html__( 'One Third (1/3)', 'charitab-wp' ),
					'3'     => esc_html__( 'One Fourth (1/4)', 'charitab-wp' )
				),
				'default' => '6',
				'required' => array( 
					array( 'portfolio-single-page-settings-select-portfolio-details-type', '=', 'small-image-slider' )
				)
			),
			array(
				'id'        => 'portfolio-single-page-settings-portfolio-type-small-image-slider-description-sticky',
				'type'     => 'switch',
				'title'    => esc_html__( 'Make Description Sticky', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Make description container sticky when scrolling down the page.', 'charitab-wp' ),
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
				'required' => array( 
					array( 'portfolio-single-page-settings-select-portfolio-details-type', '=', 'small-image-slider' )
				)
			),




			//Small Image Gallery
			array(
				'id'        => 'portfolio-single-page-settings-portfolio-type-small-image-gallery-settings',
				'type'      => 'info',
				'title'     => esc_html__( 'Small Image Gallery Settings', 'charitab-wp' ),
				'notice'    => false,
				'required' => array( 'portfolio-single-page-settings-select-portfolio-details-type', '=', 'small-image-gallery' ),
			),
			array(
				'id'        => 'portfolio-single-page-settings-portfolio-type-small-image-gallery-description-alignment',
				'type'     => 'button_set',
				'compiler' =>true,
				'title'    => esc_html__( 'Item Description Alignment', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Choose alignment of item description.', 'charitab-wp' ),
				'options'	=> array(
					'left'   => esc_html__( 'Left', 'charitab-wp' ),
					'right'  => esc_html__( 'Right', 'charitab-wp' )
				),
				'default' => 'left',
				'required' => array( 
					array( 'portfolio-single-page-settings-select-portfolio-details-type', '=', 'small-image-gallery' )
				)
			),
			array(
				'id'        => 'portfolio-single-page-settings-portfolio-type-small-image-gallery-description-width',
				'type'     => 'button_set',
				'compiler' =>true,
				'title'    => esc_html__( 'Item Description Width', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Choose width of item description.', 'charitab-wp' ),
				'options'	=> array(
					'6'     => esc_html__( 'Half (1/2)', 'charitab-wp' ),
					'4'     => esc_html__( 'One Third (1/3)', 'charitab-wp' ),
					'3'     => esc_html__( 'One Fourth (1/4)', 'charitab-wp' )
				),
				'default' => '6',
				'required' => array( 
					array( 'portfolio-single-page-settings-select-portfolio-details-type', '=', 'small-image-gallery' )
				)
			),
			array(
				'id'        => 'portfolio-single-page-settings-portfolio-type-small-image-gallery-description-sticky',
				'type'     => 'switch',
				'title'    => esc_html__( 'Make Description Sticky', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Make description container sticky when scrolling down the page.', 'charitab-wp' ),
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
				'required' => array( 
					array( 'portfolio-single-page-settings-select-portfolio-details-type', '=', 'small-image-gallery' )
				)
			),
			array(
				'id'       => 'portfolio-single-page-settings-portfolio-type-small-image-gallery-layout-mode',
				'type'     => 'image_select',
				'title'    => esc_html__( 'Gallery Layout Mode (FitRows Or Masonry)', 'charitab-wp' ),
				'subtitle' => esc_html__( 'You can position items with different layout modes. Select a layout mode you would like to use.', 'charitab-wp' ),
				'desc'     => '',
				//Must provide key => value(array:title|img) pairs for radio options
				'options'	=> array(
					'fitrows' => array(
						'alt' => 'Fit Rows',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/portfolio/layout-mode/fitrows.png'
					),
					'masonry' => array(
						'alt' => 'Masonry',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/portfolio/layout-mode/masonry.png'
					),
				),
				'default'  => 'masonry',
				'required' => array( 
					array( 'portfolio-single-page-settings-select-portfolio-details-type', '=', 'small-image-gallery' )
				)
			),
			array(
				'id'        => 'portfolio-single-page-settings-portfolio-type-small-image-isotope-items-per-row',
				'type'     => 'select',
				'title'    => esc_html__( 'Number of Images Per Row', 'charitab-wp' ),
				'subtitle'    => esc_html__( 'Select your default column structure for your gallery items.', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array(
					'1'  => '1 Item Per Row',
					'2'  => '2 Items Per Row',
					'3'  => '3 Items Per Row',
					'4'  => '4 Items Per Row',
					'5'  => '5 Items Per Row',
					'6'  => '6 Items Per Row',
					'7'  => '7 Items Per Row',
					'8'  => '8 Items Per Row',
					'9'  => '9 Items Per Row',
					'10' => '10 Items Per Row',
				),
				'default'  => '3',
				'required' => array( 
					array( 'portfolio-single-page-settings-select-portfolio-details-type', '=', 'small-image-gallery' )
				)
			),




			//Small Image Gallery
			array(
				'id'        => 'portfolio-single-page-settings-portfolio-type-big-image-gallery-settings',
				'type'      => 'info',
				'title'     => esc_html__( 'Big Image Gallery Settings', 'charitab-wp' ),
				'notice'    => false,
				'required' => array( 'portfolio-single-page-settings-select-portfolio-details-type', '=', 'big-image-gallery' ),
			),
			array(
				'id'       => 'portfolio-single-page-settings-portfolio-type-big-image-gallery-layout-mode',
				'type'     => 'image_select',
				'title'    => esc_html__( 'Gallery Layout Mode (FitRows Or Masonry)', 'charitab-wp' ),
				'subtitle' => esc_html__( 'You can position items with different layout modes. Select a layout mode you would like to use.', 'charitab-wp' ),
				'desc'     => '',
				//Must provide key => value(array:title|img) pairs for radio options
				'options'	=> array(
					'fitrows' => array(
						'alt' => 'Fit Rows',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/portfolio/layout-mode/fitrows.png'
					),
					'masonry' => array(
						'alt' => 'Masonry',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/portfolio/layout-mode/masonry.png'
					),
				),
				'default'  => 'masonry',
				'required' => array( 
					array( 'portfolio-single-page-settings-select-portfolio-details-type', '=', 'big-image-gallery' )
				)
			),
			array(
				'id'        => 'portfolio-single-page-settings-portfolio-type-big-image-isotope-items-per-row',
				'type'     => 'select',
				'title'    => esc_html__( 'Number of Images Per Row', 'charitab-wp' ),
				'subtitle'    => esc_html__( 'Select your default column structure for your gallery items.', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array(
					'1'  => '1 Item Per Row',
					'2'  => '2 Items Per Row',
					'3'  => '3 Items Per Row',
					'4'  => '4 Items Per Row',
					'5'  => '5 Items Per Row',
					'6'  => '6 Items Per Row',
					'7'  => '7 Items Per Row',
					'8'  => '8 Items Per Row',
					'9'  => '9 Items Per Row',
					'10' => '10 Items Per Row',
				),
				'default'  => '3',
				'required' => array( 
					array( 'portfolio-single-page-settings-select-portfolio-details-type', '=', 'big-image-gallery' )
				)
			),






			array(
				'id'        => 'portfolio-single-page-settings-other-settings',
				'type'      => 'info',
				'title'     => esc_html__( 'Other Settings', 'charitab-wp' ),
				'notice'    => false,
			),
			array(
				'id'       => 'portfolio-single-page-settings-portfolio-meta',
				'type'     => 'checkbox',
				'title'    => esc_html__( 'Portfolio Meta', 'charitab-wp' ),
				'subtitle'     => esc_html__( 'Enable/Disabling this option will show/hide each Portfolio Meta on your Portfolio Details Page.', 'charitab-wp' ),
				'desc' => '',
				//Must provide key => value pairs for multi checkbox options
				'options'	=> array(
					'show-post-by-author'       => esc_html__( 'Show By Author', 'charitab-wp' ),
					'show-post-date'            => esc_html__( 'Show Date', 'charitab-wp' ),
					'show-post-category'        => esc_html__( 'Show Category', 'charitab-wp' ),
					'show-post-tag'             => esc_html__( 'Show Tag', 'charitab-wp' ),
					'show-post-checklist-custom-fields'   => esc_html__( 'Show Checklist Custom Fields', 'charitab-wp' ),
				),
				//See how std has changed? you also don't need to specify opts that are 0.
				'default'  => array(
					'show-post-by-author' => '0',
					'show-post-date' => '1',
					'show-post-category' => '1',
					'show-post-tag' => '1',
					'show-post-checklist-custom-fields' => '1',
				)
			),
			array(
				'id'       => 'portfolio-single-page-settings-show-share',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Social Share', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enable/Disabling this option will show/hide share options on your page.', 'charitab-wp' ),
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
			),


			//section Next/Previous Navigation Link Starts
			array(
				'id'       => 'portfolio-single-page-settings-show-next-pre-post-link-section-starts',
				'type'     => 'info',
				'title'    => esc_html__( 'Next/Previous Navigation Link', 'charitab-wp' ),
				'notice'   => false,
			),
			array(
				'id'       => 'portfolio-single-page-settings-show-next-pre-post-link',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Next/Previous Single Post Navigation Link', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enable/Disabling this option will show/hide link for Next & Previous Posts.', 'charitab-wp' ),
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
			),
			array(
				'id'       => 'portfolio-single-page-settings-show-next-pre-post-link-within-same-cat',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Navigation Link Within Same Category', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enable/Disabling this option will show/hide link to the next/previous post within the same category as the current post.', 'charitab-wp' ),
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
				'required' => array( 'portfolio-single-page-settings-show-next-pre-post-link', '=', '1' ),
			),




			//section Related Posts Starts
			array(
				'id'       => 'portfolio-single-page-settings-related-posts-section-starts',
				'type'     => 'info',
				'title'    => esc_html__( 'Related Posts', 'charitab-wp' ),
				'notice'   => false,
			),
			array(
				'id'       => 'portfolio-single-page-settings-show-related-posts',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Related Portfolio Items', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enable/Disabling this option will show/hide Related Posts List/Carousel on your page.', 'charitab-wp' ),
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
			),
			array(
				'id'       => 'portfolio-single-page-settings-show-related-posts-carousel',
				'type'     => 'switch',
				'title'    => esc_html__( 'Carousel?', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Make it carousel or grid', 'charitab-wp' ),
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
				'required' => array( 'portfolio-single-page-settings-show-related-posts', '=', '1' ),
			),
			array(
				'id'       => 'portfolio-single-page-settings-show-related-posts-count',
				'type'     => 'text',
				'title'    => esc_html__( 'Number of Posts', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => esc_html__( 'Enter number of posts to display. Default 3', 'charitab-wp' ),
				'default'  => '3',
				'required' => array( 'portfolio-single-page-settings-show-related-posts', '=', '1' ),
			),
			array(
				'id'            => 'portfolio-single-page-settings-show-related-posts-excerpt-length',
				'type'          => 'slider',
				'title'         => esc_html__( 'Excerpt Length', 'charitab-wp' ),
				'subtitle'      => esc_html__( 'Number of words to display in excerpt.', 'charitab-wp' ),
				'desc'          => '',
				'default'       => 20,
				'min'           => 0,
				'step'          => 1,
				'max'           => 200,
				'display_value' => 'text',
				'required' => array( 'portfolio-single-page-settings-show-related-posts', '=', '1' ),
			),



			//section Related Posts Starts
			array(
				'id'       => 'portfolio-single-page-settings-comments-section-starts',
				'type'     => 'info',
				'title'    => esc_html__( 'Comments', 'charitab-wp' ),
				'notice'   => false,
			),
			array(
				'id'       => 'portfolio-single-page-settings-show-comments',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Comments', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enable/Disabling this option will show/hide Comments on your page.', 'charitab-wp' ),
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
			),

		)
	) );*/





	// -> START Page Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Flaticon & Font Icon Packs', 'charitab-wp' ),
		'id'     => 'font-flat-icons-settings',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-star-empty',
		'fields' => array(
			array(
				'id'       => 'page-settings-use-icomoon',
				'type'     => 'switch',
				'title'    => esc_html__( 'Use Icomoon Icon Pack', 'charitab-wp' ),
				'subtitle'  => sprintf( esc_html__('If you enable this option then this icon pack will become availalbe to use throughout the site. Live example %shere%s', 'charitab-wp'), '<a target="_blank" href="' . esc_url( 'https://icomoon.io/preview-free.html' ) . '">', '</a>' ),
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
			),
			array(
				'id'       => 'page-settings-use-elegant-icons',
				'type'     => 'switch',
				'title'    => esc_html__( 'Use Elegant Icon Pack', 'charitab-wp' ),
				'subtitle'  => sprintf( esc_html__('If you enable this option then this icon pack will become availalbe to use throughout the site. Live example %shere%s', 'charitab-wp'), '<a target="_blank" href="' . esc_url( 'https://www.elegantthemes.com/blog/resources/elegant-icon-font' ) . '">', '</a>' ),
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
			),
			array(
				'id'       => 'page-settings-use-pe-icon-7-stroke',
				'type'     => 'switch',
				'title'    => esc_html__( 'Use 7 Stroke Icon Pack', 'charitab-wp' ),
				'subtitle'  => sprintf( esc_html__('If you enable this option then this icon pack will become availalbe to use throughout the site. Live example %shere%s', 'charitab-wp'), '<a target="_blank" href="' . esc_url( 'http://themes-pixeden.com/font-demos/7-stroke/' ) . '">', '</a>' ),
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
			),
			array(
				'id'       => 'page-settings-use-ion-icons',
				'type'     => 'switch',
				'title'    => esc_html__( 'Use ion Icon Pack', 'charitab-wp' ),
				'subtitle'  => sprintf( esc_html__('If you enable this option then this icon pack will become availalbe to use throughout the site. Live example %shere%s', 'charitab-wp'), '<a target="_blank" href="' . esc_url( 'http://ionicons.com/' ) . '">', '</a>' ),
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
			),
			array(
				'id'       => 'page-settings-use-simple-line',
				'type'     => 'switch',
				'title'    => esc_html__( 'Use Simple Line Icon Fonts', 'charitab-wp' ),
				'subtitle'  => sprintf( esc_html__('If you enable this option then this icon pack will become availalbe to use throughout the site. Live example %shere%s', 'charitab-wp'), '<a target="_blank" href="' . esc_url( 'http://simplelineicons.com/' ) . '">', '</a>' ),
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
			),
			array(
				'id'       => 'page-settings-use-flaticon-current-theme',
				'type'     => 'switch',
				'title'    => esc_html__( 'Use Flaticon Pack (For Current Theme)', 'charitab-wp' ),
				'subtitle'  => esc_html__('If you enable this option then this icon pack will become availalbe to use throughout the site.', 'charitab-wp'),
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
			),
		)
	) );



	/* Check for Charitable */
	if ( class_exists( 'Charitable' ) ) {
	// -> START Charitable Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Charitable - Donation', 'charitab-wp' ),
		'id'     => 'charitable-donation-settings',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-heart',
		'fields' => array(
			array(
				'id'       => 'charitable-donation-settings-sidebar-layout',
				'type'     => 'select',
				'title'    => esc_html__( 'Campaign Page Sidebar Layout', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Choose a sidebar layout for Campaign Page', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array(
					'no-sidebar'            => esc_html__( 'No Sidebar', 'charitab-wp' ),
					'sidebar-right-25'      => esc_html__( 'Sidebar Right 1/4', 'charitab-wp' ),
					'sidebar-right-33'      => esc_html__( 'Sidebar Right 1/3', 'charitab-wp' ),
					'sidebar-left-25'       => esc_html__( 'Sidebar Left 1/4', 'charitab-wp' ),
					'sidebar-left-33'       => esc_html__( 'Sidebar Left 1/3', 'charitab-wp' ),

				),
				'default'  => 'sidebar-right-25',
			),
			array(
				'id'       => 'charitable-donation-settings-sidebar-layout-sidebar-default',
				'type'     => 'select',
				'title'    => esc_html__( 'Campaign Page Default Sidebar', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Choose default sidebar that will be displayed on Campaign Page.', 'charitab-wp' ),
				'desc'     => '',
				'data'     => 'sidebars',
				'default'  => 'charitable-campaign-sidebar',
				'required' => array( 'charitable-donation-settings-sidebar-layout', '!=', 'no-sidebar' ),
			),
			array(
				'id'       => 'charitable-donation-settings-donate-button-text',
				'type'     => 'text',
				'title'    => esc_html__( 'Donate Buttom Text', 'charitab-wp' ),
				'default'  => 'Donate Now',
			),
			array(
				'id'       => 'charitable-donation-settings-donate-button-text-expired',
				'type'     => 'text',
				'title'    => esc_html__( 'Donate Buttom Text Expired', 'charitab-wp' ),
				'default'  => 'Details',
			),



			array(
				'id'       => 'charitable-donation-settings-related-posts-section-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Other Settings', 'charitab-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
			),
			array(
				'id'       => 'charitable-donation-settings-campaign-creation-date',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Campaign Creation Date', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Toggle the campaign creation date on or off.', 'charitab-wp' ),
				'default'  => 1,
			),
			array(
				'id'       => 'charitable-donation-settings-campaign-donation-count',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Campaign Donation Count', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Toggle the campaign donation count on or off.', 'charitab-wp' ),
				'default'  => 1,
			),
			array(
				'id'       => 'charitable-donation-settings-campaign-location',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Campaign Location', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Toggle the campaign location on or off.', 'charitab-wp' ),
				'default'  => 1,
			),
			array(
				'id'       => 'charitable-donation-settings-campaign-categories',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Campaign Categories', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Toggle the campaign categories on or off.', 'charitab-wp' ),
				'default'  => 0,
			),
			array(
				'id'       => 'charitable-donation-settings-campaign-tags',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Campaign Tags', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Toggle the campaign tags on or off.', 'charitab-wp' ),
				'default'  => 0,
			),
			array(
				'id'       => 'charitable-donation-settings-campaign-progress-bar',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Campaign Progress Bar', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Toggle the campaign campaign progress bar on or off.', 'charitab-wp' ),
				'default'  => 1,
			),
			array(
				'id'       => 'charitable-donation-settings-campaign-raised-goal',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Campaign Raised/Goal', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Toggle the campaign raised goal on or off.', 'charitab-wp' ),
				'default'  => 1,
			),
		)
	) );
	}



	/* Check for Give */
	if ( class_exists( 'Give' ) ) {
	// -> START Give Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Give - Donation', 'charitab-wp' ),
		'id'     => 'give-donation-settings',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-heart',
		'fields' => array(
			array(
				'id'       => 'give-donation-settings-sidebar-layout',
				'type'     => 'select',
				'title'    => esc_html__( 'Give Donation Page Sidebar Layout', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Choose a sidebar layout for Donation Page', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array(
					'no-sidebar'            => esc_html__( 'No Sidebar', 'charitab-wp' ),
					'sidebar-right-25'      => esc_html__( 'Sidebar Right 1/4', 'charitab-wp' ),
					'sidebar-right-33'      => esc_html__( 'Sidebar Right 1/3', 'charitab-wp' ),
					'sidebar-left-25'       => esc_html__( 'Sidebar Left 1/4', 'charitab-wp' ),
					'sidebar-left-33'       => esc_html__( 'Sidebar Left 1/3', 'charitab-wp' ),

				),
				'default'  => 'sidebar-right-25',
			),
			array(
				'id'       => 'give-donation-settings-sidebar-layout-sidebar-default',
				'type'     => 'select',
				'title'    => esc_html__( 'Donation Page Default Sidebar', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Choose default sidebar that will be displayed on Donation Page.', 'charitab-wp' ),
				'desc'     => '',
				'data'     => 'sidebars',
				'default'  => 'give-forms-sidebar',
				'required' => array( 'give-donation-settings-sidebar-layout', '!=', 'no-sidebar' ),
			),



			array(
				'id'       => 'give-donation-settings-related-posts-section-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Other Settings', 'charitab-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
			),
			array(
				'id'       => 'give-donation-settings-campaign-creation-date',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Donation Creation Date', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Toggle the campaign creation date on or off.', 'charitab-wp' ),
				'default'  => 1,
			),
			array(
				'id'       => 'give-donation-settings-campaign-creator',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Campaign Creator', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Toggle the campaign donation count on or off.', 'charitab-wp' ),
				'default'  => 1,
			),
			array(
				'id'       => 'give-donation-settings-campaign-categories',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Donation Categories', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Toggle the campaign categories on or off.', 'charitab-wp' ),
				'default'  => 0,
			),
			array(
				'id'       => 'give-donation-settings-campaign-tags',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Donation Tags', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Toggle the campaign tags on or off.', 'charitab-wp' ),
				'default'  => 0,
			),
			array(
				'id'       => 'give-donation-settings-campaign-progress-bar',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Donation Progress Bar', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Toggle the campaign campaign progress bar on or off.', 'charitab-wp' ),
				'default'  => 1,
			),
			array(
				'id'       => 'give-donation-settings-campaign-raised-goal',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Donation Stats', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Toggle the campaign raised goal on or off.', 'charitab-wp' ),
				'default'  => 1,
			),
		)
	) );
	}






	// -> START Custom Post Types Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Custom Post Types', 'charitab-wp' ),
		'id'     => 'cpt-settings-parent',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-carrot',
	) );



	// -> START Custom Post Types Clients Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'CPT - Clients', 'charitab-wp' ),
		'id'     => 'cpt-settings-clients',
		'subsection'       => true,
		'desc'   => '',
		'fields' => array(
			array(
				'id'       => 'cpt-settings-clients-enable',
				'type'     => 'switch',
				'title'    => esc_html__( 'Clients Post Type', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Toggle the clients custom post type on or off.', 'charitab-wp' ),
				'default'  => 1,
			),
			array(
				'id'       => 'cpt-settings-clients-label',
				'type'     => 'text',
				'title'    => esc_html__( 'Clients Label', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Rename the Custom Post Type. ', 'charitab-wp' ),
				'default'  => 'Clients',
				'required' => array( 'cpt-settings-clients-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-clients-admin-dashicon',
				'type'     => 'select',
				'title'    => esc_html__( 'Clients Admin Dashboard Icon', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'options'	=> charitab_mascot_wp_admin_dashicons_list(),
				'default'  => 'dashicons-mascot',
				'required' => array( 'cpt-settings-clients-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-clients-slug',
				'type'     => 'text',
				'title'    => esc_html__( 'Courses Slug', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Specify a custom slug for Courses Post Type. ', 'charitab-wp' ),
				'desc'     => sprintf( esc_html__( '%1$sNOTE: When you change this setting you need to flush rewrite rules.%2$s %3$s%4$sTo do so, goto Settings > Permalinks and simply click on "Save Changes" button.%2$s', 'charitab-wp' ), '<strong style="color: #777;">', '</strong>', '<br>', '<strong style="color: #999;">'),
				'default'  => 'clients',
				'required' => array( 'cpt-settings-clients-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-clients-cat-slug',
				'type'     => 'text',
				'title'    => esc_html__( 'Courses Category Slug', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Specify a custom slug for the Category of Courses Post Type. ', 'charitab-wp' ),
				'desc'     => sprintf( esc_html__( '%1$sNOTE: When you change this setting you need to flush rewrite rules.%2$s %3$s%4$sTo do so, goto Settings > Permalinks and simply click on "Save Changes" button.%2$s', 'charitab-wp' ), '<strong style="color: #777;">', '</strong>', '<br>', '<strong style="color: #999;">'),
				'default'  => 'clients-category',
				'required' => array( 'cpt-settings-clients-enable', '=', '1' ),
			),
		)
	) );


	// -> START Custom Post Types Courses Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'CPT - Courses', 'charitab-wp' ),
		'id'     => 'cpt-settings-courses',
		'subsection'       => true,
		'desc'   => '',
		'fields' => array(
			array(
				'id'       => 'cpt-settings-courses-enable',
				'type'     => 'switch',
				'title'    => esc_html__( 'Courses Post Type', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Toggle the courses custom post type on or off.', 'charitab-wp' ),
				'default'  => 1,
			),
			array(
				'id'       => 'cpt-settings-courses-label',
				'type'     => 'text',
				'title'    => esc_html__( 'Courses Label', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Rename the Custom Post Type. ', 'charitab-wp' ),
				'default'  => 'Courses',
				'required' => array( 'cpt-settings-courses-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-courses-admin-dashicon',
				'type'     => 'select',
				'title'    => esc_html__( 'Courses Admin Dashboard Icon', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'options'	=> charitab_mascot_wp_admin_dashicons_list(),
				'default'   => 'dashicons-mascot',
				'required' => array( 'cpt-settings-courses-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-courses-slug',
				'type'     => 'text',
				'title'    => esc_html__( 'Courses Slug', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Specify a custom slug for Courses Post Type. ', 'charitab-wp' ),
				'desc'     => sprintf( esc_html__( '%1$sNOTE: When you change this setting you need to flush rewrite rules.%2$s %3$s%4$sTo do so, goto Settings > Permalinks and simply click on "Save Changes" button.%2$s', 'charitab-wp' ), '<strong style="color: #777;">', '</strong>', '<br>', '<strong style="color: #999;">'),
				'default'  => 'courses',
				'required' => array( 'cpt-settings-courses-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-courses-cat-slug',
				'type'     => 'text',
				'title'    => esc_html__( 'Courses Category Slug', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Specify a custom slug for the Category of Courses Post Type. ', 'charitab-wp' ),
				'desc'     => sprintf( esc_html__( '%1$sNOTE: When you change this setting you need to flush rewrite rules.%2$s %3$s%4$sTo do so, goto Settings > Permalinks and simply click on "Save Changes" button.%2$s', 'charitab-wp' ), '<strong style="color: #777;">', '</strong>', '<br>', '<strong style="color: #999;">'),
				'default'  => 'courses-category',
				'required' => array( 'cpt-settings-courses-enable', '=', '1' ),
			),
		)
	) );


	// -> START Custom Post Types FAQ Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'CPT - FAQ', 'charitab-wp' ),
		'id'     => 'cpt-settings-faq',
		'subsection'       => true,
		'desc'   => '',
		'fields' => array(
			array(
				'id'       => 'cpt-settings-faq-enable',
				'type'     => 'switch',
				'title'    => esc_html__( 'FAQ Post Type', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Toggle the faq custom post type on or off.', 'charitab-wp' ),
				'default'  => 1,
			),
			array(
				'id'       => 'cpt-settings-faq-label',
				'type'     => 'text',
				'title'    => esc_html__( 'FAQ Label', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Rename the Custom Post Type. ', 'charitab-wp' ),
				'default'  => 'FAQ',
				'required' => array( 'cpt-settings-faq-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-faq-admin-dashicon',
				'type'     => 'select',
				'title'    => esc_html__( 'FAQ Admin Dashboard Icon', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'options'	=> charitab_mascot_wp_admin_dashicons_list(),
				'default'   => 'dashicons-mascot',
				'required' => array( 'cpt-settings-faq-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-faq-slug',
				'type'     => 'text',
				'title'    => esc_html__( 'Courses Slug', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Specify a custom slug for Courses Post Type. ', 'charitab-wp' ),
				'desc'     => sprintf( esc_html__( '%1$sNOTE: When you change this setting you need to flush rewrite rules.%2$s %3$s%4$sTo do so, goto Settings > Permalinks and simply click on "Save Changes" button.%2$s', 'charitab-wp' ), '<strong style="color: #777;">', '</strong>', '<br>', '<strong style="color: #999;">'),
				'default'  => 'faq',
				'required' => array( 'cpt-settings-faq-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-faq-cat-slug',
				'type'     => 'text',
				'title'    => esc_html__( 'Courses Category Slug', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Specify a custom slug for the Category of Courses Post Type. ', 'charitab-wp' ),
				'desc'     => sprintf( esc_html__( '%1$sNOTE: When you change this setting you need to flush rewrite rules.%2$s %3$s%4$sTo do so, goto Settings > Permalinks and simply click on "Save Changes" button.%2$s', 'charitab-wp' ), '<strong style="color: #777;">', '</strong>', '<br>', '<strong style="color: #999;">'),
				'default'  => 'faq-category',
				'required' => array( 'cpt-settings-faq-enable', '=', '1' ),
			),




			//section Related Posts Starts
			array(
				'id'       => 'cpt-settings-faq-related-posts-section-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Related Posts', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enable/Disabling this option will show/hide Related Posts List/Carousel on your page. The full settings will be found at "Blog > Single Post" Theme Options', 'charitab-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
			),
			array(
				'id'       => 'cpt-settings-faq-show-related-posts',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Related Posts', 'charitab-wp' ),
				'subtitle' => '',
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
			),
			array(
				'id'       => 'cpt-settings-faq-show-related-posts-count',
				'type'     => 'text',
				'title'    => esc_html__( 'Number of Posts', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => esc_html__( 'Enter number of posts to display. Default 3', 'charitab-wp' ),
				'default'  => '3',
				'required' => array( 'cpt-settings-faq-show-related-posts', '=', '1' ),
			),



		)
	) );


	// -> START Custom Post Types Gallery Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'CPT - Gallery', 'charitab-wp' ),
		'id'     => 'cpt-settings-gallery',
		'subsection'       => true,
		'desc'   => '',
		'fields' => array(
			array(
				'id'       => 'cpt-settings-gallery-enable',
				'type'     => 'switch',
				'title'    => esc_html__( 'Gallery Post Type', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Toggle the gallery custom post type on or off.', 'charitab-wp' ),
				'default'  => 1,
			),
			array(
				'id'       => 'cpt-settings-gallery-label',
				'type'     => 'text',
				'title'    => esc_html__( 'Gallery Label', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Rename the Custom Post Type. ', 'charitab-wp' ),
				'default'  => 'Gallery',
				'required' => array( 'cpt-settings-gallery-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-gallery-admin-dashicon',
				'type'     => 'select',
				'title'    => esc_html__( 'Gallery Admin Dashboard Icon', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'options'	=> charitab_mascot_wp_admin_dashicons_list(),
				'default'   => 'dashicons-mascot',
				'required' => array( 'cpt-settings-gallery-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-gallery-slug',
				'type'     => 'text',
				'title'    => esc_html__( 'Gallery Slug', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Specify a custom slug for Gallery Post Type. ', 'charitab-wp' ),
				'desc'     => sprintf( esc_html__( '%1$sNOTE: When you change this setting you need to flush rewrite rules.%2$s %3$s%4$sTo do so, goto Settings > Permalinks and simply click on "Save Changes" button.%2$s', 'charitab-wp' ), '<strong style="color: #777;">', '</strong>', '<br>', '<strong style="color: #999;">'),
				'default'  => 'gallery',
				'required' => array( 'cpt-settings-gallery-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-gallery-cat-slug',
				'type'     => 'text',
				'title'    => esc_html__( 'Gallery Category Slug', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Specify a custom slug for the Category of Gallery Post Type. ', 'charitab-wp' ),
				'desc'     => sprintf( esc_html__( '%1$sNOTE: When you change this setting you need to flush rewrite rules.%2$s %3$s%4$sTo do so, goto Settings > Permalinks and simply click on "Save Changes" button.%2$s', 'charitab-wp' ), '<strong style="color: #777;">', '</strong>', '<br>', '<strong style="color: #999;">'),
				'default'  => 'gallery-category',
				'required' => array( 'cpt-settings-gallery-enable', '=', '1' ),
			),
		)
	) );


	// -> START Custom Post Types Pet Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'CPT - Pet', 'charitab-wp' ),
		'id'     => 'cpt-settings-pet',
		'subsection'       => true,
		'desc'   => '',
		'fields' => array(
			array(
				'id'       => 'cpt-settings-pet-enable',
				'type'     => 'switch',
				'title'    => esc_html__( 'Pet Post Type', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Toggle the pet custom post type on or off.', 'charitab-wp' ),
				'default'  => 1,
			),
			array(
				'id'       => 'cpt-settings-pet-label',
				'type'     => 'text',
				'title'    => esc_html__( 'Pet Label', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Rename the Custom Post Type. ', 'charitab-wp' ),
				'default'  => 'Pet',
				'required' => array( 'cpt-settings-pet-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-pet-admin-dashicon',
				'type'     => 'select',
				'title'    => esc_html__( 'Pet Admin Dashboard Icon', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'options'	=> charitab_mascot_wp_admin_dashicons_list(),
				'default'   => 'dashicons-mascot',
				'required' => array( 'cpt-settings-pet-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-pet-slug',
				'type'     => 'text',
				'title'    => esc_html__( 'Pet Slug', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Specify a custom slug for Pet Post Type. ', 'charitab-wp' ),
				'desc'     => sprintf( esc_html__( '%1$sNOTE: When you change this setting you need to flush rewrite rules.%2$s %3$s%4$sTo do so, goto Settings > Permalinks and simply click on "Save Changes" button.%2$s', 'charitab-wp' ), '<strong style="color: #777;">', '</strong>', '<br>', '<strong style="color: #999;">'),
				'default'  => 'pet',
				'required' => array( 'cpt-settings-pet-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-pet-cat-slug',
				'type'     => 'text',
				'title'    => esc_html__( 'Pet Category Slug', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Specify a custom slug for the Category of Pet Post Type. ', 'charitab-wp' ),
				'desc'     => sprintf( esc_html__( '%1$sNOTE: When you change this setting you need to flush rewrite rules.%2$s %3$s%4$sTo do so, goto Settings > Permalinks and simply click on "Save Changes" button.%2$s', 'charitab-wp' ), '<strong style="color: #777;">', '</strong>', '<br>', '<strong style="color: #999;">'),
				'default'  => 'pet-category',
				'required' => array( 'cpt-settings-pet-enable', '=', '1' ),
			),
		)
	) );


	/*// -> START Custom Post Types Portfolio Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'CPT - Portfolio', 'charitab-wp' ),
		'id'     => 'cpt-settings-portfolio',
		'subsection'       => true,
		'desc'   => '',
		'fields' => array(
			array(
				'id'       => 'cpt-settings-portfolio-enable',
				'type'     => 'switch',
				'title'    => esc_html__( 'Portfolio Post Type', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Toggle the portfolio custom post type on or off.', 'charitab-wp' ),
				'default'  => 1,
			),
			array(
				'id'       => 'cpt-settings-portfolio-label',
				'type'     => 'text',
				'title'    => esc_html__( 'Portfolio Label', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Rename the Custom Post Type. ', 'charitab-wp' ),
				'default'  => 'Portfolio',
				'required' => array( 'cpt-settings-portfolio-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-portfolio-admin-dashicon',
				'type'     => 'select',
				'title'    => esc_html__( 'Portfolio Admin Dashboard Icon', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'options'	=> charitab_mascot_wp_admin_dashicons_list(),
				'default'   => 'dashicons-mascot',
				'required' => array( 'cpt-settings-portfolio-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-portfolio-slug',
				'type'     => 'text',
				'title'    => esc_html__( 'Portfolio Slug', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Specify a custom slug for Portfolio Post Type. ', 'charitab-wp' ),
				'desc'     => sprintf( esc_html__( '%1$sNOTE: When you change this setting you need to flush rewrite rules.%2$s %3$s%4$sTo do so, goto Settings > Permalinks and simply click on "Save Changes" button.%2$s', 'charitab-wp' ), '<strong style="color: #777;">', '</strong>', '<br>', '<strong style="color: #999;">'),
				'default'  => 'portfolio',
				'required' => array( 'cpt-settings-portfolio-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-portfolio-cat-slug',
				'type'     => 'text',
				'title'    => esc_html__( 'Portfolio Category Slug', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Specify a custom slug for the Category of Portfolio Post Type. ', 'charitab-wp' ),
				'desc'     => sprintf( esc_html__( '%1$sNOTE: When you change this setting you need to flush rewrite rules.%2$s %3$s%4$sTo do so, goto Settings > Permalinks and simply click on "Save Changes" button.%2$s', 'charitab-wp' ), '<strong style="color: #777;">', '</strong>', '<br>', '<strong style="color: #999;">'),
				'default'  => 'portfolio-category',
				'required' => array( 'cpt-settings-portfolio-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-portfolio-tag-slug',
				'type'     => 'text',
				'title'    => esc_html__( 'Portfolio Tag Slug', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Specify a custom slug for the Tag of Portfolio Post Type. ', 'charitab-wp' ),
				'desc'     => sprintf( esc_html__( '%1$sNOTE: When you change this setting you need to flush rewrite rules.%2$s %3$s%4$sTo do so, goto Settings > Permalinks and simply click on "Save Changes" button.%2$s', 'charitab-wp' ), '<strong style="color: #777;">', '</strong>', '<br>', '<strong style="color: #999;">'),
				'default'  => 'portfolio-tag',
				'required' => array( 'cpt-settings-portfolio-enable', '=', '1' ),
			),
		)
	) );*/


	// -> START Custom Post Types Projects Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'CPT - Projects', 'charitab-wp' ),
		'id'     => 'cpt-settings-projects',
		'subsection'       => true,
		'desc'   => '',
		'fields' => array(
			array(
				'id'       => 'cpt-settings-projects-enable',
				'type'     => 'switch',
				'title'    => esc_html__( 'Projects Post Type', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Toggle the projects custom post type on or off.', 'charitab-wp' ),
				'default'  => 1,
			),
			array(
				'id'       => 'cpt-settings-projects-label',
				'type'     => 'text',
				'title'    => esc_html__( 'Projects Label', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Rename the Custom Post Type. ', 'charitab-wp' ),
				'default'  => 'Projects',
				'required' => array( 'cpt-settings-projects-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-projects-admin-dashicon',
				'type'     => 'select',
				'title'    => esc_html__( 'Projects Admin Dashboard Icon', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'options'	=> charitab_mascot_wp_admin_dashicons_list(),
				'default'   => 'dashicons-mascot',
				'required' => array( 'cpt-settings-projects-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-projects-slug',
				'type'     => 'text',
				'title'    => esc_html__( 'Projects Slug', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Specify a custom slug for Projects Post Type. ', 'charitab-wp' ),
				'desc'     => sprintf( esc_html__( '%1$sNOTE: When you change this setting you need to flush rewrite rules.%2$s %3$s%4$sTo do so, goto Settings > Permalinks and simply click on "Save Changes" button.%2$s', 'charitab-wp' ), '<strong style="color: #777;">', '</strong>', '<br>', '<strong style="color: #999;">'),
				'default'  => 'projects',
				'required' => array( 'cpt-settings-projects-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-projects-cat-slug',
				'type'     => 'text',
				'title'    => esc_html__( 'Projects Category Slug', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Specify a custom slug for the Category of Projects Post Type. ', 'charitab-wp' ),
				'desc'     => sprintf( esc_html__( '%1$sNOTE: When you change this setting you need to flush rewrite rules.%2$s %3$s%4$sTo do so, goto Settings > Permalinks and simply click on "Save Changes" button.%2$s', 'charitab-wp' ), '<strong style="color: #777;">', '</strong>', '<br>', '<strong style="color: #999;">'),
				'default'  => 'projects-category',
				'required' => array( 'cpt-settings-projects-enable', '=', '1' ),
			),
		)
	) );


	// -> START Custom Post Types Services Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'CPT - Services', 'charitab-wp' ),
		'id'     => 'cpt-settings-services',
		'subsection'       => true,
		'desc'   => '',
		'fields' => array(
			array(
				'id'       => 'cpt-settings-services-enable',
				'type'     => 'switch',
				'title'    => esc_html__( 'Services Post Type', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Toggle the services custom post type on or off.', 'charitab-wp' ),
				'default'  => 1,
			),
			array(
				'id'       => 'cpt-settings-services-label',
				'type'     => 'text',
				'title'    => esc_html__( 'Services Label', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Rename the Custom Post Type. ', 'charitab-wp' ),
				'default'  => 'Services',
				'required' => array( 'cpt-settings-services-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-services-admin-dashicon',
				'type'     => 'select',
				'title'    => esc_html__( 'Services Admin Dashboard Icon', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'options'	=> charitab_mascot_wp_admin_dashicons_list(),
				'default'   => 'dashicons-mascot',
				'required' => array( 'cpt-settings-services-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-services-slug',
				'type'     => 'text',
				'title'    => esc_html__( 'Services Slug', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Specify a custom slug for Services Post Type. ', 'charitab-wp' ),
				'desc'     => sprintf( esc_html__( '%1$sNOTE: When you change this setting you need to flush rewrite rules.%2$s %3$s%4$sTo do so, goto Settings > Permalinks and simply click on "Save Changes" button.%2$s', 'charitab-wp' ), '<strong style="color: #777;">', '</strong>', '<br>', '<strong style="color: #999;">'),
				'default'  => 'services',
				'required' => array( 'cpt-settings-services-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-services-cat-slug',
				'type'     => 'text',
				'title'    => esc_html__( 'Services Category Slug', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Specify a custom slug for the Category of Services Post Type. ', 'charitab-wp' ),
				'desc'     => sprintf( esc_html__( '%1$sNOTE: When you change this setting you need to flush rewrite rules.%2$s %3$s%4$sTo do so, goto Settings > Permalinks and simply click on "Save Changes" button.%2$s', 'charitab-wp' ), '<strong style="color: #777;">', '</strong>', '<br>', '<strong style="color: #999;">'),
				'default'  => 'services-category',
				'required' => array( 'cpt-settings-services-enable', '=', '1' ),
			),



			array(
				'id'        => 'cpt-settings-services-archive-settings',
				'type'      => 'info',
				'title'     => esc_html__( 'Services Archive Page Settings', 'charitab-wp' ),
				'notice'    => false,
			),
			array(
				'id'       => 'cpt-settings-services-archive-layout-mode',
				'type'     => 'image_select',
				'title'    => esc_html__( 'Service Layout Mode (FitRows Or Masonry)', 'charitab-wp' ),
				'subtitle' => esc_html__( 'You can position items with different layout modes. Select a layout mode you would like to use.', 'charitab-wp' ),
				'desc'     => '',
				//Must provide key => value(array:title|img) pairs for radio options
				'options'	=> array(
					'fitrows' => array(
						'alt' => 'Fit Rows',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/services/layout-mode/fitrows.png'
					),
					'masonry' => array(
						'alt' => 'Masonry',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/services/layout-mode/masonry.png'
					),
				),
				'default'  => 'masonry'
			),
			array(
				'id'       => 'cpt-settings-services-archive-items-per-row',
				'type'     => 'select',
				'title'    => esc_html__( 'Number of Services Per Row', 'charitab-wp' ),
				'subtitle'    => esc_html__( 'Select your default column structure for your Services.', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array(
					'1'  => '1 Item Per Row',
					'2'  => '2 Items Per Row',
					'3'  => '3 Items Per Row',
					'4'  => '4 Items Per Row',
					'5'  => '5 Items Per Row',
					'6'  => '6 Items Per Row',
					'7'  => '7 Items Per Row',
					'8'  => '8 Items Per Row',
					'9'  => '9 Items Per Row',
					'10' => '10 Items Per Row',
				),
				'default'=> '4',
			),
			array(
				'id'            => 'cpt-settings-services-archive-items-per-page',
				'type'          => 'slider',
				'title'         => esc_html__( 'Number of Services Per Page', 'charitab-wp' ),
				'subtitle'      => esc_html__( 'Controls the number of items to display on services archive pages. Set to -1 to display all. Set to 0 to use the number of posts from Settings > Reading.', 'charitab-wp' ),
				'desc'          => '',
				'default'       => 8,
				'min'           => -1,
				'step'          => 1,
				'max'           => 40,
				'display_value' => 'text',
			),
			array(
				'id'            => 'cpt-settings-services-archive-gutter-size',
				'type'          => 'slider',
				'title'         => esc_html__( 'Services Column Spacing (Gutter Size) px', 'charitab-wp' ),
				'subtitle'      => esc_html__( 'Controls column spacing or gutter size between items on services archive pages.', 'charitab-wp' ),
				'desc'          => '',
				'default'       => 30,
				'min'           => 0,
				'step'          => 1,
				'max'           => 250,
				'display_value' => 'text',
			),
		)
	) );


	// -> START Custom Post Types Staff Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'CPT - Staff', 'charitab-wp' ),
		'id'     => 'cpt-settings-staff',
		'subsection'       => true,
		'desc'   => '',
		'fields' => array(
			array(
				'id'       => 'cpt-settings-staff-enable',
				'type'     => 'switch',
				'title'    => esc_html__( 'Staff Post Type', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Toggle the staff custom post type on or off.', 'charitab-wp' ),
				'default'  => 1,
			),
			array(
				'id'       => 'cpt-settings-staff-label',
				'type'     => 'text',
				'title'    => esc_html__( 'Staff Label', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Rename the Custom Post Type. ', 'charitab-wp' ),
				'default'  => 'Staff',
				'required' => array( 'cpt-settings-staff-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-staff-admin-dashicon',
				'type'     => 'select',
				'title'    => esc_html__( 'Staff Admin Dashboard Icon', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'options'	=> charitab_mascot_wp_admin_dashicons_list(),
				'default'   => 'dashicons-mascot',
				'required' => array( 'cpt-settings-staff-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-staff-slug',
				'type'     => 'text',
				'title'    => esc_html__( 'Staff Slug', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Specify a custom slug for Staff Post Type. ', 'charitab-wp' ),
				'desc'     => sprintf( esc_html__( '%1$sNOTE: When you change this setting you need to flush rewrite rules.%2$s %3$s%4$sTo do so, goto Settings > Permalinks and simply click on "Save Changes" button.%2$s', 'charitab-wp' ), '<strong style="color: #777;">', '</strong>', '<br>', '<strong style="color: #999;">'),
				'default'  => 'staff',
				'required' => array( 'cpt-settings-staff-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-staff-cat-slug',
				'type'     => 'text',
				'title'    => esc_html__( 'Staff Category Slug', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Specify a custom slug for the Category of Staff Post Type. ', 'charitab-wp' ),
				'desc'     => sprintf( esc_html__( '%1$sNOTE: When you change this setting you need to flush rewrite rules.%2$s %3$s%4$sTo do so, goto Settings > Permalinks and simply click on "Save Changes" button.%2$s', 'charitab-wp' ), '<strong style="color: #777;">', '</strong>', '<br>', '<strong style="color: #999;">'),
				'default'  => 'staff-category',
				'required' => array( 'cpt-settings-staff-enable', '=', '1' ),
			),






			array(
				'id'        => 'cpt-settings-staff-archive-settings',
				'type'      => 'info',
				'title'     => esc_html__( 'Staff Archive Page Settings', 'charitab-wp' ),
				'notice'    => false,
			),
			array(
				'id'       => 'cpt-settings-staff-archive-layout-mode',
				'type'     => 'image_select',
				'title'    => esc_html__( 'Staff Layout Mode (FitRows Or Masonry)', 'charitab-wp' ),
				'subtitle' => esc_html__( 'You can position items with different layout modes. Select a layout mode you would like to use.', 'charitab-wp' ),
				'desc'     => '',
				//Must provide key => value(array:title|img) pairs for radio options
				'options'	=> array(
					'fitrows' => array(
						'alt' => 'Fit Rows',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/staff/layout-mode/fitrows.png'
					),
					'masonry' => array(
						'alt' => 'Masonry',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/staff/layout-mode/masonry.png'
					),
				),
				'default'  => 'masonry'
			),
			array(
				'id'       => 'cpt-settings-staff-archive-items-per-row',
				'type'     => 'select',
				'title'    => esc_html__( 'Number of Staffs Per Row', 'charitab-wp' ),
				'subtitle'    => esc_html__( 'Select your default column structure for your Staffs.', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array(
					'1'  => '1 Item Per Row',
					'2'  => '2 Items Per Row',
					'3'  => '3 Items Per Row',
					'4'  => '4 Items Per Row',
					'5'  => '5 Items Per Row',
					'6'  => '6 Items Per Row',
					'7'  => '7 Items Per Row',
					'8'  => '8 Items Per Row',
					'9'  => '9 Items Per Row',
					'10' => '10 Items Per Row',
				),
				'default'=> '3',
			),
			array(
				'id'            => 'cpt-settings-staff-archive-items-per-page',
				'type'          => 'slider',
				'title'         => esc_html__( 'Number of Staffs Per Page', 'charitab-wp' ),
				'subtitle'      => esc_html__( 'Controls the number of items to display on staff archive pages. Set to -1 to display all. Set to 0 to use the number of posts from Settings > Reading.', 'charitab-wp' ),
				'desc'          => '',
				'default'       => 8,
				'min'           => -1,
				'step'          => 1,
				'max'           => 40,
				'display_value' => 'text',
			),
			array(
				'id'            => 'cpt-settings-staff-archive-gutter-size',
				'type'          => 'slider',
				'title'         => esc_html__( 'Staffs Column Spacing (Gutter Size) px', 'charitab-wp' ),
				'subtitle'      => esc_html__( 'Controls column spacing or gutter size between items on staff archive pages.', 'charitab-wp' ),
				'desc'          => '',
				'default'       => 30,
				'min'           => 0,
				'step'          => 1,
				'max'           => 250,
				'display_value' => 'text',
			),


			array(
				'id'       => 'cpt-settings-staff-archive-show-featured-image',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Featured Image', 'charitab-wp' ),
				'default'  => 1,
			),
			array(
				'id'       => 'cpt-settings-staff-archive-featured-image-size',
				'type'     => 'select',
				'title'    => esc_html__( 'Featured Image Size', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Featured image size in blog page.', 'charitab-wp' ),
				'desc'     => '',
				'data'     => 'image_sizes',
				'default'  => 'charitab_mascot_wide',
				'required' => array( 'cpt-settings-staff-archive-show-featured-image', '=', '1' ),
			),


			array(
				'id'       => 'cpt-settings-staff-archive-show-title',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Title', 'charitab-wp' ),
				'default'  => 1,
			),

			array(
				'id'       => 'cpt-settings-staff-archive-title-tag',
				'type'     => 'select',
				'title'    => esc_html__( 'Title Tag', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'options'	=> charitab_mascot_heading_tag_list_all(),
				'default'  => 'h4',
				'required' => array( 'cpt-settings-staff-archive-show-title', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-staff-archive-show-speciality',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Speciality', 'charitab-wp' ),
				'default'  => 1,
			),
			array(
				'id'       => 'cpt-settings-staff-archive-show-bio',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Bio', 'charitab-wp' ),
				'default'  => 1,
			),
			array(
				'id'       => 'cpt-settings-staff-archive-show-social',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Social Links', 'charitab-wp' ),
				'default'  => 1,
			),
			array(
				'id'       => 'cpt-settings-staff-archive-show-working-hours',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Working Hours', 'charitab-wp' ),
				'default'  => 0,
			),
			array(
				'id'       => 'cpt-settings-staff-archive-show-btn',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Details Button', 'charitab-wp' ),
				'default'  => 1,
			),
			array(
				'id'       => 'cpt-settings-staff-archive-show-btn-text',
				'type'     => 'text',
				'title'    => esc_html__( 'Details Button Text', 'charitab-wp' ),
				'default'  => esc_html__( 'View Details', 'charitab-wp' ),
				'required' => array( 'cpt-settings-staff-archive-show-btn', '=', '1' ),
			),
		)
	) );


	// -> START Custom Post Types Partners Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'CPT - Partners', 'charitab-wp' ),
		'id'     => 'cpt-settings-partners',
		'subsection'       => true,
		'desc'   => '',
		'fields' => array(
			array(
				'id'       => 'cpt-settings-partners-enable',
				'type'     => 'switch',
				'title'    => esc_html__( 'Partners Post Type', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Toggle the partners custom post type on or off.', 'charitab-wp' ),
				'default'  => 1,
			),
			array(
				'id'       => 'cpt-settings-partners-label',
				'type'     => 'text',
				'title'    => esc_html__( 'Partners Label', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Rename the Custom Post Type. ', 'charitab-wp' ),
				'default'  => 'Partners',
				'required' => array( 'cpt-settings-partners-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-partners-admin-dashicon',
				'type'     => 'select',
				'title'    => esc_html__( 'Partners Admin Dashboard Icon', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'options'	=> charitab_mascot_wp_admin_dashicons_list(),
				'default'   => 'dashicons-mascot',
				'required' => array( 'cpt-settings-partners-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-partners-slug',
				'type'     => 'text',
				'title'    => esc_html__( 'Partners Slug', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Specify a custom slug for Partners Post Type. ', 'charitab-wp' ),
				'desc'     => sprintf( esc_html__( '%1$sNOTE: When you change this setting you need to flush rewrite rules.%2$s %3$s%4$sTo do so, goto Settings > Permalinks and simply click on "Save Changes" button.%2$s', 'charitab-wp' ), '<strong style="color: #777;">', '</strong>', '<br>', '<strong style="color: #999;">'),
				'default'  => 'partners',
				'required' => array( 'cpt-settings-partners-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-partners-cat-slug',
				'type'     => 'text',
				'title'    => esc_html__( 'Partners Category Slug', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Specify a custom slug for the Category of Partners Post Type. ', 'charitab-wp' ),
				'desc'     => sprintf( esc_html__( '%1$sNOTE: When you change this setting you need to flush rewrite rules.%2$s %3$s%4$sTo do so, goto Settings > Permalinks and simply click on "Save Changes" button.%2$s', 'charitab-wp' ), '<strong style="color: #777;">', '</strong>', '<br>', '<strong style="color: #999;">'),
				'default'  => 'partners-category',
				'required' => array( 'cpt-settings-partners-enable', '=', '1' ),
			),






			array(
				'id'        => 'cpt-settings-partners-archive-settings',
				'type'      => 'info',
				'title'     => esc_html__( 'Partners Archive Page Settings', 'charitab-wp' ),
				'notice'    => false,
			),
			array(
				'id'       => 'cpt-settings-partners-archive-layout-mode',
				'type'     => 'image_select',
				'title'    => esc_html__( 'Partners Layout Mode (FitRows Or Masonry)', 'charitab-wp' ),
				'subtitle' => esc_html__( 'You can position items with different layout modes. Select a layout mode you would like to use.', 'charitab-wp' ),
				'desc'     => '',
				//Must provide key => value(array:title|img) pairs for radio options
				'options'	=> array(
					'fitrows' => array(
						'alt' => 'Fit Rows',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/partners/layout-mode/fitrows.png'
					),
					'masonry' => array(
						'alt' => 'Masonry',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/partners/layout-mode/masonry.png'
					),
				),
				'default'  => 'masonry'
			),
			array(
				'id'       => 'cpt-settings-partners-archive-items-per-row',
				'type'     => 'select',
				'title'    => esc_html__( 'Number of Partnerss Per Row', 'charitab-wp' ),
				'subtitle'    => esc_html__( 'Select your default column structure for your Partnerss.', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array(
					'1'  => '1 Item Per Row',
					'2'  => '2 Items Per Row',
					'3'  => '3 Items Per Row',
					'4'  => '4 Items Per Row',
					'5'  => '5 Items Per Row',
					'6'  => '6 Items Per Row',
					'7'  => '7 Items Per Row',
					'8'  => '8 Items Per Row',
					'9'  => '9 Items Per Row',
					'10' => '10 Items Per Row',
				),
				'default'=> '3',
			),
			array(
				'id'            => 'cpt-settings-partners-archive-items-per-page',
				'type'          => 'slider',
				'title'         => esc_html__( 'Number of Partnerss Per Page', 'charitab-wp' ),
				'subtitle'      => esc_html__( 'Controls the number of items to display on partners archive pages. Set to -1 to display all. Set to 0 to use the number of posts from Settings > Reading.', 'charitab-wp' ),
				'desc'          => '',
				'default'       => 8,
				'min'           => -1,
				'step'          => 1,
				'max'           => 40,
				'display_value' => 'text',
			),
			array(
				'id'            => 'cpt-settings-partners-archive-gutter-size',
				'type'          => 'slider',
				'title'         => esc_html__( 'Partnerss Column Spacing (Gutter Size) px', 'charitab-wp' ),
				'subtitle'      => esc_html__( 'Controls column spacing or gutter size between items on partners archive pages.', 'charitab-wp' ),
				'desc'          => '',
				'default'       => 30,
				'min'           => 0,
				'step'          => 1,
				'max'           => 250,
				'display_value' => 'text',
			),


			array(
				'id'       => 'cpt-settings-partners-archive-show-featured-image',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Featured Image', 'charitab-wp' ),
				'default'  => 1,
			),
			array(
				'id'       => 'cpt-settings-partners-archive-featured-image-size',
				'type'     => 'select',
				'title'    => esc_html__( 'Featured Image Size', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Featured image size in blog page.', 'charitab-wp' ),
				'desc'     => '',
				'data'     => 'image_sizes',
				'default'  => 'charitab_mascot_wide',
				'required' => array( 'cpt-settings-partners-archive-show-featured-image', '=', '1' ),
			),


			array(
				'id'       => 'cpt-settings-partners-archive-show-title',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Title', 'charitab-wp' ),
				'default'  => 1,
			),

			array(
				'id'       => 'cpt-settings-partners-archive-title-tag',
				'type'     => 'select',
				'title'    => esc_html__( 'Title Tag', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'options'	=> charitab_mascot_heading_tag_list_all(),
				'default'  => 'h4',
				'required' => array( 'cpt-settings-partners-archive-show-title', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-partners-archive-show-speciality',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Speciality', 'charitab-wp' ),
				'default'  => 1,
			),
			array(
				'id'       => 'cpt-settings-partners-archive-show-bio',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Bio', 'charitab-wp' ),
				'default'  => 1,
			),
			array(
				'id'       => 'cpt-settings-partners-archive-show-social',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Social Links', 'charitab-wp' ),
				'default'  => 1,
			),
			array(
				'id'       => 'cpt-settings-partners-archive-show-working-hours',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Working Hours', 'charitab-wp' ),
				'default'  => 0,
			),
			array(
				'id'       => 'cpt-settings-partners-archive-show-btn',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Details Button', 'charitab-wp' ),
				'default'  => 1,
			),
			array(
				'id'       => 'cpt-settings-partners-archive-show-btn-text',
				'type'     => 'text',
				'title'    => esc_html__( 'Details Button Text', 'charitab-wp' ),
				'default'  => esc_html__( 'View Details', 'charitab-wp' ),
				'required' => array( 'cpt-settings-partners-archive-show-btn', '=', '1' ),
			),
		)
	) );


	// -> START Custom Post Types Resources Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'CPT - Resources', 'charitab-wp' ),
		'id'     => 'cpt-settings-resources',
		'subsection'       => true,
		'desc'   => '',
		'fields' => array(
			array(
				'id'       => 'cpt-settings-resources-enable',
				'type'     => 'switch',
				'title'    => esc_html__( 'Resources Post Type', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Toggle the resources custom post type on or off.', 'charitab-wp' ),
				'default'  => 1,
			),
			array(
				'id'       => 'cpt-settings-resources-label',
				'type'     => 'text',
				'title'    => esc_html__( 'Resources Label', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Rename the Custom Post Type. ', 'charitab-wp' ),
				'default'  => 'Resources',
				'required' => array( 'cpt-settings-resources-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-resources-admin-dashicon',
				'type'     => 'select',
				'title'    => esc_html__( 'Resources Admin Dashboard Icon', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'options'	=> charitab_mascot_wp_admin_dashicons_list(),
				'default'   => 'dashicons-mascot',
				'required' => array( 'cpt-settings-resources-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-resources-slug',
				'type'     => 'text',
				'title'    => esc_html__( 'Resources Slug', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Specify a custom slug for Resources Post Type. ', 'charitab-wp' ),
				'desc'     => sprintf( esc_html__( '%1$sNOTE: When you change this setting you need to flush rewrite rules.%2$s %3$s%4$sTo do so, goto Settings > Permalinks and simply click on "Save Changes" button.%2$s', 'charitab-wp' ), '<strong style="color: #777;">', '</strong>', '<br>', '<strong style="color: #999;">'),
				'default'  => 'resources',
				'required' => array( 'cpt-settings-resources-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-resources-cat-slug',
				'type'     => 'text',
				'title'    => esc_html__( 'Resources Category Slug', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Specify a custom slug for the Category of Resources Post Type. ', 'charitab-wp' ),
				'desc'     => sprintf( esc_html__( '%1$sNOTE: When you change this setting you need to flush rewrite rules.%2$s %3$s%4$sTo do so, goto Settings > Permalinks and simply click on "Save Changes" button.%2$s', 'charitab-wp' ), '<strong style="color: #777;">', '</strong>', '<br>', '<strong style="color: #999;">'),
				'default'  => 'resources-category',
				'required' => array( 'cpt-settings-resources-enable', '=', '1' ),
			),






			array(
				'id'        => 'cpt-settings-resources-archive-settings',
				'type'      => 'info',
				'title'     => esc_html__( 'Resources Archive Page Settings', 'charitab-wp' ),
				'notice'    => false,
			),
			array(
				'id'       => 'cpt-settings-resources-archive-layout-mode',
				'type'     => 'image_select',
				'title'    => esc_html__( 'Resources Layout Mode (FitRows Or Masonry)', 'charitab-wp' ),
				'subtitle' => esc_html__( 'You can position items with different layout modes. Select a layout mode you would like to use.', 'charitab-wp' ),
				'desc'     => '',
				//Must provide key => value(array:title|img) pairs for radio options
				'options'	=> array(
					'fitrows' => array(
						'alt' => 'Fit Rows',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/resources/layout-mode/fitrows.png'
					),
					'masonry' => array(
						'alt' => 'Masonry',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/resources/layout-mode/masonry.png'
					),
				),
				'default'  => 'masonry'
			),
			array(
				'id'       => 'cpt-settings-resources-archive-items-per-row',
				'type'     => 'select',
				'title'    => esc_html__( 'Number of Resourcess Per Row', 'charitab-wp' ),
				'subtitle'    => esc_html__( 'Select your default column structure for your Resourcess.', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array(
					'1'  => '1 Item Per Row',
					'2'  => '2 Items Per Row',
					'3'  => '3 Items Per Row',
					'4'  => '4 Items Per Row',
					'5'  => '5 Items Per Row',
					'6'  => '6 Items Per Row',
					'7'  => '7 Items Per Row',
					'8'  => '8 Items Per Row',
					'9'  => '9 Items Per Row',
					'10' => '10 Items Per Row',
				),
				'default'=> '3',
			),
			array(
				'id'            => 'cpt-settings-resources-archive-items-per-page',
				'type'          => 'slider',
				'title'         => esc_html__( 'Number of Resourcess Per Page', 'charitab-wp' ),
				'subtitle'      => esc_html__( 'Controls the number of items to display on resources archive pages. Set to -1 to display all. Set to 0 to use the number of posts from Settings > Reading.', 'charitab-wp' ),
				'desc'          => '',
				'default'       => 8,
				'min'           => -1,
				'step'          => 1,
				'max'           => 40,
				'display_value' => 'text',
			),
			array(
				'id'            => 'cpt-settings-resources-archive-gutter-size',
				'type'          => 'slider',
				'title'         => esc_html__( 'Resourcess Column Spacing (Gutter Size) px', 'charitab-wp' ),
				'subtitle'      => esc_html__( 'Controls column spacing or gutter size between items on resources archive pages.', 'charitab-wp' ),
				'desc'          => '',
				'default'       => 30,
				'min'           => 0,
				'step'          => 1,
				'max'           => 250,
				'display_value' => 'text',
			),


			array(
				'id'       => 'cpt-settings-resources-archive-show-featured-image',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Featured Image', 'charitab-wp' ),
				'default'  => 1,
			),
			array(
				'id'       => 'cpt-settings-resources-archive-featured-image-size',
				'type'     => 'select',
				'title'    => esc_html__( 'Featured Image Size', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Featured image size in blog page.', 'charitab-wp' ),
				'desc'     => '',
				'data'     => 'image_sizes',
				'default'  => 'charitab_mascot_wide',
				'required' => array( 'cpt-settings-resources-archive-show-featured-image', '=', '1' ),
			),


			array(
				'id'       => 'cpt-settings-resources-archive-show-title',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Title', 'charitab-wp' ),
				'default'  => 1,
			),

			array(
				'id'       => 'cpt-settings-resources-archive-title-tag',
				'type'     => 'select',
				'title'    => esc_html__( 'Title Tag', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'options'	=> charitab_mascot_heading_tag_list_all(),
				'default'  => 'h4',
				'required' => array( 'cpt-settings-resources-archive-show-title', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-resources-archive-show-speciality',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Speciality', 'charitab-wp' ),
				'default'  => 1,
			),
			array(
				'id'       => 'cpt-settings-resources-archive-show-bio',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Bio', 'charitab-wp' ),
				'default'  => 1,
			),
			array(
				'id'       => 'cpt-settings-resources-archive-show-social',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Social Links', 'charitab-wp' ),
				'default'  => 1,
			),
			array(
				'id'       => 'cpt-settings-resources-archive-show-working-hours',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Working Hours', 'charitab-wp' ),
				'default'  => 0,
			),
			array(
				'id'       => 'cpt-settings-resources-archive-show-btn',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Details Button', 'charitab-wp' ),
				'default'  => 1,
			),
			array(
				'id'       => 'cpt-settings-resources-archive-show-btn-text',
				'type'     => 'text',
				'title'    => esc_html__( 'Details Button Text', 'charitab-wp' ),
				'default'  => esc_html__( 'View Details', 'charitab-wp' ),
				'required' => array( 'cpt-settings-resources-archive-show-btn', '=', '1' ),
			),
		)
	) );


	// -> START Custom Post Types Testimonials Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'CPT - Testimonials', 'charitab-wp' ),
		'id'     => 'cpt-settings-testimonials',
		'subsection'       => true,
		'desc'   => '',
		'fields' => array(
			array(
				'id'       => 'cpt-settings-testimonials-enable',
				'type'     => 'switch',
				'title'    => esc_html__( 'Testimonials Post Type', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Toggle the testimonials custom post type on or off.', 'charitab-wp' ),
				'default'  => 1,
			),
			array(
				'id'       => 'cpt-settings-testimonials-label',
				'type'     => 'text',
				'title'    => esc_html__( 'Testimonials Label', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Rename the Custom Post Type. ', 'charitab-wp' ),
				'default'  => 'Testimonials',
				'required' => array( 'cpt-settings-testimonials-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-testimonials-admin-dashicon',
				'type'     => 'select',
				'title'    => esc_html__( 'Testimonials Admin Dashboard Icon', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'options'	=> charitab_mascot_wp_admin_dashicons_list(),
				'default'   => 'dashicons-mascot',
				'required' => array( 'cpt-settings-testimonials-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-testimonials-slug',
				'type'     => 'text',
				'title'    => esc_html__( 'Courses Slug', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Specify a custom slug for Courses Post Type. ', 'charitab-wp' ),
				'desc'     => sprintf( esc_html__( '%1$sNOTE: When you change this setting you need to flush rewrite rules.%2$s %3$s%4$sTo do so, goto Settings > Permalinks and simply click on "Save Changes" button.%2$s', 'charitab-wp' ), '<strong style="color: #777;">', '</strong>', '<br>', '<strong style="color: #999;">'),
				'default'  => 'testimonials',
				'required' => array( 'cpt-settings-testimonials-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-testimonials-cat-slug',
				'type'     => 'text',
				'title'    => esc_html__( 'Courses Category Slug', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Specify a custom slug for the Category of Courses Post Type. ', 'charitab-wp' ),
				'desc'     => sprintf( esc_html__( '%1$sNOTE: When you change this setting you need to flush rewrite rules.%2$s %3$s%4$sTo do so, goto Settings > Permalinks and simply click on "Save Changes" button.%2$s', 'charitab-wp' ), '<strong style="color: #777;">', '</strong>', '<br>', '<strong style="color: #999;">'),
				'default'  => 'testimonials-category',
				'required' => array( 'cpt-settings-testimonials-enable', '=', '1' ),
			),
		)
	) );


	// -> START Custom Post Types Vacancies Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'CPT - Vacancies', 'charitab-wp' ),
		'id'     => 'cpt-settings-vacancies',
		'subsection'       => true,
		'desc'   => '',
		'fields' => array(
			array(
				'id'       => 'cpt-settings-vacancies-enable',
				'type'     => 'switch',
				'title'    => esc_html__( 'Vacancies Post Type', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Toggle the vacancies custom post type on or off.', 'charitab-wp' ),
				'default'  => 1,
			),
			array(
				'id'       => 'cpt-settings-vacancies-label',
				'type'     => 'text',
				'title'    => esc_html__( 'Vacancies Label', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Rename the Custom Post Type. ', 'charitab-wp' ),
				'default'  => 'Vacancies',
				'required' => array( 'cpt-settings-vacancies-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-vacancies-admin-dashicon',
				'type'     => 'select',
				'title'    => esc_html__( 'Vacancies Admin Dashboard Icon', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'options'	=> charitab_mascot_wp_admin_dashicons_list(),
				'default'   => 'dashicons-mascot',
				'required' => array( 'cpt-settings-vacancies-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-vacancies-slug',
				'type'     => 'text',
				'title'    => esc_html__( 'Vacancies Slug', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Specify a custom slug for Vacancies Post Type. ', 'charitab-wp' ),
				'desc'     => sprintf( esc_html__( '%1$sNOTE: When you change this setting you need to flush rewrite rules.%2$s %3$s%4$sTo do so, goto Settings > Permalinks and simply click on "Save Changes" button.%2$s', 'charitab-wp' ), '<strong style="color: #777;">', '</strong>', '<br>', '<strong style="color: #999;">'),
				'default'  => 'vacancies',
				'required' => array( 'cpt-settings-vacancies-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-vacancies-cat-slug',
				'type'     => 'text',
				'title'    => esc_html__( 'Vacancies Category Slug', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Specify a custom slug for the Category of Vacancies Post Type. ', 'charitab-wp' ),
				'desc'     => sprintf( esc_html__( '%1$sNOTE: When you change this setting you need to flush rewrite rules.%2$s %3$s%4$sTo do so, goto Settings > Permalinks and simply click on "Save Changes" button.%2$s', 'charitab-wp' ), '<strong style="color: #777;">', '</strong>', '<br>', '<strong style="color: #999;">'),
				'default'  => 'vacancies-category',
				'required' => array( 'cpt-settings-vacancies-enable', '=', '1' ),
			),
		)
	) );


	// -> START Custom Post Types Works Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'CPT - Works', 'charitab-wp' ),
		'id'     => 'cpt-settings-works',
		'subsection'       => true,
		'desc'   => '',
		'fields' => array(
			array(
				'id'       => 'cpt-settings-works-enable',
				'type'     => 'switch',
				'title'    => esc_html__( 'Works Post Type', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Toggle the works custom post type on or off.', 'charitab-wp' ),
				'default'  => 1,
			),
			array(
				'id'       => 'cpt-settings-works-label',
				'type'     => 'text',
				'title'    => esc_html__( 'Works Label', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Rename the Custom Post Type. ', 'charitab-wp' ),
				'default'  => 'Works',
				'required' => array( 'cpt-settings-works-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-works-admin-dashicon',
				'type'     => 'select',
				'title'    => esc_html__( 'Works Admin Dashboard Icon', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'options'	=> charitab_mascot_wp_admin_dashicons_list(),
				'default'   => 'dashicons-mascot',
				'required' => array( 'cpt-settings-works-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-works-slug',
				'type'     => 'text',
				'title'    => esc_html__( 'Works Slug', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Specify a custom slug for Works Post Type. ', 'charitab-wp' ),
				'desc'     => sprintf( esc_html__( '%1$sNOTE: When you change this setting you need to flush rewrite rules.%2$s %3$s%4$sTo do so, goto Settings > Permalinks and simply click on "Save Changes" button.%2$s', 'charitab-wp' ), '<strong style="color: #777;">', '</strong>', '<br>', '<strong style="color: #999;">'),
				'default'  => 'works',
				'required' => array( 'cpt-settings-works-enable', '=', '1' ),
			),
			array(
				'id'       => 'cpt-settings-works-cat-slug',
				'type'     => 'text',
				'title'    => esc_html__( 'Works Category Slug', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Specify a custom slug for the Category of Works Post Type. ', 'charitab-wp' ),
				'desc'     => sprintf( esc_html__( '%1$sNOTE: When you change this setting you need to flush rewrite rules.%2$s %3$s%4$sTo do so, goto Settings > Permalinks and simply click on "Save Changes" button.%2$s', 'charitab-wp' ), '<strong style="color: #777;">', '</strong>', '<br>', '<strong style="color: #999;">'),
				'default'  => 'works-category',
				'required' => array( 'cpt-settings-works-enable', '=', '1' ),
			),

			array(
				'id'        => 'cpt-settings-works-archive-settings',
				'type'      => 'info',
				'title'     => esc_html__( 'Works Archive Page Settings', 'charitab-wp' ),
				'notice'    => false,
			),
			array(
				'id'       => 'cpt-settings-works-archive-layout-mode',
				'type'     => 'image_select',
				'title'    => esc_html__( 'Works Layout Mode (FitRows Or Masonry)', 'charitab-wp' ),
				'subtitle' => esc_html__( 'You can position items with different layout modes. Select a layout mode you would like to use.', 'charitab-wp' ),
				'desc'     => '',
				//Must provide key => value(array:title|img) pairs for radio options
				'options'	=> array(
					'fitrows' => array(
						'alt' => 'Fit Rows',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/works/layout-mode/fitrows.png'
					),
					'masonry' => array(
						'alt' => 'Masonry',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/works/layout-mode/masonry.png'
					),
				),
				'default'  => 'masonry'
			),
			array(
				'id'       => 'cpt-settings-works-archive-items-per-row',
				'type'     => 'select',
				'title'    => esc_html__( 'Number of works Per Row', 'charitab-wp' ),
				'subtitle'    => esc_html__( 'Select your default column structure for your works.', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array(
					'1'  => '1 Item Per Row',
					'2'  => '2 Items Per Row',
					'3'  => '3 Items Per Row',
					'4'  => '4 Items Per Row',
					'5'  => '5 Items Per Row',
					'6'  => '6 Items Per Row',
					'7'  => '7 Items Per Row',
					'8'  => '8 Items Per Row',
					'9'  => '9 Items Per Row',
					'10' => '10 Items Per Row',
				),
				'default'=> '2',
			),
			array(
				'id'            => 'cpt-settings-works-archive-items-per-page',
				'type'          => 'slider',
				'title'         => esc_html__( 'Number of works Per Page', 'charitab-wp' ),
				'subtitle'      => esc_html__( 'Controls the number of items to display on works archive pages. Set to -1 to display all. Set to 0 to use the number of posts from Settings > Reading.', 'charitab-wp' ),
				'desc'          => '',
				'default'       => 8,
				'min'           => -1,
				'step'          => 1,
				'max'           => 40,
				'display_value' => 'text',
			),
			array(
				'id'            => 'cpt-settings-works-archive-gutter-size',
				'type'          => 'slider',
				'title'         => esc_html__( 'works Column Spacing (Gutter Size) px', 'charitab-wp' ),
				'subtitle'      => esc_html__( 'Controls column spacing or gutter size between items on works archive pages.', 'charitab-wp' ),
				'desc'          => '',
				'default'       => 30,
				'min'           => 0,
				'step'          => 1,
				'max'           => 250,
				'display_value' => 'text',
			),
		)
	) );




	// -> START Shop Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Woocommerce Shop', 'charitab-wp' ),
		'id'     => 'shop-settings-parent',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-cart',
	) );



	// -> START Shop Archive Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Shop Archive/Category Layout', 'charitab-wp' ),
		'id'     => 'shop-archive-settings',
		'subsection'       => true,
		'desc'   => '',
		'fields' => array(
			array(
				'id'       => 'shop-archive-settings-fullwidth',
				'type'     => 'switch',
				'title'    => esc_html__( 'Page Fullwidth?', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Make the shop page fullwidth or not.', 'charitab-wp' ),
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
			),
			array(
				'id'       => 'shop-archive-settings-sidebar-position',
				'type'     => 'button_set',
				'compiler' =>true,
				'title'    => esc_html__( 'Sidebar Position', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Controls the position of shop sidebar.', 'charitab-wp' ),
				'options'	=> array(
					'left'          => esc_html__( 'Left', 'charitab-wp' ),
					'right'         => esc_html__( 'Right', 'charitab-wp' ),
					'no-sidebar'    => esc_html__( 'No Sidebar', 'charitab-wp' )
				),
				'default'  => 'no-sidebar',
			),




			array(
				'id'       => 'shop-layout-settings-select-shop-catalog-layout',
				'type'     => 'image_select',
				'title'    => esc_html__( 'Shop Catalog Layout', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Select the type of layout you would like to display.', 'charitab-wp' ),
				'desc'     => '',
				//Must provide key => value(array:title|img) pairs for radio options
				'options'	=> array(
					'default' => array(
						'alt' => 'Default',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/shop/type/default.png'
					),
					'classic' => array(
						'alt' => 'Classic',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/shop/type/classic.png'
					),
					'standard' => array(
						'alt' => 'Standard',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/shop/type/standard.png'
					),
				),
				'default'  => 'default'
			),

			array(
				'id'       => 'shop-layout-settings-select-shop-layout-mode',
				'type'     => 'image_select',
				'title'    => esc_html__( 'Shop Layout Mode (FitRows Or Masonry)', 'charitab-wp' ),
				'subtitle' => esc_html__( 'You can position items with different layout modes. Select a layout mode you would like to use.', 'charitab-wp' ),
				'desc'     => '',
				//Must provide key => value(array:title|img) pairs for radio options
				'options'	=> array(
					'fitrows' => array(
						'alt' => 'Fit Rows',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/shop/layout-mode/fitrows.png'
					),
					'masonry' => array(
						'alt' => 'Masonry',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/shop/layout-mode/masonry.png'
					),
				),
				'default'  => 'masonry'
			),


			array(
				'id'       => 'shop-archive-settings-products-per-row',
				'type'     => 'select',
				'title'    => esc_html__( 'Number of Products Per Row', 'charitab-wp' ),
				'subtitle'    => esc_html__( 'Select your default column structure for your shop items.', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array(
					'1'  => '1 Item Per Row',
					'2'  => '2 Items Per Row',
					'3'  => '3 Items Per Row',
					'4'  => '4 Items Per Row',
					'5'  => '5 Items Per Row',
					'6'  => '6 Items Per Row',
					'7'  => '7 Items Per Row',
					'8'  => '8 Items Per Row',
					'9'  => '9 Items Per Row',
					'10' => '10 Items Per Row',
				),
				'default'  => '4',
			),
			array(
				'id'            => 'shop-archive-settings-products-per-page',
				'type'          => 'slider',
				'title'         => esc_html__( 'Number of Products Per Page', 'charitab-wp' ),
				'subtitle'      => esc_html__( 'Controls the number of items to display on shop archive pages. Set to -1 to display all. Set to 0 to use the number of posts from Settings > Reading.', 'charitab-wp' ),
				'desc'          => '',
				'default'       => 10,
				'min'           => -1,
				'step'          => 1,
				'max'           => 40,
				'display_value' => 'text',
			),
			array(
				'id'            => 'shop-archive-settings-products-per-page-dropdown-options',
				'type'          => 'text',
				'title'         => esc_html__( 'WooCommerce Products Per Page Dropdown', 'charitab-wp' ),
				'subtitle'      => esc_html__( 'List of options products per page to show into the select dropdown menu.', 'charitab-wp' ),
				'desc'         => esc_html__( 'Seperated by spaces', 'charitab-wp' ),
				'default'       => '8 16 32 64',
			),
			array(
				'id'            => 'shop-archive-settings-gutter-size',
				'type'          => 'slider',
				'title'         => esc_html__( 'Shop Column Spacing (Gutter Size) px', 'charitab-wp' ),
				'subtitle'      => esc_html__( 'Controls column spacing or gutter size between items on shop archive pages.', 'charitab-wp' ),
				'desc'          => '',
				'default'       => 30,
				'min'           => 0,
				'step'          => 1,
				'max'           => 250,
				'display_value' => 'text',
			),
			array(
				'id'       => 'shop-archive-settings-products-thumb-type',
				'type'     => 'select',
				'title'    => esc_html__( 'Product Thumbnail Type', 'charitab-wp' ),
				'subtitle'    => esc_html__( 'Select your preferred style for your WooCommmerce product thumbnail.', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array(
					'image-featured'  => 'Featured Image',
					'image-swap'  => 'Image Swap',
					'image-gallery'  => 'Gallery Images',
				),
				'default'  => 'image-swap',
			),
		)
	) );



	// -> START Shop Single Product Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Shop Single Product', 'charitab-wp' ),
		'id'     => 'shop-single-product-settings',
		'subsection'       => true,
		'desc'   => '',
		'fields' => array(
			array(
				'id'       => 'shop-single-product-settings-fullwidth',
				'type'     => 'switch',
				'title'    => esc_html__( 'Page Fullwidth?', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Make the single product page fullwidth or not.', 'charitab-wp' ),
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
			),
			array(
				'id'       => 'shop-single-product-settings-sidebar-position',
				'type'     => 'button_set',
				'compiler' =>true,
				'title'    => esc_html__( 'Sidebar Position', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Controls the sidebar position of shop single product page.', 'charitab-wp' ),
				'options'	=> array(
					'left'          => esc_html__( 'Left', 'charitab-wp' ),
					'right'         => esc_html__( 'Right', 'charitab-wp' ),
					'no-sidebar'    => esc_html__( 'No Sidebar', 'charitab-wp' )
				),
				'default'  => 'no-sidebar',
			),



			array(
				'id'       => 'shop-single-product-settings-select-single-catalog-layout',
				'type'     => 'image_select',
				'title'    => esc_html__( 'Product Details Layout', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Select the type of layout you would like to display.', 'charitab-wp' ),
				'desc'     => '',
				//Must provide key => value(array:title|img) pairs for radio options
				'options'	=> array(
					'image-with-thumb' => array(
						'alt' => 'image-with-thumb',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/shop/single-layout/image-with-thumb.png'
					),
					'plain-image' => array(
						'alt' => 'plain-image',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/shop/single-layout/plain-image.png'
					),
					'sticky-side-text' => array(
						'alt' => 'sticky-side-text',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/shop/single-layout/sticky-side-text.png'
					),
				),
				'default'  => 'image-with-thumb'
			),



			array(
				'id'       => 'shop-single-product-settings-product-images-column-width',
				'type'     => 'select',
				'title'    => esc_html__( 'Product Images Column Width', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array(
					'4'     => esc_html__( 'Small - 4/12', 'charitab-wp' ),
					'5'     => esc_html__( 'Medium - 5/12', 'charitab-wp' ),
					'6'     => esc_html__( 'Large - 6/12', 'charitab-wp' ),
					'8'     => esc_html__( 'Extra Large - 8/12', 'charitab-wp' ),
				),
				'default'  => '6',
			),
			array(
				'id'       => 'shop-single-product-settings-product-images-align',
				'type'     => 'select',
				'title'    => esc_html__( 'Product Images Alignment', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array(
					'left'     => esc_html__( 'Left', 'charitab-wp' ),
					'right'    => esc_html__( 'Right', 'charitab-wp' ),
				),
				'default'  => 'left',
			),

			array(
				'id'       => 'shop-single-product-settings-enable-gallery-slider',
				'type'     => 'switch',
				'title'    => esc_html__( 'Enable Image Gallery Slider Feature', 'charitab-wp' ),
				'subtitle' => '',
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
				'required' => array( 'shop-single-product-settings-select-single-catalog-layout', '=', 'image-with-thumb' ),
			),
			array(
				'id'       => 'shop-single-product-settings-enable-gallery-lightbox',
				'type'     => 'switch',
				'title'    => esc_html__( 'Enable Image Gallery Lightbox Feature', 'charitab-wp' ),
				'subtitle' => '',
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
			),
			array(
				'id'       => 'shop-single-product-settings-enable-gallery-zoom',
				'type'     => 'switch',
				'title'    => esc_html__( 'Enable Image Gallery Zoom Feature', 'charitab-wp' ),
				'subtitle' => '',
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
			),




			array(
				'id'       => 'shop-single-product-settings-title-tag',
				'type'     => 'select',
				'title'    => esc_html__( 'Single Product Title Tag', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'options'	=> charitab_mascot_heading_tag_list_all(),
				'default'  => 'h3',
			),
			array(
				'id'       => 'shop-single-product-settings-enable-product-meta',
				'type'     => 'switch',
				'title'    => esc_html__( 'Product Meta', 'charitab-wp' ),
				'subtitle' => '',
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
			),
			array(
				'id'       => 'shop-single-product-settings-enable-sharing',
				'type'     => 'switch',
				'title'    => esc_html__( 'Enable Sharing', 'charitab-wp' ),
				'subtitle' => '',
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
			),

			
			//section Related Posts Starts
			array(
				'id'       => 'shop-single-product-settings-related-products-section-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Related Products', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enable/Disabling this option will show/hide Related Products List/Carousel on your page.', 'charitab-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
			),
			array(
				'id'       => 'shop-single-product-settings-related-products-per-row',
				'type'     => 'select',
				'title'    => esc_html__( 'Related Products Columns', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Set number of columns for related and upsells products only', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array(
					'1'  => '1 Item Per Row',
					'2'  => '2 Items Per Row',
					'3'  => '3 Items Per Row',
					'4'  => '4 Items Per Row',
					'5'  => '5 Items Per Row',
					'6'  => '6 Items Per Row',
					'7'  => '7 Items Per Row',
					'8'  => '8 Items Per Row',
					'9'  => '9 Items Per Row',
					'10' => '10 Items Per Row',
				),
				'default'  => '4',
			),
			array(
				'id'            => 'shop-single-product-settings-related-products-count',
				'type'          => 'text',
				'title'         => esc_html__( 'Related Products Count', 'charitab-wp' ),
				'subtitle'      => esc_html__( 'Number of related products shown on single product page. Enter "0" to disable.', 'charitab-wp' ),
				'default'       => '4',
			),

			array(
				'id'       => 'shop-single-product-settings-related-products-section-ends',
				'type'   => 'section',
				'indent' => false, // Indent all options below until the next 'section' option is set.
			),
		)
	) );



	// -> START WooCommerce Styling Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'WooCommerce Styling', 'charitab-wp' ),
		'id'     => 'woocommerce-styling-settings',
		'subsection'       => true,
		'desc'   => '',
		'fields' => array(
			array(
				'id'       => 'woocommerce-styling-product-price-color',
				'type'     => 'color',
				'title'    => esc_html__( 'Product Price Color', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Select your custom color for product price.', 'charitab-wp' ),
				'transparent' => false,
			),
			array(
				'id'       => 'woocommerce-styling-product-on-sale-tag-bg-color',
				'type'     => 'color',
				'title'    => esc_html__( 'On Sale Tag Background Color', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Select your custom background color for on-sale tag.', 'charitab-wp' ),
				'transparent' => true,
			),
		)
	) );



	// -> START Sidebar Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Sidebar Widgets', 'charitab-wp' ),
		'id'     => 'sidebar-settings',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-align-left',
		'fields' => array(
			array(
				'id'       => 'sidebar-settings-sidebar-padding',
				'type'     => 'spacing',
				// An array of CSS selectors to apply this font style to
				'mode'     => 'padding',
				// absolute, padding, margin, defaults to padding
				'all'      => false,
				// Have one field that applies to all
				'top'           => true,
				'right'         => true,
				'bottom'        => true,
				'left'          => true,
				'units'         => 'px',      // You can specify a unit value. Possible: px, em, %
				//'units_extended'=> 'true',    // Allow users to select any type of unit
				'display_units' => true,   // Set to false to hide the units if the units are specified
				'title'    => esc_html__( 'Sidebar Padding(px)', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Controls the sidebar padding. Please put only integer value. Because the unit \'px\' will be automatically added to the end of the value.', 'charitab-wp' ),
			),
			array(
				'id'       => 'sidebar-settings-sidebar-bg-color',
				'type'     => 'color',
				'title'    => esc_html__( 'Sidebar Background Color', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Controls the background color of sidebar.', 'charitab-wp' ),
				'transparent' => false,
			),
			array(
				'id'       => 'sidebar-settings-sidebar-text-align',
				'type'     => 'select',
				'title'    => esc_html__( 'Sidebar Text Alignment', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array(
					'left'     => esc_html__( 'Left', 'charitab-wp' ),
					'center'   => esc_html__( 'Center', 'charitab-wp' ),
					'right'    => esc_html__( 'Right', 'charitab-wp' ),
				),
				'default'  => '',
			),

			
			//section Related Items Starts
			array(
				'id'       => 'sidebar-settings-sidebar-title-section-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Sidebar Widget Title', 'charitab-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
			),
			array(
				'id'       => 'sidebar-settings-sidebar-title-padding',
				'type'     => 'spacing',
				// An array of CSS selectors to apply this font style to
				'mode'     => 'padding',
				// absolute, padding, margin, defaults to padding
				'all'      => false,
				// Have one field that applies to all
				'top'           => true,
				'right'         => true,
				'bottom'        => true,
				'left'          => true,
				'units'         => 'px',      // You can specify a unit value. Possible: px, em, %
				//'units_extended'=> 'true',    // Allow users to select any type of unit
				'display_units' => true,   // Set to false to hide the units if the units are specified
				'title'    => esc_html__( 'Widget Title Padding(px)', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Controls the sidebar widget title padding. Please put only integer value. Because the unit \'px\' will be automatically added to the end of the value.', 'charitab-wp' ),
			),
			array(
				'id'       => 'sidebar-settings-sidebar-title-bg-color',
				'type'     => 'color',
				'title'    => esc_html__( 'Background Color', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Controls the background color of sidebar widget title box', 'charitab-wp' ),
				'transparent' => false,
			),
			array(
				'id'       => 'sidebar-settings-sidebar-title-text-color',
				'type'     => 'color',
				'title'    => esc_html__( 'Text Color', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Controls the background color of sidebar widget title box', 'charitab-wp' ),
				'transparent' => false,
			),
			array(
				'id'            => 'sidebar-settings-sidebar-title-font-size',
				'type'          => 'text',
				'title'         => esc_html__( 'Font Size(px)', 'charitab-wp' ),
				'subtitle'      => esc_html__( 'Please put only integer value. Because the unit \'px\' will be automatically added to the end of the value.', 'charitab-wp' ),
				'desc'          => '',
			),

			
			array(
				'id'       => 'sidebar-settings-sidebar-title-show-line-bottom',
				'type'     => 'checkbox',
				'title'    => esc_html__( 'Show Line Bottom', 'charitab-wp' ),
				'subtitle' => esc_html__( 'If you enable it then a thin line will be visible below the widget title.', 'charitab-wp' ),
				'desc'     => '',
				'default'  => '1',
			),
			array(
				'id'       => 'sidebar-settings-sidebar-title-line-bottom-theme-colored',
				'type'     => 'select',
				'title'    => esc_html__( 'Make Line Bottom Theme Colored?', 'charitab-wp' ),
				'subtitle' => esc_html__( 'To make the Line Bottom theme colored, please check it.', 'charitab-wp' ),
				'desc'     => '',
				'options'  => charitab_mascot_theme_color_list(),
				'default'  => '1',
				'required' => array( 'sidebar-settings-sidebar-title-show-line-bottom', '=', '1' ),
			),
			array(
				'id'       => 'sidebar-settings-sidebar-title-line-bottom-custom-color',
				'type'     => 'color',
				'title'    => esc_html__( 'Custom Line Bottom Color', 'charitab-wp' ),
				'subtitle' => '',
				'transparent' => false,
				'required' => array( 'sidebar-settings-sidebar-title-line-bottom-theme-colored', '=', '' ),
			),


			array(
				'id'     => 'sidebar-settings-sidebar-title-section-ends',
				'type'   => 'section',
				'indent' => false, // Indent all options below until the next 'section' option is set.
			),
		)
	) );



	// -> START 404 Page Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( '404 Page', 'charitab-wp' ),
		'id'     => '404-page-settings',
		'desc'   => esc_html__( 'Title, content and background settings for 404 Error Page', 'charitab-wp' ),
		'icon'   => 'dashicons-before dashicons-editor-help',
		'fields' => array(
			array(
				'id'       => '404-page-settings-layout',
				'type'     => 'image_select',
				'title'    => esc_html__( 'Choose Layout', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Choose one among different layouts.', 'charitab-wp' ),
				'desc'     => '',
				//Must provide key => value(array:title|img) pairs for radio options
				'options'	=> array(
					'simple' => array(
						'alt' => 'Simple',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/404/simple.jpg'
					),
					'split' => array(
						'alt' => 'Split',
						'img' => CHARITAB_MASCOT_ADMIN_ASSETS_URI . '/images/404/split.jpg'
					),
				),
				'default'  => 'split',
			),
			array(
				'id'       => '404-page-settings-show-header',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Header', 'charitab-wp' ),
				'subtitle' => '',
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
			),
			array(
				'id'       => '404-page-settings-show-footer',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Footer', 'charitab-wp' ),
				'subtitle' => '',
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
			),
			
			array(
				'id'       => '404-page-settings-text-align',
				'type'     => 'select',
				'title'    => esc_html__( 'Text Alignment', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Text Alignment of this page', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> charitab_mascot_redux_text_alignment_list(),
				'default'  => 'text-center',
			),
			array(
				'id'       => '404-page-settings-show-back-to-home-button',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Back to Home Button', 'charitab-wp' ),
				'subtitle' => '',
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
			),
			array(
				'id'       => '404-page-settings-back-to-home-button-label',
				'type'     => 'text',
				'title'    => esc_html__( 'Back to Home Button Label', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => esc_html__( 'Default: "Back to Home"', 'charitab-wp' ),
				'default'  => esc_html__( 'Back to Home', 'charitab-wp' ),
				'required' => array( 
					array( '404-page-settings-show-back-to-home-button', '=', '1' )
				)
			),
			array(
				'id'       => '404-page-settings-show-social-links',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Social Links', 'charitab-wp' ),
				'subtitle' => '',
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
			),





			//section custom background
			array(
				'id'       => '404-page-settings-custom-background-section-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Custom Background', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Define background for 404 page.', 'charitab-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
			),
			array(
				'id'       => '404-page-settings-custom-background-status',
				'type'     => 'switch',
				'title'    => esc_html__( 'Custom Background', 'charitab-wp' ),
				'subtitle' => '',
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
			),
			array(
				'id'       => '404-page-settings-bg',
				'type'     => 'background',
				'title'    => esc_html__( 'Background', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Choose background image or color.', 'charitab-wp' ),
				'required' => array( 
					array( '404-page-settings-custom-background-status', '=', '1' )
				)
			),
			array(
				'id'       => '404-page-settings-bg-layer-overlay-status',
				'type'     => 'switch',
				'title'    => esc_html__( 'Add Background Overlay', 'charitab-wp' ),
				'subtitle' => '',
				'default'  => 0,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
				'required' => array( 
					array( '404-page-settings-custom-background-status', '=', '1' )
				)
			),
			array(
				'id'       => '404-page-settings-bg-layer-overlay',
				'type'          => 'slider',
				'title'         => esc_html__( 'Background Overlay Opacity', 'charitab-wp' ),
				'subtitle'      => esc_html__( 'Overlay on background image on footer.', 'charitab-wp' ),
				'desc'          => '',
				'default'       => 7,
				'min'           => 1,
				'step'          => 1,
				'max'           => 9,
				'display_value' => 'text',
				'required' => array( 
					array( '404-page-settings-custom-background-status', '=', '1' ),
					array( '404-page-settings-bg-layer-overlay-status', '=', '1' )
				)
			),
			array(
				'id'       => '404-page-settings-bg-layer-overlay-color',
				'type'     => 'button_set',
				'compiler' =>true,
				'title'    => esc_html__( 'Background Overlay Color', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Select Dark or White Overlay on background image.', 'charitab-wp' ),
				'options'	=> array(
					''          	=> esc_html__( 'None', 'charitab-wp' ),
					'dark'          => esc_html__( 'Dark', 'charitab-wp' ),
					'white'         => esc_html__( 'White', 'charitab-wp' ),
					'theme-colored1' => esc_html__( 'Primary Theme Color1', 'charitab-wp' ),
					'theme-colored2' => esc_html__( 'Primary Theme Color2', 'charitab-wp' )
				),
				'default' => 'dark',
				'required' => array( 
					array( '404-page-settings-custom-background-status', '=', '1' ),
					array( '404-page-settings-bg-layer-overlay-status', '=', '1' )
				)
			),
			array(
				'id'       => '404-page-settings-custom-background-section-ends',
				'type'     => 'section',
				'title'    => '',
				'subtitle' => '',
				'indent'   => false, // Indent all options below until the next 'section' option is set.
				'required' => array( 
					array( '404-page-settings-custom-background-status', '=', '1' )
				)
			),





			//section Title Starts
			array(
				'id'       => '404-page-settings-title-typography-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Title', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Define text and styles for Title.', 'charitab-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
			),
			array(
				'id'       => '404-page-settings-title',
				'type'     => 'text',
				'title'    => esc_html__( 'Title Text', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Set page title to show', 'charitab-wp' ),
				'desc'     => '',
				'default'  => esc_html__( '404!', 'charitab-wp' ),
			),
			array(
				'id'            => '404-page-settings-title-typography',
				'type'          => 'typography',
				'title'         => esc_html__( 'Title Typography', 'charitab-wp' ),
				'subtitle'      => '',
				//'compiler'    => true,  // Use if you want to hook in your own CSS compiler
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
			),
			array(
				'id'       => '404-page-settings-title-margin-top-bottom',
				'type'     => 'spacing',
				// An array of CSS selectors to apply this font style to
				'mode'     => 'margin',
				// absolute, padding, margin, defaults to padding
				'all'      => false,
				// Have one field that applies to all
				'top'      => true,     // Disable the top
				'right'    => false,     // Disable the right
				'bottom'   => true,     // Disable the bottom
				'left'     => false,     // Disable the left
				'units'    => 'px',      // You can specify a unit value. Possible: px, em, %
				//'units_extended'=> 'true',    // Allow users to select any type of unit
				'display_units' => true,   // Set to false to hide the units if the units are specified
				'title'    => esc_html__( 'Margin Top & Bottom', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
			),
			array(
				'id'       => '404-page-settings-title-typography-ends',
				'type'   => 'section',
				'indent' => false, // Indent all options below until the next 'section' option is set.
			),





			//section Content Starts
			array(
				'id'       => '404-page-settings-content-typography-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Content', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Define text and styles for Content.', 'charitab-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
			),
			array(
				'id'       => '404-page-settings-content',
				'type'     => 'editor',
				'title'    => esc_html__( 'Content Text', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Enter the content for 404 page which will be showed below title.', 'charitab-wp' ),
				'desc'     => '',
				'default'  => esc_html__( 'Sorry - The page you are looking for no longer exists. Perhaps you can return back to the site\'s homepage and see if you can find what you are looking for.', 'charitab-wp' ),
			),
			array(
				'id'            => '404-page-settings-content-typography',
				'type'          => 'typography',
				'title'         => esc_html__( 'Content Typography', 'charitab-wp' ),
				'subtitle'      => '',
				//'compiler'    => true,  // Use if you want to hook in your own CSS compiler
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
			),
			array(
				'id'       => '404-page-settings-content-margin-top-bottom',
				'type'     => 'spacing',
				// An array of CSS selectors to apply this font style to
				'mode'     => 'margin',
				// absolute, padding, margin, defaults to padding
				'all'      => false,
				// Have one field that applies to all
				'top'      => true,     // Disable the top
				'right'    => false,     // Disable the right
				'bottom'   => true,     // Disable the bottom
				'left'     => false,     // Disable the left
				'units'    => 'px',      // You can specify a unit value. Possible: px, em, %
				//'units_extended'=> 'true',    // Allow users to select any type of unit
				'display_units' => true,   // Set to false to hide the units if the units are specified
				'title'    => esc_html__( 'Margin Top & Bottom', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
			),
			array(
				'id'       => '404-page-settings-content-typography-ends',
				'type'   => 'section',
				'indent' => false, // Indent all options below until the next 'section' option is set.
			),




			//section Helpful Links Starts
			array(
				'id'       => '404-page-settings-helpful-links-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Helpful Links', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Define text and styles for helpful links.', 'charitab-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
			),
			array(
				'id'       => '404-page-settings-show-helpful-links',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Helpful Links', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => sprintf( esc_html__( 'Please create a new menu from %1$sAppearance > Menus%2$s and set Theme Location %1$s"Page 404 Helpful Links"%2$s', 'charitab-wp' ), '<strong>', '</strong>', '<br>'),
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
			),
			array(
				'id'       => '404-page-settings-helpful-links-heading',
				'type'     => 'text',
				'title'    => esc_html__( 'Heading Text', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Set heading text to show', 'charitab-wp' ),
				'desc'     => '',
				'default'  => esc_html__( 'Helpful Links', 'charitab-wp' ),
				'required' => array( 
					array( '404-page-settings-show-helpful-links', '=', '1' )
				)
			),
			array(
				'id'            => '404-page-settings-helpful-links-heading-typography',
				'type'          => 'typography',
				'title'         => esc_html__( 'Heading Typography', 'charitab-wp' ),
				'subtitle'      => '',
				//'compiler'    => true,  // Use if you want to hook in your own CSS compiler
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
				'required' => array( 
					array( '404-page-settings-show-helpful-links', '=', '1' )
				)
			),
			array(
				'id'            => '404-page-settings-helpful-links-typography',
				'type'          => 'typography',
				'title'         => esc_html__( 'Links Typography', 'charitab-wp' ),
				'subtitle'      => '',
				//'compiler'    => true,  // Use if you want to hook in your own CSS compiler
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
				'required' => array( 
					array( '404-page-settings-show-helpful-links', '=', '1' )
				)
			),
			array(
				'id'       => '404-page-settings-helpful-links-ends',
				'type'   => 'section',
				'indent' => false, // Indent all options below until the next 'section' option is set.
			),




			//section Search Box Starts
			array(
				'id'       => '404-page-settings-search-box-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Search Box', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Define text and styles for search box.', 'charitab-wp' ),
				'indent'   => true, // Indent all options below until the next 'section' option is set.
			),
			array(
				'id'       => '404-page-settings-show-search-box',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Search Box', 'charitab-wp' ),
				'subtitle' => '',
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
			),
			array(
				'id'       => '404-page-settings-search-box-heading',
				'type'     => 'text',
				'title'    => esc_html__( 'Heading Text', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Set heading text to show', 'charitab-wp' ),
				'desc'     => '',
				'default'  => esc_html__( 'Search Website', 'charitab-wp' ),
				'required' => array( 
					array( '404-page-settings-show-search-box', '=', '1' )
				)
			),
			array(
				'id'       => '404-page-settings-search-box-paragraph',
				'type'     => 'textarea',
				'title'    => esc_html__( 'Paragraph Text', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Set paragraph text to show', 'charitab-wp' ),
				'desc'     => '',
				'default'  => esc_html__( 'Please use the search box to find what you are looking for. Perhaps searching can help.', 'charitab-wp' ),
				'required' => array( 
					array( '404-page-settings-show-search-box', '=', '1' )
				)
			),
			array(
				'id'            => '404-page-settings-search-box-heading-typography',
				'type'          => 'typography',
				'title'         => esc_html__( 'Heading Typography', 'charitab-wp' ),
				'subtitle'      => '',
				//'compiler'    => true,  // Use if you want to hook in your own CSS compiler
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
				'required' => array( 
					array( '404-page-settings-show-search-box', '=', '1' )
				)
			),
			array(
				'id'            => '404-page-settings-search-box-paragraph-typography',
				'type'          => 'typography',
				'title'         => esc_html__( 'Paragraph Typography', 'charitab-wp' ),
				'subtitle'      => '',
				//'compiler'    => true,  // Use if you want to hook in your own CSS compiler
				'google'        => true,
				// Disable google fonts. Won't work if you haven't defined your google api key
				'font-backup'   => false,
				// Select a backup non-google font in addition to a google font
				'font-style'    => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'font-weight'   => true, // Includes font-style and weight. Can use font-style or font-weight to declare
				'subsets'       => false, // Only appears if google is true and subsets not set to false
				'font-size'     => true,
				'line-height'   => true,
				'word-spacing'  => true,  // Defaults to false
				'letter-spacing'=> true,  // Defaults to false
				'text-transform'=> true,  // Defaults to false
				'color'         => true,
				'preview'       => true, // Disable the previewer
				'all_styles'    => true,
				'units'         => 'px',
				'required' => array( 
					array( '404-page-settings-show-search-box', '=', '1' )
				)
			),
			array(
				'id'       => '404-page-settings-search-box-ends',
				'type'   => 'section',
				'indent' => false, // Indent all options below until the next 'section' option is set.
			),
		)
	) );


	if( charitab_mascot_core_plugin_installed() && function_exists( 'mascot_core_charitab_redux_opt_maintenance_section' ) ) {
		Redux::setSection( $opt_name, mascot_core_charitab_redux_opt_maintenance_section() );
	}


	// -> START Social Links Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Social Links', 'charitab-wp' ),
		'id'     => 'social-links',
		'desc'   => esc_html__( 'This is your official social links. Set the order of social links to be appeared in the header/footer section.', 'charitab-wp' ),
		'icon'   => 'dashicons-before dashicons-facebook-alt',
		'fields' => $redux_config_social_links_arraylist
	) );



	// -> START Sharing Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Sharing Settings', 'charitab-wp' ),
		'id'     => 'sharing-settings',
		'desc'   => esc_html__( 'Enable/Disable social sharing buttons for posts, pages and portfolio single pages', 'charitab-wp' ),
		'icon'   => 'dashicons-before dashicons-share',
		'fields' => array(
			array(
				'id'       => 'sharing-settings-enable-sharing',
				'type'     => 'switch',
				'title'    => esc_html__( 'Enable Sharing', 'charitab-wp' ),
				'subtitle' => '',
				'default'  => 1,
				'on'       => esc_html__( 'Yes', 'charitab-wp' ),
				'off'      => esc_html__( 'No', 'charitab-wp' ),
			),

			array(
				'id'       => 'sharing-settings-heading',
				'type'     => 'text',
				'title'    => esc_html__( 'Sharing Heading', 'charitab-wp' ),
				'subtitle' => esc_html__( 'Your custom text for the social sharing heading.', 'charitab-wp' ),
				'desc'     => '',
				'default'  => esc_html__( 'Share On:', 'charitab-wp' ),
				'required' => array( 'sharing-settings-enable-sharing', '=', '1' ),
			),
			array(
				'id'       => 'sharing-settings-icon-type',
				'type'     => 'button_set',
				'title'    => esc_html__( 'Sharing Icon Type', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'options'	=> array(
					'text'          => 'Text',
					'icon'          => 'Flat Icon',
					'icon-brand'    => 'Icon with Brand Color',
				),
				'default'  => 'icon-brand',
				'required' => array( 'sharing-settings-enable-sharing', '=', '1' ),
			),

			//Buttons Type Icon
			array(
				'id'       => 'sharing-settings-social-links-color',
				'type'     => 'button_set',
				'title'    => esc_html__( 'Sharing Links - Background Color', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array(
					'icon-gray'     => esc_html__( 'Gray', 'charitab-wp' ),
					'icon-dark'     => esc_html__( 'Dark', 'charitab-wp' ),
					'icon-white'    => esc_html__( 'White', 'charitab-wp' ),
					''              => esc_html__( 'Default', 'charitab-wp' ),
				),
				'default'  => 'icon-gray',
				'required' => array( 
					array( 'sharing-settings-icon-type', '=', 'icon' ),
				)
			),
			array(
				'id'       => 'sharing-settings-social-links-icon-style',
				'type'     => 'button_set',
				'title'    => esc_html__( 'Sharing Icons Style', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array(
					'icon-rounded'   => esc_html__( 'Rounded', 'charitab-wp' ),
					'icon-default'	 => esc_html__( 'Default', 'charitab-wp' ),
					'icon-circled'   => esc_html__( 'Circled', 'charitab-wp' ),
				),
				'default'  => 'icon-circled',
				'required' => array( 'sharing-settings-icon-type', '!=', 'text' ),
			),
			array(
				'id'       => 'sharing-settings-social-links-icon-size',
				'type'     => 'button_set',
				'title'    => esc_html__( 'Sharing Icons Size', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array(
					''          => esc_html__( 'Default', 'charitab-wp' ),
					'icon-xs'   => esc_html__( 'Extra Small', 'charitab-wp' ),
					'icon-sm'	=> esc_html__( 'Small', 'charitab-wp' ),
					'icon-md'   => esc_html__( 'Medium', 'charitab-wp' ),
					'icon-lg'   => esc_html__( 'Large', 'charitab-wp' ),
					'icon-xl'   => esc_html__( 'Extra Large', 'charitab-wp' ),
				),
				'default'  => 'icon-sm',
				'required' => array( 'sharing-settings-icon-type', '!=', 'text' ),
			),
			array(
				'id'       => 'sharing-settings-social-links-icon-animation-effect',
				'type'     => 'button_set',
				'title'    => esc_html__( 'Icons Animation Effect', 'charitab-wp' ),
				'desc'     => '',
				'options'	=> array(
					'styled-icons-effect-rollover'   => esc_html__( 'Roll Over', 'charitab-wp' ),
					''                               => esc_html__( 'Default', 'charitab-wp' ),
					'styled-icons-effect-rotate'     => esc_html__( 'Rotate', 'charitab-wp' ),
				),
				'default'  => '',
				'required' => array( 'sharing-settings-icon-type', '!=', 'text' ),
			),
			array(
				'id'       => 'sharing-settings-social-links-icon-border-style',
				'type'     => 'checkbox',
				'title'    => esc_html__( 'Make Sharing Icon Area Bordered?', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'default'  => '0',
				'required' => array( 
					array( 'sharing-settings-social-links-color', '!=', 'brand-color' ),
				)
			),
			array(
				'id'       => 'sharing-settings-social-links-theme-colored',
				'type'     => 'select',
				'title'    => esc_html__( 'Make Sharing Icons Theme Colored?', 'charitab-wp' ),
				'subtitle' => esc_html__( 'To make the sharing icons theme colored, please check it.', 'charitab-wp' ),
				'desc'     => '',
				'options'  => charitab_mascot_theme_color_list(),
				'default'  => '',
				'required' => array( 
					array( 'sharing-settings-social-links-color', '!=', 'brand-color' ),
				)
			),





			array(
				'id'       => 'sharing-settings-show-social-share-on',
				'type'     => 'checkbox',
				'title'    => esc_html__( 'Show Social Share On', 'charitab-wp' ),
				'subtitle'     => '',
				'desc' => '',
				//Must provide key => value pairs for multi checkbox options
				'options'	=> array(
					'show-on-posts'     => esc_html__( 'Posts', 'charitab-wp' ),
					'show-on-pages'     => esc_html__( 'Pages', 'charitab-wp' ),
					'show-on-tribe-events'     => esc_html__( 'Tribe Events', 'charitab-wp' ),
					'show-on-portfolio' => esc_html__( 'Portfolio', 'charitab-wp' ),
				),
				//See how std has changed? you also don't need to specify opts that are 0.
				'default'  => array(
					'show-on-posts' => '1',
					'show-on-pages' => '1',
					'show-on-tribe-events' => '1',
					'show-on-portfolio' => '1',
				),
				'required' => array( 'sharing-settings-enable-sharing', '=', '1' ),
			),
			array(
				'id'       => 'sharing-settings-networks',
				'type'     => 'sorter',
				'title'    => esc_html__( 'Seleted Social Networks', 'charitab-wp' ),
				'desc'     => '',
				'compiler' => 'true',
				'options'	=> array(
					'Enabled' => array(
						'twitter'    => 'Twitter',
						'facebook'   => 'Facebook',
						'googleplus' => 'Google+',
						'linkedin'   => 'Linkedin',
						'email'      => 'Email',
					),
					'Disabled'  => array(
						'tumblr'     => 'Tumblr',
						'pinterest'  => 'Pinterest',
						'vk'        => 'VK',
						'reddit'    => 'Reddit',
						'print'     => 'Print',
					),
				),
				'required' => array( 'sharing-settings-enable-sharing', '=', '1' ),
			),

			//section Social Network URLs Starts
			array(
				'id'       => 'sharing-settings-icon-tooltip-starts',
				'type'     => 'section',
				'title'    => esc_html__( 'Sharing Icon Tooltip', 'charitab-wp' ),
				'subtitle' => '',
				'indent'   => true, // Indent all options below until the next 'section' option is set.
				'required' => array( 'sharing-settings-enable-sharing', '=', '1' ),
			),

			array(
				'id'       => 'sharing-settings-tooltip-directions',
				'type'     => 'button_set',
				'title'    => esc_html__( 'Tooltip Text Directions', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'options'	=> array(
					'top'    => 'Top',
					'right'  => 'Right',
					'bottom' => 'Bottom',
					'left'   => 'Left',
					'none'   => 'None',
				),
				'default'  => 'top',
			),
			array(
				'id'       => 'sharing-settings-tooltip-twitter',
				'type'     => 'text',
				'title'    => esc_html__( 'Tooltip text for Twitter', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'default'  => esc_html__( 'Share on Twitter', 'charitab-wp' ),
			),
			array(
				'id'       => 'sharing-settings-tooltip-facebook',
				'type'     => 'text',
				'title'    => esc_html__( 'Tooltip text for Facebook', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'default'  => esc_html__( 'Share on Facebook', 'charitab-wp' ),
			),
			array(
				'id'       => 'sharing-settings-tooltip-googleplus',
				'type'     => 'text',
				'title'    => esc_html__( 'Tooltip text for Google+', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'default'  => esc_html__( 'Share on Google+', 'charitab-wp' ),
			),
			array(
				'id'       => 'sharing-settings-tooltip-linkedin',
				'type'     => 'text',
				'title'    => esc_html__( 'Tooltip text for LinkedIn', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'default'  => esc_html__( 'Share on LinkedIn', 'charitab-wp' ),
			),
			array(
				'id'       => 'sharing-settings-tooltip-tumblr',
				'type'     => 'text',
				'title'    => esc_html__( 'Tooltip text for Tumblr', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'default'  => esc_html__( 'Share on Tumblr', 'charitab-wp' ),
			),
			array(
				'id'       => 'sharing-settings-tooltip-email',
				'type'     => 'text',
				'title'    => esc_html__( 'Tooltip text for Email', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'default'  => esc_html__( 'Share on Email', 'charitab-wp' ),
			),
			array(
				'id'       => 'sharing-settings-tooltip-vk',
				'type'     => 'text',
				'title'    => esc_html__( 'Tooltip text for VKontakte', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'default'  => esc_html__( 'Share on VKontakte', 'charitab-wp' ),
			),
			array(
				'id'       => 'sharing-settings-tooltip-pinterest',
				'type'     => 'text',
				'title'    => esc_html__( 'Tooltip text for Pinterest', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'default'  => esc_html__( 'Share on Pinterest', 'charitab-wp' ),
			),
			array(
				'id'       => 'sharing-settings-tooltip-reddit',
				'type'     => 'text',
				'title'    => esc_html__( 'Tooltip text for Reddit', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'default'  => esc_html__( 'Share on Reddit', 'charitab-wp' ),
			),
			array(
				'id'       => 'sharing-settings-tooltip-print',
				'type'     => 'text',
				'title'    => esc_html__( 'Tooltip text for Print', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
				'default'  => esc_html__( 'Print This Page', 'charitab-wp' ),
			),
			array(
				'id'       => 'sharing-settings-icon-tooltip-ends',
				'type'   => 'section',
				'indent' => false, // Indent all options below until the next 'section' option is set.
			),

		)
	) );



	// -> START Twitter API Settings
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'API Settings', 'charitab-wp' ),
		'id'     => 'theme-api-settings',
		'desc'  => esc_html__( 'Fill the following fields if you want to use these features', 'charitab-wp' ),
		'icon'   => 'dashicons-before dashicons-admin-network',
		'fields' => array(
			array(
				'id'        => 'theme-api-settings-gmaps',
				'type'      => 'info',
				'title'     => esc_html__( 'Google Maps API Settings', 'charitab-wp' ),
				'subtitle'  => esc_html__( 'Fill the following field if you want to use Google Maps', 'charitab-wp' ),
				'notice'    => false,
			),
			array(
				'id'       => 'theme-api-settings-gmaps-api-key',
				'type'     => 'text',
				'title'    => esc_html__( 'Google Maps API Key', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
			),


			array(
				'id'        => 'theme-api-settings-twitter',
				'type'      => 'info',
				'title'     => esc_html__( 'Twitter API Settings', 'charitab-wp' ),
				'subtitle'  => sprintf( esc_html__('Fill the following fields if you want to use Twitter Feed Widget. You can collect those keys by creating your own Twitter API from here %s%s', 'charitab-wp'), '<a target="_blank" class="text-white" href="' . esc_url( 'https://dev.twitter.com/apps' ) . '">', '</a>' ),
				'notice'    => false,
			),

			array(
				'id'       => 'theme-api-settings-twitter-api-key',
				'type'     => 'text',
				'title'    => esc_html__( 'Twitter API Key', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
			),
			array(
				'id'       => 'theme-api-settings-twitter-api-secret',
				'type'     => 'text',
				'title'    => esc_html__( 'Twitter API Secret', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
			),

			array(
				'id'       => 'theme-api-settings-twitter-api-access-token',
				'type'     => 'text',
				'title'    => esc_html__( 'Twitter Access Token', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
			),
			array(
				'id'       => 'theme-api-settings-twitter-api-access-token-secret',
				'type'     => 'text',
				'title'    => esc_html__( 'Twitter Access Token Secret', 'charitab-wp' ),
				'subtitle' => '',
				'desc'     => '',
			),
		)
	) );



	// -> START Custom HTML/JS Codes
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Custom HTML/JS Codes', 'charitab-wp' ),
		'id'     => 'custom-codes',
		'desc'   => '',
		'icon'   => 'dashicons-before dashicons-editor-code',
		'fields' => array(
			array(
				'id'       => 'custom-codes-custom-html-script-header',
				'type'     => 'ace_editor',
				'title'    => esc_html__( 'Custom HTML/JS Code - in Header before &lt;/head&gt; tag', 'charitab-wp' ),
				'subtitle' => esc_html__( 'If you have any custom HTML or JS Code you would like to add in the header before &lt;/head&gt; tag of the site then please enter it here. Only accepts javascript code wrapped with &lt;script&gt; tags and valid HTML markup.', 'charitab-wp' ),
				'mode'     => 'javascript',
				'theme'    => 'chrome',
				'desc'     => '',
				'default'     => '',
			),
			array(
				'id'       => 'custom-codes-custom-html-script-footer',
				'type'     => 'ace_editor',
				'title'    => esc_html__( 'Custom HTML/JS Code - in Footer before &lt;/body&gt; tag', 'charitab-wp' ),
				'subtitle' => esc_html__( 'If you have any custom HTML or JS Code you would like to add in the footer before &lt;/body&gt; tag of the site then please enter it here. Only accepts javascript code wrapped with &lt;script&gt; tags and valid HTML markup.', 'charitab-wp' ),
				'mode'     => 'javascript',
				'theme'    => 'chrome',
				'desc'     => '',
				'default'     => '',
			)
		)
	) );
	
	
	/*
	 * <--- END SECTIONS
	 */

