<?php if ( $the_query->have_posts() ) : ?>

<!-- Portfolio Grid -->
<div id="grid" class="tm-widget tm-widget-portfolio tm-widget-portfolio-grid isotope-layout grid-3 gutter clearfix <?php echo esc_attr( $custom_css_class );?>">
	<!-- the loop -->
	<?php while ( $the_query->have_posts() ) : $the_query->the_post(); ?>
	<?php
		$full_image_url = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full' );
		$full_image_url = $full_image_url[0];

		$portfolio_images = charitab_mascot_get_rwmb_group_advanced( 'charitab_mascot_' . "portfolio_mb_gallery_images_settings",  "gallery_images", null, false, 'all' );
		//if has no post thumbnail
		if( !has_post_thumbnail( get_the_ID() ) ) {
			if ( !empty( $portfolio_images ) ) {
				$first_image_key = key($portfolio_images);
				$full_image_url = $portfolio_images[$first_image_key]['url'];
			}
		}

		//thumb image
		$thumb_url = wp_get_attachment_image_src( get_post_thumbnail_id(), 'charitab_mascot_square_150' );
		$thumb_url = $thumb_url[0];

		// if has no post thubnail or gallery images then add placeholder image
		if( empty( $thumb_url ) ) {
		$thumb_url = array();
		$full_image_url = $thumb_url['url'] = "//placehold.it/250x250?text=Image Not Found!";
		}
	?>
	<!-- Portfolio Item Start -->
	<div class="isotope-item box-hover-effect">
		<div class="effect-wrapper">
			<div class="thumb">
				<img src="<?php echo esc_url( $thumb_url );?>" alt="<?php the_title_attribute(); ?>">
			</div>
			<div class="overlay-shade"></div>
			<div class="icons-holder icons-holder-middle">
				<div class="icons-holder-inner">
					<div class="styled-icons icon-sm icon-dark icon-circled icon-theme-colored1">
						<a href="<?php the_permalink(); ?>"><i class="fa fa-link"></i></a>
					</div>
				</div>
			</div>
			<a title="<?php the_title_attribute(); ?>" href="<?php the_permalink();?>" class="hover-link"></a>
		</div>
	</div>
	<!-- Portfolio Item End -->
	<?php endwhile; ?>
	<!-- end of the loop -->
</div>
<!-- End Portfolio Grid -->
<?php wp_reset_postdata(); ?>

<?php else : ?>
	<?php charitab_mascot_no_posts_match_criteria_text(); ?>
<?php endif; ?>