<?php

if(!function_exists('mascot_core_charitab_sc_unordered_list_vc_map_modifier')) {
	/**
	 * Shortcodes vc_map modifier
	 */
	function mascot_core_charitab_sc_unordered_list_vc_map_modifier( $shortcode_base ) {
		//vc_remove_param( $shortcode_base, "display_type" );
		//vc_add_param( $shortcode_base, $attributes );
		//vc_add_params( $shortcode_base, $attributes );
	}
}



if(!function_exists('mascot_core_charitab_sc_unordered_list_render')) {
	/**
	 * Renders shortcodes HTML
	 */
	function mascot_core_charitab_sc_unordered_list_render( $attr, $content = null ) {

		$args = array(
			'custom_css_class' => '',
			'design_style' => '',

			'text_text_color' => '',
			'text_font_size' => '',
			'text_line_height' => '',
			'text_letter_spacing' => '',
			'text_font_style' => '',
			'text_font_weight' => '',
			'text_text_transform' => '',
		);
		$params = shortcode_atts($args, $attr);
		$params['content'] = $content;
		$params['text_inline_css'] = charitab_mascot_get_inline_css( mascot_core_charitab_sc_sc_unordered_list_text_css( $params ) );

		//classes
		$classes = array();
		$classes[] = 'tm-sc tm-sc-unordered-list';
		$classes[] = $params['design_style'];
		$classes[] = $params['custom_css_class'];

		$params['classes'] = $classes;

		//Produce HTML version by using the parameters (filename, variation, folder name, parameters, shortcode_ob_start)
		$html = charitab_mascot_get_shortcode_template_part( 'unordered-list', null, 'unordered-list/tpl', $params, true );
		
		return $html;
	}
}


if(!function_exists('mascot_core_charitab_sc_sc_unordered_list_text_css')) {
	/**
	 * Get Text Styles
	 */
	function mascot_core_charitab_sc_sc_unordered_list_text_css( $params ) {
		$css_array = array();

		if( $params['text_text_color'] != '' ) {
			$css_array[] = 'color: '.$params['text_text_color'];
		}
		if( $params['text_font_size'] != '' ) {
			$font_size = $params['text_font_size'];
			$css_array[] = 'font-size: '.charitab_mascot_if_numeric_add_suffix($font_size, 'px');
		}
		if( $params['text_line_height'] != '' ) {
			$font_size = $params['text_line_height'];
			$css_array[] = 'line-height: '.$font_size;
		}
		if( $params['text_letter_spacing'] != '' ) {
			$font_size = $params['text_letter_spacing'];
			$css_array[] = 'letter-spacing: '.$font_size;
		}
		if( $params['text_font_style'] != '' ) {
			$css_array[] = 'font-style: '.$params['text_font_style'];
		}
		if( $params['text_font_weight'] != '' ) {
			$css_array[] = 'font-weight: '.$params['text_font_weight'];
		}
		if( $params['text_text_transform'] != '' ) {
			$css_array[] = 'text-transform: '.$params['text_text_transform'];
		}

		return implode( '; ', $css_array );
	}
}