
<?php if ( $the_query->have_posts() ) : ?>
	<div class="row tm-sc tm-sc-tribe-events tm-sc-tribe-events-fullwidth <?php echo esc_attr(implode(' ', $classes)); ?>">
		<!-- the loop -->
		<div id="<?php echo esc_attr( $holder_id ) ?>" class="clearfix">
			<div class="row">
				<?php while ( $the_query->have_posts() ) : $the_query->the_post(); ?>
				<div class="col-md-12">
					<div id="post-<?php the_ID() ?>" class="event <?php tribe_events_event_classes() ?>">
						<div class="row">
							<div class="col-sm-2">
								<?php if ( $vertical_show_left_date == 'true' ) : ?>
								<div class="event-date">
									<span class="day"><?php echo tribe_get_start_date( get_the_ID(), false, 'd' ) ?></span>
									<span class="month"><?php echo tribe_get_start_date( get_the_ID(), false, 'F' ) ?></span>
									<!-- <span class="year"><?php echo tribe_get_start_date( get_the_ID(), false, 'Y' ) ?></span> -->
								</div>
								<?php endif; ?>
							</div>
							<div class="col-sm-7">
								<div class="event-content">
									<?php if ( $show_title == 'true' ) : ?>
									<h4 class="event-title">
										<a href="<?php echo esc_url( tribe_get_event_link() ); ?>" title="<?php the_title_attribute(); ?>">
											<?php the_title() ?>
										</a>
									</h4>
									<?php endif; ?>

									<?php if ( $show_meta == 'true' ) : ?>
									<?php charitab_mascot_get_shortcode_template_part( 'parts-event-meta', null, 'tribe-events/tpl', $params, false );?>
									<?php endif; ?>

									<?php if ( $show_excerpt == 'true' ) : ?>
									<div class="event-excerpt">
										<?php if ( empty($excerpt_length) ) { ?>
										<?php echo tribe_events_get_the_excerpt( null, wp_kses_allowed_html( 'post' ) ); ?>
										<?php } else { ?>
										<?php $excerpt = tribe_events_get_the_excerpt( null, wp_kses_allowed_html( 'post' ) ); echo wp_kses_post( charitab_mascot_slice_excerpt_by_length( $excerpt, $excerpt_length ) ); ?>
										<?php } ?>
									</div>
									<?php endif; ?>
								</div>
							</div>
							<div class="col-sm-3">
								<?php if ( $show_view_details_button == 'true' ) : ?>
								<?php charitab_mascot_get_shortcode_template_part( 'button', null, 'tribe-events/tpl', $params, false );?>
								<?php endif; ?>
							</div>
						</div>
					</div>
				</div>
				<?php endwhile; ?>
				<!-- end of the loop -->
			</div>
		</div>
	</div>
	<?php wp_reset_postdata(); ?>
		
	<?php charitab_mascot_get_shortcode_template_part( 'show-more-btn', null, 'tribe-events/tpl', $params, false ); ?>

<?php else : ?>
	<?php charitab_mascot_no_posts_match_criteria_text(); ?>
<?php endif; ?>