<?php

if(!function_exists('mascot_core_charitab_sc_tribe_events_vc_map_modifier')) {
	/**
	 * Shortcodes vc_map modifier
	 */
	function mascot_core_charitab_sc_tribe_events_vc_map_modifier( $shortcode_base ) {
		//vc_remove_param( $shortcode_base, "display_type" );
		//vc_add_param( $shortcode_base, $attributes );
		//vc_add_params( $shortcode_base, $attributes );
	}
}



if(!function_exists('mascot_core_charitab_sc_tribe_events_render')) {
	/**
	 * Renders shortcodes HTML
	 */
	function mascot_core_charitab_sc_tribe_events_render( $attr, $content = null, $class_instance ) {
		$class_instance =  (array) $class_instance;
		
		$args = array(
			'custom_css_class' => '',
			'display_type' => '',
			'columns' => '4',

			'vertical_show_left_thumb' => 'false',
			'vertical_left_thumb_image_size' => 'charitab_mascot_square_120',
			'vertical_show_left_date' => 'true',
			'vertical_left_date_block_theme_colored' => '1',
			'vertical_left_date_block_size' => 'date-block-big',
			'vertical_left_date_block_border' => false,


			'vertical_slide_show_navigation' => 'true',
			'vertical_slide_navigation_arrow_position' => 'bottom',
			'vertical_slide_minslides' => '3',
			'vertical_slide_autoplay' => 'true',

			'show_navigation' => 'true',
			'show_bullets' => 'true',
			'bullets_skin' => 'owl-dots-light-skin',
			'bullets_alignment' => 'owl-dots-center',
			'carousel_autoplay' => 'true',
			'carousel_loop' => 'true',
			'animation_speed' => '6000',
			'margin' => '30',
			'laptop' => '',
			'tablet' => '',

			'total_items' => '4',
			'category' => '',
			'order_by' => 'date',
			'order' => 'DESC',

			'show_title' => 'true',
			'show_meta' => 'true',
			'meta_options' => 'show-time',
			
			'show_excerpt' => 'true',
			'excerpt_length'	=> '',
			'show_thumb' => 'true',
			'feature_thumb_image_size' => 'post-thumbnail',


			//cat filter
			'show_cat_filter' => 'false',
			'cat_filter_style' => '',
			'cat_filter_alignment' => '',

			
			'show_view_details_button' => 'true',
			'view_details_button_text' => esc_html__( 'View Details', 'charitab-wp' ),
			

			'btn_design_style' => 'default',
			'button_size' => '',
			'btn_outlined' => false,
			'btn_round' => false,
			'btn_flat' => false,
			'btn_block' => false,
			'btn_threed_effect' => false,
			'button_alignment' => '',
			'button_hover_animation_effect' => '',


			//loadmore button options
			'loadmore_show_view_details_button' => 'false',
			'loadmore_view_details_button_text' => esc_html__( 'Load More', 'charitab-wp' ),
			'loadmore_button_loading_text' => esc_html__( 'Loading...', 'charitab-wp' ),
			'loadmore_btn_design_style' => 'default',
			'loadmore_button_size' => '',
			'loadmore_btn_outlined' => false,
			'loadmore_btn_round' => false,
			'loadmore_btn_flat' => false,
			'loadmore_btn_block' => false,
			'loadmore_btn_threed_effect' => false,
			'loadmore_button_alignment' => '',
			'loadmore_button_hover_animation_effect' => '',


			'css' => '',

		);
		$params = shortcode_atts($args, $attr);
		$params['holder_id'] = charitab_mascot_get_isotope_holder_ID('events');

		if (  $params['loadmore_show_view_details_button'] === 'true' ) {
			$holder_id = str_replace('-', '_', $params['holder_id']);
			$params['holder_id_underline'] = $holder_id;
			$params['wp_ajax_load_for_cpt'] = 'tribe_events';

			wp_enqueue_script( 'charitab-mascot-custom-loadmore', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/tm-custom-loadmore.js', array('jquery'), false, true );
			wp_localize_script( 'charitab-mascot-custom-loadmore', 'tm_loadmore_params_'.$holder_id, array(
				'ajaxurl' => site_url() . '/wp-admin/admin-ajax.php',

				'class_instance' => $class_instance,
				'params' => $params,

				'current_page' => get_query_var( 'paged' ) ? get_query_var('paged') : 1,
			) );
			wp_enqueue_script( 'charitab-mascot-custom-loadmore' );
		}


		return mascot_core_charitab_sc_tribe_events_render_output( $class_instance, $params );
	}
}


if(!function_exists('mascot_core_charitab_sc_tribe_events_render_output')) {
	/**
	 * Output render
	 */
	function mascot_core_charitab_sc_tribe_events_render_output( $class_instance, $params ) {
		$new_cpt_class = $class_instance;
		$paged = isset($params['paged']) ? $params['paged'] : '';

		//query args
		$args = array(
			'post_type' => 'tribe_events',
			'orderby' => $params['order_by'],
			'order' => $params['order'],
			'posts_per_page' => $params['total_items'],
			'paged' => $paged,
		);

		//if category selected
		if( ! empty( $params['category'] ) ) {
			$args['tax_query'] = array(
				array(
					'taxonomy' => 'tribe_events_cat',
					'field'	=> 'slug',
					'terms'	=> explode(',', $params['category']),
				)
			);
		}

		$the_query = new \WP_Query( $args );
		$params['the_query'] = $the_query;
		
		if ( !$the_query->have_posts() && $params['from_loadmore_ajax_handler'] === true ) {
			return;
		}


		//classes
		$classes = array();
		if( $params['display_type'] == 'list-vertical-slide' && $params['vertical_slide_show_navigation'] != 'false' ) {
			$classes[] = 'has-nav-arrow nav-arrow-position-' . $params['vertical_slide_navigation_arrow_position'];
		}
		if( $params['display_type'] == 'carousel' ) {
			$classes[] = $params['bullets_skin'];
			$classes[] = $params['bullets_alignment'];
		}
		$classes[] = $params['custom_css_class'];
		$classes[] = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $params['css'], ' ' ) );
		$params['classes'] = $classes;

		//button classes
		$params['btn_classes'] = charitab_mascot_prepare_button_classes_from_params( $params );
		$params['loadmore_btn_classes'] = charitab_mascot_prepare_button_classes_from_params( $params, 'loadmore_' );


		//event-date classes
		$event_left_classes = array();
		if( $params['vertical_left_date_block_size'] ) {
			$event_left_classes[] = $params['vertical_left_date_block_size'];
		}
		if( $params['vertical_left_date_block_border'] ) {
			$event_left_classes[] = 'left-block-bordered';
		}
		if( $params['vertical_left_date_block_theme_colored'] ) {
			$event_left_classes[] = 'has-bg-theme-colored theme-colored'.$params['vertical_left_date_block_theme_colored'];
		}
		$params['event_left_classes'] = $event_left_classes;
		
		//meta options
		$params['meta_options'] = explode(',', $params['meta_options']);
		
		//Owl Carousel Data
		$params['owl_carousel_data_info'] = charitab_mascot_prepare_owlcarousel_data_from_params( $params );

		//Produce HTML version by using the parameters (filename, variation, folder name, parameters, shortcode_ob_start)
		$html = charitab_mascot_get_shortcode_template_part( 'tribe-events', $params['display_type'], 'tribe-events/tpl', $params, true );
		
		return $html;
	}
}