<?php

if(!function_exists('mascot_core_charitab_sc_pie_chart_vc_map_modifier')) {
	/**
	 * Shortcodes vc_map modifier
	 */
	function mascot_core_charitab_sc_pie_chart_vc_map_modifier( $shortcode_base ) {
		//vc_remove_param( $shortcode_base, "display_type" );
		//vc_add_param( $shortcode_base, $attributes );
		//vc_add_params( $shortcode_base, $attributes );
	}
}



if(!function_exists('mascot_core_charitab_sc_pie_chart_render')) {
	/**
	 * Renders shortcodes HTML
	 */
	function mascot_core_charitab_sc_pie_chart_render( $attr, $content = null ) {
		
		$args = array(
			'custom_css_class' => '',
			'percent' => '85',

			'barcolor' => '#ef1e25',
			'trackcolor' => '#f2f2f2',
			'scalecolor' => '#dfe0e0',

			'scalelength' => '5',
			'linecap' => 'square',
			'linewidth' => '3',
			'size' => '110',

			'title' => '',
			'title_tag' => 'h3',
			'title_color' => '',

			'text' => '',
			'text_color' => '',

		);

		$params = shortcode_atts($args, $attr);

		//classes
		$classes = array();
		$classes[] = $params['custom_css_class'];
		$params['classes'] = $classes;
		
		wp_enqueue_script( 'jquery-easypiechart' );


		$params['box_inline_css'] = charitab_mascot_get_inline_css( mascot_core_charitab_sc_pie_chart_box_css( $params ) );

		$params['title_inline_css'] = '';
		if( $params['title_color'] ) {
			$params['title_inline_css'] = charitab_mascot_get_inline_css( 'color: '. $params['title_color'] );
		}

		$params['text_inline_css'] = '';
		if( $params['text_color'] ) {
			$params['text_inline_css'] = charitab_mascot_get_inline_css( 'color: '. $params['text_color'] );
		}

		//Produce HTML version by using the parameters (filename, variation, folder name, parameters, shortcode_ob_start)
		$html = charitab_mascot_get_shortcode_template_part( 'pie-chart', null, 'pie-chart/tpl', $params, true );
		
		return $html;
	}
}

if(!function_exists('mascot_core_charitab_sc_pie_chart_box_css')) {
	/**
	 * Get Parent Box Styles
	 */
	function mascot_core_charitab_sc_pie_chart_box_css( $params ) {
		$css_array = array();

		if( $params['size'] != '' ) {
			$css_array[] = 'width: '.charitab_mascot_if_numeric_add_suffix($params['size'], 'px');
			$css_array[] = 'height: '.charitab_mascot_if_numeric_add_suffix($params['size'], 'px');
			$css_array[] = 'line-height: '.charitab_mascot_if_numeric_add_suffix($params['size'], 'px');
		}
		return implode( '; ', $css_array );
	}
}