<?php

if(!function_exists('mascot_core_charitab_sc_paypal_donation_vc_map_modifier')) {
	/**
	 * Shortcodes vc_map modifier
	 */
	function mascot_core_charitab_sc_paypal_donation_vc_map_modifier( $shortcode_base ) {
		//vc_remove_param( $shortcode_base, "display_type" );
		//vc_add_param( $shortcode_base, $attributes );
		//vc_add_params( $shortcode_base, $attributes );
	}
}



if(!function_exists('mascot_core_charitab_sc_paypal_donation_render')) {
	/**
	 * Renders shortcodes HTML
	 */
	function mascot_core_charitab_sc_paypal_donation_render( $attr, $content = null ) {

		$args = array(
			'custom_css_class' => '',
			'paypal_email' => '',

			'payment_type' => '',
			'design_style' => '',

			'donate_for' => '',
			'suggested_donation_amounts' => '',
			'currency' => '',
			
			'submit_button_type' => '',

			
			'return_url' => '',
			'cancel_return_url' => '',
			'notify_url' => '',
		);

		$params = shortcode_atts($args, $attr);

		if( $params['payment_type'] != 'both-onetime-recurring' ) {
			$params['design_style'] = null;
		}

		$params['donate_for'] = explode("\n", $params['donate_for']);
		$params['suggested_donation_amounts'] = explode("\n", $params['suggested_donation_amounts']);
		$params['currency'] = explode(",", $params['currency']);



		$currency_list = array(
			'USD'	=>	esc_html__( "USD - U.S. Dollars", 'charitab-wp' ),
			'AUD'	=>	esc_html__( "AUD - Australian Dollars", 'charitab-wp' ),
			'BRL'	=>	esc_html__( "BRL - Brazilian Reais", 'charitab-wp' ),
			'GBP'	=>	esc_html__( "GBP - British Pounds", 'charitab-wp' ),
			'HKD'	=>	esc_html__( "HKD - Hong Kong Dollars", 'charitab-wp' ),
			'HUF'	=>	esc_html__( "HUF - Hungarian Forints", 'charitab-wp' ),
			'INR'	=>	esc_html__( "INR - Indian Rupee", 'charitab-wp' ),
			'ILS'	=>	esc_html__( "ILS - Israeli New Shekels", 'charitab-wp' ),
			'JPY'	=>	esc_html__( "JPY - Japanese Yen", 'charitab-wp' ),
			'MYR'	=>	esc_html__( "MYR - Malaysian Ringgit", 'charitab-wp' ),
			'MXN'	=>	esc_html__( "MXN - Mexican Pesos", 'charitab-wp' ),
			'TWD'	=>	esc_html__( "TWD - New Taiwan Dollars", 'charitab-wp' ),
			'NZD'	=>	esc_html__( "NZD - New Zealand Dollars", 'charitab-wp' ),
			'NOK'	=>	esc_html__( "NOK - Norwegian Kroner", 'charitab-wp' ),
			'PHP'	=>	esc_html__( "PHP - Philippine Pesos", 'charitab-wp' ),
			'PLN'	=>	esc_html__( "PLN - Polish Zlotys", 'charitab-wp' ),
			'RUB'	=>	esc_html__( "RUB - Russian Rubles", 'charitab-wp' ),
			'SGD'	=>	esc_html__( "SGD - Singapore Dollars", 'charitab-wp' ),
			'SEK'	=>	esc_html__( "SEK - Swedish Kronor", 'charitab-wp' ),
			'CHF'	=>	esc_html__( "CHF - Swiss Francs", 'charitab-wp' ),
			'THB'	=>	esc_html__( "THB - Thai Baht", 'charitab-wp' ),
			'TRY'	=>	esc_html__( "TRY - Turkish Liras", 'charitab-wp' ),
		);


		$new_currency_list = array();
		if( $params['currency'][0] == 'all' ) {
			$params['currency'] = $currency_list;
		} else {
			foreach( $params['currency'] as $each_item ) {
				$new_currency_list[ $each_item ] = $currency_list[ $each_item ];
			}
			$params['currency'] = $new_currency_list;
		}
		
		//classes
		$classes = array();
		$classes[] = $params['custom_css_class'];
		
		//Produce HTML version by using the parameters (filename, variation, folder name, parameters, shortcode_ob_start)
		$html = charitab_mascot_get_shortcode_template_part( $params['payment_type'], $params['design_style'], 'paypal-donation/tpl', $params, true );
		
		return $html;
	}
}