<?php

if(!function_exists('mascot_core_charitab_sc_icon_box_vc_map_modifier')) {
	/**
	 * Shortcodes vc_map modifier
	 */
	function mascot_core_charitab_sc_icon_box_vc_map_modifier( $shortcode_base ) {
		//vc_remove_param( $shortcode_base, "display_type" );
		//vc_add_param( $shortcode_base, $attributes );
		//vc_add_params( $shortcode_base, $attributes );
	}
}




if(!function_exists('mascot_core_charitab_sc_icon_box_render')) {
	/**
	 * Renders shortcodes HTML
	 */
	function mascot_core_charitab_sc_icon_box_render( $attr, $content = null ) {
		if( !array_key_exists('icon_pack', $attr) ) {
			$attr['icon_pack'] = 'null';
		}

		$args = array(
			'custom_css_class' => '',

			'title_custom_css_class' => '',
			'title' => '',
			'title_tag' => 'h3',
			'title_text_color' => '',
			'link_icon_title' => false,
			'link_url' => '',

			
			'icon_custom_css_class' => '',
			'icon_position' => 'icon-top',
			'icon_hanging_on_top' => '',
			'icon_hanging_custom_margin_top' => '',
			'icon_type' => 'font-icon',
			'icon_pack' => '',
			$attr['icon_pack'] => '',
			'image_icon' => '',
			'image_icon_predefined_image_size' => 'full',
			'image_icon_custom_size' => '',
			
			'icon_size' => '',
			'icon_custom_font_size' => '',
			'icon_line_height' => '',
			'icon_padding_around' => '',
			'icon_box_width' => '',
			'icon_box_height' => '',
			'icon_color' => '',
			'icon_area_custom_bg_color' => '',
			'icon_theme_colored' => '',
			'icon_custom_color' => '',
			'icon_style' => '',
			'icon_border_style' => '',
			'icon_box_shadow' => '',

			'text_alignment' => '',
			'box_animation' => '',
			'box_shadow' => false,
			'box_default_padding' => false,
			'everything_centered_in_responsive' => true,
			'title_mt_0_in_desktop' => false,

			'show_view_details_button' => 'true',
			'view_details_button_text' => esc_html__( 'View Details', 'charitab-wp' ),
			

			'btn_design_style' => 'default',
			'button_size' => '',
			'btn_outlined' => false,
			'btn_round' => false,
			'btn_flat' => false,
			'btn_block' => false,
			'btn_threed_effect' => false,
			'button_alignment' => '',
			'button_hover_animation_effect' => '',


			'css' => '',
		);

		$params = shortcode_atts($args, $attr);
		$params['content'] = $content;

		//link url
		$href = vc_build_link( $params['link_url'] );
		$params['target'] = $href['target'];
		$params['url'] = $href['url'];



		//classes
		$classes = array();

		if( $params['box_animation'] ) {
			$classes[] = $params['box_animation'];
		}
		if( $params['text_alignment'] ) {
			$classes[] = $params['text_alignment'];
		}
		if( $params['box_shadow'] ) {
			$classes[] = 'iconbox-box-shadow' ;
		}
		if( $params['box_default_padding'] ) {
			$classes[] = 'iconbox-default-padding';
		}
		if( $params['everything_centered_in_responsive'] ) {
			$classes[] = 'iconbox-centered-in-responsive';
		}
		if( $params['title_mt_0_in_desktop'] ) {
			$classes[] = 'iconbox-title-mt-0-desktop';
		}
		if( $params['icon_theme_colored'] ) {
			$classes[] = 'iconbox-theme-colored' . $params['icon_theme_colored'];
		}
		if( $params['icon_position'] ) {
			$classes[] = 'icon-position-' . $params['icon_position'];
		}
		if( $params['icon_position'] == 'icon-top' && $params['icon_hanging_on_top'] ) {
			$classes[] = 'hanging-icon-top';
		}
		if( $params['icon_box_shadow'] ) {
			$classes[] = 'icon-area-box-shadow';
		}

		$classes[] = $params['custom_css_class'];
		$classes[] = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $params['css'], ' ' ) );
		$params['classes'] = $classes;


		//icon classes
		$icon_classes = array();
		if( $params['icon_size'] ) {
			$icon_classes[] = $params['icon_size'];
		}
		if( $params['icon_color'] ) {
			$icon_classes[] = $params['icon_color'];
		}
		if( $params['icon_style'] ) {
			$icon_classes[] = $params['icon_style'];
		}
		if( $params['icon_border_style'] ) {
			$icon_classes[] = 'icon-bordered';
		}
		$params['icon_classes'] = $icon_classes;

		//button classes
		$params['btn_classes'] = charitab_mascot_prepare_button_classes_from_params( $params );
		
		//title classes
		$title_classes = array();
		$title_classes[] = $params['title_custom_css_class'];
		$params['title_classes'] = $title_classes;

		//icon classes
		$icon_classes = array();
		$icon_classes[] = $params['icon_custom_css_class'];
		$params['icon_classes'] = $icon_classes;

		$params['title_inline_css'] = charitab_mascot_get_inline_css( mascot_core_charitab_sc_icon_box_title_css( $params ) );
		$params['icon_parent_inline_css'] = charitab_mascot_get_inline_css( mascot_core_charitab_sc_icon_box_icon_parent_css( $params ) );
		$params['icon_child_inline_css'] = charitab_mascot_get_inline_css( mascot_core_charitab_sc_icon_box_icon_child_css( $params ) );

		//Produce HTML version by using the parameters (filename, variation, folder name, parameters, shortcode_ob_start)
		$html = charitab_mascot_get_shortcode_template_part( 'icon-box-' . $params['icon_position'], null, 'icon-box/tpl', $params, true );
		
		return $html;
	}
}

if(!function_exists('mascot_core_charitab_sc_icon_box_title_css')) {
	/**
	 * Get Title Styles
	 */
	function mascot_core_charitab_sc_icon_box_title_css( $params ) {
		$css_array = array();

		if( $params['title_text_color'] != '' ) {
			$css_array[] = 'color: '.$params['title_text_color'];
		}
		return implode( '; ', $css_array );
	}
}

if(!function_exists('mascot_core_charitab_sc_icon_box_icon_parent_css')) {
	/**
	 * Get Icon Parent Styles
	 */
	function mascot_core_charitab_sc_icon_box_icon_parent_css( $params ) {
		$css_array = array();

		if( $params['icon_box_width'] != '' ) {
			$css_array[] = 'width: '.$params['icon_box_width'];
		}
		if( $params['icon_box_height'] != '' ) {
			$css_array[] = 'height: '.$params['icon_box_height'];
		}
		if( $params['icon_padding_around'] != '' ) {
			$css_array[] = 'padding: '.$params['icon_padding_around'];
		}
		if( $params['icon_area_custom_bg_color'] != '' ) {
			$css_array[] = 'background-color: '.$params['icon_area_custom_bg_color'];
		}
		if( $params['icon_position'] == 'icon-top' && $params['icon_hanging_on_top'] && $params['icon_hanging_custom_margin_top'] != '') {
			$css_array[] = 'margin-top: '.$params['icon_hanging_custom_margin_top'];
		}

		return implode( '; ', $css_array );
	}
}

if(!function_exists('mascot_core_charitab_sc_icon_box_icon_child_css')) {
	/**
	 * Get Icon Child Styles
	 */
	function mascot_core_charitab_sc_icon_box_icon_child_css( $params ) {
		$css_array = array();

		if( $params['icon_custom_color'] != '' ) {
			$css_array[] = 'color: '.$params['icon_custom_color'];
		}
		if( $params['icon_custom_font_size'] != '' ) {
			$font_size = $params['icon_custom_font_size'];
			$css_array[] = 'font-size: '.charitab_mascot_if_numeric_add_suffix($font_size, 'px');
		}
		if( $params['icon_line_height'] != '' ) {
			$line_height = $params['icon_line_height'];
			$css_array[] = 'line-height: '.$line_height;
		}

		return implode( '; ', $css_array );
	}
}