<?php
  $random_number = wp_rand( 1111, 9999 );
?>

<!-- Google Map HTML Codes -->
<div class="tm-sc tm-sc-google-map <?php echo esc_attr(implode(' ', $classes)); ?>">
  <div 
	data-popupstring-id="#popupstring-<?php echo esc_attr( $random_number );?>"
	class="map-canvas autoload-map"
	data-mapstyle="<?php echo esc_attr( $google_map_style );?>"
	data-tm-height="<?php echo esc_attr( $height );?>"
	data-latlng="<?php echo esc_attr( $lat );?>,<?php echo esc_attr( $long );?>"
	data-title="<?php echo esc_attr( $marker_text_title );?>"
	data-zoom="<?php echo esc_attr( $zoom );?>"
	data-marker="<?php echo esc_attr( $marker_url );?>">
  </div>
  <div class="map-popupstring d-none" id="popupstring-<?php echo esc_attr( $random_number );?>">
	<div class="text-center">
		<h3><?php echo esc_html( $marker_text_title );?></h3>
		<div class="marker-text"><?php echo esc_html( $marker_text_desc );?></div>
	</div>
  </div>
</div>