<?php

if(!function_exists('mascot_core_charitab_sc_countdown_timer_vc_map_modifier')) {
	/**
	 * Shortcodes vc_map modifier
	 */
	function mascot_core_charitab_sc_countdown_timer_vc_map_modifier( $shortcode_base ) {
		//vc_remove_param( $shortcode_base, "display_type" );
		//vc_add_param( $shortcode_base, $attributes );
		//vc_add_params( $shortcode_base, $attributes );
	}
}



if(!function_exists('mascot_core_charitab_sc_countdown_timer_render')) {
	/**
	 * Renders shortcodes HTML
	 */
	function mascot_core_charitab_sc_countdown_timer_render( $attr, $content = null ) {
		
		$args = array(
			'custom_css_class' => '',
			'design_style' => 'final-countdown-advanced-coupon',
			'countdown_future_date_time' => date("Y/m/d H:i:s", strtotime("+5 week")),
			'show_time' => true,

			'word_month' => 'months',
			'word_week' => 'weeks',
			'word_day' => 'days',
			'word_hr' => 'hr',
			'word_min' => 'min',
			'word_sec' => 'sec',


			'timezone' => '',
			'borderwidth' => '3',
			'bordercolor_second' => '#7995D5',
			'bordercolor_minutes' => '#ACC742',
			'bordercolor_hours' => '#ECEFCB',
			'bordercolor_days' => '#FF9900',
		);

		$params = shortcode_atts($args, $attr);

		wp_enqueue_script( 'countdown' );
		wp_enqueue_script( 'final-countdown' );
		if( $params['design_style'] == 'final-countdown-modern-circular' ) {
			wp_enqueue_script( 'final-countdown-kinetic' );
		}
		
		//classes
		$classes = array();
		$classes[] = $params['custom_css_class'];

		//Produce HTML version by using the parameters (filename, variation, folder name, parameters, shortcode_ob_start)
		$html = charitab_mascot_get_shortcode_template_part( 'countdown-timer-' . $params['design_style'], null, 'countdown-timer/tpl', $params, true );
		
		return $html;
	}
}