        <?php if ( ! empty( $meta_options ) ) { ?>
        <div class="campaign-meta">
          <?php if ( in_array('show-created-date', $meta_options) ) : ?>
          <div class="each-meta campaign-created-date">
            <i class="fa fa-clock-o"></i> <?php echo charitab_mascot_posted_on_date() ?>
          </div>
          <?php endif; ?>

          <?php if ( in_array('show-end-date', $meta_options) ) : ?>
          <div class="each-meta campaign-end-dates">
            <i class="fa fa-calendar-check-o"></i> <?php echo wp_kses_post( $campaign->get_end_date() ); ?>
          </div>
          <?php endif; ?>

          <?php if ( in_array('show-time-left', $meta_options) ) : ?>
          <div class="each-meta campaign-time-left">
            <i class="fa fa-calendar-minus-o"></i> <?php echo wp_kses_post( $campaign->get_time_left() ); ?>
          </div>
          <?php endif; ?>

          <?php if ( in_array('show-category', $meta_options) ) { ?>
          <?php $campaign_category = charitab_mascot_get_custom_post_type_terms_with_link('campaign_category');?>
          <?php if ( ! empty( $campaign_category ) ) : ?>
          <div class="each-meta campaign-category">
            <i class="fa fa-folder-o"></i> <?php echo wp_kses_post( $campaign_category );?>
          </div>
          <?php endif; ?>
          <?php } ?>

          <?php if ( in_array('show-tag', $meta_options) ) { ?>
          <?php $campaign_tag = charitab_mascot_get_custom_post_type_terms_with_link('campaign_tag');?>
          <?php if ( ! empty( $campaign_tag ) ) : ?>
          <div class="each-meta campaign-tag">
            <i class="fa fa-tags"></i> <?php echo charitab_mascot_get_custom_post_type_terms_with_link('campaign_tag');?>
          </div>
          <?php endif; ?>
          <?php } ?>

          <?php if ( in_array('show-campaign-creator', $meta_options) ) : ?>
          <div class="each-meta campaign-creator">
            <i class="fa fa-user-circle"></i> <?php echo get_the_author_meta( 'display_name', $campaign->get_campaign_creator() ); ?>
          </div>
          <?php endif; ?>

          <?php if ( in_array('show-campaign-donor-count', $meta_options) ) { ?>
          <?php
            $count_campaign_donations = charitable_get_table( 'campaign_donations' )->get_donations_report( array( 'campaign_id' => $campaign->ID, 'status' => 'charitable-completed' ) );

            if( !empty($count_campaign_donations) ) {
              $count_campaign_donations = count($count_campaign_donations);
            }else{
              $count_campaign_donations = '';
            }

            if( $count_campaign_donations == '' ) {
              $count_campaign_donation_ending = esc_html__( 'No donation yet', 'charitab-wp' );
            }elseif( $count_campaign_donations == 1 ) {
              $count_campaign_donation_ending = esc_html__( ' Donation', 'charitab-wp' );
            }else{
              $count_campaign_donation_ending = esc_html__( ' Donations', 'charitab-wp' );
            }
          ?>
          <div class="each-meta campaign-donor-count">
            <i class="fa fa-heart-o""></i> <?php echo esc_html( $count_campaign_donations . apply_filters( 'charitus_campaign_donation_count_ending', $count_campaign_donation_ending, $count_campaign_donations ) ); ?>
          </div>
          <?php } ?>
        </div>
        <?php } ?>