<?php
if(!function_exists('mascot_core_charitab_sc_charitable_donation_stats')) {
	function mascot_core_charitab_sc_charitable_donation_stats( $attr, $content = null ) {
		$args = array(
			'custom_css_class' => '',
			'display' => '',
			'campaigns' => '',
			'goal' => '',
			'stat_bottomline_text' => '',

			'icon_type' => 'font-icon',
			'icon_pack' => '',
			$attr['icon_pack'] => '',
			
			'image_icon' => '',

			'text_alignment' => '',
			'stat_tag' => 'h3',
			'icon_size' => '',
			'icon_color' => '',
			'icon_style' => '',
			'icon_border_style' => '',
			'icon_theme_colored' => '',

			'css' => '',
		);

		$params = shortcode_atts($args, $attr);


		//classes
		$classes = array();

		if( $params['text_alignment'] ) {
			$classes[] = $params['text_alignment'];
		}
		if( $params['icon_theme_colored'] ) {
			$classes[] = 'iconbox-theme-colored' . $params['icon_theme_colored'] ;
		}

		$classes[] = $params['custom_css_class'];
		$classes[] = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $params['css'], ' ' ) );
		$params['classes'] = $classes;


		//icon classes
		$icon_classes = array();
		if( $params['icon_size'] ) {
			$icon_classes[] = $params['icon_size'];
		}
		if( $params['icon_color'] ) {
			$icon_classes[] = $params['icon_color'];
		}
		if( $params['icon_style'] ) {
			$icon_classes[] = $params['icon_style'];
		}
		if( $params['icon_border_style'] ) {
			$icon_classes[] = 'icon-bordered';
		}
		$params['icon_classes'] = $icon_classes;


		//Produce HTML version by using the parameters (filename, variation, folder name, parameters, shortcode_ob_start)
		$html = charitab_mascot_get_shortcode_template_part( 'donation-stats', null, 'charitable-campaigns/tpl', $params, true );
		
		return $html;
	}
}
			


