<?php

if(!function_exists('mascot_core_charitab_cpt_sc_testimonials_vc_map_modifier')) {
	/**
	 * Shortcodes vc_map modifier
	 */
	function mascot_core_charitab_cpt_sc_testimonials_vc_map_modifier( $shortcode_base ) {
		//vc_remove_param( $shortcode_base, "display_type" );
		//vc_add_param( $shortcode_base, $attributes );
		//vc_add_params( $shortcode_base, $attributes );
	}
}



if(!function_exists('mascot_core_charitab_cpt_sc_testimonials_render')) {
	/**
	 * Renders shortcodes HTML
	 */
	function mascot_core_charitab_cpt_sc_testimonials_render( $attr, $content = null, $class_instance ) {
		$class_instance =  (array) $class_instance;
		$args = array(
			'custom_css_class' => '',
			'design_style' => '',
			'display_type' => '',
			'columns' => '4',
			'custom_quote_icon' => '',
			'custom_quote_icon_opacity' => '',
			'custom_quote_icon_alignment' => '',

			'show_navigation' => 'true',
			'show_bullets' => 'true',
			'bullets_skin' => 'owl-dots-light-skin',
			'bullets_alignment' => 'owl-dots-center',
			'carousel_autoplay' => 'true',
			'carousel_loop' => 'true',
			'animation_speed' => '6000',
			'margin' => '30',
			'laptop' => '',
			'tablet' => '',

			'total_items' => '4',
			'selected_category' => '',
			'order_by' => 'date',
			'order' => 'DESC',

			'show_thumb' => 'true',
			'feature_thumb_image_size' => 'post-thumbnail',
			'show_testimonial_text' => 'true',
			'show_testimonial_title' => 'true',
			'show_author_name' => 'true',
			'show_rating' => 'true',
			'show_quote_icon' => 'true',
			'show_author_job_position' => 'true',
			'show_author_company' => 'true',

			//cat filter
			'show_cat_filter' => 'false',
			'cat_filter_style' => '',
			'cat_filter_alignment' => '',


			//loadmore button options
			'loadmore_show_view_details_button' => 'false',
			'loadmore_view_details_button_text' => esc_html__( 'Load More', 'charitab-wp' ),
			'loadmore_button_loading_text' => esc_html__( 'Loading...', 'charitab-wp' ),
			'loadmore_btn_design_style' => 'default',
			'loadmore_button_size' => '',
			'loadmore_btn_outlined' => false,
			'loadmore_btn_round' => false,
			'loadmore_btn_flat' => false,
			'loadmore_btn_block' => false,
			'loadmore_btn_threed_effect' => false,
			'loadmore_button_alignment' => '',
			'loadmore_button_hover_animation_effect' => '',
		);
		$params = shortcode_atts($args, $attr);
		$params['holder_id'] = charitab_mascot_get_isotope_holder_ID('testimonials');

		if (  $params['loadmore_show_view_details_button'] === 'true' ) {
			$holder_id = str_replace('-', '_', $params['holder_id']);
			$params['holder_id_underline'] = $holder_id;
			$params['wp_ajax_load_for_cpt'] = 'testimonials';

			wp_enqueue_script( 'charitab-mascot-custom-loadmore', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/tm-custom-loadmore.js', array('jquery'), false, true );
			wp_localize_script( 'charitab-mascot-custom-loadmore', 'tm_loadmore_params_'.$holder_id, array(
				'ajaxurl' => site_url() . '/wp-admin/admin-ajax.php',

				'class_instance' => $class_instance,
				'params' => $params,

				'current_page' => get_query_var( 'paged' ) ? get_query_var('paged') : 1,
			) );
			wp_enqueue_script( 'charitab-mascot-custom-loadmore' );
		}


		return mascot_core_charitab_cpt_sc_testimonials_render_output( $class_instance, $params );
	}
}


if(!function_exists('mascot_core_charitab_cpt_sc_testimonials_render_output')) {
	/**
	 * Output render
	 */
	function mascot_core_charitab_cpt_sc_testimonials_render_output( $class_instance, $params ) {
		$new_cpt_class = $class_instance;
		$paged = isset($params['paged']) ? $params['paged'] : '';

		//query args
		$args = array(
			'post_type' => $new_cpt_class['ptKey'],
			'orderby' => $params['order_by'],
			'order' => $params['order'],
			'posts_per_page' => $params['total_items'],
			'paged' => $paged,
		);

		//if category selected
		if( ! empty( $params['selected_category'] ) ) {
			$args['tax_query'] = array(
				array(
					'taxonomy' => $new_cpt_class['ptTaxKey'],
					'field'	=> 'slug',
					'terms'	=> explode(',', $params['selected_category']),
				)
			);
		}

		//if order by testimonial_author_name selected
		if( $params['order_by'] == 'testimonial_author_name' ) {
			$args['meta_key'] = 'charitab_mascot_' . 'cpt_author_name';
			$args['orderby']  = 'meta_value';
		}

		$the_query = new \WP_Query( $args );
		$params['the_query'] = $the_query;

		if ( !$the_query->have_posts() && $params['from_loadmore_ajax_handler'] === true ) {
			return;
		}
		

		//classes
		$classes = array();
		$classes[] = $params['design_style'];
		if( $params['display_type'] == 'carousel' ) {
			$classes[] = $params['bullets_skin'];
			$classes[] = $params['bullets_alignment'];
		}
		if( $params['show_quote_icon'] == 'true' ) {
			$classes[] = 'testimonial-has-quote-icon';
		}
		if( !empty($params['custom_quote_icon']) ) {
			$classes[] = 'testimonial-has-custom-quote-icon';
		}
		if( !empty($params['custom_quote_icon_alignment']) ) {
			$classes[] = $params['custom_quote_icon_alignment'];
		}
		$classes[] = $params['custom_css_class'];
		$params['classes'] = $classes;
		
		//ptTaxKey
		$params['ptTaxKey'] = $new_cpt_class['ptTaxKey'];
		
		//Owl Carousel Data
		$params['owl_carousel_data_info'] = charitab_mascot_prepare_owlcarousel_data_from_params( $params );
		
		$params['loadmore_btn_classes'] = charitab_mascot_prepare_button_classes_from_params( $params, 'loadmore_' );

		//Produce HTML version by using the parameters (filename, variation, folder name, parameters, shortcode_ob_start)
		$html = charitab_mascot_get_cpt_template_part( 'testimonials', $params['display_type'], 'testimonials/shortcodes/tpl', $params, true );
		
		return $html;
	}
}