<?php

use MASCOTCORECHARITAB\CPT\Staff\CPT_Staff;

if(!function_exists('charitab_mascot_get_staffs')) {
	/**
	 * Function that Renders Staff list HTML Codes
	 * @return HTML
	 */
	function charitab_mascot_get_staffs( $container_type = 'container' ) {
		$params = array();

		$params['container_type'] = $container_type;

		//Produce HTML version by using the parameters (filename, variation, folder name, parameters)
		$html = charitab_mascot_get_cpt_template_part( 'staff-parts', null, 'staff/staff/tpl', $params, false );
		
		return $html;
	}
}

if ( ! function_exists( 'charitab_mascot_get_staff_layout' ) ) {
	/**
	 * Returns Staff Layout Type
	 *
	 */
	function charitab_mascot_get_staff_layout() {
		$params = array();

		$params['holder_id'] = charitab_mascot_get_isotope_holder_ID('staff');

		$params['layout_mode'] = charitab_mascot_get_redux_option( 'cpt-settings-staff-archive-layout-mode' );
		$params['items_per_row'] = charitab_mascot_get_redux_option( 'cpt-settings-staff-archive-items-per-row' );

		
		//Produce HTML version by using the parameters (filename, variation, folder name, parameters)
		$html = charitab_mascot_get_cpt_template_part( 'staff-content', null, 'staff/staff/tpl/content', $params, false );
		
		return $html;
	}
}


if ( ! function_exists( 'charitab_mascot_get_staff_info' ) ) {
	/**
	 * Returns Staff Info
	 *
	 */
	function charitab_mascot_get_staff_info() {
		$params = array();

		$staff_cpt_class = CPT_Staff::Instance();
		$params['social_links'] = $staff_cpt_class->socialList();

		$params['show_featured_image'] = charitab_mascot_get_redux_option( 'cpt-settings-staff-archive-show-featured-image' );
		$params['img_size'] = charitab_mascot_get_redux_option( 'cpt-settings-staff-archive-featured-image-size', 'charitab_mascot_wide' );

		$params['show_title'] = charitab_mascot_get_redux_option( 'cpt-settings-staff-archive-show-title' );
		$params['title_tag'] = charitab_mascot_get_redux_option( 'cpt-settings-staff-archive-title-tag', 'h4' );

		$params['show_speciality'] = charitab_mascot_get_redux_option( 'cpt-settings-staff-archive-show-speciality' );
		$params['show_bio'] = charitab_mascot_get_redux_option( 'cpt-settings-staff-archive-show-bio' );
		$params['show_social'] = charitab_mascot_get_redux_option( 'cpt-settings-staff-archive-show-social' );
		$params['show_hours'] = charitab_mascot_get_redux_option( 'cpt-settings-staff-archive-show-working-hours' );
		$params['show_btn'] = charitab_mascot_get_redux_option( 'cpt-settings-staff-archive-show-btn' );
		$params['btn_text'] = charitab_mascot_get_redux_option( 'cpt-settings-staff-archive-show-btn-text' );

		//Produce HTML version by using the parameters (filename, variation, folder name, parameters)
		$html = charitab_mascot_get_cpt_template_part( 'staff-info', null, 'staff/staff/tpl/parts', $params, false );
		
		return $html;
	}
}