<?php


if(!function_exists('charitab_mascot_get_services')) {
	/**
	 * Function that Renders Service list HTML Codes
	 * @return HTML
	 */
	function charitab_mascot_get_services( $container_type = 'container' ) {
		$params = array();

		$params['container_type'] = $container_type;

		//Produce HTML version by using the parameters (filename, variation, folder name, parameters)
		$html = charitab_mascot_get_cpt_template_part( 'services-parts', null, 'services/services/tpl', $params, false );
		
		return $html;
	}
}

if ( ! function_exists( 'charitab_mascot_get_service_layout' ) ) {
	/**
	 * Returns Service Layout Type
	 *
	 */
	function charitab_mascot_get_service_layout() {
		$params = array();

		$params['holder_id'] = charitab_mascot_get_isotope_holder_ID('services');

		$params['layout_mode'] = charitab_mascot_get_redux_option( 'cpt-settings-service-archive-layout-mode' );
		$params['items_per_row'] = charitab_mascot_get_redux_option( 'cpt-settings-service-archive-items-per-row' );

		
		//Produce HTML version by using the parameters (filename, variation, folder name, parameters)
		$html = charitab_mascot_get_cpt_template_part( 'services-content', null, 'services/services/tpl/content', $params, false );
		
		return $html;
	}
}


if ( ! function_exists( 'charitab_mascot_get_service_info' ) ) {
	/**
	 * Returns Service Info
	 *
	 */
	function charitab_mascot_get_service_info() {
		$params = array();

		
		//Produce HTML version by using the parameters (filename, variation, folder name, parameters)
		$html = charitab_mascot_get_cpt_template_part( 'service-info', null, 'services/services/tpl/parts', $params, false );
		
		return $html;
	}
}


if(!function_exists('charitab_mascot_get_service_thumb')) {
	/**
	 * Returns Service Thumb
	 * @return HTML
	 */
	function charitab_mascot_get_service_thumb() {
		$params = array();

		$params['thumbnail_orientation'] = charitab_mascot_get_redux_option( 'cpt-settings-service-archive-thumbnail-orientation' );
		$params['thumbnail_ratio'] = charitab_mascot_get_redux_option( 'cpt-settings-service-archive-thumbnail-ratio' );

		//image dimension
		$full_image_url = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full' );
		$full_image_url = $full_image_url[0];

		$image_dimension = charitab_mascot_get_image_dimensions( $params['thumbnail_orientation'], $params['thumbnail_ratio'] );

		//create resized image
		$resized_image = charitab_mascot_matthewruddy_image_resize( $full_image_url, $image_dimension['width'], $image_dimension['height'], true );

		// if has no post thubnail or gallery images then add placeholder image
		if( !is_array( $resized_image ) || !$resized_image['url'] || $resized_image['url'] == '' ) {
			$resized_image = array();
			$full_image_url = $resized_image['url'] = "//placehold.it/".$image_dimension['width']."x".$image_dimension['height']."?text=Image Not Found!";
		}
		$params['resized_image'] = $resized_image;
		$params['image_dimension'] = $image_dimension;

		//Produce HTML version by using the parameters (filename, variation, folder name, parameters)
		$html = charitab_mascot_get_cpt_template_part( 'thumb', null, 'services/services/tpl/parts', $params, false );
		
		return $html;
	}
}