<?php charitab_mascot_wp_enqueue_script_owl_carousel(); ?>
<?php if ( $the_query->have_posts() ) : ?>
  <div class="tm-sc tm-sc-portfolio tm-sc-portfolio-carousel <?php echo esc_attr(implode(' ', $classes)); ?>">
	<div class="owl-carousel owl-theme tm-owl-carousel-<?php echo esc_attr( $columns );?>col" <?php echo wp_kses_post( implode(' ', $owl_carousel_data_info) ) ?>>
		<!-- the loop -->
		<?php while ( $the_query->have_posts() ) : $the_query->the_post(); ?>
		<?php
		$full_image_url = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full' );
		$full_image_url = $full_image_url[0];

		$portfolio_images = charitab_mascot_get_rwmb_group_advanced( 'charitab_mascot_' . "portfolio_mb_gallery_images_settings",  "gallery_images", null, false, 'all' );
		
		//if has no post thumbnail
		if( !has_post_thumbnail( get_the_ID() ) ) {
			if ( !empty( $portfolio_images ) ) {
				$first_image_key = key($portfolio_images);
				$full_image_url = $portfolio_images[$first_image_key]['url'];
			}
		}

		//create resized image
		$resized_image = charitab_mascot_matthewruddy_image_resize( $full_image_url, $image_dimension['width'], $image_dimension['height'], true );

		// if has no post thubnail or portfolio images then add placeholder image
		if( !is_array( $resized_image ) || !$resized_image['url'] || $resized_image['url'] == '' ) {
			$resized_image = array();
			$full_image_url = $resized_image['url'] = "//placehold.it/".$image_dimension['width']."x".$image_dimension['height']."?text=Image Not Found!";
		}

		$term_slugs_list = wp_get_post_terms( get_the_ID(), $ptTaxKey, array("fields" => "slugs") );
		$term_slugs_list_string = implode( $term_slugs_list, ' ' );
		$term_names_list = wp_get_post_terms( get_the_ID(), $ptTaxKey, array("fields" => "names") );
		$term_names_list_string = implode( $term_names_list, ', ' );
		?>
		<!-- Portfolio Item Start -->
		<div class="box-hover-effect <?php echo esc_attr( $portfolio_hover_effect );?> <?php echo esc_attr( $term_slugs_list_string );?>">
			<div class="effect-wrapper">
				<div class="thumb <?php if( $show_gradient_effect_on_image == 'true' ) echo 'gradient-effect';?>">
					<img src="<?php echo esc_url( $resized_image['url'] );?>" alt="<?php the_title_attribute(); ?>" width="<?php echo esc_attr( $image_dimension['width'] );?>">
				</div>
				<div class="overlay-shade <?php echo esc_attr( $portfolio_overlay_color_on_image );?>"></div>
				<div class="text-holder">
				<?php if ( $show_portfolio_title == 'true' ) : ?>
				<div class="title"><?php the_title();?></div>
				<?php endif; ?>
				<?php if ( $show_portfolio_description == 'true' ) : ?>
				<div class="description"><?php the_excerpt();?></div>
				<?php endif; ?>
				<?php if ( $show_selected_category == 'true' ) : ?>
				<div class="category"><?php echo esc_html( $term_names_list_string );?></div>
				<?php endif; ?>
				<?php if ( $show_portfolio_date == 'true' ) : ?>
				<div class="date"><?php echo get_the_date(); ?></div>
				<?php endif; ?>
				</div>
				<?php if ( $show_portfolio_overlay_zoomlink_icons == 'true' ) : ?>
				<div class="icons-holder icons-holder-middle">
					<div class="icons-holder-inner">
						<div class="styled-icons icon-sm icon-dark icon-circled icon-theme-colored1">
							<a href="<?php the_permalink();?>"><i class="fa fa-link"></i></a>
						</div>
					</div>
				</div>
				<?php endif; ?>
				<a title="<?php the_title_attribute(); ?>" href="<?php the_permalink();?>" class="hover-link"></a>
			</div>
		</div>
		<!-- Portfolio Item End -->
		<?php endwhile; ?>
		<!-- end of the loop -->
	</div>
  </div>
  <?php wp_reset_postdata(); ?>

<?php else : ?>
  <?php charitab_mascot_no_posts_match_criteria_text(); ?>
<?php endif; ?>