<?php


if (!function_exists('charitab_mascot_portfolio_settings_gutter_size')) {
	/**
	 * Generate CSS codes for Portfolio Column Spacing (Gutter Size)
	 */
	function charitab_mascot_portfolio_settings_gutter_size() {
		global $charitab_mascot_redux_theme_opt;
		$var_name = 'portfolio-layout-settings-gutter-size';
		$declaration = array();
		$selector = array(
			'.isotope-layout.portfolio-archive .isotope-item'
		);

		//if empty then return
		if( !array_key_exists( $var_name, $charitab_mascot_redux_theme_opt ) ) {
			return;
		}

		if( $charitab_mascot_redux_theme_opt[$var_name] == '' ) {
			return;
		}

		$column_gutter = $charitab_mascot_redux_theme_opt[$var_name] / 2;

		$declaration['padding'] = $column_gutter . 'px';
		echo charitab_mascot_dynamic_css_generator($selector, $declaration);
	}
	add_action('charitab_mascot_dynamic_css_generator_action', 'charitab_mascot_portfolio_settings_gutter_size');
}
