<?php
$description_alignment = charitab_mascot_get_redux_option( 'portfolio-single-page-settings-portfolio-type-small-image-slider-description-alignment' );
$description_width = charitab_mascot_get_redux_option( 'portfolio-single-page-settings-portfolio-type-small-image-slider-description-width' );
$description_sticky = charitab_mascot_get_redux_option( 'portfolio-single-page-settings-portfolio-type-small-image-slider-description-sticky' );
?>
<?php charitab_mascot_wp_enqueue_script_owl_carousel(); ?>
<div class="portfolio-container <?php if( $description_sticky ) echo "portfolio-sticky-side-text"; ?>">
	<div class="row">
		<div class="col-sm-<?php echo esc_attr( $description_width ); ?> <?php if( $description_alignment == 'right' ) echo "md-pull-right"; ?> portfolio-details-parent">
			<div class="portfolio-details">
			<?php charitab_mascot_get_portfolio_single_details(); ?>
			</div>
		</div>
		<div class="col-sm-<?php echo 12-$description_width; ?>">
			<div class="portfolio-images">
				<div class="owl-carousel owl-theme tm-owl-carousel-1col" data-nav="true" data-dots="true">
					<?php
						$full_image_url = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full' );
						$full_image_url = $full_image_url[0];
					?>
						<img src="<?php echo esc_url( $full_image_url );?>" alt="<?php the_title_attribute(); ?>">
					<?php

						$gallery_images = charitab_mascot_get_rwmb_group_advanced( 'charitab_mascot_' . "portfolio_mb_gallery_images_settings",  "gallery_images", null, false, 'all' );
					?>
					<?php
					if ( !empty( $gallery_images ) ) {
						foreach ( $gallery_images as $each_gallery_image ) {
						?>
						<img src="<?php echo esc_url( $each_gallery_image['url'] );?>" alt="<?php the_title_attribute(); ?>">
						<?php
						}
					}
					?>
				</div>
			</div>
		</div>
	</div>
</div>