<?php

use MASCOTCORECHARITAB\CPT\Partners\CPT_Partners;

if(!function_exists('charitab_mascot_get_partners')) {
	/**
	 * Function that Renders Partners list HTML Codes
	 * @return HTML
	 */
	function charitab_mascot_get_partners( $container_type = 'container' ) {
		$params = array();

		$params['container_type'] = $container_type;

		//Produce HTML version by using the parameters (filename, variation, folder name, parameters)
		$html = charitab_mascot_get_cpt_template_part( 'partners-parts', null, 'partners/partners/tpl', $params, false );
		
		return $html;
	}
}

if ( ! function_exists( 'charitab_mascot_get_partners_layout' ) ) {
	/**
	 * Returns Partners Layout Type
	 *
	 */
	function charitab_mascot_get_partners_layout() {
		$params = array();

		$params['holder_id'] = charitab_mascot_get_isotope_holder_ID('partners');

		$params['layout_mode'] = charitab_mascot_get_redux_option( 'cpt-settings-partners-archive-layout-mode' );
		$params['items_per_row'] = charitab_mascot_get_redux_option( 'cpt-settings-partners-archive-items-per-row' );

		
		//Produce HTML version by using the parameters (filename, variation, folder name, parameters)
		$html = charitab_mascot_get_cpt_template_part( 'partners-content', null, 'partners/partners/tpl/content', $params, false );
		
		return $html;
	}
}


if ( ! function_exists( 'charitab_mascot_get_partners_info' ) ) {
	/**
	 * Returns Partners Info
	 *
	 */
	function charitab_mascot_get_partners_info() {
		$params = array();

		$partners_cpt_class = CPT_Partners::Instance();
		$params['social_links'] = $partners_cpt_class->socialList();

		$params['show_featured_image'] = charitab_mascot_get_redux_option( 'cpt-settings-partners-archive-show-featured-image' );
		$params['img_size'] = charitab_mascot_get_redux_option( 'cpt-settings-partners-archive-featured-image-size', 'charitab_mascot_wide' );

		$params['show_title'] = charitab_mascot_get_redux_option( 'cpt-settings-partners-archive-show-title' );
		$params['title_tag'] = charitab_mascot_get_redux_option( 'cpt-settings-partners-archive-title-tag', 'h4' );

		$params['show_speciality'] = charitab_mascot_get_redux_option( 'cpt-settings-partners-archive-show-speciality' );
		$params['show_bio'] = charitab_mascot_get_redux_option( 'cpt-settings-partners-archive-show-bio' );
		$params['show_social'] = charitab_mascot_get_redux_option( 'cpt-settings-partners-archive-show-social' );
		$params['show_hours'] = charitab_mascot_get_redux_option( 'cpt-settings-partners-archive-show-working-hours' );
		$params['show_btn'] = charitab_mascot_get_redux_option( 'cpt-settings-partners-archive-show-btn' );
		$params['btn_text'] = charitab_mascot_get_redux_option( 'cpt-settings-partners-archive-show-btn-text' );

		//Produce HTML version by using the parameters (filename, variation, folder name, parameters)
		$html = charitab_mascot_get_cpt_template_part( 'partners-info', null, 'partners/partners/tpl/parts', $params, false );
		
		return $html;
	}
}