<?php if ( $the_query->have_posts() ) : ?>
	<div class="tm-sc tm-sc-gallery tm-sc-gallery-masonry <?php echo esc_attr(implode(' ', $classes)); ?>">
		<?php include('filter.php'); ?>

		<!-- Isotope Gallery Grid -->
		<div id="<?php echo esc_attr( $holder_id ) ?>" class="isotope-layout masonry grid-<?php echo esc_attr( $columns );?> <?php echo esc_attr( $gutter );?> clearfix <?php if ( $lightbox_scroll_through == 'scroll-featured-images' ) echo 'lightgallery-lightbox'; ?>">
			<div class="isotope-item isotope-item-sizer"></div>
			
			<!-- the loop -->
			<?php while ( $the_query->have_posts() ) : $the_query->the_post(); ?>
			<?php include('common-php-codes.php'); ?>

			<!-- Isotope Item Start -->
			<div class="isotope-item <?php echo esc_attr( $masonry_tiles_image_size_class );?> <?php echo esc_attr( $term_slugs_list_string );?> <?php if ( $lightbox_scroll_through == 'scroll-gallery-images' ) echo 'lightgallery-lightbox'; ?>">
				<div class="tm-gallery box-hover-effect">
					<?php charitab_mascot_get_cpt_template_part( 'each-item', $design_style, 'gallery/shortcodes/tpl', $params, false ); ?>
				</div>
			</div>
			<!-- Isotope Item End -->
			<?php endwhile; ?>
			<!-- end of the loop -->
		</div>
		<!-- End Isotope Gallery Grid -->
		<?php wp_reset_postdata(); ?>
	</div>
		
	<?php charitab_mascot_get_cpt_template_part( 'show-more-btn', null, 'gallery/shortcodes/tpl', $params, false ); ?>

<?php else : ?>
	<?php charitab_mascot_no_posts_match_criteria_text(); ?>
<?php endif; ?>