<?php	
use MASCOTCORECHARITAB\CPT\Portfolio\CPT_Portfolio;
use MASCOTCORECHARITAB\CPT\Staff\CPT_Staff;
use Leafo\ScssPhp\Compiler;
/*
*
*	Core Functions
*	---------------------------------------
*	Mascot Framework v1.0
* 	Copyright ThemeMascot 2017 - http://www.thememascot.com
*
*/

// Null Funcion
function charitab_mascot_null_function() {}

if(!function_exists('rwmb_meta')) {
	/**
	 * For fallback when metabox is not defined
	 */
	function rwmb_meta() {
		return false;
	}
}

if(!function_exists('charitab_mascot_get_blocks_template_part')) {
	/**
	 * Load a blocks template part into a template
	 *
	 * @param string $slug The slug name for the generic template.
	 * @param string $name The name of the specialised template.
	 * @param string $folder The name of the specialised folder.
	 * @param array $params array of parameters to pass to the template.
	 */
	function charitab_mascot_get_blocks_template_part( $slug, $name = null, $folder, $params = array() ) {

		$template_path = CHARITAB_MASCOT_FRAMEWORK_FOLDER . '/core/blocks/' . $folder . '/' . $slug;

		return charitab_mascot_get_template_part( $template_path, $name, $params );

	}
}

if(!function_exists('charitab_mascot_get_shortcode_template_part')) {
	/**
	 * Load a shortcode template part into a template
	 *
	 * @param string $slug The slug name for the generic template.
	 * @param string $name The name of the specialised template.
	 * @param string $folder The name of the specialised folder.
	 * @param array $params array of parameters to pass to the template.
	 * @param boolean $shortcode_ob_start only for shortcodes to get HTML string.
	 */
	function charitab_mascot_get_shortcode_template_part( $slug, $name = null, $folder, $params = array(), $shortcode_ob_start ) {

		$template_path = CHARITAB_MASCOT_FRAMEWORK_FOLDER . '/core/shortcodes/parts/' . $folder . '/' . $slug;

		return charitab_mascot_get_template_part( $template_path, $name, $params, $shortcode_ob_start );

	}
}

if(!function_exists('charitab_mascot_get_cpt_template_part')) {
	/**
	 * Load a cpt template part into a template
	 *
	 * @param string $slug The slug name for the generic template.
	 * @param string $name The name of the specialised template.
	 * @param string $folder The name of the specialised folder.
	 * @param array $params array of parameters to pass to the template.
	 * @param boolean $shortcode_ob_start only for shortcodes to get HTML string.
	 */
	function charitab_mascot_get_cpt_template_part( $slug, $name = null, $folder, $params = array(), $shortcode_ob_start ) {

		$template_path = CHARITAB_MASCOT_FRAMEWORK_FOLDER . '/core/custom-post-types/' . $folder . '/' . $slug;

		return charitab_mascot_get_template_part( $template_path, $name, $params, $shortcode_ob_start );

	}
}

if(!function_exists('charitab_mascot_get_widget_template_part')) {
	/**
	 * Load a widget template part into a template
	 *
	 * @param string $slug The slug name for the generic template.
	 * @param string $name The name of the specialised template.
	 * @param string $folder The name of the specialised folder.
	 * @param array $params array of parameters to pass to the template.
	 * @param boolean $widget_ob_start only for widget to get HTML string.
	 */
	function charitab_mascot_get_widget_template_part( $slug, $name = null, $folder, $params = array(), $widget_ob_start ) {

		$template_path = CHARITAB_MASCOT_FRAMEWORK_FOLDER . '/core/widgets/parts/' . $folder . '/' . $slug;

		return charitab_mascot_get_template_part( $template_path, $name, $params, $widget_ob_start );

	}
}


if(!function_exists('charitab_mascot_get_woocommerce_template_part')) {
	/**
	 * Load a woocommerce template part into a template
	 *
	 * @param string $slug The slug name for the generic template.
	 * @param string $name The name of the specialised template.
	 * @param string $folder The name of the specialised folder.
	 * @param array $params array of parameters to pass to the template.
	 */
	function charitab_mascot_get_woocommerce_template_part( $slug, $name = null, $folder, $params = array() ) {

		$template_path = CHARITAB_MASCOT_FRAMEWORK_FOLDER . '/core/woocommerce/' . $folder . '/' . $slug;

		return charitab_mascot_get_template_part( $template_path, $name, $params );

	}
}



if(!function_exists('charitab_mascot_get_template_part')) {
	/**
	 * Load a template part into a template
	 *
	 * @param string $template_path path of the specialised template.
	 * @param string $name The name of the specialised template.
	 * @param array $params array of parameters to pass to the template.
	 * @param boolean $shortcode_ob_start only for shortcodes to get HTML string.
	 */
	function charitab_mascot_get_template_part( $template_path, $name = null, $params = array(), $shortcode_ob_start = false ) {

		$output_html = '';

		if( is_array($params) && count($params) ) {
			extract($params);
		}

		$templates = array();
		$name = (string) $name;
		if ( '' !== $name )
			$templates[] = "{$template_path}-{$name}.php";

		$templates[] = "{$template_path}.php";

		$located = charitab_mascot_locate_template($templates);

		if($located) {
			if( $shortcode_ob_start ) {
				ob_start();
				include($located);
				$output_html = ob_get_clean();
			} else {
				include($located);
			}
		}

		return $output_html;
	}
}

if(!function_exists('charitab_mascot_locate_template')) {
	/**
	 * Retrieve the name of the highest priority template file that exists.
	 *
	 * Searches in the CHARITAB_MASCOT_STYLESHEET_DIR before CHARITAB_MASCOT_TEMPLATE_DIR
	 * so that themes which inherit from a parent theme can just overload one file.
	 *
	 * @param string|array $template_names Template file(s) to search for, in order.
	 * @return string The template filename if one is located.
	 */
	function charitab_mascot_locate_template($template_names) {
		$located = '';
		foreach ( (array) $template_names as $template_name ) {
			if ( !$template_name ) {
				continue;
			}
			if ( file_exists(CHARITAB_MASCOT_STYLESHEET_DIR . '/' . $template_name)) {
				$located = CHARITAB_MASCOT_STYLESHEET_DIR . '/' . $template_name;
				break;
			} elseif ( file_exists(CHARITAB_MASCOT_TEMPLATE_DIR . '/' . $template_name) ) {
				$located = CHARITAB_MASCOT_TEMPLATE_DIR . '/' . $template_name;
				break;
			}
		}
		return $located;
	}
}


if(!function_exists('charitab_mascot_dynamic_css_generator')) {
	/**
	 * Dynamic CSS generator based on selectors & declarations
	 *
	 * @param array,string $selector The selector points to the HTML element you want to style
	 * @param array $declaration The declaration block contains one or more declarations separated by semicolons.
	 *
	 * @return string
	 */
	function charitab_mascot_dynamic_css_generator($selector, $declaration) {

		$generated_css = '';

		if( !empty( $selector ) && ( is_array( $declaration ) && count( $declaration ) ) ) {

			if( is_array( $selector ) && count( $selector ) ) {
				$generated_css .= implode(', ', $selector);
			} else {
				$generated_css .= $selector;
			}

			$generated_css .= ' {';
			foreach( $declaration as $property => $value ) {
				if( $property !== '' ) {
					$generated_css .= $property.': '.esc_attr($value).';';
				}
			}

			$generated_css .= '}';
		}

		return $generated_css;
	}
}

if(!function_exists('charitab_mascot_redux_option_field_typography')) {
	/**
	 * Redux Option Field Typography
	 * @return bool
	 */
	function charitab_mascot_redux_option_field_typography( $var_name = '' ) {
		global $charitab_mascot_redux_theme_opt;
		$declaration = array();

		//if empty then return
		if( !array_key_exists( $var_name, $charitab_mascot_redux_theme_opt ) ) {
			return;
		}

		$redux_opt = $charitab_mascot_redux_theme_opt[$var_name];

		if( $var_name != '' && $redux_opt !== '' ) {
			if( isset( $redux_opt['font-family'] ) && $redux_opt['font-family'] != "" ) {
				$declaration['font-family'] = $redux_opt['font-family'];
			}
			if( isset( $redux_opt['font-weight'] ) && $redux_opt['font-weight'] != "" ) {
				$declaration['font-weight'] = $redux_opt['font-weight'];
			}
			if( isset( $redux_opt['font-style'] ) && $redux_opt['font-style'] != "" ) {
				$declaration['font-style'] = $redux_opt['font-style'];
			}

			if( isset( $redux_opt['text-align'] ) && $redux_opt['text-align'] != "" ) {
				$declaration['text-align'] = $redux_opt['text-align'];
			}
			if( isset( $redux_opt['text-transform'] ) && $redux_opt['text-transform'] != "" ) {
				$declaration['text-transform'] = $redux_opt['text-transform'];
			}
			if( isset( $redux_opt['font-size'] ) && $redux_opt['font-size'] != "" ) {
				$declaration['font-size'] = $redux_opt['font-size'];
			}

			if( isset( $redux_opt['line-height'] ) && $redux_opt['line-height'] != "" ) {
				$declaration['line-height'] = $redux_opt['line-height'];
			}
			if( isset( $redux_opt['word-spacing'] ) && $redux_opt['word-spacing'] != "" ) {
				$declaration['word-spacing'] = $redux_opt['word-spacing'];
			}
			if( isset( $redux_opt['letter-spacing'] ) && $redux_opt['letter-spacing'] != "" ) {
				$declaration['letter-spacing'] = $redux_opt['letter-spacing'];
			}

			if( isset( $redux_opt['color'] ) && $redux_opt['color'] != "" ) {
				$declaration['color'] = $redux_opt['color'];
			}
		}

		return $declaration;
	}
}

if(!function_exists('charitab_mascot_redux_option_field_background')) {
	/**
	 * Redux Option Field Background
	 * @return bool
	 */
	function charitab_mascot_redux_option_field_background( $var_name = '' ) {
		global $charitab_mascot_redux_theme_opt;
		$declaration = array();

		//if empty then return
		if( !array_key_exists( $var_name, $charitab_mascot_redux_theme_opt ) ) {
			return;
		}
		
		$redux_opt = $charitab_mascot_redux_theme_opt[$var_name];

		if( $var_name != '' && $redux_opt !== '' ) {
			// Background color
			if( isset( $redux_opt['background-color'] ) && $redux_opt['background-color'] != "" ) {
				$declaration['background-color'] = $redux_opt['background-color'];
			}

			// Background image options
			if( isset( $redux_opt['background-repeat'] ) &&  $redux_opt['background-repeat'] != "" ) {
				$declaration['background-repeat'] = $redux_opt['background-repeat'];
			}
			if( isset( $redux_opt['background-size'] ) &&  $redux_opt['background-size'] != "" ) {
				$declaration['background-size'] = $redux_opt['background-size'];
			}
			if( isset( $redux_opt['background-attachment'] ) &&  $redux_opt['background-attachment'] != "" ) {
				$declaration['background-attachment'] = $redux_opt['background-attachment'];
			}
			if( isset( $redux_opt['background-position'] ) &&  $redux_opt['background-position'] != "" ) {
				$declaration['background-position'] = $redux_opt['background-position'];
			}

			// Background image
			if( isset( $redux_opt['background-image'] ) &&  $redux_opt['background-image'] != "" ) {
				$declaration['background-image'] = 'url('.$redux_opt['background-image'].')';
			}
		}

		return $declaration;
	}
}

if(!function_exists('charitab_mascot_is_woocommerce_installed')) {
	/**
	 * Function that checks if woocommerce is installed
	 * @return bool
	 */
	function charitab_mascot_is_woocommerce_installed() {
		return function_exists('is_woocommerce');
	}
}

if(!function_exists('charitab_mascot_visual_composer_installed')) {
	/**
	 * Function that checks if visual composer installed
	 * @return bool
	 */
	function charitab_mascot_visual_composer_installed() {
		//is Visual Composer installed?
		if(class_exists('WPBakeryVisualComposerAbstract')) {
			return true;
		}

		return false;
	}
}

if(!function_exists('charitab_mascot_seo_plugin_installed')) {
	/**
	 * Function that checks if popular seo plugins are installed
	 * @return bool
	 */
	function charitab_mascot_seo_plugin_installed() {
		//is 'YOAST' or 'All in One SEO' installed?
		if(defined('WPSEO_VERSION') || class_exists('All_in_One_SEO_Pack')) {
			return true;
		}

		return false;
	}
}

if(!function_exists('charitab_mascot_contact_form_7_installed')) {
	/**
	 * Function that checks if contact form 7 installed
	 * @return bool
	 */
	function charitab_mascot_contact_form_7_installed() {
		//is Contact Form 7 installed?
		if(defined('WPCF7_VERSION')) {
			return true;
		}

		return false;
	}
}

if(!function_exists('charitab_mascot_is_wpml_installed')) {
	/**
	 * Function that checks if WPML plugin is installed
	 * @return bool
	 *
	 * @version 0.1
	 */
	function charitab_mascot_is_wpml_installed() {
		return defined('ICL_SITEPRESS_VERSION');
	}
}


if(!function_exists('charitab_mascot_return_false')) {
	/**
	 * return true false by add_filter and apply_filters
	 */
	function charitab_mascot_return_false( ) {
		return false;
	}

}

if(!function_exists('charitab_mascot_return_true')) {
	/**
	 * return true
	 */
	function charitab_mascot_return_true( ) {
		return true;
	}
}

if(!function_exists('_empty')) {
	/**
	 * return true
	 */
	function _empty( $val ) {
		return empty($val);
	}
}

if(!function_exists('charitab_mascot_get_url_params')) {
	/**
	 * retrieve values of parameters passing through the URL
	 */
	function charitab_mascot_get_url_params( $param ) {
		return isset( $_GET[ $param ] ) ? $_GET[ $param ] : ( isset( $_REQUEST[ $param ] ) ? $_REQUEST[ $param ] : '' );
	}
}


if(!function_exists('charitab_mascot_get_url_params')) {
	/**
	 * retrieve POST data
	 */
	function charitab_mascot_get_post_params( $param ) {
		return isset( $_POST[ $param ] ) ? $_POST[ $param ] : ( isset( $_REQUEST[ $param ] ) ? $_REQUEST[ $param ] : '' );
	}
}

if(!function_exists('charitab_mascot_get_page_id')) {
	/**
	 * retrieve page ID
	 */
	function charitab_mascot_get_page_id() {
		if( class_exists( 'WooCommerce' ) && (is_shop() || is_product()) ) {
			return get_option( 'woocommerce_shop_page_id' );
		}

		if( (is_home() && is_front_page()) || is_archive() || is_search() || is_404() ) {
			return -1;
		}

		return get_queried_object_id();
	}
}

if(!function_exists('charitab_mascot_show_comments')) {
	/**
	 * Return Comments HTML
	 *
	 */
	function charitab_mascot_show_comments() {
		if (! is_attachment() ) {
			if ( comments_open() || get_comments_number() ) :
				comments_template();
			endif;
		}
	}
}

if(!function_exists('charitab_mascot_category_list_array_for_vc')) {
	/**
	 * Return category list array for VC
	 */
	function charitab_mascot_category_list_array_for_vc( $taxonomy ) {
		$list_categories = array(
			esc_html__( 'All', 'charitab-wp' ) => ''
		);
		$terms = get_terms( $taxonomy );

		if ( $terms && !is_wp_error( $terms ) ) :
			foreach ( $terms as $term ) {
				$list_categories[ $term->name ] = $term->slug;
			}
		endif;

		return $list_categories;
	}
}

if(!function_exists('charitab_mascot_category_list_array')) {
	/**
	 * Return category list array
	 */
	function charitab_mascot_category_list_array( $taxonomy ) {
		$list_categories = array(
			'' => esc_html__( 'All', 'charitab-wp' )
		);
		$terms = get_terms( $taxonomy );

		if ( $terms && !is_wp_error( $terms ) ) :
			foreach ( $terms as $term ) {
				$list_categories[ $term->slug ] = $term->name;
			}
		endif;

		return $list_categories;
	}
}


if(!function_exists('charitab_mascot_output_array_list')) {
	/**
	 * Output list array
	 * to show use: charitab_mascot_output_array_list( $vc_map['params'] );
	 */
	function charitab_mascot_output_array_list( $list_array ) {
		//Outputs $args to make it easy
		foreach ( $list_array as $eachparam ) {
			echo "'".$eachparam['param_name']."' => '', <br>";
		}
		
	}
}



if(!function_exists('charitab_mascot_get_image_dimensions')) {
	/**
	 * Output Image Dimensions
	 */
	function charitab_mascot_get_image_dimensions( $orientation = "landscape", $ratio = "16:9", $width = 450, $height = 0 ) {
		switch ( $ratio ) {
			case "16:9":
				if ( $orientation == "landscape" )
				$height = (int) (( $width / 16 ) * 9);
				else
				$height = (int) (( $width / 9 ) * 16);
			break;

			case "4:3":
				if ( $orientation == "landscape" )
				$height = (int) (( $width / 4 ) * 3);
				else
				$height = (int) (( $width / 3 ) * 4);
			break;

			case "3:2":
				if ( $orientation == "landscape" )
				$height = (int) (( $width / 3 ) * 2);
				else
				$height = (int) (( $width / 2 ) * 3);
			break;

			case "1:1";
				$height = (int) ( $width );
			break;
		}

		return array ( 'width' => $width, 'height' => $height );
	}
}

if(!function_exists('charitab_mascot_startsWith')) {
	/**
	 * Functions that would take a string and return true if it starts with the specified character/string
	 */
	function charitab_mascot_startsWith($haystack, $needle)
	{
		$length = strlen($needle);
		return (substr($haystack, 0, $length) === $needle);
	}
}

if(!function_exists('charitab_mascot_endsWith')) {
	/**
	 * Functions that would take a string and return true if it ends with the specified character/string
	 */
	function charitab_mascot_endsWith($haystack, $needle)
	{
		$length = strlen($needle);
		if ($length == 0) {
			return true;
		}

		return (substr($haystack, -$length) === $needle);
	}
}

if(!function_exists('charitab_mascot_remove_suffix')) {
	/**
	 * Remove Suffix from String
	 */
	function charitab_mascot_remove_suffix( $string, $suffix )
	{
		if( $string != '' && charitab_mascot_endsWith($string, $suffix) ) {
			$string = substr($string, 0 , (strpos($string, $suffix)));
		}
		return $string;
	}
}

if(!function_exists('charitab_mascot_add_suffix')) {
	/**
	 * Add Suffix from String
	 */
	function charitab_mascot_if_numeric_add_suffix( $string, $suffix )
	{
		if( $string != '' && is_numeric($string) ) {
			$string = $string.$suffix;
		}
		return $string;
	}
}


if(!function_exists('charitab_mascot_get_inline_attributes')) {
	/**
	 * Get inline attributes and it's properties
	 */
	function charitab_mascot_get_inline_attributes( $values, $attribute, $glue = '' ) {
		if( $values != '' ) {
			if( is_array( $values ) && count( $values ) ) {
				$properties = implode( $glue, $values );
			} elseif( $values !== '' ) {
				$properties = $values;
			}

			return $attribute . '="' . esc_attr($properties) . '"';
		}
		return '';
	}
}


if(!function_exists('charitab_mascot_get_inline_css')) {
	/**
	 * Get inline CSS
	 */
	function charitab_mascot_get_inline_css( $values ) {
		return charitab_mascot_get_inline_attributes( $values, 'style', $glue = ';' );
	}
}


if(!function_exists('charitab_mascot_get_inline_classes')) {
	/**
	 * Get inline classes
	 */
	function charitab_mascot_get_inline_classes( $values ) {
		return charitab_mascot_get_inline_attributes( $values, 'class', $glue = ' ' );
	}
}



if(!function_exists('charitab_mascot_get_sidebar')) {
	/**
	 * Get Sidebar
	 */
	function charitab_mascot_get_sidebar( $sidebar_position ) {
		$sidebar_id = 'default-sidebar';

		//Choose Sidebar for different page type
		if ( is_front_page() && is_home() ) {
			// Default homepage
			$sidebar_id = charitab_mascot_blog_archive_get_sidebar( $sidebar_position );
		} elseif ( is_front_page() ) {
			// static homepage
			$sidebar_id = charitab_mascot_page_get_sidebar( $sidebar_position );
		} elseif ( is_home() ) {
			// blog page
			$sidebar_id = charitab_mascot_blog_archive_get_sidebar( $sidebar_position );

		} else if ( is_single() ) {
			// single page
			if ( is_singular( 'post' ) ) {
				$sidebar_id = charitab_mascot_blog_single_get_sidebar( $sidebar_position );
			} else if ( is_singular( 'portfolio' ) ) {
				$sidebar_id = charitab_mascot_portfolio_single_get_sidebar( $sidebar_position );
			} else if ( is_singular( 'campaign' ) ) {
				$sidebar_id = charitab_mascot_get_redux_option( 'charitable-donation-settings-sidebar-layout-sidebar-default' );
			} else if ( is_singular( 'give_forms' ) ) {
				$sidebar_id = charitab_mascot_get_redux_option( 'give-donation-settings-sidebar-layout-sidebar-default' );
			}

		} else if ( is_search() || is_archive() ) {
			//if custom post type archive
			if ( is_post_type_archive( 'portfolio' ) ) {
				$sidebar_id = charitab_mascot_portfolio_get_sidebar( $sidebar_position );
			} else if ( is_post_type_archive( 'campaign' ) || is_tax( 'campaign_tag' ) || is_tax( 'campaign_category' ) ) {
				$sidebar_id = charitab_mascot_get_redux_option( 'charitable-donation-settings-sidebar-layout-sidebar-default' );
			} else if ( is_post_type_archive( 'give_forms' ) || is_tax( 'give_forms_tag' ) || is_tax( 'give_forms_category' ) ) {
				$sidebar_id = charitab_mascot_get_redux_option( 'give-donation-settings-sidebar-layout-sidebar-default' );
			} else {
				// search or archive page
				$sidebar_id = charitab_mascot_blog_archive_get_sidebar( $sidebar_position );
			}

		} else if ( charitab_mascot_is_woocommerce_installed() && is_woocommerce() ) {
			//woocommerce page
		} else {
			//everyting else
			$sidebar_id = charitab_mascot_page_get_sidebar( $sidebar_position );
		}

		return $sidebar_id;
	}
}


if(!function_exists('charitab_mascot_page_get_sidebar')) {
	/**
	 * Get Sidebar for page
	 */
	function charitab_mascot_page_get_sidebar( $sidebar_position ) {
		$current_page_id = charitab_mascot_get_page_id();
		$sidebar_id = 'default-sidebar';


		//Page Sidebar Layout
		//check if meta value is provided for this page or then get it from theme options
		$temp_meta_value = charitab_mascot_get_rwmb_group( 'charitab_mascot_' . "page_mb_sidebar_layout_settings", 'sidebar_layout', $current_page_id );
		if( ! charitab_mascot_metabox_opt_val_is_empty( $temp_meta_value ) && $temp_meta_value != "inherit" ) {
			$page_layout = $temp_meta_value;
		} else {
			$page_layout = charitab_mascot_get_redux_option( 'page-settings-sidebar-layout' );
		}


		//If both sidebar then
		if( $page_layout == 'both-sidebar-25-50-25' ) {
			
			//Sidebar 2 Position
			//check if meta value is provided for this page or then get it from theme options
			$temp_meta_value = charitab_mascot_get_rwmb_group( 'charitab_mascot_' . "page_mb_sidebar_layout_settings", 'sidebar_two_position', $current_page_id );
			if( ! charitab_mascot_metabox_opt_val_is_empty( $temp_meta_value ) && $temp_meta_value != "inherit" ) {
				$sidebar_two_position = $temp_meta_value;
			} else {
				$sidebar_two_position = charitab_mascot_get_redux_option( 'page-settings-sidebar-layout-sidebar-two-position' );
			}

			if( $sidebar_two_position == $sidebar_position ) {
				//Sidebar Two
				//check if meta value is provided for this page or then get it from theme options
				$temp_meta_value = charitab_mascot_get_rwmb_group( 'charitab_mascot_' . "page_mb_sidebar_layout_settings", 'sidebar_two', $current_page_id );
				if( ! charitab_mascot_metabox_opt_val_is_empty( $temp_meta_value ) && $temp_meta_value != "inherit" ) {
					$sidebar_id = $temp_meta_value;
				} else {
					$sidebar_id = charitab_mascot_get_redux_option( 'page-settings-sidebar-layout-sidebar-two' );
				}
			} else {
				//Sidebar Default
				//check if meta value is provided for this page or then get it from theme options
				$temp_meta_value = charitab_mascot_get_rwmb_group( 'charitab_mascot_' . "page_mb_sidebar_layout_settings", 'sidebar_default', $current_page_id );
				if( ! charitab_mascot_metabox_opt_val_is_empty( $temp_meta_value ) && $temp_meta_value != "inherit" ) {
					$sidebar_id = $temp_meta_value;
				} else {
					$sidebar_id = charitab_mascot_get_redux_option( 'page-settings-sidebar-layout-sidebar-default' );
				}

			}

		} else {

			//Sidebar Default
			//check if meta value is provided for this page or then get it from theme options
			$temp_meta_value = charitab_mascot_get_rwmb_group( 'charitab_mascot_' . "page_mb_sidebar_layout_settings", 'sidebar_default', $current_page_id );
			if( ! charitab_mascot_metabox_opt_val_is_empty( $temp_meta_value ) && $temp_meta_value != "inherit" ) {
				$sidebar_id = $temp_meta_value;
			} else {
				$sidebar_id = charitab_mascot_get_redux_option( 'page-settings-sidebar-layout-sidebar-default' );
			}

		}
		
		return $sidebar_id;
	}
}


if(!function_exists('charitab_mascot_blog_archive_get_sidebar')) {
	/**
	 * Get Sidebar for Blog Archive
	 */
	function charitab_mascot_blog_archive_get_sidebar( $sidebar_position ) {
		$current_page_id = charitab_mascot_get_page_id();
		$sidebar_id = 'default-sidebar';

		$page_layout = charitab_mascot_get_redux_option( 'blog-settings-sidebar-layout' );

		//If both sidebar then
		if( $page_layout == 'both-sidebar-25-50-25' ) {
			//Sidebar 2 Position
			$sidebar_two_position = charitab_mascot_get_redux_option( 'blog-settings-sidebar-layout-sidebar-two-position' );
			if( $sidebar_two_position == $sidebar_position ) {
				//Sidebar Two
				$sidebar_id = charitab_mascot_get_redux_option( 'blog-settings-sidebar-layout-sidebar-two' );
			} else {
				//Sidebar Default
				$sidebar_id = charitab_mascot_get_redux_option( 'blog-settings-sidebar-layout-sidebar-default' );
			}
		} else {
			//Sidebar Default
			$sidebar_id = charitab_mascot_get_redux_option( 'blog-settings-sidebar-layout-sidebar-default', 'default-sidebar' );
		}

		return $sidebar_id;
	}
}


if(!function_exists('charitab_mascot_blog_single_get_sidebar')) {
	/**
	 * Get Sidebar for Blog Single
	 */
	function charitab_mascot_blog_single_get_sidebar( $sidebar_position ) {
		$current_page_id = charitab_mascot_get_page_id();
		$sidebar_id = 'default-sidebar';

		$page_layout = charitab_mascot_get_redux_option( 'blog-single-post-settings-sidebar-layout' );

		//If both sidebar then
		if( $page_layout == 'both-sidebar-25-50-25' ) {
			//Sidebar 2 Position
			$sidebar_two_position = charitab_mascot_get_redux_option( 'blog-single-post-settings-sidebar-layout-sidebar-two-position' );
			if( $sidebar_two_position == $sidebar_position ) {
				//Sidebar Two
				$sidebar_id = charitab_mascot_get_redux_option( 'blog-single-post-settings-sidebar-layout-sidebar-two' );
			} else {
				//Sidebar Default
				$sidebar_id = charitab_mascot_get_redux_option( 'blog-single-post-settings-sidebar-layout-sidebar-default' );
			}
		} else {
			//Sidebar Default
			$sidebar_id = charitab_mascot_get_redux_option( 'blog-single-post-settings-sidebar-layout-sidebar-default', 'default-sidebar' );
		}

		return $sidebar_id;
	}
}


if(!function_exists('charitab_mascot_portfolio_get_sidebar')) {
	/**
	 * Get Sidebar for portfolio
	 */
	function charitab_mascot_portfolio_get_sidebar( $sidebar_position ) {
		$current_page_id = charitab_mascot_get_page_id();
		$sidebar_id = 'default-sidebar';

		$page_layout = charitab_mascot_get_redux_option( 'portfolio-settings-sidebar-layout' );

		//If both sidebar then
		if( $page_layout == 'both-sidebar-25-50-25' ) {
			//Sidebar 2 Position
			$sidebar_two_position = charitab_mascot_get_redux_option( 'portfolio-settings-sidebar-layout-sidebar-two-position' );
			if( $sidebar_two_position == $sidebar_position ) {
				//Sidebar Two
				$sidebar_id = charitab_mascot_get_redux_option( 'portfolio-settings-sidebar-layout-sidebar-two' );
			} else {
				//Sidebar Default
				$sidebar_id = charitab_mascot_get_redux_option( 'portfolio-settings-sidebar-layout-sidebar-default' );
			}
		} else {
			//Sidebar Default
			$sidebar_id = charitab_mascot_get_redux_option( 'portfolio-settings-sidebar-layout-sidebar-default' );
		}

		return $sidebar_id;
	}
}


if(!function_exists('charitab_mascot_portfolio_single_get_sidebar')) {
	/**
	 * Get Sidebar for Portfolio Single
	 */
	function charitab_mascot_portfolio_single_get_sidebar( $sidebar_position ) {
		$current_page_id = charitab_mascot_get_page_id();
		$sidebar_id = 'default-sidebar';

		$page_layout = charitab_mascot_get_redux_option( 'portfolio-single-page-settings-sidebar-layout' );

		//If both sidebar then
		if( $page_layout == 'both-sidebar-25-50-25' ) {
			//Sidebar 2 Position
			$sidebar_two_position = charitab_mascot_get_redux_option( 'portfolio-single-page-settings-sidebar-layout-sidebar-two-position' );
			if( $sidebar_two_position == $sidebar_position ) {
				//Sidebar Two
				$sidebar_id = charitab_mascot_get_redux_option( 'portfolio-single-page-settings-sidebar-layout-sidebar-two' );
			} else {
				//Sidebar Default
				$sidebar_id = charitab_mascot_get_redux_option( 'portfolio-single-page-settings-sidebar-layout-sidebar-default' );
			}
		} else {
			//Sidebar Default
			$sidebar_id = charitab_mascot_get_redux_option( 'portfolio-single-page-settings-sidebar-layout-sidebar-default' );
		}

		return $sidebar_id;
	}
}

if(!function_exists('charitab_mascot_metabox_opt_val_is_empty')) {
	/**
	 * Check if metabox field option value is empty
	 */
	function charitab_mascot_metabox_opt_val_is_empty( $option_value ) {
		if ( ( is_array($option_value) && empty($option_value) ) || ( !is_array($option_value) && $option_value == '' ) ) {
			return true;
		} else {
			return false;
		}
	}
}


if(!function_exists('charitab_mascot_variable_val_is_empty')) {
	/**
	 * Check if variable value is empty
	 */
	function charitab_mascot_variable_val_is_empty( $variable ) {
		if ( ( is_array($variable) && empty($variable) ) || ( !is_array($variable) && $variable == '' ) ) {
			return true;
		} else {
			return false;
		}
	}
}

if(!function_exists('charitab_mascot_is_css_folder_writable')) {
	/**
	 * Checks if css folder writable
	 */
	function charitab_mascot_is_css_folder_writable() {
		$css_dir = CHARITAB_MASCOT_ASSETS_DIR . '/css';
		return is_writable( $css_dir );
	}
}

if(!function_exists('charitab_mascot_is_css_colors_folder_writable')) {
	/**
	 * Checks if css colors folder writable
	 */
	function charitab_mascot_is_css_colors_folder_writable() {
		$css_dir = CHARITAB_MASCOT_ASSETS_DIR . '/css/colors';
		return is_writable( $css_dir );
	}
}


if(!function_exists('charitab_mascot_generate_dynamic_css')) {
	/**
	 * Gets content of dynamic assets files and puts that in static file
	 */
	function charitab_mascot_generate_dynamic_css() {
		global $wp_filesystem;
		WP_Filesystem();

		if ( charitab_mascot_is_css_folder_writable() ) {
			$css_dir = CHARITAB_MASCOT_ASSETS_DIR . '/css/';
			ob_start();
			include_once $css_dir . 'dynamic-style.php';
			$css = ob_get_clean();
			if ( is_multisite() ) {
				$wp_filesystem->put_contents( $css_dir . 'dynamic-style-msid-' . charitab_mascot_get_multisite_blog_id() . '.css', $css );
			} else {
				$wp_filesystem->put_contents( $css_dir . 'dynamic-style.css', $css );
			}
		}
	}
}


if(!function_exists('charitab_mascot_generate_css_for_custom_theme_color_from_less')) {
	/**
	 * Generates css custom theme color from Less dynamically when a user presses the "Save Settings" button at Redux Framework theme options
	 */
	function charitab_mascot_generate_css_for_custom_theme_color_from_less() {
		//if ( charitab_mascot_core_plugin_installed() && class_exists( 'scss_parser' ) ) {
		if( charitab_mascot_core_plugin_installed() && class_exists('Leafo\ScssPhp\Compiler') ) {
			global $wp_filesystem;
			WP_Filesystem();
			
			if ( charitab_mascot_is_css_colors_folder_writable() ) {
				$less_dir = CHARITAB_MASCOT_ASSETS_DIR . '/scss/colors/';
				$css_colors_dir = CHARITAB_MASCOT_ASSETS_DIR . '/css/colors/';

				$scss = new Compiler();
				$scss->setImportPaths($less_dir);

				//$scss->compile( '@theme-color1: ' . charitab_mascot_get_redux_option( 'theme-color-settings-custom-theme-color1' ) . ';' );
				//$scss->compile( '@theme-color2: ' . charitab_mascot_get_redux_option( 'theme-color-settings-custom-theme-color2' ) . ';' );
				//$parser->parseFile( $less_dir . 'less-theme-color/custom-theme-color.less' );

				$scss->setVariables(array(
					'$theme-color1' => charitab_mascot_get_redux_option( 'theme-color-settings-custom-theme-color1' ),
					'$theme-color2' => charitab_mascot_get_redux_option( 'theme-color-settings-custom-theme-color2' ),
				));
				$css = $scss->compile('@import "custom-theme-color.scss"');
				//file name
				$css_file_name = 'custom-theme-color';

				if ( is_multisite() ) {
					$css_file_name .= '-msid-' .charitab_mascot_get_multisite_blog_id() ;
				}

				$redux_css_file_name = charitab_mascot_get_redux_option( 'theme-color-settings-custom-theme-color-filename' );
				if( !empty( $redux_css_file_name ) ) {
					$css_file_name = $redux_css_file_name;
				}

				/*if ( is_multisite() ) {
					$wp_filesystem->put_contents( $css_colors_dir . 'custom-theme-color-msid-' . charitab_mascot_get_multisite_blog_id() . '.css', $css);
				} else {
					$wp_filesystem->put_contents( $css_colors_dir . 'custom-theme-color.css', $css);
				}*/

				$wp_filesystem->put_contents( $css_colors_dir . $css_file_name . '.css', $css);
			}
		}
	}
	function charitab_mascot_generate_css_for_custom_theme_color_from_less_old() {
		if ( charitab_mascot_core_plugin_installed() && class_exists( 'Less_Parser' ) ) {
			global $wp_filesystem;
			WP_Filesystem();
			
			if ( charitab_mascot_is_css_colors_folder_writable() ) {
				$less_dir = CHARITAB_MASCOT_ASSETS_DIR . '/scss/';
				$css_colors_dir = CHARITAB_MASCOT_ASSETS_DIR . '/css/colors/';
				$options = array( 'compress'=>true );
				$parser = new Less_Parser( $options );
				$parser->parse( '@theme-color1: ' . charitab_mascot_get_redux_option( 'theme-color-settings-custom-theme-color1' ) . ';' );
				$parser->parse( '@theme-color2: ' . charitab_mascot_get_redux_option( 'theme-color-settings-custom-theme-color2' ) . ';' );
				$parser->parseFile( $less_dir . 'less-theme-color/custom-theme-color.less' );
				$css = $parser->getCss();


				//file name
				$css_file_name = 'custom-theme-color';

				if ( is_multisite() ) {
					$css_file_name .= '-msid-' .charitab_mascot_get_multisite_blog_id() ;
				}

				$redux_css_file_name = charitab_mascot_get_redux_option( 'theme-color-settings-custom-theme-color-filename' );
				if( !empty( $redux_css_file_name ) ) {
					$css_file_name = $redux_css_file_name;
				}

				/*if ( is_multisite() ) {
					$wp_filesystem->put_contents( $css_colors_dir . 'custom-theme-color-msid-' . charitab_mascot_get_multisite_blog_id() . '.css', $css);
				} else {
					$wp_filesystem->put_contents( $css_colors_dir . 'custom-theme-color.css', $css);
				}*/

				$wp_filesystem->put_contents( $css_colors_dir . $css_file_name . '.css', $css);
			}
		}
	}
}


if (!function_exists('charitab_mascot_get_multisite_blog_id')) {
	/**
	 * Check is multisite and return blog id
	 *
	 * @return int
	 */
	function charitab_mascot_get_multisite_blog_id() {
		if(is_multisite()){
			return get_blog_details()->blog_id;
		}
	}
}


if(!function_exists('charitab_mascot_posts_per_page_for_different_post_types')) {
	/**
	 * WordPress Posts Per Page for Different Custom Post Type
	 */
	function charitab_mascot_posts_per_page_for_different_post_types( $query ) {
		if ( !is_admin() && $query->is_main_query() ) {
					
			if( class_exists('MASCOTCORECHARITAB\CPT\Portfolio\CPT_Portfolio') ) {
				//Post Type: Portfolio
				$portfolio_cpt_class = CPT_Portfolio::Instance();
				if( is_post_type_archive( $portfolio_cpt_class->ptKey ) || is_tax( $portfolio_cpt_class->ptTaxKey ) || is_tax( $portfolio_cpt_class->ptTagTaxKey ) ) {
					$items_per_page = charitab_mascot_get_redux_option( 'portfolio-layout-settings-items-per-page' );
					$query->set( 'posts_per_page', $items_per_page );
				}
			}
					
			if( class_exists('MASCOTCORECHARITAB\CPT\Staff\CPT_Staff') ) {
				//Post Type: Staff
				$staff_cpt_class = CPT_Staff::Instance();
				if( is_post_type_archive( $staff_cpt_class->ptKey ) || is_tax( $staff_cpt_class->ptTaxKey ) ) {
					$items_per_page = charitab_mascot_get_redux_option( 'cpt-settings-staff-archive-items-per-page' );
					$query->set( 'posts_per_page', $items_per_page );
				}
			}
			
		}
	}
	add_action( 'pre_get_posts', 'charitab_mascot_posts_per_page_for_different_post_types' );
}


if(!function_exists('charitab_mascot_get_redux_option')) {
	/**
	 * Retuns Redux Theme Option
	 */
	function charitab_mascot_get_redux_option( $id, $fallback = false, $param = false ) {
		global $charitab_mascot_redux_theme_opt;

		if ( $fallback == false ) $fallback = '';

		$output = ( isset( $charitab_mascot_redux_theme_opt[$id] ) && $charitab_mascot_redux_theme_opt[$id] !== '' ) ? $charitab_mascot_redux_theme_opt[$id] : $fallback;

		if ( !empty( $charitab_mascot_redux_theme_opt[$id] ) && $param ) {
			$output = $charitab_mascot_redux_theme_opt[$id][$param];
		}
		return $output;
	}
}


if(!function_exists('charitab_mascot_get_rwmb_group')) {
	/**
	 * Retuns RWMB Group Value
	 */
	function charitab_mascot_get_rwmb_group( $group_id, $child = null, $page_id = null, $fallback = false ) {
		$group_value = rwmb_meta( $group_id, '', $page_id );
		if ( $fallback == false ) $fallback = '';

		$output = isset( $group_value[$child] ) ? $group_value[$child] : $fallback;
		return $output;
	}
}


if(!function_exists('charitab_mascot_get_rwmb_group_advanced')) {
	/**
	 * Retuns RWMB Group Value for advanced image and file fields
	 */
	function charitab_mascot_get_rwmb_group_advanced( $group_id, $child = null, $page_id = null, $fallback = false, $size = false, $for_all_img_size = 'thumbnail' ) {
		$image_ids = charitab_mascot_get_rwmb_group( $group_id, $child, $page_id, $fallback );
		$file_info = '';

		if ( empty($image_ids) ) {
			return '';
		} else if ( !$size ) {
			$file_info = wp_get_attachment_image_url( $image_ids[0], $size );
		} else if ( $size == 'all' ) {
			if ( is_array( $image_ids ) && !empty( $image_ids ) ) {
				$file_info = array();
				foreach ( $image_ids as $image_id ) {
					$file_info[] = RWMB_Image_Field::file_info( $image_id, array( 'size' => $for_all_img_size ) );
				}
			}
		} else if ( !empty($size) ) {
			$file_info = wp_get_attachment_image_url( $image_ids[0], $size );
		} else {
			$file_info = wp_get_attachment_image_url( $image_ids[0], 'full' );
		}

		return $file_info;
	}
}


if(!function_exists('charitab_mascot_metabox_get_image_advanced_field_url')) {
	/**
	 * Get Full URL of image_advanced metabox field
	 */
	function charitab_mascot_metabox_get_image_advanced_field_url( $image_field_array ) {
		$first_key = key( $image_field_array );
		return $image_field_array[$first_key]['full_url'];
	}
}


if(!function_exists('charitab_mascot_metabox_get_file_advanced_field_url')) {
	/**
	 * Get Full URL of file_advanced metabox field
	 */
	function charitab_mascot_metabox_get_file_advanced_field_url( $image_field_array ) {
		$first_key = key( $image_field_array );
		return $image_field_array[$first_key]['url'];
	}
}



if(!function_exists('charitab_mascot_render_pagination_html')) {
	/**
	 * Function that renders and returns Pagination HTML Codes
	 * @return HTML
	 */
	function charitab_mascot_render_pagination_html() {
		global $wp_query;

		$big = 999999999; // need an unlikely integer
		$pages = paginate_links( array(
			'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
			'format' => '?paged=%#%',
			'current' => max( 1, get_query_var('paged') ),
			'total' => $wp_query->max_num_pages,
			'type'  => 'array',
			'prev_next'   => true,
			'prev_text'	=> esc_html__( '&laquo;', 'charitab-wp' ),
			'next_text'	=> esc_html__( '&raquo;', 'charitab-wp'),
		) );
		$output = '';

		if ( is_array( $pages ) ) {
			$paged = ( get_query_var('paged') == 0 ) ? 1 : get_query_var( 'paged' );

			$output .=  '<ul class="pagination">';
			foreach ( $pages as $key => $page ) {
				$output .= '<li class="page-item">' . $page . '</li>';
			}
			$output .= '</ul>';
			// Create an instance of DOMDocument 
			$dom = new \DOMDocument();

			// Populate $dom with $output, making sure to handle UTF-8, otherwise
			// problems will occur with UTF-8 characters.
			$dom->loadHTML( mb_convert_encoding( $output, 'HTML-ENTITIES', 'UTF-8' ) );

			// Create an instance of DOMXpath and all elements with the class 'page-numbers' 
			$xpath = new \DOMXpath( $dom );

			// http://stackoverflow.com/a/26126336/3059883
			$page_numbers = $xpath->query( "//*[contains(concat(' ', normalize-space(@class), ' '), ' page-numbers ')]" );

			// Iterate over the $page_numbers node...
			foreach ( $page_numbers as $page_numbers_item ) {

				// Add class="mynewclass" to the <li> when its child contains the current item.
				if( isset($page_numbers_item->attributes->item(1)->value) ) {
					$page_numbers_item_classes = explode( ' ', $page_numbers_item->attributes->item(1)->value );
				}
				if ( in_array( 'current', $page_numbers_item_classes ) ) {			
					$list_item_attr_class = $dom->createAttribute( 'class' );
					$list_item_attr_class->value = 'page-item active';
					$page_numbers_item->parentNode->appendChild( $list_item_attr_class );
					$page_numbers_item->attributes->item(1)->value = 'page-link';
				}

				// Replace the class 'page-numbers' with 'page-link'
				$page_numbers_item->attributes->item(0)->value = str_replace( 
								'page-numbers',
								'page-link',
								$page_numbers_item->attributes->item(0)->value );
			}

			// Save the updated HTML and output it.
			$output = $dom->saveHTML();
		}

		return $output;
	}
}

if(!function_exists('charitab_mascot_sl_get_simple_likes_button')) {
	/**
	 * WordPress Post Like System
	 */
	function charitab_mascot_sl_get_simple_likes_button( $post_id ) {
		if ( charitab_mascot_core_plugin_installed() && function_exists( 'mascot_core_charitab_sl_get_simple_likes_button' ) ) {
			return mascot_core_charitab_sl_get_simple_likes_button( $post_id );
		}
	}
}

if ( ! function_exists( 'charitab_mascot_get_custom_post_type_terms_with_link' ) ) {
	/**
	 * Return comma separated Custom Post Type Terms with link.
	 *
	 */
	function charitab_mascot_get_custom_post_type_terms_with_link( $taxonomy ) {
		$on_draught = '';
		$terms = get_the_terms( get_the_ID(), $taxonomy );
		if ( $terms && ! is_wp_error( $terms ) ) : 

			$draught_links = array();

			foreach ( $terms as $term ) {
				$draught_links[] = wp_kses_post( '<a href="' . get_tag_link($term->term_id). '">' .$term->name. '</a>' );
			}

			$on_draught = join( ", ", $draught_links );
		endif;
		
		return $on_draught;
	}
}



if(!function_exists('charitab_mascot_inline_style')) {
	/**
	 * Function that echoes generated style attribute
	 *
	 * @param $value string | array attribute value
	 *
	 * @see charitab_mascot_get_inline_style()
	 */
	function charitab_mascot_inline_style($value) {
		echo charitab_mascot_get_inline_style($value);
	}
}

if(!function_exists('charitab_mascot_get_inline_style')) {
	/**
	 * Function that generates style attribute and returns generated string
	 *
	 * @param $value string | array value of style attribute
	 *
	 * @return string generated style attribute
	 *
	 * @see charitab_mascot_get_inline_style()
	 */
	function charitab_mascot_get_inline_style($value) {
		return charitab_mascot_get_inline_attr($value, 'style', ';');
	}
}

if(!function_exists('charitab_mascot_class_attribute')) {
	/**
	 * Function that echoes class attribute
	 *
	 * @param $value string value of class attribute
	 *
	 * @see charitab_mascot_get_class_attribute()
	 */
	function charitab_mascot_class_attribute($value) {
		echo charitab_mascot_get_class_attribute($value);
	}
}

if(!function_exists('charitab_mascot_get_class_attribute')) {
	/**
	 * Function that returns generated class attribute
	 *
	 * @param $value string value of class attribute
	 *
	 * @return string generated class attribute
	 *
	 * @see charitab_mascot_get_inline_attr()
	 */
	function charitab_mascot_get_class_attribute($value) {
		return charitab_mascot_get_inline_attr($value, 'class', ' ');
	}
}

if(!function_exists('charitab_mascot_get_inline_attr')) {
	/**
	 * Function that generates html attribute
	 *
	 * @param $value string | array value of html attribute
	 * @param $attr string name of html attribute to generate
	 * @param $glue string glue with which to implode $attr. Used only when $attr is array
	 *
	 * @return string generated html attribute
	 */
	function charitab_mascot_get_inline_attr($value, $attr, $glue = '') {
		if(!empty($value)) {

			if(is_array($value) && count($value)) {
				$properties = implode($glue, array_filter($value));
			} elseif($value !== '') {
				$properties = $value;
			}

			return $attr.'="'.esc_attr($properties).'"';
		}

		return '';
	}
}

if(!function_exists('charitab_mascot_inline_attr')) {
	/**
	 * Function that generates html attribute
	 *
	 * @param $value string | array value of html attribute
	 * @param $attr string name of html attribute to generate
	 * @param $glue string glue with which to implode $attr. Used only when $attr is array
	 *
	 * @return string generated html attribute
	 */
	function charitab_mascot_inline_attr($value, $attr, $glue = '') {
		echo charitab_mascot_get_inline_attr($value, $attr, $glue);
	}
}

if(!function_exists('charitab_mascot_get_inline_attrs')) {
	/**
	 * Generate multiple inline attributes
	 *
	 * @param $attrs
	 *
	 * @return string
	 */
	function charitab_mascot_get_inline_attrs($attrs) {
		$output = '';

		if(is_array($attrs) && count($attrs)) {
			foreach($attrs as $attr => $value) {
				$output .= ' '.charitab_mascot_get_inline_attr($value, $attr);
			}
		}

		$output = ltrim($output);

		return $output;
	}
}



if(!function_exists('charitab_mascot_slice_excerpt_by_length')) {
	/**
	 * Slice Excerpt by length
	 *
	 * @return string
	 */
	function charitab_mascot_slice_excerpt_by_length( $post_excerpt, $excerpt_length = '' ) {
		//plain text
		$post_excerpt = wp_strip_all_tags( strip_shortcodes( $post_excerpt ) );

		//remove leading dots if those exists
		$clean_excerpt = strlen($post_excerpt) && strpos($post_excerpt, '...') ? strstr($post_excerpt, '...', true) : $post_excerpt;

		//if clean excerpt has text left
		if($clean_excerpt !== '') {
			//explode current excerpt to words
			$excerpt_word_array = explode( ' ', $clean_excerpt );

			//cut down that array based on the number of the words option
			$excerpt_word_array = array_slice( $excerpt_word_array, 0, $excerpt_length );

			//add exerpt postfix
			$excert_postfix	= apply_filters( 'charitab_mascot_excerpt_postfix', '...' );

			//and finally implode words together
			$post_excerpt = implode( ' ', $excerpt_word_array ) . $excert_postfix;
		}

		return $post_excerpt;
	}
}



if(!function_exists('charitab_mascot_slice_text_by_length')) {
	/**
	 * Slice Text by length
	 *
	 * @return string
	 */
	function charitab_mascot_slice_text_by_length( $text, $word_length = 0 ) {
		//plain text
		$text = wp_strip_all_tags( strip_shortcodes( $text ) );

		//if clean excerpt has text left
		if($text !== '' && $word_length !== '') {
			//explode current excerpt to words
			$word_array = explode( ' ', $text );

			//cut down that array based on the number of the words option
			$text = array_slice( $word_array, 0, $word_length );

			//and finally implode words together
			$text = implode( ' ', $text );
		}

		return $text;
	}
}




if(!function_exists('charitab_mascot_custom_loadmore_enque_script')) {
	/**
	 * Enque custom loadmore script
	 *
	 * @return string
	 */
	function charitab_mascot_custom_loadmore_enque_script( $cpt_type, $params, $class_instance ) {
		if (  $params['loadmore_show_view_details_button'] === 'true' ) {
			$holder_id = str_replace('-', '_', $params['holder_id']);
			$params['holder_id_underline'] = $holder_id;
			$params['wp_ajax_load_for_cpt'] = $cpt_type;

			wp_enqueue_script( 'charitab-mascot-custom-loadmore', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/js/tm-custom-loadmore.js', array('jquery'), false, true );
			wp_localize_script( 'charitab-mascot-custom-loadmore', 'tm_loadmore_params_'.$holder_id, array(
				'ajaxurl' => site_url() . '/wp-admin/admin-ajax.php',

				'class_instance' => $class_instance,
				'params' => $params,

				'current_page' => get_query_var( 'paged' ) ? get_query_var('paged') : 1,
			) );
			wp_enqueue_script( 'charitab-mascot-custom-loadmore' );
		}
	}
}




if(!function_exists('mascot_core_charitab_vc_loadmore_ajax_handler')) {
	/**
	 * wp ajax handler for tm
	 *
	 */
	function mascot_core_charitab_vc_loadmore_ajax_handler() {
		$paged = $_POST['page'] + 1; //we need next page to be loaded

		//received from params
		$class_instance = $_POST['class_instance'];
		$params = $_POST['params'];
		$params['paged'] = $paged;
		$params['from_loadmore_ajax_handler'] = true;

		switch ( $params['wp_ajax_load_for_cpt'] ) {
			case 'post':
				# code...
				echo mascot_core_charitab_sc_blog_render_output( $class_instance, $params );
				break;
				
			case 'tribe_events':
				# code...
				echo mascot_core_charitab_sc_tribe_events_render_output( $class_instance, $params );
				break;
				
			case 'give-campaigns':
				# code...
				echo mascot_core_charitab_sc_give_campaigns_render_output( $class_instance, $params );
				break;
				
			case 'charitable-campaigns':
				# code...
				echo mascot_core_charitab_sc_charitable_campaigns_render_output( $class_instance, $params );
				break;



				
				
			case 'courses':
				# code...
				echo mascot_core_charitab_cpt_sc_courses_render_output( $class_instance, $params );
				break;
				
			case 'gallery':
				# code...
				echo mascot_core_charitab_cpt_sc_gallery_render_output( $class_instance, $params );
				break;

			case 'partners':
				# code...
				echo mascot_core_charitab_cpt_sc_partners_render_output( $class_instance, $params );
				break;

			case 'pet':
				# code...
				echo mascot_core_charitab_cpt_sc_pet_render_output( $class_instance, $params );
				break;

			case 'projects':
				# code...
				echo mascot_core_charitab_cpt_sc_projects_render_output( $class_instance, $params );
				break;

			case 'resources':
				# code...
				echo mascot_core_charitab_cpt_sc_resources_render_output( $class_instance, $params );
				break;

			case 'services':
				# code...
				echo mascot_core_charitab_cpt_sc_services_render_output( $class_instance, $params );
				break;

			case 'staff':
				# code...
				echo mascot_core_charitab_cpt_sc_staff_render_output( $class_instance, $params );
				break;

			case 'testimonials':
				# code...
				echo mascot_core_charitab_cpt_sc_testimonials_render_output( $class_instance, $params );
				break;

			case 'works':
				# code...
				echo mascot_core_charitab_cpt_sc_works_render_output( $class_instance, $params );
				break;
			
			default:
				# code...
				break;
		}

		die;
	}
}
add_action('wp_ajax_tm_loadmore_ajax_action', 'mascot_core_charitab_vc_loadmore_ajax_handler'); // wp_ajax_{action}
add_action('wp_ajax_nopriv_tm_loadmore_ajax_action', 'mascot_core_charitab_vc_loadmore_ajax_handler'); // wp_ajax_nopriv_{action}
