<?php


if (!function_exists('charitab_mascot_get_header_top_cpt_wpb_shortcodes_custom_css')) {
	/**
	 * Add VC inline css to body
	 */
	function charitab_mascot_get_header_top_cpt_wpb_shortcodes_custom_css() {
		$current_page_id = charitab_mascot_get_page_id();

		//Footer Widget Area
		//check if meta value is provided for this page or then get it from theme options
		$temp_meta_value = charitab_mascot_get_rwmb_group( 'charitab_mascot_' . "page_mb_header_settings", 'headertop_cpt_widget_area', $current_page_id );
		if( ! charitab_mascot_metabox_opt_val_is_empty( $temp_meta_value ) && $temp_meta_value != "inherit" ) {
			$params['header_top_cpt_post'] = $temp_meta_value;
		} else {
			$params['header_top_cpt_post'] = charitab_mascot_get_redux_option( 'header-settings-choose-header-top-cpt-widget-area', 'default' );
		}


		//VC Custom CSS
		$shortcodes_custom_css = get_post_meta( $params['header_top_cpt_post'], '_wpb_shortcodes_custom_css', true );
		if ( ! empty( $shortcodes_custom_css ) ) {
			wp_add_inline_style( 'charitab-mascot-dynamic-style', $shortcodes_custom_css );
		}


	}
	add_action( 'wp_enqueue_scripts', 'charitab_mascot_get_header_top_cpt_wpb_shortcodes_custom_css' );
}


/*Header Top Starts*/
if (!function_exists('charitab_mascot_header_top_padding_top_bottom')) {
	/**
	 * Generate CSS codes for Header Top Padding Top & Bottom
	 */
	function charitab_mascot_header_top_padding_top_bottom() {
		global $charitab_mascot_redux_theme_opt;
		$var_name = 'header-settings-header-top-padding-top-bottom';
		$declaration = array();
		$selector = array(
			'header#header .header-top .container',
			'header#header .header-top .container-fluid'
		);

		//if empty then return
		if( !array_key_exists( $var_name, $charitab_mascot_redux_theme_opt ) ) {
			return;
		}

		//added padding into the container.
		if( $charitab_mascot_redux_theme_opt[$var_name] == '' ) {
			return;
		}
		
		if( $charitab_mascot_redux_theme_opt[$var_name]['padding-top'] != "" ) {
			$declaration['padding-top'] = $charitab_mascot_redux_theme_opt[$var_name]['padding-top'];
		}
		if( $charitab_mascot_redux_theme_opt[$var_name]['padding-bottom'] != "" ) {
			$declaration['padding-bottom'] = $charitab_mascot_redux_theme_opt[$var_name]['padding-bottom'];
		}
		echo charitab_mascot_dynamic_css_generator($selector, $declaration);
	}
	add_action('charitab_mascot_dynamic_css_generator_action', 'charitab_mascot_header_top_padding_top_bottom');
}


if (!function_exists('charitab_mascot_header_top_custom_background_color')) {
	/**
	 * Generate CSS codes for Header Top Custom Background Color
	 */
	function charitab_mascot_header_top_custom_background_color() {
		global $charitab_mascot_redux_theme_opt;
		$var_name = 'header-settings-header-top-custom-bgcolor';
		$declaration = array();
		$selector = array(
			'header#header .header-top',
		);
		
		if( $charitab_mascot_redux_theme_opt['header-settings-header-top-bgcolor-use-themecolor'] != '' ) {
			return;
		}

		//if empty then return
		if( !array_key_exists( $var_name, $charitab_mascot_redux_theme_opt ) ) {
			return;
		}

		if( $charitab_mascot_redux_theme_opt[$var_name] == '' ) {
			return;
		}
		
		$declaration['background-color'] = $charitab_mascot_redux_theme_opt[$var_name];
		echo charitab_mascot_dynamic_css_generator($selector, $declaration);
	}
	add_action('charitab_mascot_dynamic_css_generator_action', 'charitab_mascot_header_top_custom_background_color');
}



if (!function_exists('charitab_mascot_header_top_widget_text_typography')) {
	/**
	 * Generate CSS codes for Header Top Widget Text Typography
	 */
	function charitab_mascot_header_top_widget_text_typography() {
		global $charitab_mascot_redux_theme_opt;
		$var_name = 'header-settings-header-top-widget-text-typography';
		$declaration = array();
		$selector = array(
			'header#header .header-top'
		);

		$declaration = charitab_mascot_redux_option_field_typography( $var_name );
		echo charitab_mascot_dynamic_css_generator($selector, $declaration);
	}
	add_action('charitab_mascot_dynamic_css_generator_action', 'charitab_mascot_header_top_widget_text_typography');
}

if (!function_exists('charitab_mascot_header_top_widget_link_typography')) {
	/**
	 * Generate CSS codes for Header Top Widget Link Typography
	 */
	function charitab_mascot_header_top_widget_link_typography() {
		global $charitab_mascot_redux_theme_opt;
		$var_name = 'header-settings-header-top-widget-link-typography';
		$declaration = array();
		$selector = array(
			'header#header .header-top a'
		);

		$declaration = charitab_mascot_redux_option_field_typography( $var_name );
		echo charitab_mascot_dynamic_css_generator($selector, $declaration);
	}
	add_action('charitab_mascot_dynamic_css_generator_action', 'charitab_mascot_header_top_widget_link_typography');
}

if (!function_exists('charitab_mascot_header_top_widget_link_hover_color')) {
	/**
	 * Generate CSS codes for Header Top Widget Link Hover Color
	 */
	function charitab_mascot_header_top_widget_link_hover_color() {
		global $charitab_mascot_redux_theme_opt;
		$var_name = 'header-settings-header-top-widget-link-hover-color';
		$declaration = array();
		$selector = array(
			'header#header .header-top a:hover'
		);

		//if empty then return
		if( !array_key_exists( $var_name, $charitab_mascot_redux_theme_opt ) ) {
			return;
		}


		if( $charitab_mascot_redux_theme_opt[$var_name] == '' ) {
			return;
		}
		
		$declaration['color'] = $charitab_mascot_redux_theme_opt[$var_name];
		echo charitab_mascot_dynamic_css_generator($selector, $declaration);
	}
	add_action('charitab_mascot_dynamic_css_generator_action', 'charitab_mascot_header_top_widget_link_hover_color');
}


if (!function_exists('charitab_mascot_header_mid_custom_background_color')) {
	/**
	 * Generate CSS codes for Header Middle Row Custom Background Color
	 */
	function charitab_mascot_header_mid_custom_background_color() {
		global $charitab_mascot_redux_theme_opt;
		$var_name = 'header-settings-header-mid-column3-custom-bgcolor';
		$declaration = array();
		$selector = array(
			'header#header .header-middle',
		);
		
		if( $charitab_mascot_redux_theme_opt['header-settings-header-mid-column3-bgcolor-use-themecolor'] != '' ) {
			return;
		}

		//if empty then return
		if( !array_key_exists( $var_name, $charitab_mascot_redux_theme_opt ) ) {
			return;
		}

		if( $charitab_mascot_redux_theme_opt[$var_name] == '' ) {
			return;
		}
		
		$declaration['background-color'] = $charitab_mascot_redux_theme_opt[$var_name];
		echo charitab_mascot_dynamic_css_generator($selector, $declaration);
	}
	add_action('charitab_mascot_dynamic_css_generator_action', 'charitab_mascot_header_mid_custom_background_color');
}


if (!function_exists('charitab_mascot_header_mid_column3_contact_info_icon_custom_text_color')) {
	/**
	 * Generate CSS codes for Header Middle Row Column3 Contact Info Custom Icon Color
	 */
	function charitab_mascot_header_mid_column3_contact_info_icon_custom_text_color() {
		global $charitab_mascot_redux_theme_opt;
		$var_name = 'header-settings-header-mid-column3-contact-info-icon-custom-color';
		$declaration = array();
		$selector = array(
			'header#header .header-middle .header-mid-column3-container .contact-info .font-icon'
		);
		
		if( $charitab_mascot_redux_theme_opt['header-settings-header-mid-column3-contact-info-icon-use-themecolor'] != '' ) {
			return;
		}

		//if empty then return
		if( !array_key_exists( $var_name, $charitab_mascot_redux_theme_opt ) ) {
			return;
		}

		if( $charitab_mascot_redux_theme_opt[$var_name] == '' ) {
			return;
		}
		
		$declaration['color'] = $charitab_mascot_redux_theme_opt[$var_name];
		echo charitab_mascot_dynamic_css_generator($selector, $declaration);
	}
	add_action('charitab_mascot_dynamic_css_generator_action', 'charitab_mascot_header_mid_column3_contact_info_icon_custom_text_color');
}


if (!function_exists('charitab_mascot_header_logo_maximum_width')) {
	/**
	 * Generate CSS codes for Maximum logo width
	 */
	function charitab_mascot_header_logo_maximum_width() {
		global $charitab_mascot_redux_theme_opt;
		$var_name = 'logo-settings-maximum-logo-width';
		$declaration = array();
		$selector = array(
			'header#header .site-brand img'
		);

		//if empty then return
		if( !array_key_exists( $var_name, $charitab_mascot_redux_theme_opt ) ) {
			return;
		}


		$declaration['max-width'] = $charitab_mascot_redux_theme_opt[$var_name].'px';
		echo charitab_mascot_dynamic_css_generator($selector, $declaration);
	}
	add_action('charitab_mascot_dynamic_css_generator_action', 'charitab_mascot_header_logo_maximum_width');
}


if (!function_exists('charitab_mascot_header_logo_maximum_height')) {
	/**
	 * Generate CSS codes for Maximum logo height
	 */
	function charitab_mascot_header_logo_maximum_height() {
		global $charitab_mascot_redux_theme_opt;
		$var_name = 'logo-settings-maximum-logo-height';
		$declaration = array();
		$selector = array(
			'header#header .site-brand img'
		);

		//if empty then return
		if( !array_key_exists( $var_name, $charitab_mascot_redux_theme_opt ) ) {
			return;
		}


		$declaration['max-height'] = $charitab_mascot_redux_theme_opt[$var_name].'px';
		echo charitab_mascot_dynamic_css_generator($selector, $declaration);
	}
	add_action('charitab_mascot_dynamic_css_generator_action', 'charitab_mascot_header_logo_maximum_height');
}


if (!function_exists('charitab_mascot_header_logo_maximum_height_in_sticky_mode')) {
	/**
	 * Generate CSS codes for Maximum logo height in Sticky Mode
	 */
	function charitab_mascot_header_logo_maximum_height_in_sticky_mode() {
		global $charitab_mascot_redux_theme_opt;
		$var_name = 'logo-settings-maximum-logo-height-in-sticky-mode';
		$declaration = array();
		$selector = array(
			'header#header .header-nav-wrapper.scroll-to-fixed-fixed .site-brand img'
		);

		//if empty then return
		if( !array_key_exists( $var_name, $charitab_mascot_redux_theme_opt ) ) {
			return;
		}


		$declaration['max-height'] = $charitab_mascot_redux_theme_opt[$var_name].'px';
		echo charitab_mascot_dynamic_css_generator($selector, $declaration);
	}
	add_action('charitab_mascot_dynamic_css_generator_action', 'charitab_mascot_header_logo_maximum_height_in_sticky_mode');
}




if (!function_exists('charitab_mascot_header_logo_margin_around_it')) {
	/**
	 * Generate CSS codes for logo margin
	 */
	function charitab_mascot_header_logo_margin_around_it() {
		global $charitab_mascot_redux_theme_opt;
		//margin around it
		$var_name = 'logo-settings-logo-margin-around';
		$declaration = array();
		$selector = array(
			'header#header .site-brand'
		);

		//if empty then return
		if( !array_key_exists( $var_name, $charitab_mascot_redux_theme_opt ) ) {
			return;
		}

		//added margin into the container.
		if( $charitab_mascot_redux_theme_opt[$var_name] == '' ) {
			return;
		}

		if( $charitab_mascot_redux_theme_opt[$var_name]['margin-top'] != "" ) {
			$declaration['margin-top'] = $charitab_mascot_redux_theme_opt[$var_name]['margin-top'];
		}
		if( $charitab_mascot_redux_theme_opt[$var_name]['margin-right'] != "" ) {
			$declaration['margin-right'] = $charitab_mascot_redux_theme_opt[$var_name]['margin-right'];
		}
		if( $charitab_mascot_redux_theme_opt[$var_name]['margin-bottom'] != "" ) {
			$declaration['margin-bottom'] = $charitab_mascot_redux_theme_opt[$var_name]['margin-bottom'];
		}
		if( $charitab_mascot_redux_theme_opt[$var_name]['margin-left'] != "" ) {
			$declaration['margin-left'] = $charitab_mascot_redux_theme_opt[$var_name]['margin-left'];
		}
		echo charitab_mascot_dynamic_css_generator($selector, $declaration);
	}
	add_action('charitab_mascot_dynamic_css_generator_action', 'charitab_mascot_header_logo_margin_around_it');
}

if (!function_exists('charitab_mascot_header_logo_sticky_margin_around_it')) {
	/**
	 * Generate CSS codes for logo margin in sticky
	 */
	function charitab_mascot_header_logo_sticky_margin_around_it() {
		global $charitab_mascot_redux_theme_opt;
		//margin around it
		$var_name = 'logo-settings-logo-sticky-margin-around';
		$declaration = array();
		$selector = array(
			'header#header .header-nav-wrapper.scroll-to-fixed-fixed .site-brand'
		);

		//if empty then return
		if( !array_key_exists( $var_name, $charitab_mascot_redux_theme_opt ) ) {
			return;
		}

		//added margin into the container.
		if( $charitab_mascot_redux_theme_opt[$var_name] == '' ) {
			return;
		}

		if( $charitab_mascot_redux_theme_opt[$var_name]['margin-top'] != "" ) {
			$declaration['margin-top'] = $charitab_mascot_redux_theme_opt[$var_name]['margin-top'];
		}
		if( $charitab_mascot_redux_theme_opt[$var_name]['margin-right'] != "" ) {
			$declaration['margin-right'] = $charitab_mascot_redux_theme_opt[$var_name]['margin-right'];
		}
		if( $charitab_mascot_redux_theme_opt[$var_name]['margin-bottom'] != "" ) {
			$declaration['margin-bottom'] = $charitab_mascot_redux_theme_opt[$var_name]['margin-bottom'];
		}
		if( $charitab_mascot_redux_theme_opt[$var_name]['margin-left'] != "" ) {
			$declaration['margin-left'] = $charitab_mascot_redux_theme_opt[$var_name]['margin-left'];
		}
		echo charitab_mascot_dynamic_css_generator($selector, $declaration);
	}
	add_action('charitab_mascot_dynamic_css_generator_action', 'charitab_mascot_header_logo_sticky_margin_around_it');
}


if (!function_exists('charitab_mascot_header_nav_row_custom_background_color')) {
	/**
	 * Generate CSS codes for Header Navigation Row Custom Background Color
	 */
	function charitab_mascot_header_nav_row_custom_background_color() {
		global $charitab_mascot_redux_theme_opt;
		$var_name = 'header-settings-navigation-custom-bgcolor';
		$declaration = array();
		$selector = array(
			'header#header .header-nav .header-nav-container',
		);

		//if empty then return
		if( !array_key_exists( $var_name, $charitab_mascot_redux_theme_opt ) ) {
			return;
		}

		if( $charitab_mascot_redux_theme_opt[$var_name] == '' ) {
			return;
		}
		
		$header_layout_type = charitab_mascot_get_redux_option( 'header-settings-choose-header-layout-type' );
		if( $header_layout_type == 'header-vertical-nav' ) {
			$selector = array(
				'body.tm-vertical-nav header#header',
			);
		}

		$declaration['background-color'] = $charitab_mascot_redux_theme_opt[$var_name];
		echo charitab_mascot_dynamic_css_generator($selector, $declaration);
	}
	add_action('charitab_mascot_dynamic_css_generator_action', 'charitab_mascot_header_nav_row_custom_background_color');
}



if (!function_exists('charitab_mascot_header_nav_row_nav_item_font_size')) {
	/**
	 * Generate CSS codes for Main Nav Item Font Size
	 */
	/*function charitab_mascot_header_nav_row_nav_item_font_size() {
		global $charitab_mascot_redux_theme_opt;
		$var_name = 'header-settings-navigation-item-font-size';
		$declaration = array();
		$selector = array(
			'#top-primary-nav .menuzord-menu > li > a'
		);

		//if empty then return
		if( !array_key_exists( $var_name, $charitab_mascot_redux_theme_opt ) ) {
			return;
		}

		if( $charitab_mascot_redux_theme_opt[$var_name] == '' ) {
			return;
		}
		
		$declaration['font-size'] = $charitab_mascot_redux_theme_opt[$var_name] . 'px';
		echo charitab_mascot_dynamic_css_generator($selector, $declaration);
	}
	add_action('charitab_mascot_dynamic_css_generator_action', 'charitab_mascot_header_nav_row_nav_item_font_size');*/
}


if (!function_exists('charitab_mascot_header_nav_row_nav_dropdown_menu_width')) {
	/**
	 * Generate CSS codes for Dropdown Menu Width(px)
	 */
	function charitab_mascot_header_nav_row_nav_dropdown_menu_width() {
		global $charitab_mascot_redux_theme_opt;
		$var_name = 'header-settings-navigation-skin-dropdown-menu-width';
		$declaration = array();
		$selector = array(
			'.menuzord-menu ul.dropdown',
			'.menuzord-menu ul.dropdown li ul.dropdown',
		);

		//if empty then return
		if( !array_key_exists( $var_name, $charitab_mascot_redux_theme_opt ) ) {
			return;
		}


		$declaration['min-width'] = $charitab_mascot_redux_theme_opt[$var_name].'px';
		echo charitab_mascot_dynamic_css_generator($selector, $declaration);
	}
	add_action('charitab_mascot_dynamic_css_generator_action', 'charitab_mascot_header_nav_row_nav_dropdown_menu_width');
}

if (!function_exists('charitab_mascot_header_nav_row_nav_item_typography')) {
	/**
	 * Generate CSS codes for Main Nav Item Typography
	 */
	function charitab_mascot_header_nav_row_nav_item_typography() {
		global $charitab_mascot_redux_theme_opt;
		$var_name = 'header-settings-navigation-item-typography';
		$declaration = array();
		$selector = array(
			'#top-primary-nav .menuzord-menu > li > a'
		);

		$declaration = charitab_mascot_redux_option_field_typography( $var_name );
		echo charitab_mascot_dynamic_css_generator($selector, $declaration);




		//hover color
		$var_name = 'header-settings-navigation-item-hover-color';
		$declaration = array();
		$selector = array(
			'#top-primary-nav .menuzord-menu > li:hover > a',
			'#top-primary-nav .menuzord-menu > li.active > a'
		);

		if( $charitab_mascot_redux_theme_opt[$var_name] != '' ) {
			$declaration['color'] = $charitab_mascot_redux_theme_opt[$var_name];
			echo charitab_mascot_dynamic_css_generator($selector, $declaration);
		}
		


		//padding around it
		$var_name = 'header-settings-navigation-item-padding';
		$declaration = array();
		$selector = array(
			'#top-primary-nav .menuzord-menu > li'
		);

		//if empty then return
		if( !array_key_exists( $var_name, $charitab_mascot_redux_theme_opt ) ) {
			return;
		}

		//added padding into the container.
		if( $charitab_mascot_redux_theme_opt[$var_name] == '' ) {
			return;
		}

		if( $charitab_mascot_redux_theme_opt[$var_name]['padding-top'] != "" ) {
			$declaration['padding-top'] = $charitab_mascot_redux_theme_opt[$var_name]['padding-top'];
		}
		if( $charitab_mascot_redux_theme_opt[$var_name]['padding-right'] != "" ) {
			$declaration['padding-right'] = $charitab_mascot_redux_theme_opt[$var_name]['padding-right'];
		}
		if( $charitab_mascot_redux_theme_opt[$var_name]['padding-bottom'] != "" ) {
			$declaration['padding-bottom'] = $charitab_mascot_redux_theme_opt[$var_name]['padding-bottom'];
		}
		if( $charitab_mascot_redux_theme_opt[$var_name]['padding-left'] != "" ) {
			$declaration['padding-left'] = $charitab_mascot_redux_theme_opt[$var_name]['padding-left'];
		}
		echo charitab_mascot_dynamic_css_generator($selector, $declaration);
	}
	add_action('charitab_mascot_dynamic_css_generator_action', 'charitab_mascot_header_nav_row_nav_item_typography');
}


if (!function_exists('charitab_mascot_header_nav_row_nav_item_dropdown_typography')) {
	/**
	 * Generate CSS codes for Main Nav Item dropdown Typography
	 */
	function charitab_mascot_header_nav_row_nav_item_dropdown_typography() {
		global $charitab_mascot_redux_theme_opt;
		$var_name = 'header-settings-navigation-item-dropdown-typography';
		$declaration = array();
		$selector = array(
			'#top-primary-nav .menuzord-menu ul.dropdown li a'
		);

		$declaration = charitab_mascot_redux_option_field_typography( $var_name );
		echo charitab_mascot_dynamic_css_generator($selector, $declaration);

		//hover color
		$var_name = 'header-settings-navigation-item-dropdown-hover-color';
		$declaration = array();
		$selector = array(
			'#top-primary-nav .menuzord-menu ul.dropdown li:hover > .menu-item-link:not(.tm-submenu-title)',
			'#top-primary-nav .menuzord-menu ul.dropdown li.active > .menu-item-link:not(.tm-submenu-title)'
		);

		if( $charitab_mascot_redux_theme_opt[$var_name] == '' ) {
			return;
		}
		
		$declaration['color'] = $charitab_mascot_redux_theme_opt[$var_name];
		echo charitab_mascot_dynamic_css_generator($selector, $declaration);
	}
	add_action('charitab_mascot_dynamic_css_generator_action', 'charitab_mascot_header_nav_row_nav_item_dropdown_typography');
}


if (!function_exists('charitab_mascot_header_nav_row_nav_item_megamenu_dropdown_typography')) {
	/**
	 * Generate CSS codes for Main Nav Item megamenu dropdown Typography
	 */
	function charitab_mascot_header_nav_row_nav_item_megamenu_dropdown_typography() {
		global $charitab_mascot_redux_theme_opt;
		$var_name = 'header-settings-navigation-item-megamenu-dropdown-typography';
		$declaration = array();
		$selector = array(
			'#top-primary-nav .menuzord-menu > li > .megamenu .megamenu-row li a.menu-item-link'
		);

		$declaration = charitab_mascot_redux_option_field_typography( $var_name );
		echo charitab_mascot_dynamic_css_generator($selector, $declaration);

		//hover color
		$var_name = 'header-settings-navigation-item-megamenu-dropdown-hover-color';
		$declaration = array();
		$selector = array(
			'#top-primary-nav .menuzord-menu > li > .megamenu .megamenu-row li:hover > .menu-item-link:not(.tm-submenu-title)',
			'#top-primary-nav .menuzord-menu > li > .megamenu .megamenu-row li.active > .menu-item-link:not(.tm-submenu-title)'
		);

		if( $charitab_mascot_redux_theme_opt[$var_name] == '' ) {
			return;
		}
		
		$declaration['color'] = $charitab_mascot_redux_theme_opt[$var_name];
		echo charitab_mascot_dynamic_css_generator($selector, $declaration);
	}
	add_action('charitab_mascot_dynamic_css_generator_action', 'charitab_mascot_header_nav_row_nav_item_megamenu_dropdown_typography');
}



if (!function_exists('charitab_mascot_header_nav_row_custom_nav_link_n_icon_color')) {
	/**
	 * Generate CSS codes for Header Navigation Row Link and Cart/Search/Side Push Icon Color
	 */
	function charitab_mascot_header_nav_row_custom_nav_link_n_icon_color() {
		global $charitab_mascot_redux_theme_opt;
		$var_name = 'header-settings-navigation-custom-navigation-link-n-icon-color';
		$declaration = array();
		
		$selector = array(
			'header#header .header-nav .header-nav-container .menuzord-menu > li > a',
			'header#header .header-nav .header-nav-container .search-icon',
			'header#header .header-nav .header-nav-container .mini-cart-icon',
		);

		//if empty then return
		if( !array_key_exists( $var_name, $charitab_mascot_redux_theme_opt ) ) {
			return;
		}

		if( $charitab_mascot_redux_theme_opt[$var_name] == '' ) {
			return;
		}
		
		echo "@media (min-width: ". CHARITAB_MASCOT_MENUZORD_MEGAMENU_BREAKPOINT_FW ."){";
		
		$declaration['color'] = $charitab_mascot_redux_theme_opt[$var_name];
		echo charitab_mascot_dynamic_css_generator($selector, $declaration);


		
		$header_layout_type = charitab_mascot_get_redux_option( 'header-settings-choose-header-layout-type' );
		if( $header_layout_type == 'header-vertical-nav' ) {
			$selector = array(
				'body.tm-vertical-nav header#header .vertical-nav-sidebar-widget-wrapper .widget',
				'body.tm-vertical-nav header#header .vertical-nav-sidebar-widget-wrapper .widget-title',
			);
			$declaration['color'] = $charitab_mascot_redux_theme_opt[$var_name];
			echo charitab_mascot_dynamic_css_generator($selector, $declaration);
		}


		//background color
		$selector = array(
			'header#header .header-nav .header-nav-container .hamburger-box .hamburger-inner',
			'header#header .header-nav .header-nav-container .hamburger-box .hamburger-inner:before',
			'header#header .header-nav .header-nav-container .hamburger-box .hamburger-inner:after',
		);
		$declaration['background-color'] = $charitab_mascot_redux_theme_opt[$var_name];
		echo charitab_mascot_dynamic_css_generator($selector, $declaration);
		
		echo "}";

	}
	add_action('charitab_mascot_dynamic_css_generator_action', 'charitab_mascot_header_nav_row_custom_nav_link_n_icon_color');
}


if (!function_exists('charitab_mascot_header_navigation_vertical_navbar_width')) {
	/**
	 * Generate CSS codes for Vertical Nav Bar Width
	 */
	function charitab_mascot_header_navigation_vertical_navbar_width() {
		global $charitab_mascot_redux_theme_opt;
		$var_name = 'header-settings-navigation-vertical-navbar-width';
		$declaration = array();
		$selector = array(
			'body.tm-vertical-nav header#header'
		);
		
		$navbar_width = $charitab_mascot_redux_theme_opt[$var_name];
		$declaration['width'] = $navbar_width.'px';
		$dynamic_css_width = charitab_mascot_dynamic_css_generator($selector, $declaration);

		//margin left
		$declaration = array();
		$selector = array(
			'body.tm-vertical-nav .main-content',
			'body.tm-vertical-nav .footer'
		);
		$declaration['margin-left'] = $navbar_width.'px';
		$dynamic_css_margin_left = charitab_mascot_dynamic_css_generator($selector, $declaration);


		//container width
		$var_name = 'header-settings-navigation-vertical-nav-container-width';
		$declaration = array();

		$selector = array(
			'body.tm-vertical-nav .container'
		);
		$container_width = $charitab_mascot_redux_theme_opt[$var_name];
		echo "@media (min-width: ". ($container_width + $navbar_width + 50) .'px' ."){";
		$declaration['max-width'] = $container_width.'px';
		echo esc_attr( $dynamic_css_width );
		echo esc_attr( $dynamic_css_margin_left );
		echo charitab_mascot_dynamic_css_generator($selector, $declaration);
		echo "}";

	}
	add_action('charitab_mascot_dynamic_css_generator_action', 'charitab_mascot_header_navigation_vertical_navbar_width');
}


if (!function_exists('charitab_mascot_header_navigation_vertical_nav_bgimg')) {
	/**
	 * Generate CSS codes for Background Image for Vertical Nav
	 */
	function charitab_mascot_header_navigation_vertical_nav_bgimg() {
		global $charitab_mascot_redux_theme_opt;
		$var_name = 'header-settings-navigation-vertical-nav-bgimg';
		$declaration = array();
		$selector = array(
			'body.tm-vertical-nav header#header'
		);

		$declaration = charitab_mascot_redux_option_field_background( $var_name );
		echo charitab_mascot_dynamic_css_generator($selector, $declaration);
	}
	add_action('charitab_mascot_dynamic_css_generator_action', 'charitab_mascot_header_navigation_vertical_nav_bgimg');
}



if (!function_exists('charitab_mascot_header_navigation_vertical_nav_widget_title_typography')) {
	/**
	 * Generate CSS codes for Header vertical-nav Widget Text Typography
	 */
	function charitab_mascot_header_navigation_vertical_nav_widget_title_typography() {
		global $charitab_mascot_redux_theme_opt;
		$var_name = 'header-settings-navigation-vertical-nav-widget-title-typography';
		$declaration = array();
		$selector = array(
			'body.tm-vertical-nav header#header .header-nav .widget .widget-title'
		);

		$declaration = charitab_mascot_redux_option_field_typography( $var_name );
		echo charitab_mascot_dynamic_css_generator($selector, $declaration);
	}
	add_action('charitab_mascot_dynamic_css_generator_action', 'charitab_mascot_header_navigation_vertical_nav_widget_title_typography');
}

if (!function_exists('charitab_mascot_header_navigation_vertical_nav_widget_text_typography')) {
	/**
	 * Generate CSS codes for Header vertical-nav Widget Text Typography
	 */
	function charitab_mascot_header_navigation_vertical_nav_widget_text_typography() {
		global $charitab_mascot_redux_theme_opt;
		$var_name = 'header-settings-navigation-vertical-nav-widget-text-typography';
		$declaration = array();
		$selector = array(
			'body.tm-vertical-nav header#header .header-nav .widget'
		);

		$declaration = charitab_mascot_redux_option_field_typography( $var_name );
		echo charitab_mascot_dynamic_css_generator($selector, $declaration);
	}
	add_action('charitab_mascot_dynamic_css_generator_action', 'charitab_mascot_header_navigation_vertical_nav_widget_text_typography');
}

if (!function_exists('charitab_mascot_header_navigation_vertical_nav_widget_link_typography')) {
	/**
	 * Generate CSS codes for Header vertical-nav Widget Link Typography
	 */
	function charitab_mascot_header_navigation_vertical_nav_widget_link_typography() {
		global $charitab_mascot_redux_theme_opt;
		$var_name = 'header-settings-navigation-vertical-nav-widget-link-typography';
		$declaration = array();
		$selector = array(
			'body.tm-vertical-nav header#header .header-nav .widget a'
		);

		$declaration = charitab_mascot_redux_option_field_typography( $var_name );
		echo charitab_mascot_dynamic_css_generator($selector, $declaration);
	}
	add_action('charitab_mascot_dynamic_css_generator_action', 'charitab_mascot_header_navigation_vertical_nav_widget_link_typography');
}

if (!function_exists('charitab_mascot_header_navigation_vertical_nav_widget_link_hover_color')) {
	/**
	 * Generate CSS codes for Header vertical-nav Widget Link Hover Color
	 */
	function charitab_mascot_header_navigation_vertical_nav_widget_link_hover_color() {
		global $charitab_mascot_redux_theme_opt;
		$var_name = 'header-settings-navigation-vertical-nav-widget-link-hover-color';
		$declaration = array();
		$selector = array(
			'body.tm-vertical-nav header#header .header-nav .widget a:hover'
		);

		//if empty then return
		if( !array_key_exists( $var_name, $charitab_mascot_redux_theme_opt ) ) {
			return;
		}


		if( $charitab_mascot_redux_theme_opt[$var_name] == '' ) {
			return;
		}
		
		$declaration['color'] = $charitab_mascot_redux_theme_opt[$var_name];
		echo charitab_mascot_dynamic_css_generator($selector, $declaration);
	}
	add_action('charitab_mascot_dynamic_css_generator_action', 'charitab_mascot_header_navigation_vertical_nav_widget_link_hover_color');
}