<?php 


?>
<article id="post-<?php the_ID(); ?>" <?php post_class( array( 'give-campaign' ) ); ?>>
	<div class="campaign-inner">
		<?php
			do_action( 'charitab_mascot_give_campaign_content_loop_before' );
		?>
		<div class="images">
			<?php //Featured Thumbnail
			if ( has_post_thumbnail() ) {
				
				$image_size = give_get_option( 'featured_image_size' );
				$image      = get_the_post_thumbnail( $post->ID, apply_filters( 'single_give_form_large_thumbnail_size', ( ! empty( $image_size ) ? $image_size : 'large' ) ) );

				echo apply_filters( 'single_give_form_image_html', $image );

			} else {

				//Placeholder Image
				echo apply_filters( 'single_give_form_image_html', sprintf( '<img src="%s" alt="%s" />', give_get_placeholder_img_src(), esc_attr__( 'Placeholder', 'charitab-wp' ) ), $post->ID );

			} ?>
		</div>
		<div class="campaign-content">
			<header class="entry-header">
				<?php
					do_action( 'charitab_mascot_give_campaign_content_loop_header_start' );
				?>


				<?php
					do_action( 'charitab_mascot_give_campaign_content_loop_before_title' );
				?>
				<?php
					if ( is_single() ) :
						the_title( '<h3 class="entry-title">', '</h3>' );
					else :
						the_title( '<h3 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h3>' );
					endif;
				?>
				<?php
					/**
					 * @hook give_campaign_content_loop_after_title
					 */
					do_action( 'charitab_mascot_give_campaign_content_loop_after_title' );
				?>


				<?php charitab_mascot_give_donation_meta_info(); ?>


				<?php
					do_action( 'charitab_mascot_give_campaign_content_loop_header_end' );
				?>
			</header><!-- .entry-header -->

			<div class="entry-content">
				<?php
					do_action( 'charitab_mascot_give_campaign_content_loop_content_start' );
				?>

				<?php
					if( is_single() ){
						the_content( sprintf(
							/* translators: %s: Name of current post. */
							wp_kses( __( 'Continue reading %s <span class="meta-nav">&rarr;</span>', 'charitab-wp' ), array( 'span' => array( 'class' => array() ) ) ),
							the_title( '<span class="screen-reader-text">"', '"</span>', false )
						) );
					}else{
						the_excerpt();
					}
				?>
				<?php echo do_shortcode( '[give_goal id="'. get_the_id() .'" show_text="true" show_bar="true"]' );?>
				<?php
					do_action( 'charitab_mascot_give_campaign_content_loop_content_end' );
				?>
			</div><!-- .entry-content -->

			<footer class="entry-footer clearfix">
				<?php
					do_action( 'charitab_mascot_give_campaign_content_loop_footer_start' );
				?>

				<a href="<?php the_permalink();?>"
				class="<?php echo esc_attr( apply_filters( 'charitab_mascot_give_template_campaign_loop_donate_link', 'btn btn-theme-colored1') ); ?>">
				<?php echo apply_filters( 'charitab_mascot_give_template_campaign_loop_donate_link_text', 'Donate Now'); ?>
				</a>

				<?php
					do_action( 'charitab_mascot_give_campaign_content_loop_footer_end' );
				?>
			</footer><!-- .entry-footer -->
		</div>
		<?php
			do_action( 'charitab_mascot_give_campaign_content_loop_after' );
		?>
	</div>
</article>