<?php

//Give forms add comments support
add_filter('give_forms_supports','charitab_mascot_give_form_supports');

add_action('give_after_single_form_summary', 'charitab_mascot_give_comment_form', 30 );


if ( ! function_exists( 'charitab_mascot_give_comment_form' ) ) {
	/**
	 * Show Comment Form
	 *
	 */
	function charitab_mascot_give_comment_form() {
		$page_show_comments = charitab_mascot_get_redux_option( 'page-settings-show-comments', true );
		if( $page_show_comments ) {
			charitab_mascot_show_comments();
		}
	}
}

remove_action( 'give_before_single_form_summary', 'give_get_forms_sidebar', 20 );



if (!function_exists('charitab_mascot_give_donation_meta_info')) {
	function charitab_mascot_give_donation_meta_info() {
		?>
			<ul class="campaign-entry-meta list-inline">
				<?php
					if( charitab_mascot_get_redux_option( 'give-donation-settings-campaign-creation-date', true ) ) {
				?>
				<li class="list-inline-item posted-date">
					<i class="fa fa-calendar-o"></i> <?php charitab_mascot_posted_on();?>
				</li>
				<?php
					} if( charitab_mascot_get_redux_option( 'give-donation-settings-campaign-creator', true ) ) {
				?>

				<li class="list-inline-item campaign-creator">
					<i class="fa fa-user-circle"></i> <?php echo charitab_mascot_posted_by(); ?>
				</li>
				<?php
					} if( charitab_mascot_get_redux_option( 'give-donation-settings-campaign-categories', true ) ) {
						$campaign_category = charitab_mascot_get_custom_post_type_terms_with_link('give_forms_category');
						if ( ! empty( $campaign_category ) ) {
				?>
				<li class="list-inline-item campaign-donation-categories">
					<i class="fa fa-folder-o"></i> <?php echo wp_kses_post( $campaign_category );?>
				</li>
				<?php
						}
					} if( charitab_mascot_get_redux_option( 'give-donation-settings-campaign-tags', true ) ) {
						$campaign_tag = charitab_mascot_get_custom_post_type_terms_with_link('give_forms_tag');
						if ( ! empty( $campaign_tag ) ) {
				?>
				<li class="list-inline-item campaign-donation-tags">
					<i class="fa fa-tags"></i> <?php echo wp_kses_post( $campaign_tag );?>
				</li>
				<?php
						}
					}
				?>

			</ul>
		<?php
	}
}
