<?php 

$campaign = '';
if( function_exists('charitable_get_campaign') ){
	$campaign = charitable_get_campaign( get_the_ID() );
}
?>
<article id="post-<?php the_ID(); ?>" <?php post_class( array( 'charitable-campaign', ( $campaign->has_ended() ? 'charitable-campaign-ended' : '' ) ) ); ?>>
	<div class="campaign-inner">
		<?php
			do_action( 'charitab_mascot_charitable_campaign_content_loop_before', $campaign );
		?>
		<?php 
		$thumbnail_size = apply_filters( 'charitable_campaign_loop_thumbnail_size', 'charitab_mascot_wide' );
		if ( has_post_thumbnail( $campaign->ID ) ) :
		?>
		<div class="campaign-thumbnail">
			<a href="<?php the_permalink() ?>"><?php    echo get_the_post_thumbnail( $campaign->ID, $thumbnail_size );   ?></a>
		</div>
		<?php endif; ?>


		<div class="campaign-content">
			<header class="entry-header">
				<?php
					do_action( 'charitab_mascot_charitable_campaign_content_loop_header_start', $campaign );
				?>


				<?php
					do_action( 'charitab_mascot_charitable_campaign_content_loop_before_title', $campaign );
				?>
				<?php
					if ( is_single() ) :
						the_title( '<h3 class="entry-title">', '</h3>' );
					else :
						the_title( '<h3 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h3>' );
					endif;
				?>
				<?php
					/**
					 * @hook charitable_campaign_content_loop_after_title
					 */
					do_action( 'charitab_mascot_charitable_campaign_content_loop_after_title', $campaign );
				?>


				<?php charitab_mascot_charitable_donation_meta_info( $campaign ); ?>
				

				<?php
					do_action( 'charitab_mascot_charitable_campaign_content_loop_header_end', $campaign );
				?>
			</header><!-- .entry-header -->

			<div class="entry-content">
				<?php
					do_action( 'charitab_mascot_charitable_campaign_content_loop_content_start', $campaign );
				?>

				<?php echo wp_kses_post( $campaign->description ); ?>

				<?php
					if( charitab_mascot_get_redux_option( 'charitable-donation-settings-campaign-progress-bar', true ) ) { charitab_mascot_charitable_campaign_progress_bar( $campaign );
					}
				?>

				<?php
					do_action( 'charitab_mascot_charitable_campaign_content_loop_content_end', $campaign );
				?>
			</div><!-- .entry-content -->

			<footer class="entry-footer clearfix">
				<?php
					do_action( 'charitab_mascot_charitable_campaign_content_loop_footer_start', $campaign );
				?>

				<?php charitable_template_campaign_loop_donate_link( $campaign ); ?>

				<?php
					do_action( 'charitab_mascot_charitable_campaign_content_loop_footer_end', $campaign );
				?>
			</footer><!-- .entry-footer -->
		</div>
		<?php
			do_action( 'charitab_mascot_charitable_campaign_content_loop_after', $campaign );
		?>
	</div>
</article>