<?php

add_action( 'charitable_campaign_content_before', 'charitab_mascot_charitable_campaign_single_title', 2 );
add_action( 'charitable_campaign_content_before', 'charitab_mascot_charitable_donation_meta_info', 2 );

add_action( 'charitable_campaign_content_before', 'charitab_mascot_charitable_campaign_single_progress_bar', 2 );


add_action( 'after_setup_theme', 'charitab_mascot_charitable_single_campaign_add_donation_summary_action' );
if (!function_exists('charitab_mascot_charitable_single_campaign_add_donation_summary_action')) {
	/**
	 * Register Charitable Campaign Single Summery
	 */
	function charitab_mascot_charitable_single_campaign_add_donation_summary_action() {
		if( charitab_mascot_get_redux_option( 'charitable-donation-settings-campaign-raised-goal', true ) ) { 
			add_action( 'charitable_campaign_content_before', 'charitable_template_campaign_loop_donation_stats', 2 );
			//add_action( 'charitable_campaign_content_before', 'charitab_mascot_charitable_campaign_get_donation_summary', 2 );
		}
	}
}

if (!function_exists('charitab_mascot_charitable_campaign_single_title')) {
	/**
	 * Register Charitable Campaign Single Title
	 */
	function charitab_mascot_charitable_campaign_single_title() {
		the_title( '<h3 class="entry-title">', '</h3>' );
	}
}

if (!function_exists('charitab_mascot_charitable_campaign_single_progress_bar')) {
	/**
	 * Register Charitable Campaign Single Progress Bar
	 */
	function charitab_mascot_charitable_campaign_single_progress_bar() {
		if( charitab_mascot_get_redux_option( 'charitable-donation-settings-campaign-progress-bar', true ) ) { 
			$campaign = charitable_get_current_campaign();
			charitab_mascot_charitable_template_campaign_progress_bar( $campaign );
		}
	}
}

if ( ! function_exists( 'charitab_mascot_get_charitable_campaign_single_content' ) ) {
	/**
	 * Returns Campaign Single Content
	 *
	 */
	function charitab_mascot_get_charitable_campaign_single_content() {
		$params = array();
		
		$params['page_show_comments'] = charitab_mascot_get_redux_option( 'page-settings-show-comments', true );

		//Produce HTML version by using the parameters (filename, variation, folder name, parameters)
		$html = charitab_mascot_get_blocks_template_part( 'single-content', null, 'charitable/tpl/parts', $params );
		
		return $html;
	}
}