<?php
/**
 * Gutenberg functions
 *
 */

// Add support for Block Styles.
add_theme_support( 'wp-block-styles' );

// Add support for full and wide align images.
add_theme_support( 'align-wide' );

// Add support for editor styles.
add_theme_support( 'editor-styles' );

add_editor_style('assets/css/gutenberg/editor-style.css');


// Add custom editor font sizes.
add_theme_support(
	'editor-font-sizes',
	array(
		array(
			'name'      => __( 'Small', 'charitab-wp' ),
			'shortName' => __( 'S', 'charitab-wp' ),
			'size'      => 13,
			'slug'      => 'small',
		),
		array(
			'name'      => __( 'Normal', 'charitab-wp' ),
			'shortName' => __( 'N', 'charitab-wp' ),
			'size'      => 16,
			'slug'      => 'normal',
		),
		array(
			'name'      => __( 'Medium', 'charitab-wp' ),
			'shortName' => __( 'M', 'charitab-wp' ),
			'size'      => 20,
			'slug'      => 'medium',
		),
		array(
			'name'      => __( 'Large', 'charitab-wp' ),
			'shortName' => __( 'L', 'charitab-wp' ),
			'size'      => 36,
			'slug'      => 'large',
		),
		array(
			'name'      => __( 'Huge', 'charitab-wp' ),
			'shortName' => __( 'XL', 'charitab-wp' ),
			'size'      => 42,
			'slug'      => 'huge',
		),
	)
);


//Gutenberg Color Palettes
if(!function_exists('charitab_mascot_gutenberg_color_palletts')) {
	function charitab_mascot_gutenberg_color_palletts() {
		$primary_theme_color = charitab_mascot_get_redux_option( 'theme-color-settings-custom-theme-color1' );
		if( empty($primary_theme_color) ) {
			$primary_theme_color = '#f89d35';
		}

		$secondary_theme_color = charitab_mascot_get_redux_option( 'theme-color-settings-custom-theme-color2' );
		if( empty($secondary_theme_color) ) {
			$secondary_theme_color = '#040A18';
		}
		$palettes = array(
			array(
				'name'  => __( 'Primary', 'charitab-wp' ),
				'slug'  => 'primary',
				'color' => $primary_theme_color,
			),
			array(
				'name'  => __( 'Secondary', 'charitab-wp' ),
				'slug'  => 'secondary',
				'color' => $secondary_theme_color,
			),
			array(
				'name'  => __( 'Dark Gray', 'charitab-wp' ),
				'slug'  => 'dark-gray',
				'color' => '#111',
			),
			array(
				'name'  => __( 'Light Gray', 'charitab-wp' ),
				'slug'  => 'light-gray',
				'color' => '#767676',
			),
			array(
				'name'  => __( 'White', 'charitab-wp' ),
				'slug'  => 'white',
				'color' => '#FFF',
			)
		);
		return apply_filters('charitab_mascot_gutenberg_color_palletts_filter', $palettes);
	}
}


// Editor color palette.
add_theme_support(
	'editor-color-palette',
	charitab_mascot_gutenberg_color_palletts()
);

// Add support for responsive embedded content.
add_theme_support( 'responsive-embeds' );




function charitab_mascot_action_wp_enqueue_gutenberg_frontend_styles() {
	if( is_rtl() ) {
		wp_enqueue_style( 'charitab-mascot-gutenberg-frontend-style-rtl', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/css/gutenberg/frontend-style-rtl.css', array(), CHARITAB_MASCOT_THEME_VERSION );
	} else {
		wp_enqueue_style( 'charitab-mascot-gutenberg-frontend-style', CHARITAB_MASCOT_TEMPLATE_URI . '/assets/css/gutenberg/frontend-style.css', array(), CHARITAB_MASCOT_THEME_VERSION );
	}
}

add_action('wp_enqueue_scripts', 'charitab_mascot_action_wp_enqueue_gutenberg_frontend_styles');

function load_custom_wp_admin_style() {
	if( is_admin() ){
		wp_enqueue_style( 'charitab-mascot-google-fonts', charitab_mascot_google_fonts_url(), null, false, 'all' );
	}
}
add_action( 'admin_enqueue_scripts', 'load_custom_wp_admin_style' );