<?php
/**
 * Displays the donate button to be displayed within campaign loops.
 *
 * Override this template by copying it to yourtheme/charitable/campaign-loop/donate-link.php
 *
 * @author  Studio 164a
 * @since   1.0.0
 * @version 1.5.0
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) { exit; }

/**
 * @var 	Charitable_Campaign
 */
$campaign = $view_args['campaign'];


if ( ! $campaign->can_receive_donations() ) :
	return;
endif;

?>
<div class="campaign-donation-btn">
	<a class="<?php echo esc_attr( apply_filters( 'charitab_mascot_charitable_campaign_loop_donate_link_btn', 'btn btn-theme-colored1 donate-button button') ); ?>" href="<?php echo charitable_get_permalink( 'campaign_donation_page', array( 'campaign_id' => $campaign->ID ) ) ?>" aria-label="<?php echo esc_attr( sprintf( _x( 'Make a donation to %s', 'make a donation to campaign', 'charitab-wp' ), get_the_title( $campaign->ID ) ) ) ?>">
		<?php echo esc_html( charitab_mascot_get_redux_option( 'charitable-donation-settings-donate-button-text', __( 'Donate', 'charitab-wp' ) ) ) ?>
	</a>
</div>
