<?php
/**
 * Displays the campaign loop.
 *
 * Override this template by copying it to yourtheme/charitable/campaign-loop.php
 *
 * @author  Studio 164a
 * @package Charitable/Templates/Campaign
 * @since   1.0.0
 * @version 1.2.3
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) { exit; }

$campaigns = $view_args['campaigns'];
$columns   = $view_args['columns'];
$args      = charitable_campaign_loop_args( $view_args );

if ( ! $campaigns->have_posts() ) :
	return;
endif;


//custom parameters from shortcode
global $tm_query_array;
$tm_query_array = array();
$tm_query_info = explode('-', $columns);
$columns = $tm_query_info[0];
foreach( $tm_query_info as $value ) {
	$split = explode(':', $value);
	if( isset($split[1]) ) {
		$tm_query_array[$split[0]] = $split[1];
	}
}

if ( isset( $tm_query_array['display_type'] ) && $tm_query_array['display_type'] == 'grid' ) :
	$loop_class = sprintf( 'campaign-loop campaign-grid campaign-grid-%d', $columns );
elseif ( isset( $tm_query_array['display_type'] ) && $tm_query_array['display_type'] == 'masonry' ) :
	$loop_class = sprintf( 'campaign-loop campaign-list isotope-layout masonry grid-%d campaign-isotope gutter-20', $columns );
elseif ( isset( $tm_query_array['display_type'] ) && $tm_query_array['display_type'] == 'carousel' ) :
	charitab_mascot_wp_enqueue_script_owl_carousel();
	$loop_class = sprintf( 'campaign-loop campaign-list tm-owl-carousel-%dcol', $columns );
elseif ( $columns > 1 ) :
	$loop_class = sprintf( 'campaign-loop campaign-grid campaign-grid-%d', $columns );
else :
	$loop_class = 'campaign-loop campaign-list';
endif;

/**
 * @hook charitable_campaign_loop_before
 */
do_action( 'charitable_campaign_loop_before', $campaigns, $args );

?>
<ul class="<?php echo esc_attr( $loop_class ) ?> <?php if( isset( $tm_query_array['custom_css_class'] ) ) { echo esc_attr( $tm_query_array['custom_css_class'] ); } ?>" <?php 
	if( isset( $tm_query_array['display_type'] ) && $tm_query_array['display_type'] == 'carousel' ) { 
		if( $tm_query_array['show_navigation'] == 'true' ) echo 'data-nav="true"';  
		if( $tm_query_array['show_bullets'] == 'true' ) echo 'data-dots="true"';  
		if( $tm_query_array['animation_speed'] != '' ) echo 'data-duration="'. esc_attr( $tm_query_array['animation_speed'] ) .'"'; 
	} ?>>
	<?php if( isset( $tm_query_array['display_type'] ) && $tm_query_array['display_type'] == 'masonry' ): ?>
	<div class="isotope-item isotope-item-sizer"></div>
	<?php endif; ?>

<?php
while ( $campaigns->have_posts() ) :

	$campaigns->the_post();

	charitable_template( 'campaign-loop/campaign.php', $args );

endwhile;

wp_reset_postdata();
?>
</ul>
<?php

/**
 * @hook charitable_campaign_loop_after
 */
do_action( 'charitable_campaign_loop_after', $campaigns, $args );
