<?php

/*
 * Adds Mascot_Core_Charitab_Widget_InstagramFeed widget.
 */
if( !class_exists( 'Mascot_Core_Charitab_Widget_InstagramFeed' ) ) {
class Mascot_Core_Charitab_Widget_InstagramFeed extends Mascot_Core_Charitab_Widget_Loader {

	/**
	 * Register widget with WordPress.
	 */
	function __construct() {
		$this->widgetOptions = array( 
			'classname'		=> 'widget-instagram-feed clearfix',
			'description'	=> esc_html__( 'The widget lets you easily displays instagram feed as list or carousel.', 'mascot-core' ),
		);
		parent::__construct( 'tm_widget_instagram_feed', esc_html__( '(TM) Instagram Feed', 'mascot-core' ), $this->widgetOptions );
		$this->getFormFields();
	}

	
	/**
	 * Get form fields of the widget.
	 */
	protected function getFormFields() {
		$this->formFields = array(
			array(
				'id'		=> 'title',
				'type'		=> 'text',
				'title'		=> esc_html__( 'Widget Title:', 'mascot-core' ),
				'desc'		=> '',
				'default'	=> esc_html__( 'Instagram Feed', 'mascot-core' ),
			),
			array(
				'id'		=> 'custom_css_class',
				'type'		=> 'text',
				'title'		=> esc_html__( 'Custom CSS Class:', 'mascot-core' ),
				'desc'		=> esc_html__( 'To style particular content element', 'mascot-core' ),
			),
			array(
				'id'		=> 'userid',
				'type'		=> 'text',
				'title'		=> esc_html__( 'Instagram User ID:', 'mascot-core' ),
				'desc'		=> sprintf( esc_html__( 'Put your instagram UserId here. Collect your own UserId from %1$shere%2$s.', 'mascot-core' ), '<a target="_blank" href="' . esc_url( 'https://smashballoon.com/instagram-feed/find-instagram-user-id/' ) . '">', '</a>' ),
				'default'	=> '3450544574',
			),
			array(
				'id'		=> 'accesstoken',
				'type'		=> 'text',
				'title'		=> esc_html__( 'Instagram Access Token:', 'mascot-core' ),
				'desc'		=> sprintf( esc_html__( 'Put your instagram Access Token here. Collect Your own Instagram Access Token from %1$shere%2$s.', 'mascot-core' ), '<a target="_blank" href="' . esc_url( 'http://instagram.pixelunion.net/' ) . '">', '</a>' ),
				'default'	=> '3450544574.1677ed0.7d0725a565914415b40a4953c17bcdc9',
			),
			array(
				'id'		=> 'count',
				'type'		=> 'text',
				'title'		=> esc_html__( 'Number of Images to Show:', 'mascot-core' ),
				'desc'		=> '',
			),
			array(
				'id'		=> 'feed_type',
				'type'		=> 'dropdown',
				'title'		=> esc_html__( 'Feed Type:', 'mascot-core' ),
				'desc'		=> '',
				'options'	=> array(
					'grid'		=> esc_html__( 'Grid', 'mascot-core' ),
					'carousel'   => esc_html__( 'Carousel', 'mascot-core' ),
				)
			),
			array(
				'id'		=> 'image_resolution',
				'type'		=> 'dropdown',
				'title'		=> esc_html__( 'Image Resolution:', 'mascot-core' ),
				'desc'		=> '',
				'options'	=> array(
					'thumbnail' => esc_html__( 'Thumbnail (150x150)', 'mascot-core' ),
					'low_resolution' => esc_html__( 'Low Resolution (320x320)', 'mascot-core' ),
					'standard_resolution' => esc_html__( 'Standard Resolution (640x640)', 'mascot-core' ),
				)
			),
		);
	}



	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args	 Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	public function widget( $args, $instance ) {
		echo wp_kses_post($args['before_widget']);

		if ( ! empty( $instance['title'] ) ) {
			echo wp_kses_post( $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ) . $args['after_title'] );
		}

		wp_enqueue_script( 'instafeed' );
		//Produce HTML version by using the parameters (filename, variation, folder name, parameters, widget_ob_start)
		$html = mascot_core_charitab_get_widget_template_part( 'instagram-feed' . '-' . $instance['feed_type'], null, 'instagram-feed/tpl', $instance, false );

		echo wp_kses_post($args['after_widget']);
	}
}
}