<?php

/*
 * Adds Mascot_Core_Charitab_Widget_ImageWidget widget.
 */
if( !class_exists( 'Mascot_Core_Charitab_Widget_ImageWidget' ) ) {
class Mascot_Core_Charitab_Widget_ImageWidget extends Mascot_Core_Charitab_Widget_Loader {

	/**
	 * Register widget with WordPress.
	 */
	function __construct() {
		$this->widgetOptions = array( 
			'classname'		=> 'widget-image-widget clearfix',
			'description'	=> esc_html__( 'A widget that displays Image with description.', 'mascot-core' ),
		);
		parent::__construct( 'tm_widget_image_widget', esc_html__( '(TM) Image Widget', 'mascot-core' ), $this->widgetOptions );
		$this->getFormFields();
	}

	
	/**
	 * Get form fields of the widget.
	 */
	protected function getFormFields() {
		$this->formFields = array(
			array(
				'id'		=> 'desc',
				'type'		=> 'description',
				'title'		=> $this->widgetOptions['description'],
			),
			array(
				'id'		=> 'title',
				'type'		=> 'text',
				'title'		=> esc_html__( 'Widget Title:', 'mascot-core' ),
				'desc'		=> '',
				'default'	=> '',
			),
			array(
				'id'		=> 'custom_css_class',
				'type'		=> 'text',
				'title'		=> esc_html__( 'Custom CSS Class:', 'mascot-core' ),
				'desc'		=> esc_html__( 'To style particular content element', 'mascot-core' ),
			),
			array(
				'id'		=> 'uploaded_image',
				'type'		=> 'media_upload',
				'title'		=> esc_html__( 'Image URL:', 'mascot-core' ),
			),
			array(
				'id'		=> 'image_alignment',
				'type'		=> 'dropdown',
				'title'		=> esc_html__( 'Image Alignment:', 'mascot-core' ),
				'desc'		=> '',
				'options'	=> array(
					'text-left flip'	 => esc_html__( 'Left', 'mascot-core' ),
					'text-center'   => esc_html__( 'Center', 'mascot-core' ),
					'text-right flip'	=> esc_html__( 'Right', 'mascot-core' )
				)
			),
			array(
				'id'		=> 'description',
				'type'		=> 'textarea',
				'title'		=> esc_html__( 'Description', 'mascot-core' ),
				'desc'		=> '',
			),
		);
	}



	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args	 Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	public function widget( $args, $instance ) {
		echo wp_kses_post($args['before_widget']);

		if ( ! empty( $instance['title'] ) ) {
			echo wp_kses_post( $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ) . $args['after_title'] );
		}

		//Produce HTML version by using the parameters (filename, variation, folder name, parameters, widget_ob_start)
		$html = mascot_core_charitab_get_widget_template_part( 'image-widget', null, 'image-widget/tpl', $instance, false );

		echo wp_kses_post($args['after_widget']);
	}
}
}