<?php

/*
 * Adds Mascot_Core_Charitab_Widget_IconBox widget.
 */
if( !class_exists( 'Mascot_Core_Charitab_Widget_IconBox' ) ) {
class Mascot_Core_Charitab_Widget_IconBox extends Mascot_Core_Charitab_Widget_Loader {

	/**
	 * Register widget with WordPress.
	 */
	function __construct() {
		$this->widgetOptions = array( 
			'classname'		=> 'widget-icon-box clearfix',
			'description'	=> esc_html__( 'The widget lets you easily add Icon Box.', 'mascot-core' ),
		);
		parent::__construct( 'tm_widget_icon_box', esc_html__( '(TM) Icon Box', 'mascot-core' ), $this->widgetOptions );
		$this->getFormFields();
	}

	
	/**
	 * Get form fields of the widget.
	 */
	protected function getFormFields() {
		$this->formFields = array(
			array(
				'id'		=> 'title',
				'type'		=> 'text',
				'title'		=> esc_html__( 'Widget Title:', 'mascot-core' ),
				'desc'		=> '',
				'default'	=> esc_html__( 'Icon Box', 'mascot-core' ),
			),
			array(
				'id'		=> 'custom_css_class',
				'type'		=> 'text',
				'title'		=> esc_html__( 'Custom CSS Class:', 'mascot-core' ),
				'desc'		=> esc_html__( 'To style particular content element', 'mascot-core' ),
			),
			array(
				'id'		=> 'icon_box_title',
				'type'		=> 'text',
				'title'		=> esc_html__( 'Title', 'mascot-core' ),
				'desc'		=> '',
			),
			array(
				'id'		=> 'title_tag',
				'type'		=> 'dropdown',
				'title'		=> esc_html__( 'Title Tag:', 'mascot-core' ),
				'desc'		=> '',
				'options'	=> array(
					'h5' => 'h5',
					'h2' => 'h2',
					'h3' => 'h3',
					'h4' => 'h4',
					'h6' => 'h6',
				)
			),
			array(
				'id'		=> 'paragraph',
				'type'		=> 'text',
				'title'		=> esc_html__( 'Paragraph', 'mascot-core' ),
				'desc'		=> '',
			),
			array(
				'id'		=> 'hyperlink',
				'type'		=> 'text',
				'title'		=> esc_html__( 'Hyperlink', 'mascot-core' ),
				'desc'		=> '',
			),
			array(
				'id'		=> 'target',
				'type'		=> 'checkbox',
				'title'		=> esc_html__( 'Open Link in New Tab', 'mascot-core' ),
				'desc'		=> '',
				'value'	=> 'on',
			),
			array(
				'id'		=> 'icon',
				'type'		=> 'text',
				'title'		=> esc_html__( 'Icon', 'mascot-core' ),
				'desc'		=> sprintf( esc_html__( 'Example: fa fa-user. Collect your own icon from %1$sFontAwesome%2$s.', 'mascot-core' ), '<a target="_blank" href="' . esc_url( 'https://fontawesome.com/v4.7.0/icons/' ) . '">', '</a>' ),
			),

			array(
				'id'		=> 'icon_size',
				'type'		=> 'dropdown',
				'title'		=> esc_html__( 'Icon Size:', 'mascot-core' ),
				'desc'		=> '',
				'options'	=> array(
					''  	  => esc_html__( 'Default', 'mascot-core' ),
					'icon-xs' => esc_html__( 'Extra Small', 'mascot-core' ),
					'icon-sm' => esc_html__( 'Small', 'mascot-core' ),
					'icon-md' => esc_html__( 'Medium', 'mascot-core' ),
					'icon-lg' => esc_html__( 'Large', 'mascot-core' ),
					'icon-xl' => esc_html__( 'Extra Large', 'mascot-core' ),
				)
			),
			array(
				'id'		=> 'icon_color',
				'type'		=> 'dropdown',
				'title'		=> esc_html__( 'Icon Color:', 'mascot-core' ),
				'desc'		=> '',
				'options'	=> array(
					'icon-gray' => esc_html__( 'Gray', 'mascot-core' ),
					''			=> esc_html__( 'Default', 'mascot-core' ),
					'icon-dark' => esc_html__( 'Dark', 'mascot-core' ),
				)
			),

			array(
				'id'		=> 'icon_style',
				'type'		=> 'dropdown',
				'title'		=> esc_html__( 'Icon Style:', 'mascot-core' ),
				'desc'		=> '',
				'options'	=> array(
					'icon-rounded' => esc_html__( 'Rounded', 'mascot-core' ),
					'icon-default' => esc_html__( 'Default', 'mascot-core' ),
					'icon-circled' => esc_html__( 'Circled', 'mascot-core' ),
				)
			),
			array(
				'id'		=> 'icon_theme_colored',
				'type'		=> 'dropdown',
				'title'		=> esc_html__( 'Make Icon Theme Colored?', 'mascot-core' ),
				'desc'		=> '',
				'options'	=> mascot_core_charitab_theme_color_list()
			),
			array(
				'id'		=> 'icon_border_style',
				'type'		=> 'checkbox',
				'title'		=> esc_html__( 'Make Icon Area Bordered?', 'mascot-core' ),
				'desc'		=> '',
				'value'	=> 'on',
			),
		);
	}



	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args	 Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	public function widget( $args, $instance ) {
		echo wp_kses_post($args['before_widget']);

		if ( ! empty( $instance['title'] ) ) {
			echo wp_kses_post( $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ) . $args['after_title'] );
		}

		//Produce HTML version by using the parameters (filename, variation, folder name, parameters, widget_ob_start)
		$html = mascot_core_charitab_get_widget_template_part( 'icon-box', null, 'icon-box/tpl', $instance, false );

		echo wp_kses_post($args['after_widget']);
	}
}
}