<?php

/*
 * Adds Mascot_Core_Charitab_Widget_GooglePlus widget.
 */
if( !class_exists( 'Mascot_Core_Charitab_Widget_GooglePlus' ) ) {
class Mascot_Core_Charitab_Widget_GooglePlus extends Mascot_Core_Charitab_Widget_Loader {

	/**
	 * Register widget with WordPress.
	 */
	function __construct() {
		$this->widgetOptions = array( 
			'classname'		=> 'widget-google-plus clearfix',
			'description'	=> esc_html__( 'The widget lets you easily displays Google Plus.', 'mascot-core' ),
		);
		parent::__construct( 'tm_widget_google_plus', esc_html__( '(TM) Google +', 'mascot-core' ), $this->widgetOptions );
		$this->getFormFields();
	}

	
	/**
	 * Get form fields of the widget.
	 */
	protected function getFormFields() {
		$this->formFields = array(
			array(
				'id'		=> 'title',
				'type'		=> 'text',
				'title'		=> esc_html__( 'Widget Title:', 'mascot-core' ),
				'desc'		=> '',
				'default'	=> esc_html__( 'Google Plus', 'mascot-core' ),
			),
			array(
				'id'		=> 'custom_css_class',
				'type'		=> 'text',
				'title'		=> esc_html__( 'Custom CSS Class:', 'mascot-core' ),
				'desc'		=> esc_html__( 'To style particular content element', 'mascot-core' ),
			),
			array(
				'id'		=> 'badge',
				'type'		=> 'dropdown',
				'title'		=> esc_html__( 'Badge Types', 'mascot-core' ),
				'options'	=> array(
					'g-community'   => esc_html__( 'Communities', 'mascot-core' ),
					'g-person'		=> esc_html__( 'Profiles', 'mascot-core' ),
					'g-page'		=> esc_html__( 'Pages', 'mascot-core' ),
				)
			),
			array(
				'id'		=> 'url',
				'type'		=> 'text',
				'title'		=> esc_html__( 'Google + Page URL:', 'mascot-core' ),
				'default'	=> 'https://plus.google.com/communities/105484898574579059070',
			),
			array(
				'id'		=> 'layout',
				'type'		=> 'dropdown',
				'title'		=> esc_html__( 'Layout', 'mascot-core' ),
				'options'	=> array(
					''			=> esc_html__( 'Portrait', 'mascot-core' ),
					'landscape' => esc_html__( 'Landscape', 'mascot-core' ),
				)
			),
			array(
				'id'		=> 'theme',
				'type'		=> 'dropdown',
				'title'		=> esc_html__( 'Color Theme', 'mascot-core' ),
				'options'	=> array(
					''	 => esc_html__( 'Light', 'mascot-core' ),
					'dark' => esc_html__( 'Dark', 'mascot-core' ),
				)
			),
			array(
				'id'		=> 'width',
				'type'		=> 'text',
				'title'		=> esc_html__( 'Width:', 'mascot-core' ),
				'desc'		=> esc_html__( 'The pixel width of the embed. Default 300', 'mascot-core' ),
			),
			array(
				'id'		=> 'showcoverphoto',
				'type'		=> 'checkbox',
				'title'		=> esc_html__( 'Show Cover Photo', 'mascot-core' ),
				'desc'		=> '',
				'value'	=> 'true',
				'default'	=> 'checked',
			),
		);
	}



	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args	 Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	public function widget( $args, $instance ) {
		echo wp_kses_post($args['before_widget']);

		if ( ! empty( $instance['title'] ) ) {
			echo wp_kses_post( $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ) . $args['after_title'] );
		}

		//Produce HTML version by using the parameters (filename, variation, folder name, parameters, widget_ob_start)
		$html = mascot_core_charitab_get_widget_template_part( 'google-plus', null, 'google-plus/tpl', $instance, false );

		echo wp_kses_post($args['after_widget']);
	}
}
}