<?php

/*
 * Adds Mascot_Core_Charitab_Widget_ContactInfo widget.
 */
if( !class_exists( 'Mascot_Core_Charitab_Widget_ContactInfo' ) ) {
class Mascot_Core_Charitab_Widget_ContactInfo extends Mascot_Core_Charitab_Widget_Loader {

	/**
	 * Register widget with WordPress.
	 */
	function __construct() {
		$this->widgetOptions = array( 
			'classname'		=> 'widget-contact-info clearfix',
			'description'	=> esc_html__( 'A widget that displays contact info in different styles.', 'mascot-core' ),
		);
		parent::__construct( 'tm_widget_contact_info', esc_html__( '(TM) Contact Info', 'mascot-core' ), $this->widgetOptions );
		$this->getFormFields();
	}

	
	/**
	 * Get form fields of the widget.
	 */
	protected function getFormFields() {
		$this->formFields = array(
			array(
				'id'		=> 'desc',
				'type'		=> 'description',
				'title'		=> $this->widgetOptions['description'],
			),
			array(
				'id'		=> 'title',
				'type'		=> 'text',
				'title'		=> esc_html__( 'Widget Title:', 'mascot-core' ),
				'desc'		=> '',
				'default'	=> esc_html__( 'Contact Info', 'mascot-core' ),
			),
			array(
				'id'		=> 'custom_css_class',
				'type'		=> 'text',
				'title'		=> esc_html__( 'Custom CSS Class:', 'mascot-core' ),
				'desc'		=> esc_html__( 'To style particular content element', 'mascot-core' ),
			),
			array(
				'id'		=> 'logo',
				'type'		=> 'media_upload',
				'title'		=> esc_html__( 'Logo:', 'mascot-core' ),
			),
			array(
				'id'		=> 'description',
				'type'		=> 'textarea',
				'title'		=> esc_html__( 'Description', 'mascot-core' ),
				'desc'		=> '',
			),

			array(
				'id'		=> 'name',
				'type'		=> 'text',
				'title'		=> esc_html__( 'Name', 'mascot-core' ),
				'desc'		=> '',
			),
			array(
				'id'		=> 'name_fonticon',
				'type'		=> 'text',
				'title'		=> esc_html__( 'And it\'s Font Icon: ', 'mascot-core' ),
				'desc'		=> '',
				'default'	=> 'fa fa-user',
				'width'		=> 'auto',
			),

			array(
				'id'		=> 'company',
				'type'		=> 'text',
				'title'		=> esc_html__( 'Company Name', 'mascot-core' ),
				'desc'		=> '',
			),
			array(
				'id'		=> 'company_fonticon',
				'type'		=> 'text',
				'title'		=> esc_html__( 'And it\'s Font Icons: ', 'mascot-core' ),
				'desc'		=> '',
				'default'	=> 'fa fa-building-o',
				'width'		=> 'auto',
			),

			array(
				'id'		=> 'phone',
				'type'		=> 'text',
				'title'		=> esc_html__( 'Phone', 'mascot-core' ),
				'desc'		=> '',
			),
			array(
				'id'		=> 'phone_fonticon',
				'type'		=> 'text',
				'title'		=> esc_html__( 'And it\'s Font Icon: ', 'mascot-core' ),
				'desc'		=> '',
				'default'	=> 'fa fa-phone',
				'width'		=> 'auto',
			),

			array(
				'id'		=> 'fax',
				'type'		=> 'text',
				'title'		=> esc_html__( 'Fax', 'mascot-core' ),
				'desc'		=> '',
			),
			array(
				'id'		=> 'fax_fonticon',
				'type'		=> 'text',
				'title'		=> esc_html__( 'And it\'s Font Icon: ', 'mascot-core' ),
				'desc'		=> '',
				'default'	=> 'fa fa-fax',
				'width'		=> 'auto',
			),

			array(
				'id'		=> 'email',
				'type'		=> 'text',
				'title'		=> esc_html__( 'Email', 'mascot-core' ),
				'desc'		=> '',
			),
			array(
				'id'		=> 'email_fonticon',
				'type'		=> 'text',
				'title'		=> esc_html__( 'And it\'s Font Icon: ', 'mascot-core' ),
				'desc'		=> '',
				'default'	=> 'fa fa-envelope',
				'width'		=> 'auto',
			),

			array(
				'id'		=> 'website',
				'type'		=> 'text',
				'title'		=> esc_html__( 'Website', 'mascot-core' ),
				'desc'		=> '',
			),
			array(
				'id'		=> 'website_fonticon',
				'type'		=> 'text',
				'title'		=> esc_html__( 'And it\'s Font Icon: ', 'mascot-core' ),
				'desc'		=> '',
				'default'	=> 'fa fa-globe',
				'width'		=> 'auto',
			),

			array(
				'id'		=> 'skype',
				'type'		=> 'text',
				'title'		=> esc_html__( 'Skype', 'mascot-core' ),
				'desc'		=> '',
			),
			array(
				'id'		=> 'skype_fonticon',
				'type'		=> 'text',
				'title'		=> esc_html__( 'And it\'s Font Icon: ', 'mascot-core' ),
				'desc'		=> '',
				'default'	=> 'fa fa-skype',
				'width'		=> 'auto',
			),

			array(
				'id'		=> 'address',
				'type'		=> 'text',
				'title'		=> esc_html__( 'Address', 'mascot-core' ),
				'desc'		=> '',
			),
			array(
				'id'		=> 'address_fonticon',
				'type'		=> 'text',
				'title'		=> esc_html__( 'And it\'s Font Icon: ', 'mascot-core' ),
				'desc'		=> '',
				'default'	=> 'fa fa-location-arrow',
				'width'		=> 'auto',
			),

			array(
				'id'		=> 'contact_info_style',
				'type'		=> 'dropdown',
				'title'		=> esc_html__( 'Contact Info Style', 'mascot-core' ),
				'desc'		=> '',
				'options'	=> array(
					'style1' => esc_html__( 'Style 1', 'mascot-core' ),
					'style2' => esc_html__( 'Style 2', 'mascot-core' ),
					'style3' => esc_html__( 'Style 3', 'mascot-core' ),
					'style4' => esc_html__( 'Style 4', 'mascot-core' ),
				)
			),
			array(
				'id'		=> 'icon_theme_colored',
				'type'		=> 'dropdown',
				'title'		=> esc_html__( 'Make Icon Theme Colored?', 'mascot-core' ),
				'desc'		=> '',
				'options'	=> mascot_core_charitab_theme_color_list()
			),
		);
	}



	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args	 Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	public function widget( $args, $instance ) {
		echo wp_kses_post($args['before_widget']);

		if ( ! empty( $instance['title'] ) ) {
			echo wp_kses_post( $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ) . $args['after_title'] );
		}

		//Produce HTML version by using the parameters (filename, variation, folder name, parameters, widget_ob_start)
		$html = mascot_core_charitab_get_widget_template_part( 'contact-info-' . $instance['contact_info_style'], null, 'contact-info/tpl', $instance, false );

		echo wp_kses_post($args['after_widget']);
	}
}
}