<?php
namespace MASCOTCORECHARITAB\Shortcodes\WorkingStepsHolder;

use MASCOTCORECHARITAB\Shortcodes\Lib;

/**
 * class SC_Working_Steps_Holder
 * @package MASCOTCORECHARITAB\Shortcodes\WorkingStepsHolder;
 */
class SC_Working_Steps_Holder implements Lib\Mascot_Core_Charitab_Interface_Shortcodes {
	
	/**
	 * @var shortcode_base
	 */
	private $shortcode_base;

	/**
	 * construct
	 */
	public function __construct() {
		$this->shortcode_base = 'tm_working_steps_holder';
		add_action('init', array($this, 'MapShortCodeVC'), 998);
	}

	/**
	 * Returns shortcode_base for shortcode
	 */
	public function getShortCodeBase() {
		return $this->shortcode_base;
	}

	/**
	 * Maps shortcode to Visual Composer
	 */
	public function MapShortCodeVC() {
    
		if(function_exists('vc_map')) {
			$vc_map = array(
				'name'		=> esc_html__( 'Working Steps Holder', 'mascot-core' ),
				'base'		=>$this->shortcode_base,
				'category'	=> 'by TM',
				'icon'		=> 'mascot-vc-icons vc-icon-working-steps',
				'as_parent' => array('only' => 'tm_working_steps_holder_item'),
				"js_view" => 'VcColumnView',
				'params'	=>array(
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Custom CSS class", 'mascot-core' ),
						"param_name"	=> "custom_css_class",
						"description"	=> esc_html__( 'To style particular content element.', 'mascot-core' ),
					),

					
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Number of Working Step Items", 'mascot-core' ),
						"param_name"	=> "number_of_items",
						'description'   => '',
						'value'			=> array(
							esc_html__( 'three', 'mascot-core' )	=> 'three',
							esc_html__( 'four', 'mascot-core' )		=> 'four',
						),
						'admin_label'   => true,
						'save_always'   => true,
					),
					
					mascot_core_charitab_vc_add_css_editor(),

				)
			);
			vc_map( $vc_map );

			//Modify vc_map from themes
			if( function_exists('mascot_core_charitab_sc_working_steps_holder_vc_map_modifier') ) {
				mascot_core_charitab_sc_working_steps_holder_vc_map_modifier( $this->shortcode_base );
			}
		}
	}

	/**
	 * Renders shortcodes HTML
	 */
	public function render( $attr, $content = null ) {

		//Render Shortcode from themes
		if( function_exists('mascot_core_charitab_sc_working_steps_holder_render') && function_exists('vc_map') ) {
			return mascot_core_charitab_sc_working_steps_holder_render( $attr, $content );
		}
		
	}
}