<?php
namespace MASCOTCORECHARITAB\Shortcodes\UnorderedList;

use MASCOTCORECHARITAB\Shortcodes\Lib;

/**
 * class SC_Unordered_List
 * @package MASCOTCORECHARITAB\Shortcodes\UnorderedList;
 */
class SC_Unordered_List implements Lib\Mascot_Core_Charitab_Interface_Shortcodes {
	
	/**
	 * @var shortcode_base
	 */
	private $shortcode_base;

	/**
	 * construct
	 */
	public function __construct() {
		$this->shortcode_base = 'tm_unordered_list';
		add_action('init', array($this, 'MapShortCodeVC'), 998);
	}

	/**
	 * Returns shortcode_base for shortcode
	 */
	public function getShortCodeBase() {
		return $this->shortcode_base;
	}

	/**
	 * Maps shortcode to Visual Composer
	 */
	public function MapShortCodeVC() {
		$text_options = esc_html__( 'Text Options', 'mascot-core' );
		$footer_cite_options = esc_html__( 'Footer Cite Options', 'mascot-core' );

		if(function_exists('vc_map')) {
			$vc_map = array(
				'name'		=> esc_html__( 'Unordered List', 'mascot-core' ),
				'base'		=>$this->shortcode_base,
				'category'	=> 'by TM',
				'icon'		=> 'mascot-vc-icons vc-icon-unordered-list',
				'allowed_container_element' => 'vc_row',
				'params'	=>array(
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Custom CSS class", 'mascot-core' ),
						"param_name"	=> "custom_css_class",
						"description"	=> esc_html__( 'To style particular content element.', 'mascot-core' ),
					),

					
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Design Style", 'mascot-core' ),
						"param_name"	=> "design_style",
						'description'   => '',
						'value'			=> array(
							esc_html__( 'Default', 'mascot-core' )	=> 'list-default',
							esc_html__( 'Style 23 Tick + Circle', 'mascot-core' )	=> 'list-style23',
							esc_html__( 'Style 2', 'mascot-core' )	=> 'list-style2',
							esc_html__( 'Style 3', 'mascot-core' )	=> 'list-style3',
							esc_html__( 'Style 4', 'mascot-core' )	=> 'list-style4',
							esc_html__( 'Style 5', 'mascot-core' )	=> 'list-style5',
							esc_html__( 'Style 6', 'mascot-core' )	=> 'list-style6',
							esc_html__( 'Style 7', 'mascot-core' )	=> 'list-style7',
							esc_html__( 'Style 8', 'mascot-core' )	=> 'list-style8',
							esc_html__( 'Style 9', 'mascot-core' )	=> 'list-style9',
							esc_html__( 'Style 10', 'mascot-core' )	=> 'list-style10',
							esc_html__( 'Style 11', 'mascot-core' )	=> 'list-style11',
							esc_html__( 'Style 12', 'mascot-core' )	=> 'list-style12',
							esc_html__( 'Style 13', 'mascot-core' )	=> 'list-style13',
							esc_html__( 'Style 14', 'mascot-core' )	=> 'list-style14',
							esc_html__( 'Style 15', 'mascot-core' )	=> 'list-style15',
							esc_html__( 'Style 16', 'mascot-core' )	=> 'list-style16',
							esc_html__( 'Style 17', 'mascot-core' )	=> 'list-style17',
							esc_html__( 'Style 18', 'mascot-core' )	=> 'list-style18',
							esc_html__( 'Style 19', 'mascot-core' )	=> 'list-style19',
							esc_html__( 'Style 20', 'mascot-core' )	=> 'list-style20',
							esc_html__( 'Style 21', 'mascot-core' )	=> 'list-style21',
							esc_html__( 'Style 22', 'mascot-core' )	=> 'list-style22',
						),
						'admin_label'   => true,
						'save_always'   => true,
					),
					
					array(
						'type'			=> 'textarea_html',
						"heading"		=> esc_html__( "Content", 'mascot-core' ),
						"param_name"	=> "content",
						"value"		 	=> '<ul><li>List item one<ul><li>List item one<ul><li>List item one</li><li>List item two</li></ul></li><li>List item two</li></ul></li><li>List item two</li><li>List item three</li></ul>',
					),




					//Text Options
					array(
						'type'			=> 'colorpicker',
						"heading"		=> esc_html__( "Text Color", 'mascot-core' ),
						"param_name"	=> "text_text_color",
						"value"		 => '',
						'group'			=> $text_options
					),
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Font Size", 'mascot-core' ),
						"param_name"	=> "text_font_size",
						"description"	=> "",
						'group'			=> $text_options
					),
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Line Height", 'mascot-core' ),
						"param_name"	=> "text_line_height",
						"description"	=> "",
						'group'			=> $text_options
					),
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Letter Spacing", 'mascot-core' ),
						"param_name"	=> "text_letter_spacing",
						"description"	=> "",
						'group'			=> $text_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Font Style", 'mascot-core' ),
						"param_name"	=> "text_font_style",
						"description"	=> "",
						'value'			=> mascot_core_charitab_vc_font_style_list(),
						'group'			=> $text_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Font Weight", 'mascot-core' ),
						"param_name"	=> "text_font_weight",
						"description"	=> "",
						'value'			=> mascot_core_charitab_vc_font_weight_list(),
						'group'			=> $text_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Text Transform", 'mascot-core' ),
						"param_name"	=> "text_text_transform",
						"description"	=> "",
						'value'			=> mascot_core_charitab_vc_text_transform_list(),
						'group'			=> $text_options
					),
				)
			);
			vc_map( $vc_map );

			//Modify vc_map from themes
			if( function_exists('mascot_core_charitab_sc_unordered_list_vc_map_modifier') ) {
				mascot_core_charitab_sc_unordered_list_vc_map_modifier( $this->shortcode_base );
			}
		}
	}

	/**
	 * Renders shortcodes HTML
	 */
	public function render( $attr, $content = null ) {

		//Render Shortcode from themes
		if( function_exists('mascot_core_charitab_sc_unordered_list_render') && function_exists('vc_map') ) {
			return mascot_core_charitab_sc_unordered_list_render( $attr, $content );
		}
		
	}
}