<?php
if(function_exists('vc_map')) {
	add_action( 'init', 'mascot_core_charitab_reg_shortcodes_timeline_cd_horizontal', 998 );
}
function mascot_core_charitab_reg_shortcodes_timeline_cd_horizontal() {
	class WPBakeryShortCode_tmvc_Timeline_CD_Horizontal  extends WPBakeryShortCodesContainer {}
	vc_map( array(
		"name" =>  __( 'Timeline - Horizontal (CD)', 'mascot-core' ),
		"base" => "tmvc_timeline_cd_horizontal",
		"as_parent" => array('only' => 'tmvc_timeline_cd_horizontal_each_block'),
		"content_element" => true,
		"category" => esc_html__( 'by TM', 'mascot-core' ),
		"icon" => 'mascot-vc-icons vc-icon-vc-map-timeline_cd_horizontal',
		"show_settings_on_create" => false,
		"js_view" => 'VcColumnView',
		'params' => array(
			array(
				'type' => 'param_group',
				'heading' => __( 'Timeline Dates', 'js_composer' ),
				'param_name' => 'values',
				'value' => urlencode( json_encode( array(
					array(
						'date' 			=> __( '16/01/2014', 'js_composer' ),
						'date_label' 	=> __( '16 Jan', 'js_composer' ),
						'make_selected' => 'true',
					),
					array(
						'date' 			=> __( '28/02/2014', 'js_composer' ),
						'date_label' 	=> __( '28 Feb', 'js_composer' ),
					),
					array(
						'date' 			=> __( '20/04/2014', 'js_composer' ),
						'date_label' 	=> __( '20 Mar', 'js_composer' ),
					),
				) ) ),
				'params' => array(
					array(
						'type' => 'textfield',
						'heading' => __( 'Date', 'js_composer' ),
						'param_name' => 'date',
						'description' => __( 'Date in (MM/DD/YYYY) format. Example: 16/01/2014.', 'js_composer' ),
						'admin_label' => true,
					),
					array(
						'type' => 'textfield',
						'heading' => __( 'Date Label', 'js_composer' ),
						'param_name' => 'date_label',
						'description' => __( 'Example: 16 Jan.', 'js_composer' ),
						'admin_label' => true,
					),
					array(
						'type'			=> 'checkbox',
						"heading"		=> esc_html__( "Make it Selected?", 'mascot-core' ),
						"param_name"	=> "make_selected",
						'description'	=> '',
					),
				),
			),
		)
	) );


	class WPBakeryShortCode_tmvc_Timeline_CD_Horizontal_Each_Block  extends WPBakeryShortCodesContainer {}
	vc_map( array(
		"name" =>  __( 'Each Timeline Block', 'mascot-core' ),
		"base" => "tmvc_timeline_cd_horizontal_each_block",
		"as_parent" => array('except' => 'vc_row, vc_accordion'),
		"as_child" => array('only' => 'tmvc_flipbox'),
		"content_element" => true,
		"category" => esc_html__( 'by TM', 'mascot-core' ),
		"icon" => 'mascot-vc-icons vc-icon-vc-map-timeline_cd_horizontal-block',
		"show_settings_on_create" => false,
		"js_view" => 'VcColumnView',
		"params" => array(
			array(
				'type' => 'textfield',
				'heading' => __( 'Date', 'js_composer' ),
				'param_name' => 'date',
				'description' => __( 'Date in (MM/DD/YYYY) format. Example: 16/01/2014.', 'js_composer' ),
				'admin_label' => true,
			),
			array(
				'type'			=> 'checkbox',
				"heading"		=> esc_html__( "Make it Selected?", 'mascot-core' ),
				"param_name"	=> "make_selected",
				'description'	=> '',
				'admin_label' => true,
			),
			array(
				"type"			=> 'dropdown',
				"heading"		=> esc_html__( "Text Typography", 'mascot-core' ) ,
				"param_name"	=> "section_typo",
				"description"	=> esc_html__( "Define the color typography of the text of this block.", 'mascot-core' ) ,
				"value" => array(
					esc_html__( 'Default', 'mascot-core' ) => '',
					esc_html__( 'Light Text - on Dark Background', 'mascot-core' ) => 'section-typo-light',
					esc_html__( 'Dark Text - on White Background', 'mascot-core' ) => 'section-typo-dark',
				) ,
				"weight" => "99"
			),
			mascot_core_charitab_vc_add_css_editor(),
		)
	) );
}