<?php
namespace MASCOTCORECHARITAB\Shortcodes\SocialList;

use MASCOTCORECHARITAB\Shortcodes\Lib;

/**
 * class SC_Social_List
 * @package MASCOTCORECHARITAB\Shortcodes\SocialList;
 */
class SC_Social_List implements Lib\Mascot_Core_Charitab_Interface_Shortcodes {
	
	/**
	 * @var shortcode_base
	 */
	private $shortcode_base;

	/**
	 * construct
	 */
	public function __construct() {
		$this->shortcode_base = 'tm_social_list';
		add_action('init', array($this, 'MapShortCodeVC'), 998);
	}

	/**
	 * Returns shortcode_base for shortcode
	 */
	public function getShortCodeBase() {
		return $this->shortcode_base;
	}

	/**
	 * Maps shortcode to Visual Composer
	 */
	public function MapShortCodeVC() {
		if(function_exists('vc_map')) {
			$group_content_options = esc_html__( 'Content Options', 'mascot-core' );

			$vc_map = array(
				'name'		=> esc_html__( 'Social List', 'mascot-core' ),
				'base'		=>$this->shortcode_base,
				'category'	=> 'by TM',
				'icon'		=> 'mascot-vc-icons vc-icon-twitter',
				'allowed_container_element' => 'vc_row',
				'params'	=>array(
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Custom CSS class", 'mascot-core' ),
						"param_name"	=> "custom_css_class",
						"description"	=> esc_html__( 'To style particular content element.', 'mascot-core' ),
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Icon Type", 'mascot-core' ),
						"param_name"	=> "icon_type",
						'desc'		  => '',
						'value'			=> array(
							esc_html__( 'Flat Color', 'mascot-core' )		=>   'icon-flat',
							esc_html__( 'Brand Color', 'mascot-core' )		=>   'icon-brand',
						),
						'save_always'   => true,
						'admin_label'   => true,
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Icon Color", 'mascot-core' ),
						"param_name"	=> "icon_color",
						'desc'		  => '',
						'value'			=> array(
							esc_html__( 'Dark', 'mascot-core' )		=>   'icon-dark',
							esc_html__( 'Default', 'mascot-core' )	=>   '',
							esc_html__( 'Gray', 'mascot-core' )		=>   'icon-gray',
						),
						'dependency'	=> array('element' => 'icon_type', 'value' => 'icon-flat'),
						'save_always'   => true,
						'admin_label'   => true,
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Icon Style", 'mascot-core' ),
						"param_name"	=> "icon_style",
						'desc'		  => '',
						'value'			=> array(
							esc_html__( 'Rounded', 'mascot-core' )		=>   'icon-rounded',
							esc_html__( 'Default', 'mascot-core' )		=>   'icon-default',
							esc_html__( 'Circled', 'mascot-core' )		=>   'icon-circled',
						),
						'save_always'   => true,
						'admin_label'   => true,
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Icon Size", 'mascot-core' ),
						"param_name"	=> "icon_size",
						'desc'		  => '',
						'value'			=> array(
							esc_html__( 'Extra Small', 'mascot-core' )	=>   'icon-xs',
							esc_html__( 'Small', 'mascot-core' )		=>   'icon-sm',
							esc_html__( 'Default', 'mascot-core' )		=>   '',
							esc_html__( 'Medium', 'mascot-core' )		=>   'icon-md',
							esc_html__( 'Large', 'mascot-core' )		=>   'icon-lg',
							esc_html__( 'Extra Large', 'mascot-core' )	=>   'icon-xl',
						),
						'save_always'   => true,
						'admin_label'   => true,
					),
					array(
						'type'			=> 'checkbox',
						"heading"		=> esc_html__( "Make Icon Area Bordered?", 'mascot-core' ),
						"param_name"	=> "icon_border_style",
						'desc'		  => '',
						'dependency'	=> array('element' => 'icon_type', 'value' => 'icon-flat'),
						'admin_label'   => true,
						'std'			=> true,
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Make Icon Theme Colored?", 'mascot-core' ),
						"param_name"	=> "icon_theme_colored",
						'desc'		  => '',
						'value'			=> mascot_core_charitab_theme_color_list_vc(),
						'dependency'	=> array('element' => 'icon_type', 'value' => 'icon-flat'),
						'admin_label'   => true,
					),

				)
			);
			vc_map( $vc_map );

			//Modify vc_map from themes
			if( function_exists('mascot_core_charitab_sc_social_list_vc_map_modifier') ) {
				mascot_core_charitab_sc_social_list_vc_map_modifier( $this->shortcode_base );
			}
		}
	}

	/**
	 * Renders shortcodes HTML
	 */
	public function render( $attr, $content = null ) {

		//Render Shortcode from themes
		if( function_exists('mascot_core_charitab_sc_social_list_render') && function_exists('vc_map') ) {
			return mascot_core_charitab_sc_social_list_render( $attr, $content );
		}
		
	}
}