<?php
namespace MASCOTCORECHARITAB\Shortcodes\ProgressBar;

use MASCOTCORECHARITAB\Shortcodes\Lib;

/**
 * class SC_Progress_Bar
 * @package MASCOTCORECHARITAB\Shortcodes\ProgressBar;
 */
class SC_Progress_Bar implements Lib\Mascot_Core_Charitab_Interface_Shortcodes {
	
	/**
	 * @var shortcode_base
	 */
	private $shortcode_base;

	/**
	 * construct
	 */
	public function __construct() {
		$this->shortcode_base = 'tm_progress_bar';
		add_action('init', array($this, 'MapShortCodeVC'), 998);
	}

	/**
	 * Returns shortcode_base for shortcode
	 */
	public function getShortCodeBase() {
		return $this->shortcode_base;
	}

	/**
	 * Maps shortcode to Visual Composer
	 */
	public function MapShortCodeVC() {
		if(function_exists('vc_map')) {
			$group_content_options = esc_html__( 'Content Options', 'mascot-core' );

			$vc_map = array(
				'name'		=> esc_html__( 'Progress Bar', 'mascot-core' ),
				'base'		=>$this->shortcode_base,
				'category'	=> 'by TM',
				'icon'		=> 'mascot-vc-icons vc-icon-progress-bar',
				'allowed_container_element' => 'vc_row',
				'params'	=>array(
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Custom CSS class", 'mascot-core' ),
						"param_name"	=> "custom_css_class",
						"description"	=> esc_html__( 'To style particular content element.', 'mascot-core' ),
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Design Style", 'mascot-core' ),
						"param_name"	=> "design_style",
						"description"	=> "",
						'value'			=> array(
							esc_html__( "Style 1", 'mascot-core' )   => 'style1',
							esc_html__( "Style 2", 'mascot-core' )   => 'style2'
						),
						'save_always'   => true,
						'admin_label'   => true,
					),
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Title", 'mascot-core' ),
						"param_name"	=> "title",
						"description"	=> esc_html__( 'Add your Progress/Skill Title Text. Default: Wordpress', 'mascot-core' ),
						'admin_label'   => true,
					),
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Percentage Value", 'mascot-core' ),
						"param_name"	=> "percentage_value",
						"description"	=> esc_html__( 'Add a Percentage Value. Maximum 100. Default: 85', 'mascot-core' ),
						'admin_label'   => true,
					),
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Unit Symbol", 'mascot-core' ),
						"param_name"	=> "unit_symbol",
						"description"	=> esc_html__( 'Add an Unit Symbol. Default: %', 'mascot-core' ),
						'admin_label'   => true,
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Title Tag", 'mascot-core' ),
						"param_name"	=> "title_tag",
						"description"	=> "",
						'value'			=> mascot_core_charitab_heading_tag_list(),
						'std'			=> 'h5',
						'admin_label'   => true,
					),
					array(
						'type'			=> 'colorpicker',
						"heading"		=> esc_html__( "Progress Color", 'mascot-core' ),
						"param_name"	=> "progress_color",
						"value"		 => '',
						"description"	=> esc_html__( 'Pick a color for progress bar. Leave empty for default value.', 'mascot-core' ),
						'admin_label'   => true,
					),
					array(
						'type'			=> 'colorpicker',
						"heading"		=> esc_html__( "Background Color", 'mascot-core' ),
						"param_name"	=> "background_color",
						"value"		 => '',
						"description"	=> esc_html__( 'Pick a color for the background of progress bar. Leave empty for default value.', 'mascot-core' ),
						'admin_label'   => true,
					),

				)
			);
			vc_map( $vc_map );

			//Modify vc_map from themes
			if( function_exists('mascot_core_charitab_sc_progress_bar_vc_map_modifier') ) {
				mascot_core_charitab_sc_progress_bar_vc_map_modifier( $this->shortcode_base );
			}
		}
	}

	/**
	 * Renders shortcodes HTML
	 */
	public function render( $attr, $content = null ) {

		//Render Shortcode from themes
		if( function_exists('mascot_core_charitab_sc_progress_bar_render') && function_exists('vc_map') ) {
			return mascot_core_charitab_sc_progress_bar_render( $attr, $content );
		}
		
	}
}