<?php
namespace MASCOTCORECHARITAB\Shortcodes\PricingTable;

use MASCOTCORECHARITAB\Shortcodes\Lib;

/**
 * class SC_PricingTable
 * @package MASCOTCORECHARITAB\Shortcodes\PricingTable;
 */
class SC_PricingTable implements Lib\Mascot_Core_Charitab_Interface_Shortcodes {
	
	/**
	 * @var shortcode_base
	 */
	private $shortcode_base;

	/**
	 * construct
	 */
	public function __construct() {
		$this->shortcode_base = 'tm_pricing_table';
		add_action('init', array($this, 'MapShortCodeVC'), 998);
	}

	/**
	 * Returns shortcode_base for shortcode
	 */
	public function getShortCodeBase() {
		return $this->shortcode_base;
	}

	/**
	 * Maps shortcode to Visual Composer
	 */
	public function MapShortCodeVC() {
		if(function_exists('vc_map')) {
			$title_options = esc_html__( 'Title Options', 'mascot-core' );
			$sub_title_options = esc_html__( 'Sub Title', 'mascot-core' );
			$price_options = esc_html__( 'Price', 'mascot-core' );
			$group_features_options = esc_html__( 'Features', 'mascot-core' );
			$group_button_options = esc_html__( 'Button Options', 'mascot-core' );

			$vc_map = array(
				'name'		=> esc_html__( 'Pricing Table', 'mascot-core' ),
				'base'		=>$this->shortcode_base,
				'category'	=> 'by TM',
				'icon'		=> 'mascot-vc-icons vc-icon-pricingtable',
				'allowed_container_element' => 'vc_row',
				'params'	=>array(
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Custom CSS class", 'mascot-core' ),
						"param_name"	=> "custom_css_class",
						"description"	=> esc_html__( 'To style particular content element.', 'mascot-core' ),
					),
					//mascot_core_charitab_load_styles( 5, 'design_style', true ),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Pricing Table Style", 'mascot-core' ),
						"param_name"	=> "design_style",
						'description'   => '',
						'value' => array(
							esc_html__( 'Style 1 - Standard', 'mascot-core' )								=> 'style1',
							esc_html__( 'Style 2 - Padding Around Whole Table', 'mascot-core' )				=> 'style2',
							esc_html__( 'Style 3 - Padding + Title Area Text Center', 'mascot-core' )		=> 'style3',
							esc_html__( 'Style 4 - Padding + Everything Text Center ', 'mascot-core' )		=> 'style4',
							esc_html__( 'Style 5 - No Padding + Everything Text Center', 'mascot-core' )	=> 'style5',
						),
						'admin_label'   => true,
					),
					array(
						'type'			=> 'attach_image',
						"heading"		=> esc_html__( "Pricing Thumbnail Image", 'mascot-core' ),
						"param_name"	=> "pricing_image",
						"description"	=> esc_html__( 'This image will be shown on the top of the pricing table.', 'mascot-core' ),
					),
					array(
						'type'       => 'textfield',
						'heading'    => esc_html__('Title', 'mascot-core'),
						'param_name' => 'title',
						'admin_label'   => true,
					),
					array(
						'type'       => 'textfield',
						'heading'    => esc_html__('Sub Title', 'mascot-core'),
						'param_name' => 'sub_title',
						'admin_label'   => true,
					),
					array(
						'type'       => 'textfield',
						'heading'    => esc_html__('Prefix', 'mascot-core'),
						'param_name' => 'price_prefix'
					),
					array(
						'type'       => 'textfield',
						'heading'    => esc_html__('Price', 'mascot-core'),
						'param_name' => 'price',
						'admin_label'   => true,
					),
					array(
						'type'       => 'textfield',
						'heading'    => esc_html__('Separator', 'mascot-core'),
						'param_name' => 'price_separator'
					),
					array(
						'type'       => 'textfield',
						'heading'    => esc_html__('Postfix', 'mascot-core'),
						'param_name' => 'price_postfix'
					),
					array(
						'type'       => 'textfield',
						'heading'    => esc_html__('Label/Offer/Tag Text', 'mascot-core'),
						'param_name' => 'label_text'
					),
					array(
						'type'       => 'textarea_html',
						'heading'    => esc_html__('Text', 'mascot-core'),
						'param_name' => 'content'
					),


					//Title Options
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Title Custom CSS Class", 'mascot-core' ),
						"param_name"	=> "title_custom_css_class",
						"description"	=> esc_html__( 'To style Title.', 'mascot-core' ),
						'group'			=> $title_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Title Tag", 'mascot-core' ),
						"param_name"	=> "title_tag",
						"description"	=> "",
						'value'			=> mascot_core_charitab_heading_tag_list(),
						'std'			=> 'h4',
						'admin_label'   => true,
						'save_always'   => true,
						'group'			=> $title_options
					),
					array(
						'type'			=> 'colorpicker',
						"heading"		=> esc_html__( "Text Color", 'mascot-core' ),
						"param_name"	=> "title_text_color",
						"value"		 => '',
						'group'			=> $title_options
					),
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Font Size", 'mascot-core' ),
						"param_name"	=> "title_font_size",
						"description"	=> "",
						'group'			=> $title_options
					),
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Line Height", 'mascot-core' ),
						"param_name"	=> "title_line_height",
						"description"	=> "",
						'group'			=> $title_options
					),
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Letter Spacing", 'mascot-core' ),
						"param_name"	=> "title_letter_spacing",
						"description"	=> "",
						'group'			=> $title_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Font Style", 'mascot-core' ),
						"param_name"	=> "title_font_style",
						"description"	=> "",
						'value'			=> mascot_core_charitab_vc_font_style_list(),
						'group'			=> $title_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Font Weight", 'mascot-core' ),
						"param_name"	=> "title_font_weight",
						"description"	=> "",
						'value'			=> mascot_core_charitab_vc_font_weight_list(),
						'group'			=> $title_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Text Transform", 'mascot-core' ),
						"param_name"	=> "title_text_transform",
						"description"	=> "",
						'value'			=> mascot_core_charitab_vc_text_transform_list(),
						'group'			=> $title_options
					),


					//Sub Title Options
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Sub Title Custom CSS Class", 'mascot-core' ),
						"param_name"	=> "subtitle_custom_css_class",
						"description"	=> esc_html__( 'To style Sub Title.', 'mascot-core' ),
						'group'			=> $sub_title_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Sub Title Tag", 'mascot-core' ),
						"param_name"	=> "subtitle_tag",
						"description"	=> "",
						'value'			=> mascot_core_charitab_heading_tag_list(),
						'std'			=> 'h5',
						'admin_label'   => true,
						'save_always'   => true,
						'group'			=> $sub_title_options
					),
					array(
						'type'			=> 'colorpicker',
						"heading"		=> esc_html__( "Text Color", 'mascot-core' ),
						"param_name"	=> "subtitle_text_color",
						"value"		 => '',
						'group'			=> $sub_title_options
					),
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Font Size", 'mascot-core' ),
						"param_name"	=> "subtitle_font_size",
						"description"	=> "",
						'group'			=> $sub_title_options
					),
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Line Height", 'mascot-core' ),
						"param_name"	=> "subtitle_line_height",
						"description"	=> "",
						'group'			=> $sub_title_options
					),
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Letter Spacing", 'mascot-core' ),
						"param_name"	=> "subtitle_letter_spacing",
						"description"	=> "",
						'group'			=> $sub_title_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Font Style", 'mascot-core' ),
						"param_name"	=> "subtitle_font_style",
						"description"	=> "",
						'value'			=> mascot_core_charitab_vc_font_style_list(),
						'group'			=> $sub_title_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Font Weight", 'mascot-core' ),
						"param_name"	=> "subtitle_font_weight",
						"description"	=> "",
						'value'			=> mascot_core_charitab_vc_font_weight_list(),
						'group'			=> $sub_title_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Text Transform", 'mascot-core' ),
						"param_name"	=> "subtitle_text_transform",
						"description"	=> "",
						'value'			=> mascot_core_charitab_vc_text_transform_list(),
						'group'			=> $sub_title_options
					),




					//Price Options
					array(
						'type'			=> 'colorpicker',
						"heading"		=> esc_html__( "Price Text Color", 'mascot-core' ),
						"param_name"	=> "price_text_color",
						"value"		 => '',
						'group'			=> $price_options
					),
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Price Font Size", 'mascot-core' ),
						"param_name"	=> "price_font_size",
						"description"	=> "",
						'group'			=> $price_options
					),
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Price Line Height", 'mascot-core' ),
						"param_name"	=> "price_line_height",
						"description"	=> "",
						'group'			=> $price_options
					),
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Price Letter Spacing", 'mascot-core' ),
						"param_name"	=> "price_letter_spacing",
						"description"	=> "",
						'group'			=> $price_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Price Font Style", 'mascot-core' ),
						"param_name"	=> "price_font_style",
						"description"	=> "",
						'value'			=> mascot_core_charitab_vc_font_style_list(),
						'group'			=> $price_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Price Font Weight", 'mascot-core' ),
						"param_name"	=> "price_font_weight",
						"description"	=> "",
						'value'			=> mascot_core_charitab_vc_font_weight_list(),
						'group'			=> $price_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Price Text Transform", 'mascot-core' ),
						"param_name"	=> "price_text_transform",
						"description"	=> "",
						'value'			=> mascot_core_charitab_vc_text_transform_list(),
						'group'			=> $price_options
					),




					//Features Options
					array(
						'type'			=> 'checkbox',
						"heading"		=> esc_html__( "Disable List(ul, li) Bullets Icons in Content Text Area?", 'mascot-core' ),
						"param_name"	=> "disable_list_bullets",
						'group'			=> $group_features_options
					),
					array(
						'type'			=> 'checkbox',
						"heading"		=> esc_html__( "Make List(ul, li) Border Bottom?", 'mascot-core' ),
						"param_name"	=> "list_bordered",
						'group'			=> $group_features_options
					),
					array(
						'type'			=> 'checkbox',
						"heading"		=> esc_html__( "Put Pricing Info after Content/Text Block?", 'mascot-core' ),
						"param_name"	=> "put_pricing_info_after_text",
						'group'			=> $group_features_options
					),
					array(
						'type'			=> 'checkbox',
						"heading"		=> esc_html__( "Put Pricing Thumbnail Image after Title/Subtitle?", 'mascot-core' ),
						"param_name"	=> "put_pricing_image_after_title",
						'group'			=> $group_features_options
					),
					array(
						'type'			=> 'checkbox',
						"heading"		=> esc_html__( "Add Box Shadow Around Table?", 'mascot-core' ),
						"param_name"	=> "add_box_shadow_around_table",
						'std'			=> 'true',
						'group'			=> $group_features_options
					),
					array(
						'type'			=> 'checkbox',
						"heading"		=> esc_html__( "Make This Table Featured?", 'mascot-core' ),
						"description"	=> esc_html__( "Featured Pricing Table has some different looks to highlight it.", 'mascot-core' ),
						"param_name"	=> "make_this_table_featured",
						'group'			=> $group_features_options
					),
					array(
						'type'			=> 'checkbox',
						"heading"		=> esc_html__( "Make Hover Effect on This Table?", 'mascot-core' ),
						"description"	=> esc_html__( "There will be a transition when hovering on this table.", 'mascot-core' ),
						"param_name"	=> "make_hover_effect",
						'group'			=> $group_features_options
					),
					vc_map_add_css_animation(),


					//Button
					array(
						'type'       => 'vc_link',
						'heading'    => esc_html__('Button', 'mascot-core'),
						'param_name' => 'button',
						'group'			=> $group_button_options
					),

					
					//button options
					mascot_core_charitab_get_button_arraylist( 1, $group_button_options ),
					mascot_core_charitab_get_button_arraylist( 2, $group_button_options ),
					mascot_core_charitab_get_button_arraylist( 3, $group_button_options ),
					mascot_core_charitab_get_button_arraylist( 4, $group_button_options ),
					mascot_core_charitab_get_button_arraylist( 5, $group_button_options ),
					mascot_core_charitab_get_button_arraylist( 6, $group_button_options ),
					mascot_core_charitab_get_button_arraylist( 7, $group_button_options ),
					mascot_core_charitab_get_button_arraylist( 8, $group_button_options ),
					mascot_core_charitab_get_button_arraylist( 9, $group_button_options ),

					mascot_core_charitab_vc_add_css_editor(),
				)
			);
			vc_map( $vc_map );

			//Modify vc_map from themes
			if( function_exists('mascot_core_charitab_sc_pricing_table_vc_map_modifier') ) {
				mascot_core_charitab_sc_pricing_table_vc_map_modifier( $this->shortcode_base );
			}
		}
	}

	/**
	 * Renders shortcodes HTML
	 */
	public function render( $attr, $content = null ) {

		//Render Shortcode from themes
		if( function_exists('mascot_core_charitab_sc_pricing_table_render') && function_exists('vc_map') ) {
			return mascot_core_charitab_sc_pricing_table_render( $attr, $content );
		}
		
	}
}