<?php
namespace MASCOTCORECHARITAB\Shortcodes\PieChart;

use MASCOTCORECHARITAB\Shortcodes\Lib;

/**
 * class SC_Pie_Chart
 * @package MASCOTCORECHARITAB\Shortcodes\PieChart;
 */
class SC_Pie_Chart implements Lib\Mascot_Core_Charitab_Interface_Shortcodes {
	
	/**
	 * @var shortcode_base
	 */
	private $shortcode_base;

	/**
	 * construct
	 */
	public function __construct() {
		$this->shortcode_base = 'tm_pie_chart';
		add_action('init', array($this, 'MapShortCodeVC'), 998);
	}

	/**
	 * Returns shortcode_base for shortcode
	 */
	public function getShortCodeBase() {
		return $this->shortcode_base;
	}

	/**
	 * Maps shortcode to Visual Composer
	 */
	public function MapShortCodeVC() {
		if(function_exists('vc_map')) {
			$group_content_options = esc_html__( 'Content Options', 'mascot-core' );

			$vc_map = array(
				'name'		=> esc_html__( 'Pie Chart', 'mascot-core' ),
				'base'		=>$this->shortcode_base,
				'category'	=> 'by TM',
				'icon'		=> 'mascot-vc-icons vc-icon-piechart',
				'allowed_container_element' => 'vc_row',
				'params'	=>array(
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Custom CSS class", 'mascot-core' ),
						"param_name"	=> "custom_css_class",
						"description"	=> esc_html__( 'To style particular content element.', 'mascot-core' ),
					),

					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Percentage Value", 'mascot-core' ),
						"param_name"	=> "percent",
						"description"	=> esc_html__( 'Add a Percentage Value. Maximum 100. Default: 85', 'mascot-core' ),
						'admin_label'   => true,
					),


					array(
						'type'			=> 'colorpicker',
						"heading"		=> esc_html__( "Bar Color", 'mascot-core' ),
						"param_name"	=> "barcolor",
						"value"		 => '',
						"description"	=> esc_html__( 'The color of the curcular bar. Leave empty for default value.', 'mascot-core' ),
						'admin_label'   => true,
					),
					array(
						'type'			=> 'colorpicker',
						"heading"		=> esc_html__( "Track Color", 'mascot-core' ),
						"param_name"	=> "trackcolor",
						"value"		 => '',
						"description"	=> esc_html__( 'The color of the track, or false to disable rendering. Leave empty for default value.', 'mascot-core' ),
						'admin_label'   => true,
					),
					array(
						'type'			=> 'colorpicker',
						"heading"		=> esc_html__( "Scale  Color", 'mascot-core' ),
						"param_name"	=> "scalecolor",
						"value"		 => '',
						"description"	=> esc_html__( 'The color of the scale lines, false to disable rendering. Leave empty for default value.', 'mascot-core' ),
						'admin_label'   => true,
					),


					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Scale Length", 'mascot-core' ),
						"param_name"	=> "scalelength",
						"description"	=> esc_html__( 'Length of the scale lines (reduces the radius of the chart). Default: 5', 'mascot-core' ),
						'admin_label'   => true,
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Line Cap", 'mascot-core' ),
						"param_name"	=> "linecap",
						"description"	=> "",
						'value'			=> array(
							esc_html__( "Square", 'mascot-core' )   => 'square',
							esc_html__( "Butt", 'mascot-core' )   => 'butt',
							esc_html__( "Round", 'mascot-core' )   => 'round',
						),
						'admin_label'   => true,
					),
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Line Width", 'mascot-core' ),
						"param_name"	=> "linewidth",
						"description"	=> esc_html__( 'Width of the chart line in px. Default: 3', 'mascot-core' ),
						'admin_label'   => true,
					),
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Size", 'mascot-core' ),
						"param_name"	=> "size",
						"description"	=> esc_html__( 'Size of the pie chart in px. It will always be a square. Default: 110', 'mascot-core' ),
						'admin_label'   => true,
					),


					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Title", 'mascot-core' ),
						"param_name"	=> "title",
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Title Tag", 'mascot-core' ),
						"param_name"	=> "title_tag",
						"description"	=> "",
						'value'			=> mascot_core_charitab_heading_tag_list(),
						'std'			=> 'h3',
					),
					array(
						'type'			=> 'colorpicker',
						"heading"		=> esc_html__( "Title Color", 'mascot-core' ),
						"param_name"	=> "title_color",
						"value"		 => '',
					),
					array(
						'type'			=> 'textarea',
						"heading"		=> esc_html__( "Text", 'mascot-core' ),
						"param_name"	=> "text",
					),
					array(
						'type'			=> 'colorpicker',
						"heading"		=> esc_html__( "Text Color", 'mascot-core' ),
						"param_name"	=> "text_color",
						"value"		 => '',
					),


				)
			);
			vc_map( $vc_map );

			//Modify vc_map from themes
			if( function_exists('mascot_core_charitab_sc_pie_chart_vc_map_modifier') ) {
				mascot_core_charitab_sc_pie_chart_vc_map_modifier( $this->shortcode_base );
			}
		}
	}

	/**
	 * Renders shortcodes HTML
	 */
	public function render( $attr, $content = null ) {

		//Render Shortcode from themes
		if( function_exists('mascot_core_charitab_sc_pie_chart_render') && function_exists('vc_map') ) {
			return mascot_core_charitab_sc_pie_chart_render( $attr, $content );
		}
		
	}
}