<?php
namespace MASCOTCORECHARITAB\Shortcodes\PaypalDonation;

use MASCOTCORECHARITAB\Shortcodes\Lib;

/**
 * class SC_Paypal_Donation
 * @package MASCOTCORECHARITAB\Shortcodes\BeforeAfterSlider;
 */
class SC_Paypal_Donation implements Lib\Mascot_Core_Charitab_Interface_Shortcodes {
	
	/**
	 * @var shortcode_base
	 */
	private $shortcode_base;

	/**
	 * construct
	 */
	public function __construct() {
		$this->shortcode_base = 'tm_paypal_donation';
		add_action('init', array($this, 'MapShortCodeVC'), 998);
	}

	/**
	 * Returns shortcode_base for shortcode
	 */
	public function getShortCodeBase() {
		return $this->shortcode_base;
	}

	/**
	 * Maps shortcode to Visual Composer
	 */
	public function MapShortCodeVC() {
		$content_options = esc_html__( 'Content Options', 'mascot-core' );
		$return_options = esc_html__( 'Return Options', 'mascot-core' );

		if(function_exists('vc_map')) {
			$vc_map = array(
				'name'		=> esc_html__( 'Paypal Donation', 'mascot-core' ),
				'base'		=>$this->shortcode_base,
				'category'	=> 'by TM',
				'description' => esc_html__( 'One Time and Recurring Donation', 'mascot-core' ),
				'icon'		=> 'mascot-vc-icons vc-icon-paypal',
				'allowed_container_element' => 'vc_row',
				'params'	=>array(
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Custom CSS class", 'mascot-core' ),
						"param_name"	=> "custom_css_class",
						"description"	=> esc_html__( 'To style particular content element.', 'mascot-core' ),
					),
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "PayPal Email Address", 'mascot-core' ),
						"param_name"	=> "paypal_email",
					),


					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Payment Type", 'mascot-core' ),
						"param_name"	=> "payment_type",
						"description"	=> "",
						'value'			=> array(
							esc_html__( "Both One Time and Recurring", 'mascot-core' )		=> 'both-onetime-recurring',
							esc_html__( "One Time", 'mascot-core' )		=> 'onetime',
							esc_html__( "Recurring", 'mascot-core' )	=> 'recurring',
						),
						'save_always'	=> true,
						'admin_label'	=> true,
					),


					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Design Style", 'mascot-core' ),
						"param_name"	=> "design_style",
						"description"	=> "",
						'value'			=> array(
							esc_html__( "Style 1 - Two Different Blocks", 'mascot-core' )	=> 'style1-different-blocks',
							esc_html__( "Style 2 - Tab", 'mascot-core' )	=> 'style2-tab',
							esc_html__( "Style 3 - Radio Button", 'mascot-core' )	=> 'style3-radio-button',
							esc_html__( "Style 4 - Radio Button", 'mascot-core' )	=> 'style4-radio-button',
						),
						'dependency'	=> array('element' => 'payment_type', 'value' => array( 'both-onetime-recurring' ) ),
						'save_always'	=> true,
						'admin_label'	=> true,
					),



					array(
						'type'			=> 'textarea',
						"heading"		=> esc_html__( "Donate For (Dropdown Options)", 'mascot-core' ),
						"param_name"	=> "donate_for",
						"value"			=> esc_html__( "
Child Camp for Education
Clean Water Program
The Accessibility Fund", 'mascot-core' ),
						"description"	=> esc_html__( "Seperate each option by new line", 'mascot-core' ),
						'save_always'   => true,
						'group'			=> $content_options
					),
					array(
						'type'			=> 'textarea',
						"heading"		=> esc_html__( "Suggested Donation Amounts", 'mascot-core' ),
						"param_name"	=> "suggested_donation_amounts",
						"value"			=> esc_html__( "
10
50
100
200
500
1000", 'mascot-core' ),
						"description"	=> esc_html__( "Seperate each option by new line", 'mascot-core' ),
						'save_always'   => true,
						'group'			=> $content_options
					),


					array(
						'type'			=> 'checkbox',
						"heading"		=> esc_html__( "Currency", 'mascot-core' ),
						"param_name"	=> "currency",
						"description"	=> "",
						'value'			=> array(
							esc_html__( "All", 'mascot-core' )							=> 'all',
							esc_html__( "USD - U.S. Dollars", 'mascot-core' )			=> 'USD',
							esc_html__( "AUD - Australian Dollars", 'mascot-core' )		=> 'AUD',
							esc_html__( "BRL - Brazilian Reais", 'mascot-core' )		=> 'BRL',
							esc_html__( "GBP - British Pounds", 'mascot-core' )			=> 'GBP',
							esc_html__( "HKD - Hong Kong Dollars", 'mascot-core' )		=> 'HKD',
							esc_html__( "HUF - Hungarian Forints", 'mascot-core' )		=> 'HUF',
							esc_html__( "INR - Indian Rupee", 'mascot-core' )			=> 'INR',
							esc_html__( "ILS - Israeli New Shekels", 'mascot-core' )	=> 'ILS',
							esc_html__( "JPY - Japanese Yen", 'mascot-core' )			=> 'JPY',
							esc_html__( "MYR - Malaysian Ringgit", 'mascot-core' )		=> 'MYR',
							esc_html__( "MXN - Mexican Pesos", 'mascot-core' )			=> 'MXN',
							esc_html__( "TWD - New Taiwan Dollars", 'mascot-core' )		=> 'TWD',
							esc_html__( "NZD - New Zealand Dollars", 'mascot-core' )	=> 'NZD',
							esc_html__( "NOK - Norwegian Kroner", 'mascot-core' )		=> 'NOK',
							esc_html__( "PHP - Philippine Pesos", 'mascot-core' )		=> 'PHP',
							esc_html__( "PLN - Polish Zlotys", 'mascot-core' )			=> 'PLN',
							esc_html__( "RUB - Russian Rubles", 'mascot-core' )			=> 'RUB',
							esc_html__( "SGD - Singapore Dollars", 'mascot-core' )		=> 'SGD',
							esc_html__( "SEK - Swedish Kronor", 'mascot-core' )			=> 'SEK',
							esc_html__( "CHF - Swiss Francs", 'mascot-core' )			=> 'CHF',
							esc_html__( "THB - Thai Baht", 'mascot-core' )				=> 'THB',
							esc_html__( "TRY - Turkish Liras", 'mascot-core' )			=> 'TRY',
						),
						'std'			=> 'all',
						'save_always'	=> true,
						'group'			=> $content_options
					),


					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Submit Button Type", 'mascot-core' ),
						"param_name"	=> "submit_button_type",
						"description"	=> "",
						'value'			=> array(
							esc_html__( "Simple Button", 'mascot-core' )	=> 'button',
							esc_html__( "PayPal Image", 'mascot-core' )		=> 'image',
						),
						'save_always'	=> true,
					),


					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Return URL", 'mascot-core' ),
						"param_name"	=> "return_url",
						'group'			=> $return_options
					),
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Cancel Return URL", 'mascot-core' ),
						"param_name"	=> "cancel_return_url",
						'group'			=> $return_options
					),
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Notify URL", 'mascot-core' ),
						"param_name"	=> "notify_url",
						'group'			=> $return_options
					),


				)
			);
			vc_map( $vc_map );

			//Modify vc_map from themes
			if( function_exists('mascot_core_charitab_sc_paypal_donation_vc_map_modifier') ) {
				mascot_core_charitab_sc_paypal_donation_vc_map_modifier( $this->shortcode_base );
			}
		}
	}

	/**
	 * Renders shortcodes HTML
	 */
	public function render( $attr, $content = null ) {

		//Render Shortcode from themes
		if( function_exists('mascot_core_charitab_sc_paypal_donation_render') && function_exists('vc_map') ) {
			return mascot_core_charitab_sc_paypal_donation_render( $attr, $content );
		}
		
	}
}