<?php
namespace MASCOTCORECHARITAB\Shortcodes\IconBox;

use MASCOTCORECHARITAB\Shortcodes\Lib;

/**
 * class SC_Icon_Box
 * @package MASCOTCORECHARITAB\Shortcodes\IconBox;
 */
class SC_Icon_Box implements Lib\Mascot_Core_Charitab_Interface_Shortcodes {
	
	/**
	 * @var shortcode_base
	 */
	private $shortcode_base;

	/**
	 * construct
	 */
	public function __construct() {
		$this->shortcode_base = 'tm_icon_box';
		add_action('init', array($this, 'MapShortCodeVC'), 998);
	}

	/**
	 * Returns shortcode_base for shortcode
	 */
	public function getShortCodeBase() {
		return $this->shortcode_base;
	}

	/**
	 * Maps shortcode to Visual Composer
	 */
	public function MapShortCodeVC() {
		if(function_exists('vc_map')) {
			$group_title_options = esc_html__( 'Title', 'mascot-core' );
			$group_icon_options = esc_html__( 'Icon', 'mascot-core' );
			$group_button_options = esc_html__( 'Button Options', 'mascot-core' );
			$group_styling_options = esc_html__( 'Styling', 'mascot-core' );

			//collect vc icon pack
			$vc_icon_pack_array = array();
			if( function_exists('charitab_mascot_get_vc_icon_pack_array') ) {
				$vc_icon_pack_array = charitab_mascot_get_vc_icon_pack_array( array('element' => 'icon_type', 'value' => array('font-icon')), $group_icon_options );
			}

			$params_part1 = array(
				array(
					'type'			=> 'textfield',
					"heading"		=> esc_html__( "Custom CSS Class", 'mascot-core' ),
					"param_name"	=> "custom_css_class",
					"description"	=> esc_html__( 'To style particular content element.', 'mascot-core' ),
					'admin_label'   => true,
				),
				array(
					'type'			=> 'checkbox',
					"heading"		=> esc_html__( "Link Icon, Title and Button?", 'mascot-core' ),
					"param_name"	=> "link_icon_title",
					'description'   => '',
				),
				array(
					'type'			=> 'vc_link',
					'heading'		=> esc_html__( 'Link URL', 'mascot-core' ),
					'param_name'	=> 'link_url',
					'description'   => esc_html__( 'Add link to Icon, Title and Button.', 'mascot-core' ),
					'dependency'	=> array('element' => 'link_icon_title', 'value' => 'true'),
				),
				array(
					'type'			=> 'textarea_html',
					"heading"		=> esc_html__( "Content", 'mascot-core' ),
					"param_name"	=> "content",
					'description'   => '',
					'value'			=> "Default text for Box Content. Lorem ipsum dolor sit amet, consectetur adipisicing elit.",
					'save_always'   => true,
				),



				//Icon Options
				array(
					'type'			=> 'textfield',
					"heading"		=> esc_html__( "Icon Custom CSS Class", 'mascot-core' ),
					"param_name"	=> "icon_custom_css_class",
					"description"	=> esc_html__( 'To style Icon.', 'mascot-core' ),
					'admin_label'   => true,
					'group'			=> $group_icon_options
				),
				array(
					'type'			=> 'dropdown',
					"heading"		=> esc_html__( "Icon Type", 'mascot-core' ),
					"param_name"	=> "icon_type",
					"description"	=> esc_html__( 'Choose font icon or image.', 'mascot-core' ),
					'value'			=> array(
						esc_html__( 'Font Icon', 'mascot-core' )		=> 'font-icon',
						esc_html__( 'JPG/PNG Image', 'mascot-core' )   	=> 'image'
					),
					'save_always'   => true,
					'group'			=> $group_icon_options
				),
			);

			$merged_fields = array_merge($params_part1, $vc_icon_pack_array);


			$params_part2 = array(
				array(
					'type'			=> 'attach_image',
					"heading"		=> esc_html__( "Upload Image Icon", 'mascot-core' ),
					"param_name"	=> "image_icon",
					"description"	=> esc_html__( 'Upload the custom image icon.', 'mascot-core' ),
					'group'			=> $group_icon_options,
					'dependency'	=> array('element' => 'icon_type', 'value' => 'image'),
				),
				array(
					'type'			=> 'dropdown',
					"heading"		=> esc_html__( "Choose Predefined Image Size", 'mascot-core' ),
					"param_name"	=> "image_icon_predefined_image_size",
					"description"	=> esc_html__( 'Default: full.', 'mascot-core' ),
					'value'			=> mascot_core_charitab_get_available_image_sizes_for_vc(),
					'std'			=> 'full',
					'group'			=> $group_icon_options,
					'dependency'	=> array('element' => 'icon_type', 'value' => 'image'),
				),
				array(
					'type'			=> 'textfield',
					"heading"		=> esc_html__( "Image Custom Width (Only number)", 'mascot-core' ),
					"param_name"	=> "image_icon_custom_size",
					"description"	=> esc_html__( 'Put custom width of the uploaded image in positive integer value. Example: 120', 'mascot-core' ),
					'group'			=> $group_icon_options,
					'dependency'	=> array('element' => 'icon_type', 'value' => 'image'),
				),





				array(
					'type'			=> 'dropdown',
					"heading"		=> esc_html__( "Icon Position", 'mascot-core' ),
					"param_name"	=> "icon_position",
					"description"	=> "",
					'value'			=> array(
						esc_html__( 'Top', 'mascot-core' )	 	=> 'icon-top',
						esc_html__( 'Left', 'mascot-core' )		=> 'icon-left',
						esc_html__( 'Right', 'mascot-core' )	=> 'icon-right'
					),
					'group'			=> $group_icon_options
				),
				array(
					'type'			=> 'checkbox',
					"heading"		=> esc_html__( "Icon Hanging On Top?", 'mascot-core' ),
					"param_name"	=> "icon_hanging_on_top",
					'description'	=> '',
					'group'			=> $group_icon_options,
					'dependency'	=> array('element' => 'icon_position', 'value' => 'icon-top'),
				),
				array(
					'type'			=> 'textfield',
					"heading"		=> esc_html__( "Custom Margin Top to Position Hanging Icon Accurately", 'mascot-core' ),
					"param_name"	=> "icon_hanging_custom_margin_top",
					"description"	=> "",
					'group'			=> $group_icon_options,
					'dependency'	=> array('element' => 'icon_hanging_on_top', 'value' => 'true'),
				),
				array(
					'type'			=> 'dropdown',
					"heading"		=> esc_html__( "Predefined Icon/Image Size", 'mascot-core' ),
					"param_name"	=> "icon_size",
					"description"	=> "",
					'value'			=> array(
						esc_html__( 'Default', 'mascot-core' )		=>   'icon-size-default',
						esc_html__( 'Small', 'mascot-core' )		=>   'icon-sm',
						esc_html__( 'Extra Small', 'mascot-core' )	=>   'icon-xs',
						esc_html__( 'Medium', 'mascot-core' )		=>   'icon-md',
						esc_html__( 'Large', 'mascot-core' )		=>   'icon-lg',
						esc_html__( 'Extra Large', 'mascot-core' )	=>   'icon-xl',
					),
					'group'			=> $group_icon_options,
				),
				array(
					'type'			=> 'textfield',
					"heading"		=> esc_html__( "Icon Custom Font Size", 'mascot-core' ),
					"param_name"	=> "icon_custom_font_size",
					"description"	=> "",
					'group'			=> $group_icon_options,
					'dependency'	=> array('element' => 'icon_type', 'value' => 'font-icon'),
				),
				array(
					'type'			=> 'textfield',
					"heading"		=> esc_html__( "Icon Line Height", 'mascot-core' ),
					"param_name"	=> "icon_line_height",
					"description"	=> "",
					'group'			=> $group_icon_options,
					'dependency'	=> array('element' => 'icon_type', 'value' => 'font-icon'),
				),
				array(
					'type'			=> 'textfield',
					"heading"		=> esc_html__( "Padding Around Icon/Image", 'mascot-core' ),
					"param_name"	=> "icon_padding_around",
					"description"	=> "",
					'group'			=> $group_icon_options,
				),
				array(
					'type'			=> 'textfield',
					"heading"		=> esc_html__( "Icon/Image Area Width", 'mascot-core' ),
					"param_name"	=> "icon_box_width",
					"description"	=> "",
					'group'			=> $group_icon_options,
				),
				array(
					'type'			=> 'textfield',
					"heading"		=> esc_html__( "Icon/Image Area Height", 'mascot-core' ),
					"param_name"	=> "icon_box_height",
					"description"	=> "",
					'group'			=> $group_icon_options,
				),
				array(
					'type'			=> 'dropdown',
					"heading"		=> esc_html__( "Icon/Image Area Background Color", 'mascot-core' ),
					"param_name"	=> "icon_color",
					"description"	=> "",
					'value'			=> array(
						esc_html__( 'Default', 'mascot-core' )  			=> 'icon-default',
						esc_html__( 'White Background', 'mascot-core' )		=> 'icon-white',
						esc_html__( 'Gray Background', 'mascot-core' )	  	=> 'icon-gray',
						esc_html__( 'Dark Background', 'mascot-core' )	  	=> 'icon-dark'
					),
					'group'			=> $group_icon_options,
					'save_always'   => true,
				),
				array(
					'type'			=> 'colorpicker',
					"heading"		=> esc_html__( "Icon/Image Area Custom Background Color", 'mascot-core' ),
					"param_name"	=> "icon_area_custom_bg_color",
					"value"		 => '',
					'group'			=> $group_icon_options,
				),
				array(
					'type'			=> 'dropdown',
					"heading"		=> esc_html__( "Make Icon Theme Colored?", 'mascot-core' ),
					"param_name"	=> "icon_theme_colored",
					'description'	=> '',
					'value'			=> mascot_core_charitab_theme_color_list_vc(),
					'group'			=> $group_icon_options,
					'dependency'	=> array('element' => 'icon_type', 'value' => 'font-icon'),
				),
				array(
					'type'			=> 'colorpicker',
					"heading"		=> esc_html__( "Icon Custom Color", 'mascot-core' ),
					"param_name"	=> "icon_custom_color",
					"value"		 => '',
					'group'			=> $group_icon_options,
					'dependency'	=> array('element' => 'icon_type', 'value' => 'font-icon'),
				),
				array(
					'type'			=> 'dropdown',
					"heading"		=> esc_html__( "Icon/Image Area Style", 'mascot-core' ),
					"param_name"	=> "icon_style",
					"description"	=> "",
					'value'			=> array(
						esc_html__( 'Default', 'mascot-core' )   => 'icon-default',
						esc_html__( 'Rounded', 'mascot-core' )   => 'icon-rounded',
						esc_html__( 'Circled', 'mascot-core' )   => 'icon-circled',
					),
					'group'			=> $group_icon_options,
				),
				array(
					'type'			=> 'checkbox',
					"heading"		=> esc_html__( "Make Icon/Image Area Bordered?", 'mascot-core' ),
					"param_name"	=> "icon_border_style",
					'description'	=> '',
					'group'			=> $group_icon_options,
				),
				array(
					'type'			=> 'checkbox',
					"heading"		=> esc_html__( "Box Shadow Around Icon Area?", 'mascot-core' ),
					"param_name"	=> "icon_box_shadow",
					'description'	=> '',
					'group'			=> $group_icon_options,
				),






				array(
					'type'			=> 'textfield',
					"heading"		=> esc_html__( "Title Custom CSS Class", 'mascot-core' ),
					"param_name"	=> "title_custom_css_class",
					"description"	=> esc_html__( 'To style Title.', 'mascot-core' ),
					'admin_label'   => true,
					'group'			=> $group_title_options
				),
				array(
					'type'			=> 'textfield',
					"heading"		=> esc_html__( "Title", 'mascot-core' ),
					"param_name"	=> "title",
					'admin_label'   => true,
					'group'			=> $group_title_options
				),
				array(
					'type'			=> 'dropdown',
					"heading"		=> esc_html__( "Title Tag", 'mascot-core' ),
					"param_name"	=> "title_tag",
					'description'   => esc_html__( 'Default: H3', 'mascot-core' ),
					'value'			=> mascot_core_charitab_heading_tag_list(),
					'std'			=> 'h3',
					'save_always'   => true,
					'admin_label'   => true,
					'group'			=> $group_title_options
				),
				array(
					'type'			=> 'colorpicker',
					"heading"		=> esc_html__( "Text Color", 'mascot-core' ),
					"param_name"	=> "title_text_color",
					'description'	=> '',
					'group'			=> $group_title_options,
				),
				





				array(
					'type'			=> 'dropdown',
					"heading"		=> esc_html__( "Text Alignment", 'mascot-core' ),
					"param_name"	=> "text_alignment",
					"description"	=> "",
					'value'			=> mascot_core_charitab_text_alignment_list(),
					'save_always'   => true,
					'group'			=> $group_styling_options,
				),
				array(
					'type'			=> 'dropdown',
					"heading"		=> esc_html__( "Box Animation Style", 'mascot-core' ),
					"param_name"	=> "box_animation",
					"description"	=> "",
					'value'			=> array(
						esc_html__( 'No Animation', 'mascot-core' )							=> '',
						esc_html__( 'Style 1 - Current Theme Animation', 'mascot-core' )	=> 'iconbox-style1-current-theme-animation',
						esc_html__( 'Style 2 - Border Bottom', 'mascot-core' )				=> 'iconbox-style2-border-bottom',
						esc_html__( 'Style 3 - Moving Border Bottom', 'mascot-core' )		=> 'iconbox-style3-moving-border-bottom',
					),
					'save_always'   => true,
					'group'			=> $group_styling_options,
				),
				array(
					'type'			=> 'checkbox',
					"heading"		=> esc_html__( "Box Shadow?", 'mascot-core' ),
					"param_name"	=> "box_shadow",
					'description'	=> '',
					'group'			=> $group_styling_options,
				),
				array(
					'type'			=> 'checkbox',
					"heading"		=> esc_html__( "Add Default Padding Around the Box?", 'mascot-core' ),
					"param_name"	=> "box_default_padding",
					'description'	=> '',
					'group'			=> $group_styling_options,
				),
				array(
					'type'			=> 'checkbox',
					"heading"		=> esc_html__( "Make everything centered in responsive mode?", 'mascot-core' ),
					"param_name"	=> "everything_centered_in_responsive",
					'description'	=> '',
					'std'			=> 'true',
					'group'			=> $group_styling_options,
				),
				array(
					'type'			=> 'checkbox',
					"heading"		=> esc_html__( "Make title margin top = 0 in desktop mode?", 'mascot-core' ),
					"param_name"	=> "title_mt_0_in_desktop",
					'description'	=> '',
					'std'			=> 'false',
					'group'			=> $group_styling_options,
				),

					
				//Button
				mascot_core_charitab_get_viewdetails_button_arraylist( 1, $group_button_options ),
				mascot_core_charitab_get_viewdetails_button_arraylist( 2, $group_button_options ),

				//button options
				mascot_core_charitab_get_button_arraylist( 1, $group_button_options ),
				mascot_core_charitab_get_button_arraylist( 2, $group_button_options ),
				mascot_core_charitab_get_button_arraylist( 3, $group_button_options ),
				mascot_core_charitab_get_button_arraylist( 4, $group_button_options ),
				mascot_core_charitab_get_button_arraylist( 5, $group_button_options ),
				mascot_core_charitab_get_button_arraylist( 6, $group_button_options ),
				mascot_core_charitab_get_button_arraylist( 7, $group_button_options ),
				mascot_core_charitab_get_button_arraylist( 8, $group_button_options ),
				mascot_core_charitab_get_button_arraylist( 9, $group_button_options ),

				mascot_core_charitab_vc_add_css_editor(),

			);

			$merged_fields = array_merge($merged_fields, $params_part2);

			$vc_map = array(
				'name'		=> esc_html__( 'Icon Box', 'mascot-core' ),
				'base'		=>$this->shortcode_base,
				'category'	=> 'by TM',
				'icon'		=> 'mascot-vc-icons vc-icon-iconbox',
				'allowed_container_element' => 'vc_row',
				'params'	=> $merged_fields
			);
			vc_map( $vc_map );

			//Modify vc_map from themes
			if( function_exists('mascot_core_charitab_sc_icon_box_vc_map_modifier') ) {
				mascot_core_charitab_sc_icon_box_vc_map_modifier( $this->shortcode_base );
			}
		}
	}

	/**
	 * Renders shortcodes HTML
	 */
	public function render( $attr, $content = null ) {

		//Render Shortcode from themes
		if( function_exists('mascot_core_charitab_sc_icon_box_render') && function_exists('vc_map') ) {
			return mascot_core_charitab_sc_icon_box_render( $attr, $content );
		}
		
	}
}