<?php
namespace MASCOTCORECHARITAB\Shortcodes\GiveSingleFormCustom;

use MASCOTCORECHARITAB\Shortcodes\Lib;

/**
 * class SC_Give_Single_Form_Custom
 * @package MASCOTCORECHARITAB\Shortcodes\GiveSingleFormCustom;
 */
class SC_Give_Single_Form_Custom implements Lib\Mascot_Core_Charitab_Interface_Shortcodes {
	
	/**
	 * @var shortcode_base
	 */
	private $shortcode_base;

	/**
	 * construct
	 */
	public function __construct() {
		$this->shortcode_base = 'tm_give_single_form_custom';
		add_action('init', array($this, 'MapShortCodeVC'), 998);
	}

	/**
	 * Returns shortcode_base for shortcode
	 */
	public function getShortCodeBase() {
		return $this->shortcode_base;
	}

	/**
	 * Maps shortcode to Visual Composer
	 */
	public function MapShortCodeVC() {
		$group_button_options = esc_html__( 'Button', 'mascot-core' );

		if(function_exists('vc_map')) {
			$vc_map = array(
				'name'		=> esc_html__( 'Give Form - Custom Built', 'mascot-core' ),
				'base'		=>$this->shortcode_base,
				'category'	=> 'by TM',
				'description' => esc_html__( 'Campaigns Grid/Carousel', 'mascot-core' ),
				'icon'		=> 'mascot-vc-icons vc-icon-give',
				'allowed_container_element' => 'vc_row',
				'params'	=> array(
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Custom CSS Class", 'mascot-core' ),
						"param_name"	=> "custom_css_class",
						"description"	=> esc_html__( 'To style particular content element.', 'mascot-core' ),
						'admin_label'   => true,
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Choose Donation Form to Display", 'mascot-core' ),
						"param_name"	=> "id",
						//"description"	=> esc_html__( 'The "id" is a required attribute for this shortcode. The "id" should be the post ID of a published donation form.', 'mascot-core' ),
						'value'			=> mascot_core_charitab_get_post_list_array_by_post_type( 'give_forms', true ),
						'admin_label'   => true,
					),

					
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Show Title", 'mascot-core' ),
						"param_name"	=> "show_title",
						'value'			=> array(
							esc_html__( 'Yes', 'mascot-core' )	=> 'true',
							esc_html__( 'No', 'mascot-core' )	=> 'false'
						),
						'admin_label'   => true,
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Title Tag", 'mascot-core' ),
						"param_name"	=> "title_tag",
						"description"	=> "",
						'value'			=> mascot_core_charitab_heading_tag_list(),
						'std'			=> 'h2',
						'admin_label'   => true,
						'save_always'   => true,
						'dependency'	=> array('element' => 'show_title', 'value' => 'true'),
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Show Excerpt", 'mascot-core' ),
						"param_name"	=> "show_excerpt",
						'value'			=> array(
							esc_html__( 'Yes', 'mascot-core' )	=> 'true',
							esc_html__( 'No', 'mascot-core' )	=> 'false'
						),
						'admin_label'   => true,
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Show Progress", 'mascot-core' ),
						"param_name"	=> "show_progress",
						'description'   => '',
						'value'			=> array(
							esc_html__( 'Yes', 'mascot-core' )	=> 'true',
							esc_html__( 'No', 'mascot-core' )	=> 'false'
						),
						'admin_label'   => true,
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Show Donation Stats", 'mascot-core' ),
						"param_name"	=> "show_donation_stats",
						'description'   => '',
						'value'			=> array(
							esc_html__( 'Yes', 'mascot-core' )	=> 'true',
							esc_html__( 'No', 'mascot-core' )	=> 'false'
						),
						'admin_label'   => true,
					),


					
					//Button
					mascot_core_charitab_get_viewdetails_button_arraylist( 1, $group_button_options ),
					mascot_core_charitab_get_viewdetails_button_arraylist( 2, $group_button_options ),

					//button options
					mascot_core_charitab_get_button_arraylist( 1, $group_button_options ),
					mascot_core_charitab_get_button_arraylist( 2, $group_button_options ),
					mascot_core_charitab_get_button_arraylist( 3, $group_button_options ),
					mascot_core_charitab_get_button_arraylist( 4, $group_button_options ),
					mascot_core_charitab_get_button_arraylist( 5, $group_button_options ),
					mascot_core_charitab_get_button_arraylist( 6, $group_button_options ),
					mascot_core_charitab_get_button_arraylist( 7, $group_button_options ),
					mascot_core_charitab_get_button_arraylist( 8, $group_button_options ),
					mascot_core_charitab_get_button_arraylist( 9, $group_button_options ),

				)
			);
			vc_map( $vc_map );

			//Modify vc_map from themes
			if( function_exists('mascot_core_charitab_sc_give_single_form_custom_vc_map_modifier') ) {
				mascot_core_charitab_sc_give_single_form_custom_vc_map_modifier( $this->shortcode_base );
			}
		}
	}

	/**
	 * Renders shortcodes HTML
	 */
	public function render( $attr, $content = null ) {

		//Render Shortcode from themes
		if( function_exists('mascot_core_charitab_sc_give_single_form_custom_render') && function_exists('vc_map') ) {
			return mascot_core_charitab_sc_give_single_form_custom_render( $attr, $content );
		}
		
	}
}