<?php
namespace MASCOTCORECHARITAB\Shortcodes\GiveCampaigns;

use MASCOTCORECHARITAB\Shortcodes\Lib;

/**
 * class SC_Give_Campaigns
 * @package MASCOTCORECHARITAB\Shortcodes\GiveCampaigns;
 */
class SC_Give_Campaigns implements Lib\Mascot_Core_Charitab_Interface_Shortcodes {
	
	/**
	 * @var shortcode_base
	 */
	private $shortcode_base;

	/**
	 * construct
	 */
	public function __construct() {
		$this->shortcode_base = 'tm_give_campaigns';
		add_action('init', array($this, 'MapShortCodeVC'), 998);
	}

	/**
	 * Returns shortcode_base for shortcode
	 */
	public function getShortCodeBase() {
		return $this->shortcode_base;
	}

	/**
	 * Maps shortcode to Visual Composer
	 */
	public function MapShortCodeVC() {
		$group_content_options = esc_html__( 'Content', 'mascot-core' );
		$group_carousel_options = esc_html__( 'Carousel', 'mascot-core' );
		$group_query_options = esc_html__( 'Query', 'mascot-core' );
		$group_button_options = esc_html__( 'Button', 'mascot-core' );
		$group_donate_button_options = esc_html__( 'Donate Button', 'mascot-core' );
			$group_loadmore_button_options = esc_html__( 'Loadmore Button', 'mascot-core' );

		$categories_array = mascot_core_charitab_category_list_array_for_vc( 'give_forms_category' );
		$tag_array = mascot_core_charitab_category_list_array_for_vc( 'give_forms_tag' );
		$orderby_parameters_list1 = mascot_core_charitab_orderby_parameters_list();
		$orderby_parameters_list2 = array(
		);
		$orderby_parameters_list = array_merge( $orderby_parameters_list2, $orderby_parameters_list1 );


		if(function_exists('vc_map')) {
			$vc_map = array(
				'name'		=> esc_html__( 'Give Campaigns', 'mascot-core' ),
				'base'		=>$this->shortcode_base,
				'category'	=> 'by TM',
				'description' => esc_html__( 'Campaigns Grid/Carousel', 'mascot-core' ),
				'icon'		=> 'mascot-vc-icons vc-icon-give',
				'allowed_container_element' => 'vc_row',
				'params'	=> array(
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Custom CSS class", 'mascot-core' ),
						"param_name"	=> "custom_css_class",
						"description"	=> esc_html__( 'To style particular content element.', 'mascot-core' ),
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Display Type", 'mascot-core' ),
						"param_name"	=> "display_type",
						"description"	=> "",
						'value'			=> array(
							esc_html__( 'Grid', 'mascot-core' )								=> 'grid',
							esc_html__( 'Masonry', 'mascot-core' )							=> 'masonry',
							esc_html__( 'Carousel', 'mascot-core' )							=> 'carousel',
							esc_html__( 'Horizontal Fullwidth', 'mascot-core' )				=> 'horizontal',
							esc_html__( 'Horizontal Fullwidth + Carousel', 'mascot-core' )	=> 'horizontal-carousel',
							//esc_html__( 'Featured Campaign Style 2', 'mascot-core' )	=> 'featured-campaign-style2'
						),
						'save_always'   => true,
						'admin_label'   => true,
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Columns Layout", 'mascot-core' ),
						"param_name"	=> "columns",
						"description"	=> esc_html__( 'Define Columns Layout for Grid/Carousel.', 'mascot-core' ),
						'value'			=> array(
							'1'  =>  '1',
							'2'  =>  '2',
							'3'  =>  '3',
							'4'  =>  '4',
							'5'  =>  '5',
							'6'  =>  '6',
						),
						'std'			=> 3,
						'dependency'	=> array('element' => 'display_type', 'value' => array('grid', 'masonry', 'carousel') ),
						'save_always'   => true,
						'admin_label'   => true,
					),

					vc_map_add_css_animation(),






					//Carousel Options
					mascot_core_charitab_get_owl_carousel_arraylist( 1, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel', 'horizontal-carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 2, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel', 'horizontal-carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 3, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel', 'horizontal-carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 4, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel', 'horizontal-carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 5, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel', 'horizontal-carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 6, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel', 'horizontal-carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 7, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel', 'horizontal-carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 8, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel', 'horizontal-carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 9, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel', 'horizontal-carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 10, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel', 'horizontal-carousel' ) ) ),


					//Query Options
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Number of Items to Query from Database", 'mascot-core' ),
						"param_name"	=> "total_items",
						"description"	=> esc_html__( 'How many items do you wish to show? Put -1 to show all. Default 3', 'mascot-core' ),
						'value'			=> 3,
						'admin_label'	=> true,
						'group'			=> $group_query_options
					),
					array(
						'type'			=> 'checkbox',
						"heading"		=> esc_html__( "Category", 'mascot-core' ),
						"param_name"	=> "category",
						"description"	=> esc_html__( 'Choose a category to pull from.', 'mascot-core' ),
						'value'			=> $categories_array,
						'group'			=> $group_query_options
					),
					array(
						'type'			=> 'checkbox',
						"heading"		=> esc_html__( "Tag", 'mascot-core' ),
						"param_name"	=> "tag",
						"description"	=> esc_html__( 'Choose a tag to pull from.', 'mascot-core' ),
						'value'			=> $tag_array,
						'group'			=> $group_query_options
					),
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Donation Form ID", 'mascot-core' ),
						"param_name"	=> "campaigns_id",
						"description"	=> esc_html__( 'To display donation frms with specific ID, you can provide a single number or multiple IDs as a comma separated list. Example: 33,44', 'mascot-core' ),
						'admin_label'   => true,
						'group'			=> $group_query_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Order By", 'mascot-core' ),
						"param_name"	=> "order_by",
						"description"	=> esc_html__( 'Select how to sort retrieved posts.', 'mascot-core' ),
						'value'			=> array(
							esc_html__( 'Date', 'mascot-core' )			=> 'date',
							esc_html__( 'Title', 'mascot-core' )		=> 'title',
							esc_html__( 'Popular', 'mascot-core' )		=> 'popular',
							esc_html__( 'Ending', 'mascot-core' )		=> 'ending',
						),
						'std'			=> $orderby_parameters_list[ 'Date' ],
						'group'			=> $group_query_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Order", 'mascot-core' ),
						"param_name"	=> "order",
						"description"	=> esc_html__( 'Descending or Ascending order.', 'mascot-core' ),
						'value'			=> array(
							esc_html__( 'Descending', 'mascot-core' )	=> 'DESC',
							esc_html__( 'Ascending', 'mascot-core' )	=> 'ASC',
						),
						'group'			=> $group_query_options
					),



					//Content Options
					
					//Category Filter
					mascot_core_charitab_get_cat_filter_arraylist( 1, $group_content_options, array('element' => 'display_type', 'value' => array('grid', 'masonry', 'carousel') ) ),
					mascot_core_charitab_get_cat_filter_arraylist( 2, $group_content_options ),
					mascot_core_charitab_get_cat_filter_arraylist( 3, $group_content_options ),



					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Show Thumbnail", 'mascot-core' ),
						"param_name"	=> "show_thumb",
						'description'   => '',
						'value'			=> array(
							esc_html__( 'Yes', 'mascot-core' )	=> 'true',
							esc_html__( 'No', 'mascot-core' )	=> 'false'
						),
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Thumbnail Image Size", 'mascot-core' ),
						"param_name"	=> "feature_thumb_image_size",
						'description'   => '',
						'value'			=> mascot_core_charitab_get_available_image_sizes_for_vc(),
						'std'			=> 'post-thumbnail',
						'save_always'   => true,
						'dependency'	=> array('element' => 'show_thumb', 'value' => 'true'),
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Show Title", 'mascot-core' ),
						"param_name"	=> "show_title",
						'description'   => '',
						'value'			=> array(
							esc_html__( 'Yes', 'mascot-core' )	=> 'true',
							esc_html__( 'No', 'mascot-core' )	=> 'false'
						),
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Show Excerpt", 'mascot-core' ),
						"param_name"	=> "show_excerpt",
						'description'   => '',
						'value'			=> array(
							esc_html__( 'Yes', 'mascot-core' )	=> 'true',
							esc_html__( 'No', 'mascot-core' )	=> 'false'
						),
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Excerpt Length", 'mascot-core' ),
						"param_name"	=> "excerpt_length",
						"description"	=> esc_html__( 'Number of words to display. Example: 25. Default all.', 'mascot-core' ),
						'dependency'	=> array('element' => 'show_excerpt', 'value' => 'true'),
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Show Meta", 'mascot-core' ),
						"param_name"	=> "show_meta",
						'description'   => '',
						'value'			=> array(
							esc_html__( 'Yes', 'mascot-core' )	=> 'true',
							esc_html__( 'No', 'mascot-core' )	=> 'false'
						),
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'checkbox',
						"heading"		=> esc_html__( "Choose Meta", 'mascot-core' ),
						"param_name"	=> "meta_options",
						"description"	=> esc_html__( 'Enable/Disabling this option will show/hide each Post Meta.', 'mascot-core' ),
						'value'			=> array(
							esc_html__( 'Show Created Date', 'mascot-core' )	=> 'show-created-date',
							esc_html__( 'Show Category', 'mascot-core' )	=> 'show-category',
							esc_html__( 'Show Tag', 'mascot-core' )	=> 'show-tag',
							esc_html__( 'Show Campaign Creator', 'mascot-core' )	=> 'show-campaign-creator',
							//esc_html__( 'Show Campaign Donor Count', 'mascot-core' )	=> 'show-campaign-donor-count',
						),
						'std'			=> 'show-created-date',
						'save_always'   => true,
						'dependency'	=> array('element' => 'show_meta', 'value' => 'true'),
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Show Progress", 'mascot-core' ),
						"param_name"	=> "show_progress",
						'description'   => '',
						'value'			=> array(
							esc_html__( 'Yes', 'mascot-core' )	=> 'true',
							esc_html__( 'No', 'mascot-core' )	=> 'false'
						),
						'admin_label'   => true,
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Show Donation Stats", 'mascot-core' ),
						"param_name"	=> "show_donation_stats",
						'description'   => '',
						'value'			=> array(
							esc_html__( 'Yes', 'mascot-core' )	=> 'true',
							esc_html__( 'No', 'mascot-core' )	=> 'false'
						),
						'admin_label'   => true,
						'group'			=> $group_content_options
					),
					/*array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Show Social Share", 'mascot-core' ),
						"param_name"	=> "show_social_share",
						'description'   => '',
						'value'			=> array(
							esc_html__( 'Yes', 'mascot-core' )	=> 'true',
							esc_html__( 'No', 'mascot-core' )	=> 'false'
						),
						'std'			=> 'false',
						'group'			=> $group_content_options
					),*/





					
					//Button
					mascot_core_charitab_get_viewdetails_button_arraylist( 1, $group_button_options ),
					mascot_core_charitab_get_viewdetails_button_arraylist( 2, $group_button_options ),

					//button options
					mascot_core_charitab_get_button_arraylist( 1, $group_button_options ),
					mascot_core_charitab_get_button_arraylist( 2, $group_button_options ),
					mascot_core_charitab_get_button_arraylist( 3, $group_button_options ),
					mascot_core_charitab_get_button_arraylist( 4, $group_button_options ),
					mascot_core_charitab_get_button_arraylist( 5, $group_button_options ),
					mascot_core_charitab_get_button_arraylist( 6, $group_button_options ),
					mascot_core_charitab_get_button_arraylist( 7, $group_button_options ),
					mascot_core_charitab_get_button_arraylist( 8, $group_button_options ),
					mascot_core_charitab_get_button_arraylist( 9, $group_button_options ),



					
					//Donate Button
					mascot_core_charitab_get_viewdetails_button_arraylist( 1, $group_donate_button_options, esc_html__( 'Donate Now', 'mascot-core' ), 'donate_' ),
					mascot_core_charitab_get_viewdetails_button_arraylist( 2, $group_donate_button_options, esc_html__( 'Donate Now', 'mascot-core' ), 'donate_'  ),

					//Donate Button options
					mascot_core_charitab_get_button_arraylist( 1, $group_donate_button_options, 'donate_' ),
					mascot_core_charitab_get_button_arraylist( 2, $group_donate_button_options, 'donate_' ),
					mascot_core_charitab_get_button_arraylist( 3, $group_donate_button_options, 'donate_' ),
					mascot_core_charitab_get_button_arraylist( 4, $group_donate_button_options, 'donate_' ),
					mascot_core_charitab_get_button_arraylist( 5, $group_donate_button_options, 'donate_' ),
					mascot_core_charitab_get_button_arraylist( 6, $group_donate_button_options, 'donate_' ),
					mascot_core_charitab_get_button_arraylist( 7, $group_donate_button_options, 'donate_' ),
					mascot_core_charitab_get_button_arraylist( 8, $group_donate_button_options, 'donate_' ),
					mascot_core_charitab_get_button_arraylist( 9, $group_donate_button_options, 'donate_' ),

					//Loadmore Button options
					mascot_core_charitab_get_viewdetails_button_arraylist( 1, $group_loadmore_button_options,  esc_html__( "Load More", 'mascot-core' ), 'loadmore_', 'false' ),
					mascot_core_charitab_get_viewdetails_button_arraylist( 2, $group_loadmore_button_options,  esc_html__( "Load More", 'mascot-core' ), 'loadmore_', 'false' ),
					$array = array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Loading Text", 'mascot-core' ),
						"param_name"	=> "loadmore_button_loading_text",
						'std'			=> esc_html__( "Loading...", 'mascot-core' ),
						'save_always'   => true,
						'group'			=> $group_loadmore_button_options
					),
					mascot_core_charitab_get_button_arraylist( 1, $group_loadmore_button_options, 'loadmore_' ),
					mascot_core_charitab_get_button_arraylist( 2, $group_loadmore_button_options, 'loadmore_' ),
					mascot_core_charitab_get_button_arraylist( 3, $group_loadmore_button_options, 'loadmore_' ),
					mascot_core_charitab_get_button_arraylist( 4, $group_loadmore_button_options, 'loadmore_' ),
					mascot_core_charitab_get_button_arraylist( 5, $group_loadmore_button_options, 'loadmore_' ),
					mascot_core_charitab_get_button_arraylist( 6, $group_loadmore_button_options, 'loadmore_' ),
					mascot_core_charitab_get_button_arraylist( 7, $group_loadmore_button_options, 'loadmore_' ),
					mascot_core_charitab_get_button_arraylist( 8, $group_loadmore_button_options, 'loadmore_' ),
					mascot_core_charitab_get_button_arraylist( 9, $group_loadmore_button_options, 'loadmore_' ),



					mascot_core_charitab_vc_add_css_editor(),

				)
			);
			vc_map( $vc_map );

			//Modify vc_map from themes
			if( function_exists('mascot_core_charitab_sc_give_campaigns_vc_map_modifier') ) {
				mascot_core_charitab_sc_give_campaigns_vc_map_modifier( $this->shortcode_base );
			}
		}
	}

	/**
	 * Renders shortcodes HTML
	 */
	public function render( $attr, $content = null ) {

		//Render Shortcode from themes
		if( function_exists('mascot_core_charitab_sc_give_campaigns_render') && function_exists('vc_map') ) {
			return mascot_core_charitab_sc_give_campaigns_render( $attr, $content );
		}
		
	}
}